/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * view.c
 */

#include <stdio.h>
#include <stdlib.h>

#include <view.h>


VIEW_ITEM *Views = NULL;

VIEW_ITEM *
add_view(int type, int number)
{
  VIEW_ITEM **cv, *v;

  /* look to see if this view exists already! */
  cv = &Views;
  while (*cv) {
    if (((*cv)->type == type) && ((*cv)->number == number)) {
      fprintf(stdout, "Warning: this view already exists!\n");
      return (*cv);
    }
    cv = &((*cv)->next_View);
  }

  /* create new view */
  v = (VIEW_ITEM *) calloc(1, sizeof(VIEW_ITEM));
  v->type = type;
  v->number = number;
  v->next_View = NULL;
  (*cv) = v;

  return v;
}

void
dismiss_view(int type, int number) 
{
  VIEW_ITEM **cv, *old;

  /* look to see if this view exists already! */
  cv = &Views;
  while (*cv) {
    if (((*cv)->type == type) && ((*cv)->number == number)) {
      old = *cv;
      (*cv) = (*cv)->next_View;
      free((char *) old);
      dump_views();
      return;
    }
    cv = &((*cv)->next_View);
  }
  
  fprintf(stdout, "Warning: this view does not exist, so can not dismiiss.\n");
  dump_views();
  return;
}

VIEW_ITEM *
get_view(int type, int number)
{
  VIEW_ITEM *cv = Views;
  while (cv) {
    if ( (cv->type == type) && (cv->number == number) )
      return cv;
    cv = cv->next_View;
  }
  return (VIEW_ITEM *) NULL;
}

void
dump_views()
{
  VIEW_ITEM *v = Views;

  fprintf(stdout, "Current views are: \n");
  while (v) {
    switch (v->type)
      {
      case TWOD:
	twod_dump(v);
	break;
      case ONED:
      case GEOMVIEW:
      default:
	fprintf(stdout, "  %s %d\n", win_keyindex(v->type), v->number);
	break;
      }
    v = v->next_View;
  }
}

/*
 * plots a memory object on all views
 */
void
view_plot_mem(memory m)
{
  VIEW_ITEM *v = Views;

  while (v) {
    switch (v->type)
      {
      case TWOD:
	twod_mem(v,m);
	break;
      case ONED:
      case GEOMVIEW:
      default:
	fprintf(stdout, "view_plot_mem: unrecognized view object.\n");
	break;
      }
    v = v->next_View;
  }
}
