/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * sys_install.c
 *
 * Procedures:
 *   sys_install()
 *
 * Here we install the postmaster objects which will always exist.
 *
 */

#include <stdio.h>

#include "pm.h"
#include "init_local.h"

static PFV sys_install_procs[] = {
  model_install,
  selected_install,
  manifold_install,
  memory_install,
  flow_install,
  prop_install,
  color_install,
  mult_install,
  browser_install,
  fixed_install,
  porbit_install,
  defaults_install,
  geomview_install,
  parser_install,
  save_install,
  load_install,
  view_install,
  print_install, 
  cont_install,
  twod_install
/*
  oned_install,
*/
  };

#define N_SYS_INSTALL sizeof(sys_install_procs)/sizeof(PFV)

void
  sys_install()
{
  int i;

  for (i=0; i<N_SYS_INSTALL; i++)
    if (sys_install_procs[i] != (PFV) NULL)
      sys_install_procs[i]();

}

extern int N_USER_INSTALL;
extern PFV user_install_procs[];

void
user_install()
{
  int i;

  for (i=0; i<N_USER_INSTALL; i++)
    if (user_install_procs[i] != (PFV) NULL)
      user_install_procs[i]();

}

