/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * flow.h
 *
 * Declarations for flow routines
 */

#ifndef FLOW_H
#define FLOW_H

#include "complib.h"

/* flow.c */
void flow_forwards(void);
void flow_backwards(void);
void flow_continue(void);
void clear_last_trajectory(void);
void clear_all_trajs(void);

/* traj_mem_orb.c */
void traj_mem_orbit(void);
int allocate_integ(struct Prop_DataS *ic, int size);
int release_integ(struct Prop_DataS *ic, int size);
void bump_color(void);
void unbump_color(void);
void reset_color(void);
int get_alt_color(void);
void prop_struct_dump(struct Prop_DataS *ic);

/* load_int.c */
void load_int(void);
void prop_to_pm(void);

/* compute_orb.c */
int compute_orbit(struct Prop_DataS *prop_cntl);
int prop_cntl_orbit(struct Prop_DataS *prop_cntl);
int comp_alloc(struct Prop_DataS *prop_cntl);
int comp_free(struct Prop_DataS *prop_cntl);
void watch_free(struct Prop_DataS *prop_cntl);
int comp_def_setup(struct Prop_DataS *prop_cntl);
int varb_watch_func(double x[], double p[], int index, double *result);
int aux_fn_watch_func(double x[], double p[], int index, double *result);
void watch_setup(struct Prop_DataS *prop_cntl);

/* orbits/integration/iterate.c */
int iterate(struct Prop_DataS *prop_cntl);
int implicit_iter( int (*f)(double*, double* , double* ),
                   int (*jacobian)(double**, double*, double*),
                   int jacobian_switch,
                   int newt_iter,
                   int k,
                   double** m,
                   double* x,
                   double* c,
                   double* param,
                   int ph_sp_dim,
                   double time_step,
                   double* h,
                   double tolx,
                   double tolf,
                   Manifold* manifold,
                   double* y,
                   int* indx);


/* orbits/iteration/integrate.c */
int integrate(struct Prop_DataS *prop_cntl);

#endif
/* !FLOW_H */
