Description: fix for compiling with gcc 4.7
 [Julian Taylor <jtaylor.debian@googlemail.com>]
  * Include algorithm and added std::
Author: Julian Taylor <jtaylor.debian@googlemail.com>
--- a/src/matrix.h
+++ b/src/matrix.h
@@ -14,6 +14,7 @@
 #include <istream>
 #include <cassert>
 #include <stdexcept>
+#include <algorithm>
 
 // --------------------------------------------------------------------
 // uBlas compatible matrix types
@@ -310,7 +311,7 @@ matrix<T> operator*(const matrix_base<T>
 template<typename T>
 matrix<T> operator-(const matrix_base<T>& lhs, const matrix_base<T>& rhs)
 {
-	matrix<T> result(min(lhs.dim_m(), rhs.dim_m()), min(lhs.dim_n(), rhs.dim_n()));
+	matrix<T> result(std::min(lhs.dim_m(), rhs.dim_m()), std::min(lhs.dim_n(), rhs.dim_n()));
 	
 	for (uint32 i = 0; i < result.dim_m(); ++i)
 	{
