// 
// Copyright (C) 2001,2002,2003,2004 Jorge Daza Garcia-Blanes
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
// USA
// 
// $Id: task.h 1108 2005-01-21 18:32:19Z jorge $
//

#ifndef _TASK_H_
#define _TASK_H_

#ifdef __LINUX
#include <stdint.h>
#else
# ifdef __IRIX
#  include <sys/types.h>
# else
#  ifdef __OSX
#   include <stdint.h>
#  else
#   ifdef __FREEBSD
#    include <stdint.h>
#   else
#    ifdef __CYGWIN
#     include <stdint.h>
#    else
#     error You need to define the OS, or OS defined not supported
#    endif
#   endif
#  endif
# endif
#endif

#include "constants.h"

#define DR_EXITEDFLAG (0x0100)
#define DR_SIGNALEDFLAG (0x0200)

#define DR_WIFEXITED(stat)   ((stat)&DR_EXITEDFLAG)
#define DR_WEXITSTATUS(stat) ((stat)&0xff)
#define DR_WIFSIGNALED(stat) ((stat)&DR_SIGNALEDFLAG)
#define DR_WTERMSIG(stat)    ((stat)&0xff)

typedef enum {
  TASKSTATUS_LOADING,		/* Assigned but not running yet */
  TASKSTATUS_RUNNING
} t_taskstatus;

struct task {
  uint8_t used;
  char jobname[MAXNAMELEN];	/* jobname */
  uint32_t ijob;		/* index to the job in the global db */
	uint32_t icomp;		// Index to the computer that renders this frame
  uint16_t itask;		/* index to the task in the computer !not in the global db! */
  char jobcmd[MAXCMDLEN];	/* string that will be executed */
  char owner[MAXNAMELEN];	/* owner of the job */
  uint32_t frame;		/* current _real_ frame number (!!not index!!) */
  uint32_t frame_start,frame_end;
  uint32_t frame_step;
	uint32_t block_size;
  int32_t pid;			/* pid */
  int32_t exitstatus;		/* exit status */
  uint8_t status;		/* status */
};

struct slave_database;

void task_init_all (struct task *task);
void task_init (struct task *task);
int task_available (struct slave_database *sdb);
void task_report (struct task *task);
char *task_status_string (unsigned char status);
void task_environment_set (struct task *task);

#endif /* _TASK_H_ */




