/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../config.h"
#include <gnome.h>
#include "callbacks.h"
#include "process.h"
#include "interface.h"
#include "support.h"
#include "drip.h"
#include <pthread.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <dvddb.h>
#include <sys/ioctl.h>
#include <inttypes.h>
#include <ctype.h>
#include <errno.h>
#include <assert.h>
#include <gdk/gdkx.h>
#include "../encoder/external.hh"
#include "../encoder/plugin-loader.hh"

/* GLOBALS */
GtkWidget *propertybox1 = NULL;
GtkWidget *select_dialog;
GtkWidget *spinbutton1;
GtkWidget *spinbutton2;
GtkWidget *spinbutton3;
GtkWidget *spinbutton4;
GtkWidget *spinbutton5;
GtkWidget *entry3;
GtkWidget *stop_dialog = NULL;
GtkWidget *audio_subpicture_dialog;
GtkWidget *druid_vbox3;
GtkWidget *druid_vbox2;
GtkWidget *window1;
GtkWidget *hbox21;
GtkWidget *hbox22;
GtkWidget *vbox9b;
GtkWidget *viewport_DVD_tree;
GtkWidget *frame1;
GtkWidget *frame5;
GtkWidget *vbox9_2nd;
GtkWidget *label;
GtkWidget *current_avi_clist = NULL;
static GtkWidget *plugin_GUI = NULL;
/* Tree widgets */
GtkWidget *DVDtree;                                                       // Main tree
GtkWidget *DVDtreeItem;                                                   // DVD volume ID
GtkWidget *DVDVTStree;                                                    // Video Title Set tree
GtkWidget *DVDVTStreeItem[512];      gint DVDVTStreeItem_counter = 0;     // Video Title Set Items
GtkWidget *DVDVTtree[512];           gint DVDVTtree_counter = 0;          // Video Title tree
GtkWidget *DVDVTtreeItem[2048];      gint DVDVTtreeItem_counter = 0;      // Video Title Items
GtkWidget *DVDprogramtree[512];      gint DVDprogramtree_counter = 0;     // Programs tree
GtkWidget *DVDprogramtreeItem[2048]; gint DVDprogramtreeItem_counter = 0; // Program Items
GtkWidget *DVDchaptertree[512];      gint DVDchaptertree_counter = 0;     // Chapters
GtkWidget *DVDchaptertreeItem[2048]; gint DVDchaptertreeItem_counter = 0; // Chapter Items
GtkWidget *viewport_avi;
gint DVD_TREE_LEVEL = 2;
gboolean RECURSIVE = TRUE;

// protos
void build_compose_tree(gboolean advanced);
void build_compose_avilist(void);



void on_button_main_rip_clicked(GtkButton *button, gpointer user_data) {
    pthread_t ripthread;
    gint ripthread_id;
    if (converting == FALSE) {
        /* start conversion thread */
        if (Config.useDVDdevice == TRUE ) Config.conversion_mode = DVDTITLE_DVDDISK; /* automatic dvd stream select */
        if (Config.useDVDdevice == FALSE) Config.conversion_mode = DVDTITLE_DRIPCACHE;
        bind_titles_guitype();
        converting = TRUE;
        paused = FALSE;
        ripthread_id = pthread_create(&ripthread,NULL,conversion_thread,NULL);
        #ifdef LM_SENSORS
        /* heat monitoring */
        if (heatthread_id!=0) pthread_cancel(heatthread);
        heatthread_id = pthread_create(&heatthread,NULL,heat_thread,NULL);
        #endif /* LM_SENSORS */
    } else {
        GtkWidget* buzy;
        buzy = create_messagebox_buzy();
        gtk_widget_show(buzy);
    }
    return;
}

void on_button_main_dvd2vcd_clicked(GtkButton *button, gpointer user_data) {
    pthread_t ripthread;
    gint ripthread_id;
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING," ");
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING," ");
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"------------------------------");
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"DVD to VCD is not yet working!");
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"this is work in progress");
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"------------------------------");
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING," ");
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING," ");
    if (converting == FALSE) {
        /* start conversion thread */
        if (Config.useDVDdevice == TRUE ) Config.conversion_mode = DVDTITLE_DVD2VCDDISK; /* automatic dvd stream select */
        if (Config.useDVDdevice == FALSE) Config.conversion_mode = DVDTITLE_DRIPCACHE2VCD;
        bind_titles_guitype();
        converting = TRUE;
        paused = FALSE;
        ripthread_id = pthread_create(&ripthread,NULL,conversion_thread,NULL);
        #ifdef LM_SENSORS
        /* heat monitoring */
        if (heatthread_id!=0) pthread_cancel(heatthread);
        heatthread_id = pthread_create(&heatthread,NULL,heat_thread,NULL);
        #endif /* LM_SENSORS */
    } else {
        GtkWidget* buzy;
        buzy = create_messagebox_buzy();
        gtk_widget_show(buzy);
    }
    return;
}



void on_button_main_rescan_clicked(GtkButton *button,gpointer user_data) {
    if (converting == FALSE) {
        /* start conversion thread */
        Config.conversion_mode = MPEG_PLAIN; /* manual dvd stream select */
        bind_titles_guitype();
        converting = TRUE;
        ripthread_id = pthread_create(&ripthread,NULL,conversion_thread,NULL);
        #ifdef LM_SENSORS
        /* heat monitoring */
        if (heatthread_id!=0) pthread_cancel(heatthread);
        heatthread_id = pthread_create(&heatthread,NULL,heat_thread,NULL);
        #endif /* LM_SENSORS */
    } else {
        GtkWidget* buzy;
        buzy = create_messagebox_buzy();
        gtk_widget_show(buzy);
    }
}

void on_button_eject_clicked(GtkButton *button, gpointer user_data) {
    GString *command = g_string_new("");
    GString *command2 = g_string_new("");

    if (Config.track_dir == NULL || Config.track_dir->len == 0) {
        g_string_sprintf(command,"%s",detect_source_track_dir(FALSE));
    } else {
        g_string_sprintf(command,"%s",Config.track_dir->str);
    }
    if (Config.DVDhandle!=NULL) { 
        DVDClose(Config.DVDhandle);
        Config.DVDhandle = NULL;
    }
    if (command!=NULL && command->len>0) {
        eject_dvdrom(Config.track_dir->str,Config.DVDdevice->str,FALSE);
    } else {
        g_string_sprintf(command,"Unable to eject, DVD device %s not valid?",Config.DVDdevice->str);
        drip_error(command->str);
    }
    /* Clean & Exit */
    g_string_free(command,TRUE);
    g_string_free(command2,TRUE);
    return;
}


void on_button_main_pref_clicked(GtkButton *button, gpointer user_data) {
    return;
}


void on_homepage_activate (GtkButton *button, gpointer user_data) {
    gint result;
    printf("About to show url..");
    drip_system("gnome-moz-remote --newwin http://drip.sourceforge.net",&result,TRUE,FALSE);
    printf("done\n");
    return;
}


void on_button_main_exit_clicked(GtkButton *button, gpointer user_data) {
    terminate(FALSE,FALSE);
    return;
}


void on_propertybox1_destroy(GtkObject *object,gpointer user_data) {
    gboolean result;
    result = save_config(FALSE);
    /* Destroy old plug */
    if (plugin_GUI != NULL) {
        gtk_widget_destroy(plugin_GUI);
    }
    propertybox1 = NULL;
    return;
}


gboolean on_mainwindow_destroy_event(GtkWidget *widget,GdkEvent *event,gpointer user_data) {
    if (converting == FALSE) {
        terminate(TRUE,FALSE);
    } else {
        GtkWidget* buzy;
        buzy = create_messagebox_buzy();
        gtk_widget_show(buzy);
    }
    return FALSE;
}

gboolean on_mainwindow_delete_event(GtkWidget *widget,GdkEvent *event, gpointer user_data) {
    if (converting == FALSE) {
        terminate(TRUE,FALSE);
    } else {
        GtkWidget* buzy;
        buzy = create_messagebox_buzy();
        gtk_widget_show(buzy);
    }
    return FALSE;
}

void on_combo_entry_dvddevice_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *combo = (GtkWidget*)user_data;
    GString *command = g_string_new("");
    /* Set Config DVDdevice string to user input */
    g_string_sprintf(Config.DVDdevice,"%s",gtk_entry_get_text(GTK_ENTRY(combo)));
    /* Clean & Exit */
    g_string_free(command,TRUE);
    return;
}

void on_combo_entry_plugin_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *combo = (GtkWidget*)user_data;
    GString *command = g_string_new("");
    gint i;
    /* Destroy old plug */
    if (plugin_GUI != NULL) {
        gtk_widget_destroy(plugin_GUI);
    }
    /* Build new plugin gui */
    g_string_sprintf(command,"%s",gtk_entry_get_text(GTK_ENTRY(combo)));
    for (i=0;i<filters_index;i++) {
        if (strcmp(filters[i].module_name->str,command->str)==0) {
            plugin_GUI = (*filters[i].module_gui_function)();
            filters[i].module_GUI = gtk_plug_new(GDK_WINDOW_XWINDOW(plugin_GUI_socket->window));
            gtk_widget_show(GTK_WIDGET(filters[i].module_GUI));
            gtk_container_add(GTK_CONTAINER(filters[i].module_GUI), plugin_GUI);
            gtk_widget_show(plugin_GUI);
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(checkbutton_active), filters[i].active);
            switch (filters[i].module_type) {
                case AUDIO   : gtk_label_set_text (GTK_LABEL(label_filter_type), "      (Audio ");
                               break;
                case VIDEO   : gtk_label_set_text (GTK_LABEL(label_filter_type), "      (Video ");
                               break;
                case SPU     : gtk_label_set_text (GTK_LABEL(label_filter_type), "      (Subpicture ");
                               break;
                default      : gtk_label_set_text (GTK_LABEL(label_filter_type), "      (Unknown ");
                               break;
            }
            switch (filters[i].module_phase) {
                case PRE     : gtk_label_set_text (GTK_LABEL(label_filter_phase), "Pre filter)    ");
                               break;
                case NORMAL  : gtk_label_set_text (GTK_LABEL(label_filter_phase), "Normal filter)    ");
                               break;
                case POST    : gtk_label_set_text (GTK_LABEL(label_filter_phase), "Post filter)    ");
                               break;
                default      : gtk_label_set_text (GTK_LABEL(label_filter_phase), "Unknown filter)    ");
                               break;
            }
            i = filters_index;
        }
    }
    /* Clean & Exit */
    g_string_free(command,TRUE);
    return;
}   

void on_combo_entry_dvdsource_changed(GtkEditable *editable,gpointer user_data) {
    gchar *last_char;
    GtkWidget *combo = (GtkWidget*)user_data;
    g_string_sprintf(Config.DVDsource,"%s",g_strstrip(gtk_entry_get_text(GTK_ENTRY(combo))));
    /* force "/" at end */
    last_char = (gchar*)((glong)Config.DVDsource->str + Config.DVDsource->len - 1);
    if (strncmp(last_char,"/",1)) {
        Config.DVDsource = g_string_append(Config.DVDsource,"/");
    }
    return;
}


void on_combo_entry2_changed(GtkEditable *editable,gpointer user_data) {
    GtkWidget *combo = (GtkWidget*)user_data;
    g_string_sprintf(Config.DIVXfileUser,"%s",gtk_entry_get_text(GTK_ENTRY(combo)));
    return;
}

void on_spinbutton_blur_changed(GtkEditable *editable,gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.blurradius = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
    return;
}

void on_spinbutton_cpus_changed(GtkEditable *editable,gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.cpus = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
    return;
}


void on_spinbutton_video_bitrate_changed(GtkEditable *editable,gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.video_bitrate = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
    return;
}

void on_spinbutton_video_stream_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.video_stream = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
    return;
}


void on_combo_audio_bitrate_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    if (strcmp(gtk_entry_get_text(GTK_ENTRY(entry)),"auto")==0) {
        Config.audio_bitrate = -1;
    } else {
        Config.audio_bitrate = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
    }
    return;
}


void on_spinbutton_audio_stream_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.audio_1st_stream = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
    return;
}

void on_spinbutton_clip_changed(GtkEditable *editable, gpointer user_data) {
    Config.cliptop = atoi(gtk_editable_get_chars(editable,0,-1));
    return;
}

void on_spinbutton_clipleft_changed(GtkEditable *editable, gpointer user_data) {
    Config.clipleft = atoi(gtk_editable_get_chars(editable,0,-1));
    return;
}

void on_spinbutton_clipright_changed(GtkEditable *editable, gpointer user_data) {
    Config.clipright = atoi(gtk_editable_get_chars(editable,0,-1));
    return;
}

void on_spinbutton_clip_offset_changed(GtkEditable *editable, gpointer user_data) {
    Config.clipbottom = atoi(gtk_editable_get_chars(editable,0,-1));
    return;
}

void on_spinbutton_clipframes_changed(GtkEditable *editable, gpointer user_data) {
    Config.autoclip_frames = atoi(gtk_editable_get_chars(editable,0,-1));
    return;
}


void on_checkbutton_limit_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    return;
}


void on_checkbutton_eject_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.eject_dvdrom = gtk_toggle_button_get_active(togglebutton);
    return;
}

void on_checkbutton_2nd_audio_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_2nd_enabled = gtk_toggle_button_get_active(togglebutton);
    Config.audio_2nd_stream = 0;
    gtk_widget_set_sensitive(vbox9_2nd,Config.audio_2nd_enabled);
    return;
}

void on_checkbutton_advanced_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    switch (gtk_toggle_button_get_active(togglebutton)) {
        case TRUE  : DVD_TREE_LEVEL = 4;
                     break;
        case FALSE : DVD_TREE_LEVEL = 2;
                     break;
        default    : DVD_TREE_LEVEL = 2;
                     break;
    }
    build_compose_tree(gtk_toggle_button_get_active(togglebutton));
    return;
}

void on_checkbutton_active_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    GString *command = g_string_new("");
    GtkWidget *combo = (GtkWidget*)user_data;
    gint i;
    /* Build new plugin gui */
    g_string_sprintf(command,"%s",gtk_entry_get_text(GTK_ENTRY(combo)));
    for (i=0;i<filters_index;i++) {
        if (strcmp(filters[i].module_name->str,command->str)==0) {
            filters[i].active = gtk_toggle_button_get_active(togglebutton);
            i = filters_index;
        }
    }
    /* Clean & Exit */
    g_string_free(command,TRUE);
    return;
}

void on_checkbutton_hyperzoom_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.hyper_zoom = gtk_toggle_button_get_active(togglebutton);
    return;
}

void on_checkbutton_autoclip_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.autoclip = gtk_toggle_button_get_active(togglebutton);
    return;
}

void on_checkbutton_deinterlace_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.deinterlace = gtk_toggle_button_get_active(togglebutton);
    return;
}

void on_checkbutton_pulldown_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.pulldown = gtk_toggle_button_get_active(togglebutton);
    return;
}

void on_checkbutton_dvddb_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.use_dvddb = gtk_toggle_button_get_active(togglebutton);
    return;
}


void on_checkbutton_debug_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.debug_log = gtk_toggle_button_get_active(togglebutton);
    return;
}


void on_entry2_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.nice = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
    return;
}

void on_checkbutton_audionorm_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_norm = gtk_toggle_button_get_active(togglebutton);
    return;
}

void on_spinbutton_width_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.set_width = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
}

void on_spinbutton_heigth_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.set_height = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
}

void on_spinbutton_angle_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.angle = atoi(gtk_entry_get_text(GTK_ENTRY(entry)));
}

void on_dvdstreams_select_row(GtkCList *clist,gint row,gint column,GdkEvent *event,gpointer user_data) {
    GdkColor col_yes,col_no;
    gchar *text;
    gint result;

    /* Allocate colours */
    gdk_color_parse("white",&col_no);
    gdk_color_parse("green3",&col_yes);

    /* Anything at all? */
    result = gtk_clist_get_text(clist,row,3,(gchar**)&text);
    if (result!=1) 
        return;

    if (strstr(text,"NO")!=NULL) {
        gtk_clist_set_text(clist,row,3,"   YES   ");
        gtk_clist_set_background(GTK_CLIST(clist),row,&col_yes);
    } 

    if (strstr(text,"YES")!=NULL) {
        gtk_clist_set_text(clist,row,3,"   NO   ");
        gtk_clist_set_background(GTK_CLIST(clist),row,&col_no);
    }

    return;
}


void on_dvdtitels_select_row(GtkCList *clist,gint row,gint column,GdkEvent *event,gpointer user_data) {
    /* Select titel */
    Config.CS[row] = TRUE;
    /* Build audio\subpictures page */
    on_combo_entry_DVDtitle_changed(NULL,NULL);
    return;
}


void on_dvdtitels_unselect_row(GtkCList *clist,gint row,gint column,GdkEvent *event,gpointer user_data) {
    /* Unselect titel */
    Config.CS[row] = FALSE;
    /* Build audio\subpictures page */
    on_combo_entry_DVDtitle_changed(NULL,NULL);
    return;
}


/* Parse selected mpeg input streams */
void on_dvdstream_ok_clicked(GtkButton *button,gpointer user_data) {
    gint row = 0;
    gint file = 0;
    gchar *text;
    /* Anything selected at all? */
    if (gtk_clist_get_text(GTK_CLIST(user_data),row,3,(gchar**)&text) == 1) {
        do {
            gtk_clist_get_text(GTK_CLIST(user_data),row,3,(gchar**)&text);
            if (strstr(text,"YES") != NULL) {
                /* this file should be encoded */
                gtk_clist_get_text(GTK_CLIST(user_data),row,0,(gchar**)&text);
                Config.CS_files[0][file] = g_string_new(Config.DVDsource->str);
                Config.CS_files[0][file] = g_string_append(Config.CS_files[0][file],"/");
                Config.CS_files[0][file] = g_string_append(Config.CS_files[0][file],text);
                file++;
                #ifdef DEBUG
                g_print("%s should be encoded\n",Config.CS_files[0][file-1]->str);
                #endif
            }
            row++;
        }
        while (gtk_clist_get_text(GTK_CLIST(user_data),row,3,(gchar**)&text) == 1);
    }
    /* --- */
    selected_files = file;
    gtk_widget_destroy(select_dialog);
    return;
}

void on_dvdstream_cancel_clicked(GtkButton *button,gpointer user_data) {
    selected_files = 0;
    gtk_widget_destroy(select_dialog);
    return;
}

void on_button8_clicked(GtkButton *button,gpointer user_data) {
    /* calculate bitrate */
    gint size = atoi(gtk_entry_get_text(GTK_ENTRY(spinbutton1)));
    gint duration = atoi(gtk_entry_get_text(GTK_ENTRY(spinbutton2)));
    gint audio = atoi(gtk_entry_get_text(GTK_ENTRY(spinbutton3)));
    gint width = atoi(gtk_entry_get_text(GTK_ENTRY(spinbutton4)));
    gint height = atoi(gtk_entry_get_text(GTK_ENTRY(spinbutton5)));
    gdouble res = width * height * 0.000000006607788;
    gdouble bitrate = ((size-(duration*audio*0.013721987)-(duration*res))/res)/(duration*5.5); /* for pal 25fps */
    GString *format = g_string_new("");

    /* Correct for other than PAL */
    if (CALCframerate != 25 ) {
        bitrate = bitrate/CALCframerate*25.00;
    }

    
    g_string_sprintf(format,"%i",(gint)bitrate);
    gtk_entry_set_text(GTK_ENTRY(entry3),format->str);

    g_string_free(format,TRUE);
    return;
}


void on_button10_clicked(GtkButton *button, gpointer user_data) {
    /* close calc window */
    gtk_widget_destroy(GTK_WIDGET(user_data));
    return;
}

void on_checkbutton_encode_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.encode = gtk_toggle_button_get_active(togglebutton);
    return;
}

void on_checkbutton_iso_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.create_iso = gtk_toggle_button_get_active(togglebutton);
    return;
}

void on_spinbutton_maxsizeoutput_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *entry = (GtkWidget*)user_data;
    Config.maxsize = atol(gtk_entry_get_text(GTK_ENTRY(entry)));
    return;
}

void on_stop_activate(GtkMenuItem *menuitem, gpointer user_data) {
    if (converting) {
        stop_dialog = create_stop_dialog();
        gtk_widget_show(stop_dialog);
    }
    /* TODO : if (cacheing) { */
    return;
}

void on_pause_activate(GtkMenuItem *menuitem, gpointer user_data) {
    if (converting) {
        if (paused==FALSE) {
            encoder_pause(FALSE);
            paused = TRUE;
            gnome_appbar_set_status(GNOME_APPBAR(appbar1),"   PAUSED, click Pause again to resume");

        } else {
            encoder_resume(FALSE);
            paused = FALSE;
            gnome_appbar_set_status(GNOME_APPBAR(appbar1),"   Resuming...");
        }
    }
    return;
}

void on_radiobutton_useDVDdevice_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    Config.useDVDdevice = (gtk_toggle_button_get_active(togglebutton));
    bind_titles_guitype();
    return;
}

void on_radiobutton_PAL_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    if (gtk_toggle_button_get_active(togglebutton) == TRUE) {
        CALCframerate = 25.00;
    }
    return;
}

void on_radiobutton_NTSC_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    if (gtk_toggle_button_get_active(togglebutton) == TRUE) {
        CALCframerate = 29.97;
    }
    return;
}


void on_radiobutton_useDVDsource_toggled (GtkToggleButton *togglebutton,gpointer user_data) {
    Config.useDVDdevice = !(gtk_toggle_button_get_active(togglebutton));
    return;
}


/* User clicked OK on 'Really quit encoding proces
   Here all flags are set to reach idle mode */
void on_button_ok_stop_clicked(GtkButton *button, gpointer user_data) {
    gboolean result;
    if (stop_dialog) {
        if (paused==TRUE) {
            encoder_resume(FALSE);          // resume encoder
        }
        encoder_stop(FALSE);                // stop encoder
        converting = FALSE;                 // clear encoding flag
        encoding_time = FALSE;              // ---
        quit_converting = TRUE;             // set request quit flag, used to shutdown threads by request
        stopped = TRUE;                     // set general idle mode flag
        paused = FALSE;                     // lift pause block
        druidpagestandard1 = NULL;
        gtk_widget_destroy(stop_dialog);    // Remove dialog
        gtk_widget_hide(hbox35);
        gnome_appbar_set_status(GNOME_APPBAR(appbar1),"");
        gnome_appbar_set_progress(GNOME_APPBAR(appbar1),1);
        /* Hide progres frame buttons */
        gtk_widget_hide(hbox35);

        result = pthread_cancel(ripthread); // cancel encoding thread

        g_log(DRIP_CB_LD,G_LOG_LEVEL_INFO,"Encoding stopped.");
    }
    return;
}


void on_button_no_stop_clicked(GtkButton *button,gpointer user_data) {
    if (stop_dialog) {
        gtk_widget_destroy(stop_dialog);
    }
    return;
}


void on_combo_entry_cache_location_changed(GtkEditable *editable, gpointer user_data) {
    gchar *last_char = NULL;
    GtkWidget *combo = (GtkWidget*)user_data;
    g_string_sprintf(Config.CACHElocation,"%s",gtk_entry_get_text(GTK_ENTRY(combo)));
    /* force "/" at end */
    last_char = (gchar*)((glong)Config.CACHElocation->str + Config.CACHElocation->len - 1);
    if (strncmp(last_char,"/",1)) {
        Config.CACHElocation = g_string_append(Config.CACHElocation,"/");
    }
    return;
}


void on_checkbutton_delete_cache_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.cache_delete_on_exit = (gtk_toggle_button_get_active(togglebutton));
    return;
}

void on_checkbutton_chunk_cache_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.cache_chunk = (gtk_toggle_button_get_active(togglebutton));
    return;
}

void on_button11_clicked(GtkButton *button, gpointer user_data) {
    /* OK on audio\subpicture dialog */
    gtk_widget_destroy(audio_subpicture_dialog);
    audio_subpicture_dialog = NULL;
    return;
}


void on_button13_clicked(GtkButton *button,gpointer user_data) {
    /* Cancel on audio\subpicture dialog */
    converting = FALSE;
    pthread_cancel(ripthread);
    gtk_widget_destroy(audio_subpicture_dialog);
    gnome_appbar_set_status(GNOME_APPBAR(appbar1),"   Ready.");
    return;
}

void on_radiobutton_audio_1st_channel_0_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_1st_stream = 0;
    return;
}


void on_radiobutton_audio_1st_channel_1_toggled(GtkToggleButton *togglebutton,gpointer user_data) {
    Config.audio_1st_stream = 1;
    return;
}


void on_radiobutton_audio_1st_channel_2_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_1st_stream = 2;
    return;
}


void on_radiobutton_audio_1st_channel_3_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_1st_stream = 3;
    return;
}


void on_radiobutton_audio_1st_channel_4_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_1st_stream = 4;
    return;
}


void on_radiobutton_audio_1st_channel_5_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_1st_stream = 5;
    return;
}


void on_radiobutton_audio_1st_channel_6_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_1st_stream = 6;
    return;
}

void on_radiobutton_audio_1st_channel_7_toggled (GtkToggleButton *togglebutton,gpointer user_data) {
    Config.audio_1st_stream = 7;
    return;
}

void on_radiobutton_audio_2nd_channel_0_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_2nd_stream = 0;
    return;
}


void on_radiobutton_audio_2nd_channel_1_toggled(GtkToggleButton *togglebutton,gpointer user_data) {
    Config.audio_2nd_stream = 1;
    return;
}


void on_radiobutton_audio_2nd_channel_2_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_2nd_stream = 2;
    return;
}


void on_radiobutton_audio_2nd_channel_3_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_2nd_stream = 3;
    return;
}


void on_radiobutton_audio_2nd_channel_4_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_2nd_stream = 4;
    return;
}


void on_radiobutton_audio_2nd_channel_5_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_2nd_stream = 5;
    return;
}


void on_radiobutton_audio_2nd_channel_6_toggled (GtkToggleButton *togglebutton, gpointer user_data) {
    Config.audio_2nd_stream = 6;
    return;
}

void on_radiobutton_audio_2nd_channel_7_toggled (GtkToggleButton *togglebutton,gpointer user_data) {
    Config.audio_2nd_stream = 7;
    return;
}


void on_combo_entry9_changed(GtkEditable *editable, gpointer user_data) {
    gint i = 0;
    gint not_found = TRUE;
    GtkWidget *combo = (GtkWidget*)user_data;
    gint CS = first_selected_titel();
    GString *sub_buffer = g_string_new("");

    while (i<32 && not_found) {
        g_string_sprintf(sub_buffer,"%s (%02d)",Config.subpicture_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[CS]]][i]->str,i+1);
        if (!strcmp(gtk_entry_get_text(GTK_ENTRY(combo)),sub_buffer->str)) {
            not_found = FALSE;
        } else {
            i++;
        }
    }
    if (i<32) { /* 33 = ( 32subpictures + 1none) -1 */
        /* Found subpicture stream */
        Config.subpicture_stream = i;
    } else {
        /* None or ?unknown? -> set to None (=-1) */
        Config.subpicture_stream = -1; 
    }
 
    g_string_free(sub_buffer,TRUE);
    return;
}

/* Update selected video codec */
void on_combo_entry11_changed(GtkEditable *editable, gpointer user_data) {
    gint i = 0;
    GtkWidget *combo = (GtkWidget*)user_data;
    while (i<Config.codecs_amount && strcmp(gtk_entry_get_text(GTK_ENTRY(combo)),Config.codecs[i].cdescription->str)) {
        i++;
    }
    Config.encoding_video_codec = i;

    return;
}

/* Update selected audio codec */
void on_combo_audiocodec_changed(GtkEditable *editable, gpointer user_data) {
    gint i = 0;
    GtkWidget *combo = (GtkWidget*)user_data;
    while (i<Config.codecs_amount && strcmp(gtk_entry_get_text(GTK_ENTRY(combo)),Config.codecs[i].cdescription->str)) {
        i++;
    }
    Config.encoding_audio_codec = i;

    return;
}


/* Update selected audio codec */
void on_combo_avi_entry_changed(GtkEditable *editable, gpointer user_data) {
    GtkWidget *combo = (GtkWidget*)user_data;
    Config.CURRENT_AVIFILE = atoi(gtk_entry_get_text(GTK_ENTRY(combo)));
    RECURSIVE = FALSE;
    /* -- AVI LIST -------------------------- */
    build_compose_avilist();
    /* -- DVD tree -------------------------- */
    build_compose_tree(FALSE);
    
    RECURSIVE = TRUE;
    return;
}

/* Update preference */
void on_combo_audio_preferenceA_changed(GtkEditable *editable, gpointer user_data) {
    g_string_sprintf(Config.audio_preferedA,"%s",gtk_entry_get_text(GTK_ENTRY(user_data)));
    return;
}

/* Update preference */
void on_combo_audio_preferenceB_changed(GtkEditable *editable, gpointer user_data) {
    g_string_sprintf(Config.audio_preferedB,"%s",gtk_entry_get_text(GTK_ENTRY(user_data)));
    return;
}

/* Update preference */
void on_combo_spu_preferenceA_changed(GtkEditable *editable, gpointer user_data) {
    g_string_sprintf(Config.spu_preferedA,"%s",gtk_entry_get_text(GTK_ENTRY(user_data)));
    return;
}

/* Update preference */
void on_combo_spu_preferenceB_changed(GtkEditable *editable, gpointer user_data) {
    g_string_sprintf(Config.spu_preferedB,"%s",gtk_entry_get_text(GTK_ENTRY(user_data)));

    return;
}


/* Change title to user selection for Druid dialog */
void on_combo_entry_DVDtitle_changed(GtkEditable *editable,gpointer user_data) {
  GtkWidget *label_ripdvd_select_audio_channel;
  GtkWidget *vbox9_1st;
  GSList *audio_1st_channels_group = NULL;
  GtkWidget *radiobutton_audio_1st_channel_0 = NULL;
  GtkWidget *radiobutton_audio_1st_channel_1 = NULL;
  GtkWidget *radiobutton_audio_1st_channel_2 = NULL;
  GtkWidget *radiobutton_audio_1st_channel_3 = NULL;
  GtkWidget *radiobutton_audio_1st_channel_4 = NULL;
  GtkWidget *radiobutton_audio_1st_channel_5 = NULL;
  GtkWidget *radiobutton_audio_1st_channel_6 = NULL;
  GtkWidget *radiobutton_audio_1st_channel_7 = NULL;
  GSList *audio_2nd_channels_group = NULL;
  GtkWidget *radiobutton_audio_2nd_channel_0 = NULL;
  GtkWidget *radiobutton_audio_2nd_channel_1 = NULL;
  GtkWidget *radiobutton_audio_2nd_channel_2 = NULL;
  GtkWidget *radiobutton_audio_2nd_channel_3 = NULL;
  GtkWidget *radiobutton_audio_2nd_channel_4 = NULL;
  GtkWidget *radiobutton_audio_2nd_channel_5 = NULL;
  GtkWidget *radiobutton_audio_2nd_channel_6 = NULL;
  GtkWidget *radiobutton_audio_2nd_channel_7 = NULL;
  GtkWidget *checkbutton_2nd_audio;
  GtkWidget *combo_subpicture;
  GtkWidget *label6;
  GtkWidget *hseparator2;
  GtkWidget *label_angle;
  GtkObject *spinbutton_angle_adj;
  GtkWidget *spinbutton_angle;
  GList *combo_subpicture_items = NULL;
  gboolean audio_preferedA_found = FALSE;
  gboolean spu_preferedA_found = FALSE;
  gint i;
  //gchar *sub_buffer;
  GtkWidget *combo_entry9;
  GString *temp[32],*language;

  /* Destroy previous gui */
  gtk_widget_destroy(vbox9b);

  /* Build Audio and Subpicture gui */
  vbox9b = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox9b);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox9b", vbox9b,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9b);
  gtk_container_add (GTK_CONTAINER (frame1), vbox9b);
  gtk_container_set_border_width (GTK_CONTAINER (vbox9b), 3);

  hbox21 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox21);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox21", hbox21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox21);
  gtk_box_pack_start (GTK_BOX (vbox9b), hbox21, TRUE, TRUE, 0);

  /* 1st Audio Channel */
  label_ripdvd_select_audio_channel = gtk_label_new (_(" Audio Channel  "));
  gtk_widget_ref (label_ripdvd_select_audio_channel);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_ripdvd_select_audio_channel", label_ripdvd_select_audio_channel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_ripdvd_select_audio_channel);
  gtk_box_pack_start (GTK_BOX (hbox21), label_ripdvd_select_audio_channel, FALSE, FALSE, 0);

  vbox9_1st = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox9_1st);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox9_1st", vbox9_1st,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9_1st);
  gtk_box_pack_start (GTK_BOX (hbox21), vbox9_1st, TRUE, TRUE, 0);

  /* Audio 0 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>0) {
      radiobutton_audio_1st_channel_0 = gtk_radio_button_new_with_label (audio_1st_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][0]->str);
      audio_1st_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_1st_channel_0));
      gtk_widget_ref (radiobutton_audio_1st_channel_0);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_1st_channel_0", radiobutton_audio_1st_channel_0,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_1st_channel_0);
      gtk_box_pack_start (GTK_BOX (vbox9_1st), radiobutton_audio_1st_channel_0, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][0] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_1st_channel_0,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 0 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][0]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {
       
          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_0), TRUE);
          Config.audio_1st_stream = 0;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][0]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_0), TRUE);
          Config.audio_1st_stream = 0;
      }
  }

  /* Audio 1 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>1) {
      radiobutton_audio_1st_channel_1 = gtk_radio_button_new_with_label (audio_1st_channels_group,  Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][1]->str);
      audio_1st_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_1st_channel_1));
      gtk_widget_ref (radiobutton_audio_1st_channel_1);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_1st_channel_1", radiobutton_audio_1st_channel_1,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_1st_channel_1);
      gtk_box_pack_start (GTK_BOX (vbox9_1st), radiobutton_audio_1st_channel_1, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][1] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_1st_channel_1,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 1 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][1]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {
       
          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_1), TRUE);
          Config.audio_1st_stream = 1;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][1]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_1), TRUE);
          Config.audio_1st_stream = 1;
      }
  }

  /* Audio 2 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>2) {
      radiobutton_audio_1st_channel_2 = gtk_radio_button_new_with_label (audio_1st_channels_group,  Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][2]->str);
      audio_1st_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_1st_channel_2));
      gtk_widget_ref (radiobutton_audio_1st_channel_2);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_1st_channel_2", radiobutton_audio_1st_channel_2,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_1st_channel_2);
      gtk_box_pack_start (GTK_BOX (vbox9_1st), radiobutton_audio_1st_channel_2, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][2] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_1st_channel_2,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 2 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][2]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_2), TRUE);
          Config.audio_1st_stream = 2;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][2]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_2), TRUE);
          Config.audio_1st_stream = 2;
      }
  }

  /* Audio 3 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>3) {
      radiobutton_audio_1st_channel_3 = gtk_radio_button_new_with_label (audio_1st_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][3]->str);
      audio_1st_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_1st_channel_3));
      gtk_widget_ref (radiobutton_audio_1st_channel_3);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_1st_channel_3", radiobutton_audio_1st_channel_3,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_1st_channel_3);
      gtk_box_pack_start (GTK_BOX (vbox9_1st), radiobutton_audio_1st_channel_3, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][3] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_1st_channel_3,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 3 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][3]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_3), TRUE);
          Config.audio_1st_stream = 3;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][3]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_3), TRUE);
          Config.audio_1st_stream = 3;
      }

  }

  /* Audio 4 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>4) {
      radiobutton_audio_1st_channel_4 = gtk_radio_button_new_with_label (audio_1st_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][4]->str);
      audio_1st_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_1st_channel_4));
      gtk_widget_ref (radiobutton_audio_1st_channel_4);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_1st_channel_4", radiobutton_audio_1st_channel_4,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_1st_channel_4);
      gtk_box_pack_start (GTK_BOX (vbox9_1st), radiobutton_audio_1st_channel_4, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][4] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_1st_channel_4,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 4 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][4]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_4), TRUE);
          Config.audio_1st_stream = 4;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][4]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_4), TRUE);
          Config.audio_1st_stream = 4;
      }

  }

  /* Audio 5 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>5) {
      radiobutton_audio_1st_channel_5 = gtk_radio_button_new_with_label (audio_1st_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][5]->str);
      audio_1st_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_1st_channel_5));
      gtk_widget_ref (radiobutton_audio_1st_channel_5);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_1st_channel_5", radiobutton_audio_1st_channel_5,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_1st_channel_5);
      gtk_box_pack_start (GTK_BOX (vbox9_1st), radiobutton_audio_1st_channel_5, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][5] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_1st_channel_5,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 5 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][5]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {
          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_5), TRUE);
          Config.audio_1st_stream = 5;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][5]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_5), TRUE);
          Config.audio_1st_stream = 5;
      }

  }

  /* Audio 6 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>6) {
      radiobutton_audio_1st_channel_6 = gtk_radio_button_new_with_label (audio_1st_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][6]->str);
      audio_1st_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_1st_channel_6));
      gtk_widget_ref (radiobutton_audio_1st_channel_6);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_1st_channel_6", radiobutton_audio_1st_channel_6,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_1st_channel_6);
      gtk_box_pack_start (GTK_BOX (vbox9_1st), radiobutton_audio_1st_channel_6, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][6] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_1st_channel_6,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 6 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][6]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_6), TRUE);
          Config.audio_1st_stream = 6;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][6]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_6), TRUE);
          Config.audio_1st_stream = 6;
      }
  }

  /* Audio 7 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>7) {
      radiobutton_audio_1st_channel_7 = gtk_radio_button_new_with_label (audio_1st_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][7]->str);
      audio_1st_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_1st_channel_7));
      gtk_widget_ref (radiobutton_audio_1st_channel_7);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_1st_channel_7", radiobutton_audio_1st_channel_7,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_1st_channel_7);
      gtk_box_pack_start (GTK_BOX (vbox9_1st), radiobutton_audio_1st_channel_7, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][7] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_1st_channel_7,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 7 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][7]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_7), TRUE);
          Config.audio_1st_stream = 7;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][7]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_1st_channel_7), TRUE);
          Config.audio_1st_stream = 7;
      }
  }

  /* 2nd Audio Channel */
  label_ripdvd_select_audio_channel = gtk_label_new (_(" 2nd Audio Channel  "));
  gtk_widget_ref (label_ripdvd_select_audio_channel);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label_ripdvd_select_audio_channel", label_ripdvd_select_audio_channel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_ripdvd_select_audio_channel);
  gtk_box_pack_start (GTK_BOX (hbox21), label_ripdvd_select_audio_channel, FALSE, FALSE, 0);

  vbox9_2nd = gtk_vbox_new (TRUE, 0);
  gtk_widget_ref (vbox9_2nd);
  gtk_object_set_data_full (GTK_OBJECT (window1), "vbox9_2nd", vbox9_2nd,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9_2nd);
  gtk_box_pack_start (GTK_BOX (hbox21), vbox9_2nd, TRUE, TRUE, 0);

  /* Audio 0 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>0) {
      radiobutton_audio_2nd_channel_0 = gtk_radio_button_new_with_label (audio_2nd_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][0]->str);
      audio_2nd_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_2nd_channel_0));
      gtk_widget_ref (radiobutton_audio_2nd_channel_0);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_2nd_channel_0", radiobutton_audio_2nd_channel_0,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_2nd_channel_0);
      gtk_box_pack_start (GTK_BOX (vbox9_2nd), radiobutton_audio_2nd_channel_0, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][0] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_2nd_channel_0,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 0 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][0]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_0), TRUE);
          Config.audio_2nd_stream = 0;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][0]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_0), TRUE);
          Config.audio_2nd_stream = 0;
      }
  }

  /* Audio 1 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>1) {
      radiobutton_audio_2nd_channel_1 = gtk_radio_button_new_with_label (audio_2nd_channels_group,  Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][1]->str);
      audio_2nd_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_2nd_channel_1));
      gtk_widget_ref (radiobutton_audio_2nd_channel_1);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_2nd_channel_1", radiobutton_audio_2nd_channel_1,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_2nd_channel_1);
      gtk_box_pack_start (GTK_BOX (vbox9_2nd), radiobutton_audio_2nd_channel_1, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][1] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_2nd_channel_1,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 1 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][1]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_1), TRUE);
          Config.audio_2nd_stream = 1;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][1]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_1), TRUE);
          Config.audio_2nd_stream = 1;
      }
  }

  /* Audio 2 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>2) {
      radiobutton_audio_2nd_channel_2 = gtk_radio_button_new_with_label (audio_2nd_channels_group,  Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][2]->str);
      audio_2nd_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_2nd_channel_2));
      gtk_widget_ref (radiobutton_audio_2nd_channel_2);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_2nd_channel_2", radiobutton_audio_2nd_channel_2,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_2nd_channel_2);
      gtk_box_pack_start (GTK_BOX (vbox9_2nd), radiobutton_audio_2nd_channel_2, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][2] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_2nd_channel_2,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 2 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][2]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_2), TRUE);
          Config.audio_2nd_stream = 2;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][2]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_2), TRUE);
          Config.audio_2nd_stream = 2;
      }
  }

  /* Audio 3 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>3) {
      radiobutton_audio_2nd_channel_3 = gtk_radio_button_new_with_label (audio_2nd_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][3]->str);
      audio_2nd_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_2nd_channel_3));
      gtk_widget_ref (radiobutton_audio_2nd_channel_3);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_2nd_channel_3", radiobutton_audio_2nd_channel_3,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_2nd_channel_3);
      gtk_box_pack_start (GTK_BOX (vbox9_2nd), radiobutton_audio_2nd_channel_3, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][3] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_2nd_channel_3,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 3 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][3]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_3), TRUE);
          Config.audio_2nd_stream = 3;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][3]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_3), TRUE);
          Config.audio_2nd_stream = 3;
      }

  }

  /* Audio 4 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>4) {
      radiobutton_audio_2nd_channel_4 = gtk_radio_button_new_with_label (audio_2nd_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][4]->str);
      audio_2nd_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_2nd_channel_4));
      gtk_widget_ref (radiobutton_audio_2nd_channel_4);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_2nd_channel_4", radiobutton_audio_2nd_channel_4,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_2nd_channel_4);
      gtk_box_pack_start (GTK_BOX (vbox9_2nd), radiobutton_audio_2nd_channel_4, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][4] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_2nd_channel_4,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 4 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][4]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_4), TRUE);
          Config.audio_2nd_stream = 4;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][4]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_4), TRUE);
          Config.audio_2nd_stream = 4;
      }

  }

  /* Audio 5 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>5) {
      radiobutton_audio_2nd_channel_5 = gtk_radio_button_new_with_label (audio_2nd_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][5]->str);
      audio_2nd_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_2nd_channel_5));
      gtk_widget_ref (radiobutton_audio_2nd_channel_5);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_2nd_channel_5", radiobutton_audio_2nd_channel_5,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_2nd_channel_5);
      gtk_box_pack_start (GTK_BOX (vbox9_2nd), radiobutton_audio_2nd_channel_5, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][5] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_2nd_channel_5,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 5 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][5]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {
          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_5), TRUE);
          Config.audio_2nd_stream = 5;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][5]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_5), TRUE);
          Config.audio_2nd_stream = 5;
      }

  }

  /* Audio 6 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>6) {
      radiobutton_audio_2nd_channel_6 = gtk_radio_button_new_with_label (audio_2nd_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][6]->str);
      audio_2nd_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_2nd_channel_6));
      gtk_widget_ref (radiobutton_audio_2nd_channel_6);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_2nd_channel_6", radiobutton_audio_2nd_channel_6,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_2nd_channel_6);
      gtk_box_pack_start (GTK_BOX (vbox9_2nd), radiobutton_audio_2nd_channel_6, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][6] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_2nd_channel_6,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 6 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][6]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_6), TRUE);
          Config.audio_2nd_stream = 6;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][6]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_6), TRUE);
          Config.audio_2nd_stream = 6;
      }
  }

  /* Audio 7 */
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>7) {
      radiobutton_audio_2nd_channel_7 = gtk_radio_button_new_with_label (audio_2nd_channels_group, Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][7]->str);
      audio_2nd_channels_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_audio_2nd_channel_7));
      gtk_widget_ref (radiobutton_audio_2nd_channel_7);
      gtk_object_set_data_full (GTK_OBJECT (window1), "radiobutton_audio_2nd_channel_7", radiobutton_audio_2nd_channel_7,
                                (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show (radiobutton_audio_2nd_channel_7);
      gtk_box_pack_start (GTK_BOX (vbox9_2nd), radiobutton_audio_2nd_channel_7, FALSE, FALSE, 0);
      /* Audio type unsupported */
      if (Config.audio_channel_types[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][7] == 6) {
          gtk_widget_set_sensitive(radiobutton_audio_2nd_channel_7,FALSE);
          g_log(DRIP_CB_LD,G_LOG_LEVEL_MESSAGE,"Audio channel 7 is of type DTS, unsupported");
      }
      /* Audio prefered? */
      if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][7]->str,Config.audio_preferedA->str)==0 && audio_preferedA_found == FALSE) {

          audio_preferedA_found = TRUE;
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_7), TRUE);
          Config.audio_2nd_stream = 7;
      } else if (strcmp(Config.audio_channel_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][7]->str,Config.audio_preferedB->str)==0 && audio_preferedA_found == FALSE) {
          gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_audio_2nd_channel_7), TRUE);
          Config.audio_2nd_stream = 7;
      }
  }

  /* 2nd audio enable\disable toggle */
  checkbutton_2nd_audio = gtk_check_button_new_with_label (_("  Encode a 2nd audio channel into avi"));
  gtk_widget_ref (checkbutton_2nd_audio);
  gtk_object_set_data_full (GTK_OBJECT (window1), "checkbutton_2nd_audio", checkbutton_2nd_audio,(GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (checkbutton_2nd_audio);
  gtk_box_pack_start (GTK_BOX (vbox9b), checkbutton_2nd_audio, FALSE, FALSE, 0);
  //gtk_tooltips_set_tip (tooltips, checkbutton_2nd_audio, _("Encode a 2nd audio channel into the avi"),NULL);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton_2nd_audio), Config.audio_2nd_enabled);
  gtk_widget_set_sensitive(checkbutton_2nd_audio,Config.two_audio_channels_support);
  gtk_widget_set_sensitive(vbox9_2nd,Config.audio_2nd_enabled);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox9b), hseparator2, FALSE, FALSE, 0);
  gtk_widget_set_usize (hseparator2, -1, 30);

  /* Subpictures */
  hbox22 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox22);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox22", hbox22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox22);
  gtk_box_pack_start (GTK_BOX (vbox9b), hbox22, TRUE, TRUE, 5);

  label6 = gtk_label_new (_(" Subpicture   "));
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (window1), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_box_pack_start (GTK_BOX (hbox22), label6, FALSE, FALSE, 0);

  combo_subpicture = gtk_combo_new ();
  gtk_widget_ref (combo_subpicture);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_subpicture", combo_subpicture,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_subpicture);

  combo_entry9 = GTK_COMBO (combo_subpicture)->entry;
  gtk_widget_ref (combo_entry9);
  gtk_object_set_data_full (GTK_OBJECT (window1), "combo_entry9", combo_entry9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry9);

  language = g_string_new("None (00)");

  gtk_box_pack_start (GTK_BOX (hbox22), combo_subpicture, TRUE, TRUE, 0);
  combo_subpicture_items = g_list_append (combo_subpicture_items, (gpointer)"None (00)");
  for (i=0;i<Config.subpictures_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]];i++) {
      temp[i] = g_string_new("");
      g_string_sprintf(temp[i],"%s (%02d)",Config.subpicture_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][i]->str,i+1);
      combo_subpicture_items = g_list_append (combo_subpicture_items, (gpointer)temp[i]->str);
      /* Auto select prefered langauge */
      if (strcmp(Config.subpicture_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][i]->str,Config.spu_preferedA->str)==0 && spu_preferedA_found == FALSE) {
          g_string_sprintf(language,"%s",temp[i]->str);
          Config.subpicture_stream = i;
          spu_preferedA_found = TRUE;
      } else if (strcmp(Config.subpicture_names[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]][i]->str,Config.spu_preferedB->str)==0 && spu_preferedA_found == FALSE) {
          g_string_sprintf(language,"%s",temp[i]->str);
          Config.subpicture_stream = i;
      }
  }
  
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_subpicture), combo_subpicture_items);
  g_list_free (combo_subpicture_items);
  gtk_entry_set_text (GTK_ENTRY (combo_entry9), language->str);
  g_string_free(language,TRUE);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_ref (hseparator2);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hseparator2);
  gtk_box_pack_start (GTK_BOX (vbox9b), hseparator2, FALSE, FALSE, 0);
  gtk_widget_set_usize (hseparator2, -1, 30);

  /* Angles */
  hbox22 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox22);
  gtk_object_set_data_full (GTK_OBJECT (window1), "hbox22", hbox22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox22);
  gtk_box_pack_start (GTK_BOX (vbox9b), hbox22, TRUE, TRUE, 5);

  label_angle = gtk_label_new (_("  DVD Video Angle  "));
  gtk_widget_ref (label_angle);
  gtk_object_set_data_full (GTK_OBJECT(window1), "label_angle", label_angle,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_angle);
  gtk_box_pack_start (GTK_BOX (hbox22), label_angle, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label_angle), GTK_JUSTIFY_RIGHT);

  spinbutton_angle_adj = gtk_adjustment_new(Config.angle, 1, Config.VT_Angles[Config.CS_belongs_to_VT[first_selected_titel()]], 1, 1, 10);
  spinbutton_angle = gtk_spin_button_new (GTK_ADJUSTMENT (spinbutton_angle_adj), 1, 0);
  gtk_widget_ref (spinbutton_angle);
  gtk_object_set_data_full (GTK_OBJECT (window1), "spinbutton_angle", spinbutton_angle,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spinbutton_angle);
  gtk_box_pack_start (GTK_BOX (hbox22), spinbutton_angle, TRUE, TRUE, 0);

  /* Callbacks */
  gtk_signal_connect (GTK_OBJECT (spinbutton_angle), "changed",
                      GTK_SIGNAL_FUNC (on_spinbutton_angle_changed),
                      spinbutton_angle);
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>0) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_1st_channel_0), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_1st_channel_0_toggled),
                          radiobutton_audio_1st_channel_0);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>1) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_1st_channel_1), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_1st_channel_1_toggled),
                          radiobutton_audio_1st_channel_1);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>2) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_1st_channel_2), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_1st_channel_2_toggled),
                          radiobutton_audio_1st_channel_2);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>3) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_1st_channel_3), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_1st_channel_3_toggled),
                          radiobutton_audio_1st_channel_3);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>4) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_1st_channel_4), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_1st_channel_4_toggled),
                          radiobutton_audio_1st_channel_4);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>5) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_1st_channel_5), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_1st_channel_5_toggled),
                          radiobutton_audio_1st_channel_5);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>6) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_1st_channel_6), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_1st_channel_6_toggled),
                          radiobutton_audio_1st_channel_6);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>7) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_1st_channel_7), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_1st_channel_7_toggled),
                          radiobutton_audio_1st_channel_7);
  }

  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>0) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_2nd_channel_0), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_2nd_channel_0_toggled),
                          radiobutton_audio_2nd_channel_0);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>1) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_2nd_channel_1), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_2nd_channel_1_toggled),
                          radiobutton_audio_2nd_channel_1);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>2) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_2nd_channel_2), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_2nd_channel_2_toggled),
                          radiobutton_audio_2nd_channel_2);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>3) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_2nd_channel_3), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_2nd_channel_3_toggled),
                          radiobutton_audio_2nd_channel_3);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>4) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_2nd_channel_4), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_2nd_channel_4_toggled),
                          radiobutton_audio_2nd_channel_4);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>5) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_2nd_channel_5), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_2nd_channel_5_toggled),
                          radiobutton_audio_2nd_channel_5);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>6) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_2nd_channel_6), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_2nd_channel_6_toggled),
                          radiobutton_audio_2nd_channel_6);
  }
  if (Config.audio_channels_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]]>7) {
      gtk_signal_connect (GTK_OBJECT (radiobutton_audio_2nd_channel_7), "toggled",
                          GTK_SIGNAL_FUNC (on_radiobutton_audio_2nd_channel_7_toggled),
                          radiobutton_audio_2nd_channel_7);
  }
  gtk_signal_connect (GTK_OBJECT (combo_entry9), "changed",
                      GTK_SIGNAL_FUNC (on_combo_entry9_changed),
                      combo_entry9);
  gtk_signal_connect (GTK_OBJECT (checkbutton_2nd_audio), "toggled",
                      GTK_SIGNAL_FUNC (on_checkbutton_2nd_audio_toggled),
                      checkbutton_2nd_audio);


  /* Clean & Exit */
  for (i=0;i<Config.subpictures_in_dvd[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[first_selected_titel()]]];i++) {
      g_string_free(temp[i],TRUE);
  }
  return;
}


void on_save_preferences_activate(GtkMenuItem *menuitem, gpointer user_data) {
    save_config(FALSE);
    gnome_appbar_set_status(GNOME_APPBAR(appbar1),"   Done saving.");
    return;
}

void on_ripdvd_activate(GtkMenuItem *menuitem, gpointer user_data) {
    on_button_main_rip_clicked((GtkButton*)menuitem,user_data);
    return;
}

void on_dvd2vcd_activate(GtkMenuItem *menuitem, gpointer user_data) {
g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"on_dvd2vcd_activate");
    on_button_main_dvd2vcd_clicked((GtkButton*)menuitem,user_data);
    return;
}


void on_button_calculate_bitrate_clicked(GtkButton *button, gpointer user_data) {
    GtkWidget *calc_window;

    calc_window = create_calculate_bitrate();
    gtk_widget_show(calc_window);
    return;
}

void on_rescan_for_dvd_activate(GtkMenuItem *menuitem, gpointer user_data) {
    on_button_main_rescan_clicked(NULL,NULL);
    return;
}


void on_exit1_activate(GtkMenuItem *menuitem, gpointer user_data) {
    terminate(FALSE,FALSE);
    return;
}

void on_preferences1_activate(GtkMenuItem *menuitem, gpointer user_data) {
    /* show properties interface */
    if (propertybox1 == NULL) {
        propertybox1 = create_propertybox1 ();
    }
    return;
}


void on_about1_activate(GtkMenuItem *menuitem,gpointer user_data) {
    GtkWidget* aboutbox;
    aboutbox = create_about_drip();
    gtk_widget_show(aboutbox);
    return;
}


/* Remove dialogs and stop encoding process */
void on_drip_druid_cancel(GnomeDruid *gnomedruid,gpointer user_data) {
    encoder_stop(FALSE);
    converting = FALSE;
    pthread_cancel(ripthread);
    gtk_widget_destroy(audio_subpicture_dialog);
    gtk_widget_hide(hbox35);
    audio_subpicture_dialog = NULL;
    encoding_time = FALSE;
    return;
}

gint build_compare(gconstpointer a,gconstpointer b) {
    selected_chapters_t *scA = (selected_chapters_t*)a;
    selected_chapters_t *scB = (selected_chapters_t*)b;
    if ((scA!=NULL) && (scB!=NULL)) {
        if ( (scA->VTS  == scB->VTS) && 
             (scA->VT   == scB->VT) &&
             (scA->PC   == scB->PC) &&
             (scA->CHAP == scB->CHAP) &&
             (scA->CHAP_TOTAL == scB->CHAP_TOTAL) &&
             (scA->ANGL == scB->ANGL))
                return 0;
    }
    return 1;
}

gint dvdtree_add_chapter(gint VTS,gint VT,gint PC,gint CHAP,gint CHAP_TOTAL,gint ANGL) {
    selected_chapters_t *sc = (selected_chapters_t*)g_malloc(sizeof(selected_chapters_t));
 
    sc->VTS = VTS;
    sc->VT  = VT;
    sc->PC  = PC;
    sc->CHAP = CHAP;
    sc->CHAP_TOTAL = CHAP_TOTAL;
    sc->ANGL = ANGL;
    if (g_list_find_custom(Config.selected_chapters[Config.CURRENT_AVIFILE],sc,build_compare) == NULL) {
        Config.selected_chapters[Config.CURRENT_AVIFILE] = g_list_append(Config.selected_chapters[Config.CURRENT_AVIFILE],(gpointer)sc);
    }

    return TRUE;
}

gint dvdtree_delete_chapter(gint VTS,gint VT,gint PC,gint CHAP,gint CHAP_TOTAL,gint ANGL) {
    selected_chapters_t *sc;
    selected_chapters_t *sc2 = (selected_chapters_t*)g_malloc(sizeof(selected_chapters_t));
    
    sc2->VTS = VTS;
    sc2->VT  = VT;
    sc2->PC  = PC;
    sc2->CHAP = CHAP;
    sc2->CHAP_TOTAL = CHAP_TOTAL;
    sc2->ANGL = ANGL;
 
    sc = (selected_chapters_t*)g_list_find_custom(Config.selected_chapters[Config.CURRENT_AVIFILE],sc2,build_compare);
    if (sc != NULL) {
        sc = (selected_chapters_t*)((GList*)sc)->data;
        Config.selected_chapters[Config.CURRENT_AVIFILE] = g_list_remove(Config.selected_chapters[Config.CURRENT_AVIFILE],(gpointer)sc);
    }
    /* Clean / exit */
    g_free(sc);
    g_free(sc2);
    return TRUE;
}

/* Callback for deselect on tree */
void dvdtree_deselect_itemsignal(GtkWidget *item,GtkTreeItem *treeitem) {
    gchar *name;
    GtkLabel *label;
    GList *list;
    gchar **chunks;
    void (*handler)(GtkTree*,GtkWidget*);
    static gint last_s = 0;
    gint last_i = 0;
    gint result,i;
    gboolean deselected;

    /* Keep track of which handler is called 1st */
    if (last_s == 0) {
        last_s = 1;
        last_i = 1;
    }
    /* It's a Bin, so it has one child, which we know to be a label, so get that */
    label = GTK_LABEL(GTK_BIN(item)->child);
    /* Get the text of the label */
    gtk_label_get(label, &name);
    /* Get the level of the tree which the item is in */
    if (strncmp(name,"Chapter",7) == 0) {
        chunks = g_strsplit(name,",",0);
        result = dvdtree_delete_chapter(atoi(chunks[3])-1,atoi(chunks[4])-1,atoi(chunks[2])-1,atoi(chunks[1])-1,atoi(chunks[6])-1,atoi(chunks[5])-1);
        g_strfreev(chunks);
    }
    /* Set handler */
    handler = gtk_tree_unselect_child;
    /* select\deselect items below current one */
    if (RECURSIVE && GTK_TREE(item->parent)->level < DVD_TREE_LEVEL) {
        for (i=0;i<g_list_length(GTK_TREE(treeitem->subtree)->children);i++) {
            list = g_list_nth(GTK_TREE(treeitem->subtree)->children,i);    
            deselected = (NULL != g_list_find(GTK_TREE(item->parent)->root_tree->selection,list->data));
            if (!deselected) {
                (handler)(GTK_TREE(item->parent),GTK_WIDGET(list->data));
            }
        }
    }
    /* Is this instance the 1st handler? */
    if (last_i == 1) {
        last_s = 0;
        build_compose_avilist();
    }
    return;
}

/* Callback for select on tree */
void dvdtree_select_itemsignal(GtkWidget *item,GtkTreeItem *treeitem) {
    gchar *name;
    GtkLabel *label;
    GList *list;
    gchar **chunks;
    void (*handler)(GtkTree*,GtkWidget*);
    static gint last_s = 0;
    gint last_i = 0;
    gint i;
    gboolean selected;

    /* Keep track of which handler is called 1st */
    if (last_s == 0) {
        last_s = 1;
        last_i = 1;
    }
    /* It's a Bin, so it has one child, which we know to be a label, so get that */
    label = GTK_LABEL (GTK_BIN(item)->child);
    /* Get the text of the label */
    gtk_label_get(label, &name);
    /* Get the level of the tree which the item is in */
    if (strncmp(name,"Chapter",7) == 0) {
        chunks = g_strsplit(name,",",0);
        dvdtree_add_chapter(atoi(chunks[3])-1,atoi(chunks[4])-1,atoi(chunks[2])-1,atoi(chunks[1])-1,atoi(chunks[6])-1,atoi(chunks[5])-1);
        g_strfreev(chunks);
    }
    /* Set handler */
    handler = gtk_tree_select_child;
    /* select\deselect items below current one */
    if (RECURSIVE && GTK_TREE(item->parent)->level < DVD_TREE_LEVEL) {
        for (i=0;i<g_list_length(GTK_TREE(treeitem->subtree)->children);i++) {
            list = g_list_nth(GTK_TREE(treeitem->subtree)->children,i);  
            selected = (NULL != g_list_find(GTK_TREE(item->parent)->root_tree->selection,list->data));
            if (!selected) {
                (handler)(GTK_TREE(item->parent),GTK_WIDGET(list->data));
            }
        }
    }
    /* Is this instance the 1st handler? */
    if (last_i == 1) {
        last_s = 0;
        build_compose_avilist();
    }

    return;
}


/* Build the list of chapters selected for an avi */
void build_compose_avilist() {
    /* list widgets */
    GtkWidget *clist1;
    GtkWidget *label_select_pc;
    GtkWidget *label_select_angle;
    GtkWidget *label_select_chap;
    GtkWidget *label_select_chap_total;
    GtkWidget *label_select_playback;
    GtkWidget *label_select_frames;
    GtkWidget *label_select_aspect;
    GtkWidget *label_select_FPS;
    GtkWidget *label_select_title;
    GtkWidget *label_select_vts;
    GString *select_pc = g_string_new("");
    GString *select_angle = g_string_new("");
    GString *select_chap = g_string_new("");
    GString *select_chap_total = g_string_new("");
    GString *select_playback = g_string_new("");
    GString *select_frames = g_string_new("");
    GString *select_aspect = g_string_new("");
    GString *select_FPS = g_string_new("");
    GString *select_title = g_string_new("");
    GString *select_vts = g_string_new("");
    GString *labelStr = g_string_new("");
    GString *labelTimeStr = g_string_new("");
    gchar *row[10];
    GtkWidget *viewport1 = viewport_avi;
    GList *temp_list;
    selected_chapters_t *sc;
    gfloat f2e,f2e_total;

    // Clean it..
    if (viewport1)
        if (GTK_BIN(viewport1)->child != NULL) gtk_widget_destroy(GTK_BIN(viewport1)->child);

    // Build it..
    clist1 = gtk_clist_new (10);
    current_avi_clist = clist1; // make global
    gtk_widget_ref (clist1);
    gtk_object_set_data_full (GTK_OBJECT (window1), "clist1", clist1,(GtkDestroyNotify) gtk_widget_unref);
    gtk_container_add (GTK_CONTAINER (viewport1), clist1);
    gtk_widget_show (clist1);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 160);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 2, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 3, 100);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 4, 150);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 5, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 6, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 7, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 8, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 9, 80);

    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 0,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 1,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 2,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 3,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 4,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 5,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 6,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 7,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 8,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 9,TRUE);

    gtk_clist_set_column_justification(GTK_CLIST (clist1), 0, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 1, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 2, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 3, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 4, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 5, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 6, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 7, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 8, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 9, GTK_JUSTIFY_CENTER);
    gtk_clist_set_selection_mode (GTK_CLIST (clist1), GTK_SELECTION_SINGLE);
    gtk_clist_column_titles_show (GTK_CLIST (clist1));

    label_select_chap_total = gtk_label_new (_("  Chapter  "));
    gtk_widget_ref (label_select_chap_total);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_chap_total", label_select_chap_total,(GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_show (label_select_chap_total);
    gtk_clist_set_column_widget (GTK_CLIST(clist1), 0, label_select_chap_total);

    label_select_pc = gtk_label_new (_("  Program Chain  "));
    gtk_widget_ref (label_select_pc);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_pc", label_select_pc,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_pc);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label_select_pc);

    label_select_angle = gtk_label_new (_("  Angles  "));
    gtk_widget_ref (label_select_angle);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_angle", label_select_angle,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_angle);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 3, label_select_angle);

    label_select_chap = gtk_label_new (_("  Chapter/PC  "));
    gtk_widget_ref (label_select_chap);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_chap", label_select_chap,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_chap);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 2, label_select_chap);

    label_select_playback = gtk_label_new (_("  Playback  "));
    gtk_widget_ref (label_select_playback);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_playback", label_select_playback,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_playback);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 4, label_select_playback);

    label_select_frames = gtk_label_new (_("  Frames  "));
    gtk_widget_ref (label_select_frames);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_frames", label_select_frames,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_frames);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 5, label_select_frames);

    label_select_aspect = gtk_label_new (_("  Aspect  "));
    gtk_widget_ref (label_select_aspect);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_aspect", label_select_aspect,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_aspect);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 6, label_select_aspect);

    label_select_FPS = gtk_label_new (_("  FPS  "));
    gtk_widget_ref (label_select_FPS);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_FPS", label_select_FPS,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_FPS);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 7, label_select_FPS);

    label_select_title = gtk_label_new (_("  DVD Title  "));
    gtk_widget_ref (label_select_title);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_title", label_select_title,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_title);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 8, label_select_title);

    label_select_vts = gtk_label_new (_("  DVD Title Set  "));
    gtk_widget_ref (label_select_vts);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_vts", label_select_vts,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_vts);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 9, label_select_vts);

    /* Fill in columns */
    temp_list = Config.selected_chapters[Config.CURRENT_AVIFILE];
    f2e_total = 0;
    while (temp_list) {
        sc = (selected_chapters_t*)temp_list->data;
        g_string_sprintf(select_pc,"%i",sc->PC+1);
        g_string_sprintf(select_angle,"%i",sc->ANGL+1);
        g_string_sprintf(select_chap,"%i",sc->CHAP+1);
        g_string_sprintf(select_chap_total,"%i",sc->CHAP_TOTAL+1);
        f2e = Config.frames2encode[sc->PC] / Config.CS_Chapters[sc->PC]; // Duration of a chapter: PC duration/chapters
        seconds2time((gint)(f2e/Config.framerate),select_playback);
        g_string_sprintf(select_frames,"%.0f",f2e);
        f2e_total += f2e;
        g_string_sprintf(select_aspect,"%.3g:1",Config.VTS_Aspects[sc->VTS]);
        g_string_sprintf(select_FPS,"%g",Config.framerate);
        g_string_sprintf(select_title,"%i",sc->VT+1);
        g_string_sprintf(select_vts,"%i",sc->VTS+1);

        row[1] = select_pc->str;
        row[3] = select_angle->str;
        row[2] = select_chap->str;
        row[0] = select_chap_total->str;
        row[4] = select_playback->str;
        row[5] = select_frames->str;
        row[6] = select_aspect->str;
        row[7] = select_FPS->str;
        row[8] = select_title->str;
        row[9] = select_vts->str;
        gtk_clist_append(GTK_CLIST(clist1),row);
        if (Config.CS[sc->PC]==TRUE) {
            gtk_clist_select_row(GTK_CLIST(clist1),sc->PC,0);
        }
        temp_list = g_list_next(temp_list);
    }
    Config.selected_chapters_frames[Config.CURRENT_AVIFILE] = f2e_total;

    // Update info about totals
    seconds2time((gint)(Config.selected_chapters_frames[Config.CURRENT_AVIFILE]/Config.framerate),labelTimeStr);
    g_string_sprintf(labelStr,"  with a current duration of %s  (%.0f frames)   ",labelTimeStr->str,Config.selected_chapters_frames[Config.CURRENT_AVIFILE]);
    gtk_label_set_text(GTK_LABEL(label),labelStr->str);

    // Clean & exit 
    g_string_free(labelTimeStr,TRUE);
    g_string_free(labelStr,TRUE);
    g_string_free(select_pc,TRUE);
    g_string_free(select_playback,TRUE);
    g_string_free(select_chap,TRUE);
    g_string_free(select_chap_total,TRUE);
    g_string_free(select_frames,TRUE);
    g_string_free(select_aspect,TRUE);
    g_string_free(select_FPS,TRUE);
    g_string_free(select_title,TRUE);
    g_string_free(select_vts,TRUE);
    return;
}


/* Build the tree for the DVD Compo view */
void build_compose_tree(gboolean advanced) {
    GString *select_pc = g_string_new("");
    GString *select_angle = g_string_new("");
    GString *select_chap = g_string_new("");
    GString *select_playback = g_string_new("");
    GString *select_frames = g_string_new("");
    GString *select_aspect = g_string_new("");
    GString *select_FPS = g_string_new("");
    GString *select_title = g_string_new("");
    GString *select_vts = g_string_new("");
    GString *playback = g_string_new("");
    gint i,n,chap_total;
    selected_chapters_t sc;
    GtkWidget* viewport1 = viewport_DVD_tree;
    gboolean all_vts,all_vt,all_pc,all_chapters;//,all_angles;
    GtkWidget *window1 = viewport1;
    GString *DVDchaptertreeItemStr = g_string_new("");
    GString *DVDchaptertreeStr = g_string_new("");
    GString *DVDprogramtreeItemStr = g_string_new("");
    GString *DVDprogramtreeStr = g_string_new("");
    GString *DVDVTtreeItemStr = g_string_new("");
    GString *DVDVTtreeStr = g_string_new("");
    GString *DVDVTStreeItemStr = g_string_new("");

    // Cleanup old trees
    if (viewport1)
        if (GTK_BIN(viewport1)->child)
            gtk_widget_destroy(GTK_BIN(viewport1)->child);
    // Null init all 
    for (i=0;i<512;i++) {
        DVDVTStreeItem[i] = NULL;
        DVDVTtree[i] = NULL;
        DVDprogramtree[i] = NULL;
        DVDchaptertree[i] = NULL;
    }
    for (i=0;i<2048;i++) {
        DVDVTtreeItem[i] = NULL;
        DVDprogramtreeItem[i] = NULL;
        DVDchaptertreeItem[i] = NULL;
    }
    DVDVTStreeItem_counter = 0;     // Video Title Set Items
    DVDVTtree_counter = 0;          // Video Title tree
    DVDVTtreeItem_counter = 0;      // Video Title Items
    DVDprogramtree_counter = 0;     // Programs tree
    DVDprogramtreeItem_counter = 0; // Program Items
    DVDchaptertree_counter = 0;     // Chapters
    DVDchaptertreeItem_counter = 0; // Chapter Items

    // Create main tree
    DVDtree = gtk_tree_new();
    gtk_widget_ref(DVDtree);
    gtk_object_set_data_full (GTK_OBJECT(window1),"DVDtree",DVDtree,(GtkDestroyNotify)gtk_widget_unref);
    gtk_container_add (GTK_CONTAINER(viewport1),DVDtree);
    gtk_widget_show(DVDtree);
    gtk_tree_set_selection_mode(GTK_TREE(DVDtree),GTK_SELECTION_MULTIPLE);
    // Add DVD volume ID item to main tree
    if (Config.DVDvolumeid->len == 0 ) { g_string_sprintf(Config.DVDvolumeid,"%s","DVD_Volume");}
    DVDtreeItem = gtk_tree_item_new_with_label(Config.DVDvolumeid->str);
    gtk_widget_ref(DVDtreeItem);
    
    gtk_object_set_data_full(GTK_OBJECT(window1),"DVDtreeItem",DVDtreeItem,(GtkDestroyNotify)gtk_widget_unref);
    gtk_tree_append(GTK_TREE(DVDtree),DVDtreeItem);
    gtk_widget_show(DVDtreeItem);
    gtk_signal_connect(GTK_OBJECT(DVDtreeItem),"select",GTK_SIGNAL_FUNC(dvdtree_select_itemsignal),DVDtreeItem);
    gtk_signal_connect(GTK_OBJECT(DVDtreeItem),"deselect",GTK_SIGNAL_FUNC(dvdtree_deselect_itemsignal),DVDtreeItem);

    // VTS tree
    if (advanced) {
        DVDVTStree = gtk_tree_new();
        gtk_widget_ref(DVDVTStree);
        gtk_object_set_data_full(GTK_OBJECT(window1),"DVDVTStree",DVDVTStree,(GtkDestroyNotify)gtk_widget_unref);
        gtk_widget_show(DVDVTStree);
        gtk_tree_set_selection_mode(GTK_TREE(DVDVTStree), GTK_SELECTION_MULTIPLE);
        gtk_tree_item_set_subtree(GTK_TREE_ITEM(DVDtreeItem),DVDVTStree);
    }

    // Loop all chapters and build trees\items accordingly 
    all_vts = FALSE;
    all_vt = FALSE;
    all_pc = FALSE;
    chap_total = 0;
    for (i=0;i<Config.DVD_Total_ChapterSequences;i++) {
        g_string_sprintf(select_pc,"%i",i+1);
        g_string_sprintf(select_angle,"%i",Config.VT_Angles[Config.CS_belongs_to_VT[i]]);
        g_string_sprintf(select_chap,"%i",Config.CS_Chapters[i]);
        seconds2time((gint)(Config.frames2encode[i]/Config.framerate),select_playback);
        g_string_sprintf(select_frames,"%i",Config.frames2encode[i]);
        g_string_sprintf(select_aspect,"%.3g:1",Config.VTS_Aspects[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]]]);
        g_string_sprintf(select_FPS,"%g",Config.framerate);
        g_string_sprintf(select_title,"Title %i",Config.CS_belongs_to_VT[i]+1);
        g_string_sprintf(select_vts,"Title Set %i",Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]]);

       
        // Add VTS level above DVDtreeItem
        if (advanced && ((DVDVTStreeItem_counter==0) || (DVDVTStreeItem[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]]]==NULL))) {
            // VTS item to VTS tree
            DVDVTStreeItem_counter = Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]];
            DVDVTStreeItem[DVDVTStreeItem_counter] = gtk_tree_item_new_with_label(select_vts->str);
            gtk_widget_ref(DVDVTStreeItem[DVDVTStreeItem_counter]);
            g_string_sprintf(DVDVTStreeItemStr,"DVDVTStreeItem%i",i);
            gtk_object_set_data_full(GTK_OBJECT(window1),DVDVTStreeItemStr->str,DVDVTStreeItem[DVDVTStreeItem_counter],(GtkDestroyNotify) gtk_widget_unref);
            gtk_tree_append(GTK_TREE(DVDVTStree),DVDVTStreeItem[DVDVTStreeItem_counter]);
            gtk_widget_show(DVDVTStreeItem[DVDVTStreeItem_counter]);
            gtk_signal_connect(GTK_OBJECT(DVDVTStreeItem[DVDVTStreeItem_counter]),"select",GTK_SIGNAL_FUNC(dvdtree_select_itemsignal),DVDVTStreeItem[DVDVTStreeItem_counter]);
            gtk_signal_connect(GTK_OBJECT(DVDVTStreeItem[DVDVTStreeItem_counter]),"deselect",GTK_SIGNAL_FUNC(dvdtree_deselect_itemsignal),DVDVTStreeItem[DVDVTStreeItem_counter]);
            // VT (Video Title) tree
            DVDVTtree_counter = Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]-1];
            DVDVTtree[DVDVTtree_counter] = gtk_tree_new();
            gtk_widget_ref(DVDVTtree[DVDVTtree_counter]);
            g_string_sprintf(DVDVTtreeStr,"DVDVTtree%i",i);
            gtk_object_set_data_full(GTK_OBJECT(window1),DVDVTtreeStr->str,DVDVTtree[DVDVTtree_counter],(GtkDestroyNotify)gtk_widget_unref);
            gtk_widget_show(DVDVTtree[DVDVTtree_counter]);
            gtk_tree_set_selection_mode(GTK_TREE(DVDVTtree[DVDVTtree_counter]), GTK_SELECTION_MULTIPLE);
            gtk_tree_item_set_subtree(GTK_TREE_ITEM(DVDVTStreeItem[DVDVTStreeItem_counter]),DVDVTtree[DVDVTtree_counter]);
        }

        if (DVDVTtreeItem[Config.CS_belongs_to_VT[i]] == NULL) {
            if (advanced) {
                // VT item to VT tree
                DVDVTtreeItem_counter = Config.CS_belongs_to_VT[i];
                DVDVTtreeItem[DVDVTtreeItem_counter] = gtk_tree_item_new_with_label(select_title->str);
                gtk_widget_ref(DVDVTtreeItem[DVDVTtreeItem_counter]);
                g_string_sprintf(DVDVTtreeItemStr,"DVDVTtreeItem%i",i);
                gtk_object_set_data_full(GTK_OBJECT(window1),DVDVTtreeItemStr->str,DVDVTtreeItem[DVDVTtreeItem_counter],(GtkDestroyNotify)gtk_widget_unref);
                gtk_tree_append(GTK_TREE(DVDVTtree[DVDVTtree_counter]),DVDVTtreeItem[DVDVTtreeItem_counter]);
                gtk_widget_show(DVDVTtreeItem[DVDVTtreeItem_counter]);
                gtk_signal_connect(GTK_OBJECT(DVDVTtreeItem[DVDVTtreeItem_counter]),"select",GTK_SIGNAL_FUNC(dvdtree_select_itemsignal),DVDVTtreeItem[DVDVTtreeItem_counter]);
                gtk_signal_connect(GTK_OBJECT(DVDVTtreeItem[DVDVTtreeItem_counter]),"deselect",GTK_SIGNAL_FUNC(dvdtree_deselect_itemsignal),DVDVTtreeItem[DVDVTtreeItem_counter]);
            }
            if (advanced || (DVDprogramtree_counter == 0)) {
                // Program chains tree
                DVDprogramtree[DVDprogramtree_counter++] = gtk_tree_new();
                gtk_widget_ref(DVDprogramtree[DVDprogramtree_counter-1]);
                g_string_sprintf(DVDprogramtreeStr,"DVDprogramtree%i",i);
                gtk_object_set_data_full(GTK_OBJECT(window1),DVDprogramtreeStr->str, DVDprogramtree[DVDprogramtree_counter-1],(GtkDestroyNotify)gtk_widget_unref);
                gtk_widget_show(DVDprogramtree[DVDprogramtree_counter-1]);
                gtk_tree_set_selection_mode(GTK_TREE(DVDprogramtree[DVDprogramtree_counter-1]), GTK_SELECTION_MULTIPLE);
                if (advanced) {
                    gtk_tree_item_set_subtree(GTK_TREE_ITEM(DVDVTtreeItem[DVDVTtreeItem_counter]),DVDprogramtree[DVDprogramtree_counter-1]);
                } else {
                    gtk_tree_item_set_subtree(GTK_TREE_ITEM(DVDtreeItem),DVDprogramtree[DVDprogramtree_counter-1]);
                }
                if (advanced) {
                    if (all_pc) {  // All PC's selected?
                        if (DVDVTtreeItem_counter>0) {
                            g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"  DVDVTtreeItem_counter-1 = %i",DVDVTtreeItem_counter-1);
                            gtk_tree_item_select(GTK_TREE_ITEM(DVDVTtreeItem[DVDVTtreeItem_counter-1]));
                        }
                    } else {
                        all_vt = FALSE;
                    }
                }
                all_pc = TRUE; // Reset all_pc
            }

            if (advanced) {
                // All VT's selected for previous VTS tree?
                if (all_vt) {  // All VT's selected? 
                    if (DVDVTStreeItem_counter>0) {
                        gtk_tree_item_select(GTK_TREE_ITEM(DVDVTStreeItem[DVDVTStreeItem_counter-1]));
                    }
                } else {
                    all_vts = FALSE;
                }
                all_vt = TRUE;
            }
        }
        // Build Program info string
        seconds2time((gint)(Config.frames2encode[i]/Config.framerate),playback);
        g_string_sprintf(select_pc,"Program %i (%s)",i+1,playback->str);
        // Add a program item to program tree
        DVDprogramtreeItem[DVDprogramtreeItem_counter++] = gtk_tree_item_new_with_label(select_pc->str);
        gtk_widget_ref(DVDprogramtreeItem[DVDprogramtreeItem_counter-1]);
        g_string_sprintf(DVDprogramtreeItemStr,"DVDprogramtreeItem%i",i);
        gtk_object_set_data_full(GTK_OBJECT(window1),DVDprogramtreeItemStr->str,DVDprogramtreeItem[DVDprogramtreeItem_counter-1],(GtkDestroyNotify)gtk_widget_unref);
        gtk_tree_append(GTK_TREE(DVDprogramtree[DVDprogramtree_counter-1]),DVDprogramtreeItem[DVDprogramtreeItem_counter-1]);
        gtk_widget_show(DVDprogramtreeItem[DVDprogramtreeItem_counter-1]);
        gtk_signal_connect(GTK_OBJECT(DVDprogramtreeItem[DVDprogramtreeItem_counter-1]),"select",GTK_SIGNAL_FUNC(dvdtree_select_itemsignal),DVDprogramtreeItem[DVDprogramtreeItem_counter-1]);
        gtk_signal_connect(GTK_OBJECT(DVDprogramtreeItem[DVDprogramtreeItem_counter-1]),"deselect",GTK_SIGNAL_FUNC(dvdtree_deselect_itemsignal),DVDprogramtreeItem[DVDprogramtreeItem_counter-1]);
        // Add chapter tree to program item
        DVDchaptertree[DVDchaptertree_counter++] = gtk_tree_new();
        gtk_widget_ref(DVDchaptertree[DVDchaptertree_counter-1]);
        g_string_sprintf(DVDchaptertreeStr,"DVDchaptertree%i",i);
        gtk_object_set_data_full(GTK_OBJECT(window1),DVDchaptertreeStr->str,DVDchaptertree[DVDchaptertree_counter-1],(GtkDestroyNotify)gtk_widget_unref);
        gtk_widget_show(DVDchaptertree[DVDchaptertree_counter-1]);
        gtk_tree_set_selection_mode(GTK_TREE(DVDchaptertree[DVDchaptertree_counter-1]),GTK_SELECTION_MULTIPLE);
        gtk_tree_item_set_subtree(GTK_TREE_ITEM(DVDprogramtreeItem[DVDprogramtreeItem_counter-1]),DVDchaptertree[DVDchaptertree_counter-1]);
        // Add chapter items to chapter tree
        all_chapters = TRUE;
        for (n=0;n<Config.CS_Chapters[i];n++) {
            g_string_sprintf(select_pc,"Chapter %i,%i,%i,%i,%i,%i,%i",n+1,n+1,i+1,Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]],Config.CS_belongs_to_VT[i]+1,Config.VT_Angles[Config.CS_belongs_to_VT[i]],Config.CS_starts_at_Chapter[i]+n);
            DVDchaptertreeItem[DVDchaptertreeItem_counter++] = gtk_tree_item_new_with_label(select_pc->str);
            gtk_widget_ref(DVDchaptertreeItem[DVDchaptertreeItem_counter-1]);
            g_string_sprintf(DVDchaptertreeItemStr,"DVDchaptertreeItem%i",i);
            gtk_object_set_data_full(GTK_OBJECT(window1),DVDchaptertreeItemStr->str,DVDchaptertreeItem[DVDchaptertreeItem_counter-1],(GtkDestroyNotify)gtk_widget_unref);
            gtk_tree_append(GTK_TREE(DVDchaptertree[DVDchaptertree_counter-1]),DVDchaptertreeItem[DVDchaptertreeItem_counter-1]);
            // TODO : check for selected in another avi as current_avi
            // if true -> dont show
            gtk_widget_show(DVDchaptertreeItem[DVDchaptertreeItem_counter-1]);
            gtk_signal_connect(GTK_OBJECT(DVDchaptertreeItem[DVDchaptertreeItem_counter-1]),"select",GTK_SIGNAL_FUNC(dvdtree_select_itemsignal),DVDchaptertreeItem[DVDchaptertreeItem_counter-1]);
            gtk_signal_connect(GTK_OBJECT(DVDchaptertreeItem[DVDchaptertreeItem_counter-1]),"deselect",GTK_SIGNAL_FUNC(dvdtree_deselect_itemsignal),DVDchaptertreeItem[DVDchaptertreeItem_counter-1]);
            // Is this chapter selected in current avi?
            sc.VTS  = Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]]-1;
            sc.VT   = Config.CS_belongs_to_VT[i];
            sc.PC   = i;
            sc.CHAP = n;
            sc.CHAP_TOTAL = Config.CS_starts_at_Chapter[i]+n;
            sc.ANGL = Config.VT_Angles[Config.CS_belongs_to_VT[i]]-1;
            if (g_list_find_custom(Config.selected_chapters[Config.CURRENT_AVIFILE],&sc,build_compare) != NULL) {
                gtk_tree_item_select(GTK_TREE_ITEM(DVDchaptertreeItem[DVDchaptertreeItem_counter-1]));
            } else all_chapters = FALSE;
        }
        if (all_chapters) { // All chapters selected?
            gtk_tree_item_select(GTK_TREE_ITEM(DVDprogramtreeItem[DVDprogramtreeItem_counter-1]));
        } else {
            all_pc = FALSE;
        }
    }
    if (!advanced) {
        if (all_pc) {  // All PC's selected?
            gtk_tree_item_select(GTK_TREE_ITEM(DVDtreeItem));
        } else {
            all_vt = FALSE;
        }
    }
    if (advanced) {
        if (all_pc) {  // All PC's selected?
            if (Config.CS_belongs_to_VT[i-1]>-1) {
                gtk_tree_item_select(GTK_TREE_ITEM(DVDVTtreeItem[Config.CS_belongs_to_VT[i-1]]));
            }
        } else {
            all_vt = FALSE;
        }

        if (all_vt) {  // All VT's selected?
            if ((Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i-1]])>-1) {
                g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"   Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i-1]] = %i   (Config.CS_belongs_to_VT[i]=%i)",Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i-1]],Config.CS_belongs_to_VT[i]);
                gtk_tree_item_select(GTK_TREE_ITEM(DVDVTStreeItem[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i-1]]]));
            } 
        } else {
            all_vts = FALSE;
        }

        if (all_vts) gtk_tree_item_select(GTK_TREE_ITEM(DVDtreeItem));
    }

    /* Clean & Exit */
    g_string_free(DVDVTStreeItemStr,TRUE);
    g_string_free(DVDVTtreeStr,TRUE);
    g_string_free(DVDVTtreeItemStr,TRUE);
    g_string_free(DVDprogramtreeStr,TRUE);
    g_string_free(DVDprogramtreeItemStr,TRUE);
    g_string_free(DVDchaptertreeStr,TRUE);
    g_string_free(DVDchaptertreeItemStr,TRUE);
    g_string_free(select_pc,TRUE);
    g_string_free(select_playback,TRUE);
    g_string_free(select_frames,TRUE);
    g_string_free(select_aspect,TRUE);
    g_string_free(select_FPS,TRUE);
    g_string_free(select_title,TRUE);
    g_string_free(select_vts,TRUE);
    g_string_free(playback,TRUE);
    return;
}


/* Keep track of page location and update internal status accordingly */
gboolean on_drip_druid_next(GnomeDruidPage *druidpage,gpointer arg1,gpointer user_data) {
    GString *command = g_string_new("");
    GString *temp = g_string_new("");
    gint i;
    gint result = 0;
    struct stat st;
    gint err;
    GString *nrs[RANGE];
    GString *text = g_string_new("");
    GtkWidget *vbox23,*hbox23,*hbox24,*hbox25;
    GtkWidget *label_avi;
    GtkWidget *combo_avi,*combo_avi_entry;
    GtkWidget *scrolledwindow6;
    GtkWidget *viewport1;
    GtkWidget *button_up;
    GtkWidget *button_down;
    GtkTooltips *tooltips;
    GList *combo_avi_items = NULL;
    GtkWidget *avi_advanced;
    GString *select_pc = g_string_new("");
    GString *select_playback = g_string_new("");
    GString *select_frames = g_string_new("");
    GString *select_aspect = g_string_new("");
    GString *select_FPS = g_string_new("");
    GString *select_title = g_string_new("");
    GString *select_vts = g_string_new("");
    GString *labelStr = g_string_new("");
    GString *labelTimeStr = g_string_new("");

    /* Keep track of page location and update internal status accordingly */

    /* Location of input content */
    if (Config.useDVDdevice==FALSE) {
        g_string_sprintf(temp,"%s",Config.DVDsource->str);
    } else {
        g_string_sprintf(temp,"%s",Config.DVDdevice->str);
    }
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Opening DVD content at %s (2)",temp->str);

    /* Does source content location exsists? */
    if (stat(temp->str, &st) != 0) {
        g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"Content not found (%s %s)",strerror(errno),temp->str);
        /* Clean & exit */
        encoder_stop(FALSE);             // stop encoder
        converting = FALSE;              // clear encoding flag
        encoding_time = FALSE;           // ---
        quit_converting = TRUE;          // set request quit flag, used to shutdown threads by request
        stopped = TRUE;                  // set general idle mode flag
        paused = FALSE;                  // lift pause block

        gtk_widget_hide(hbox35);
        gnome_appbar_set_status(GNOME_APPBAR(appbar1),"");
        gnome_appbar_set_progress(GNOME_APPBAR(appbar1),1);

        pthread_cancel(ripthread);       // cancel encoding thread
        gtk_widget_destroy(audio_subpicture_dialog);
        audio_subpicture_dialog = NULL;
        g_log(DRIP_CB_LD,G_LOG_LEVEL_INFO,"Encoding aborted.");

        gnome_appbar_set_status(GNOME_APPBAR(appbar1),"   Ready");
        g_string_free(command,TRUE);
        g_string_free(temp,TRUE);
        g_string_free(cached_files,TRUE);
        return TRUE;
    }

    /* Opening cached files or DVD contents? */
    g_string_sprintf(command,"ls -lsa %s | grep DVDTITLE.tbl | awk '{printf($10)}'",temp->str);
    text = drip_system(command->str,&result,FALSE,FALSE);
    if ( strstr(text->str,"DVDTITLE")!=NULL) {
        Config.DVDhandle = NULL;
        if (Config.conversion_mode != DVDTITLE_DVD2VCDDISK && Config.conversion_mode != DVDTITLE_DRIPCACHE2VCD)
            Config.conversion_mode = DVDTITLE_DRIPCACHE;
        else 
            Config.conversion_mode = DVDTITLE_DRIPCACHE2VCD;
        //bind_titles_guitype();
        load_dvd_title_info(-1,FALSE);
        g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Opened Drip cache from %s",temp->str);
    } else {
        Config.DVDhandle = DVDOpen(temp->str);
        err = errno;
        g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"After DVDOpen (%s %s)",strerror(err),temp->str);
        /* Check operation */
        switch (err) {
        case 123:/* NO medium found */
                g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"Content not opened (%s %s)",strerror(err),temp->str);
                /* Clean & exit */
                converting = FALSE;
                gnome_appbar_set_status(GNOME_APPBAR(appbar1),"   Ready");
                g_string_free(command,TRUE);
                g_string_free(temp,TRUE);
                pthread_cancel(ripthread);
                gtk_widget_destroy(audio_subpicture_dialog);
                audio_subpicture_dialog = NULL;
                return TRUE;
                break;
        default:
                break;
        }
        // TODO: check if location is valid, cq contains content
        if (!detect_DVD_titles(FALSE)) {
            g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"Could not open DVD content");
            encoder_stop(FALSE);             // stop encoder

            converting = FALSE;              // clear encoding flag
            encoding_time = FALSE;           // ---
            quit_converting = TRUE;          // set request quit flag, used to shutdown threads by request
            stopped = TRUE;                  // set general idle mode flag
            paused = FALSE;                  // lift pause block

            gtk_widget_hide(hbox35);
            gnome_appbar_set_status(GNOME_APPBAR(appbar1),"");
            gnome_appbar_set_progress(GNOME_APPBAR(appbar1),1);

            pthread_cancel(ripthread);       // cancel encoding thread
            gtk_widget_destroy(audio_subpicture_dialog);
            audio_subpicture_dialog = NULL;
            g_log(DRIP_CB_LD,G_LOG_LEVEL_INFO,"Encoding stopped.");
            return TRUE;
        }
        selected_files = 1; // we're about to read one stream
        if (Config.useDVDdevice==FALSE) {
            if (Config.conversion_mode == DVDTITLE_DVDDISK || Config.conversion_mode == DVDTITLE_DRIPCACHE) {
                Config.conversion_mode = DVDTITLE_DVDDISK;
                g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Config.conversion_mode = DVDTITLE_DVDDISK");
            } else {
                 Config.conversion_mode = DVDTITLE_DVD2VCDDISK;
                 g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Config.conversion_mode = DVDTITLE_DVD2VCDDISK");
            }
        } else {
            if (Config.conversion_mode == DVDTITLE_DVDDISK || Config.conversion_mode == DVDTITLE_DRIPCACHE) {
                Config.conversion_mode = DVDTITLE_DVDIMAGE;
                g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Config.conversion_mode = DVDTITLE_DVDIMAGE");
            }
        }
        //bind_titles_guitype();
        g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Opened DVD content at %s",temp->str);

    }

    if ((Config.conversion_mode == DVDTITLE_DVDDISK) || (Config.conversion_mode == DVDTITLE_DVDIMAGE) || (Config.conversion_mode == DVDTITLE_DVD2VCDDISK)) {
        for (i=0;i<Config.DVD_TitleSets;i++) {
            parse_ifo(i+1,FALSE,TRUE);
        }
    }

    /* Destroy old page */
    gtk_widget_destroy(frame5);

    /* Build DVD Compose View Page */
    frame5 = gtk_frame_new (NULL);
    gtk_widget_ref (frame5);
    gtk_object_set_data_full (GTK_OBJECT (window1), "frame5", frame5,
                            (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (frame5);
    gtk_container_add (GTK_CONTAINER (druid_vbox2), frame5);
    gtk_container_set_border_width (GTK_CONTAINER (frame5), 3);

    vbox23 = gtk_hpaned_new ();
    gtk_widget_ref (vbox23);
    gtk_object_set_data_full (GTK_OBJECT (frame5), "vbox23", vbox23,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (vbox23);
    gtk_container_add (GTK_CONTAINER (frame5), vbox23);
    gtk_paned_set_position (GTK_PANED(vbox23), 250);


    /* 1st panel on compose view: tree of all DVD VTS\VT\PC\Chapters */
    scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_ref (scrolledwindow6);
    gtk_object_set_data_full(GTK_OBJECT(window1),"scrolledwindow6",scrolledwindow6,(GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_show (scrolledwindow6);
    //gtk_box_pack_start (GTK_BOX (vbox23), scrolledwindow6, TRUE, TRUE, 0);
    gtk_paned_pack1(GTK_PANED(vbox23), scrolledwindow6, FALSE, TRUE);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow6),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

    viewport1 = gtk_viewport_new (NULL, NULL);
    gtk_widget_ref (viewport1);
    gtk_object_set_data_full (GTK_OBJECT (window1), "viewport1", viewport1,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (viewport1);
    gtk_container_add (GTK_CONTAINER (scrolledwindow6), viewport1);

    /* 2nd panel on compose view: advanced view \ Nr. avi composing \ chapters selected for current avi */
    hbox23 = gtk_vbox_new (FALSE, 0); 
    gtk_widget_ref(hbox23);
    gtk_object_set_data_full(GTK_OBJECT(window1), "hbox23", hbox23,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (hbox23);
    //gtk_box_pack_start(GTK_BOX (vbox23), hbox23, TRUE, TRUE, 0);
    gtk_paned_pack2 (GTK_PANED (vbox23), hbox23, TRUE, TRUE);


    /* Avi selection pulldown */
    tooltips = gtk_tooltips_new ();
    hbox24 = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref(hbox24);
    gtk_object_set_data_full(GTK_OBJECT(window1), "hbox24", hbox24,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (hbox24);
    gtk_box_pack_start (GTK_BOX (hbox23), hbox24, FALSE, FALSE, 3);

    label_avi = gtk_label_new(_(" Composing AVI Nr. "));
    gtk_widget_ref(label_avi);
    gtk_object_set_data_full(GTK_OBJECT(window1),"label_avi",label_avi,(GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_show(label_avi);
    gtk_box_pack_start(GTK_BOX(hbox24),label_avi,FALSE,FALSE,3);

    combo_avi = gtk_combo_new ();
    gtk_widget_ref(combo_avi);
    gtk_object_set_data_full(GTK_OBJECT(window1),"combo_avi",combo_avi,(GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_show(combo_avi);

    combo_avi_entry = GTK_COMBO(combo_avi)->entry;
    gtk_widget_ref(combo_avi_entry);
    gtk_object_set_data_full(GTK_OBJECT(window1),"combo_avi_entry",combo_avi_entry,(GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_show (combo_avi_entry);
    gtk_box_pack_start(GTK_BOX(hbox24),combo_avi,FALSE,FALSE,3);
    gtk_signal_connect(GTK_OBJECT(combo_avi_entry),"changed",GTK_SIGNAL_FUNC(on_combo_avi_entry_changed),combo_avi_entry);
    gtk_widget_set_usize(combo_avi_entry,40,20);
    for (i=0;i<RANGE;i++) {
        nrs[i] = g_string_new("");
        g_string_sprintf(nrs[i],"%i",i+1);
        combo_avi_items = g_list_append(combo_avi_items,(gpointer)nrs[i]->str);
    }
    gtk_combo_set_popdown_strings (GTK_COMBO (combo_avi), combo_avi_items);
    g_list_free (combo_avi_items);
    Config.CURRENT_AVIFILE = 1;
    gtk_entry_set_text (GTK_ENTRY (combo_avi_entry), "1");

    seconds2time((gint)(Config.selected_chapters_frames[Config.CURRENT_AVIFILE]/Config.framerate),labelTimeStr);
    g_string_sprintf(labelStr,"  with a current duration of %s  (%.0f frames)   ",labelTimeStr->str,Config.selected_chapters_frames[Config.CURRENT_AVIFILE]);
    label = gtk_label_new (labelStr->str);
    gtk_widget_ref (label);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label", label,(GtkDestroyNotify) gtk_widget_unref);
    gtk_box_pack_start(GTK_BOX(hbox24),label,FALSE,FALSE,3);
    gtk_widget_show (label);

    hbox25 = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref(hbox25);
    gtk_object_set_data_full(GTK_OBJECT(window1), "hbox25", hbox25,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (hbox25);
    gtk_box_pack_start (GTK_BOX (hbox23), hbox25, FALSE, FALSE, 3);

    button_down = gnome_stock_button (GNOME_STOCK_BUTTON_DOWN);
    gtk_widget_ref (button_down);
    gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_down", button_down,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (button_down);
    gtk_box_pack_start (GTK_BOX (hbox25), button_down, FALSE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (button_down), 0);
    gtk_tooltips_set_tip (tooltips, button_down, _("Move selected chapter down"), NULL);
    gtk_button_set_relief (GTK_BUTTON (button_down), GTK_RELIEF_HALF);

    button_up = gnome_stock_button (GNOME_STOCK_BUTTON_UP);
    gtk_widget_ref (button_up);
    gtk_object_set_data_full (GTK_OBJECT (mainwindow), "button_up", button_up,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (button_up);
    gtk_box_pack_start (GTK_BOX (hbox25), button_up, FALSE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (button_up), 0);
    gtk_tooltips_set_tip (tooltips, button_up, _("Move selected chapter up"), NULL);
    gtk_button_set_relief (GTK_BUTTON (button_up), GTK_RELIEF_HALF);

    avi_advanced = gtk_check_button_new_with_label (_("Advanced View"));
    gtk_widget_ref (avi_advanced);
    gtk_object_set_data_full (GTK_OBJECT (window1), "avi_advanced", avi_advanced,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (avi_advanced);
    gtk_box_pack_end(GTK_BOX (hbox25), avi_advanced, FALSE, FALSE, 0);
    gtk_signal_connect(GTK_OBJECT(avi_advanced),"toggled",GTK_SIGNAL_FUNC(on_checkbutton_advanced_toggled),viewport1);

    /* Selected chapters-per-avi list */
    frame5 = gtk_frame_new (NULL);
    gtk_widget_ref (frame5);
    gtk_object_set_data_full (GTK_OBJECT (window1), "frame5", frame5,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (frame5);
    gtk_container_add (GTK_CONTAINER (hbox23), frame5);
    gtk_container_set_border_width (GTK_CONTAINER (frame5), 3);

    vbox23 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox23);
    gtk_object_set_data_full (GTK_OBJECT (window1), "vbox23", vbox23,
                            (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (vbox23);
    gtk_container_add (GTK_CONTAINER (frame5), vbox23);
    gtk_container_set_border_width (GTK_CONTAINER (vbox23), 3);

    scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_ref (scrolledwindow6);
    gtk_object_set_data_full(GTK_OBJECT(window1),"scrolledwindow6",scrolledwindow6,(GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_show (scrolledwindow6);
    gtk_box_pack_start (GTK_BOX (vbox23), scrolledwindow6, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow6), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    viewport_avi = gtk_viewport_new (NULL, NULL);
    gtk_widget_ref(viewport_avi);
    gtk_object_set_data_full (GTK_OBJECT(window1),"viewport_avi",viewport_avi,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(viewport_avi);
    gtk_container_add(GTK_CONTAINER (scrolledwindow6), viewport_avi);

    /* Callbacks to move up\down buttons */
    gtk_signal_connect(GTK_OBJECT(button_down),"clicked",GTK_SIGNAL_FUNC(on_button_up_clicked),viewport_avi);
    gtk_signal_connect(GTK_OBJECT(button_up),"clicked",GTK_SIGNAL_FUNC(on_button_down_clicked),viewport_avi);

    /* -- AVI LIST -------------------------- */
    build_compose_avilist();

    /* -- DVD tree -------------------------- */
    viewport_DVD_tree = viewport1;
    build_compose_tree(FALSE);

    /* Set next (dummy) page */
    on_combo_entry_DVDtitle_changed(NULL,NULL);

    /* Call divx output naming */
    format_divxname(Config.DIVXfileUser,FALSE);

    /* Clean & Exit */
    for (i=0;i<RANGE;i++) g_string_free(nrs[i],TRUE);
    g_string_free(labelTimeStr,TRUE);
    g_string_free(labelStr,TRUE);
    g_string_free(temp,TRUE);
    g_string_free(command,TRUE);
    g_string_free(text,TRUE);
    g_string_free(select_pc,TRUE);
    g_string_free(select_playback,TRUE);
    g_string_free(select_frames,TRUE);
    g_string_free(select_aspect,TRUE);
    g_string_free(select_FPS,TRUE);
    g_string_free(select_title,TRUE);
    g_string_free(select_vts,TRUE);
    return FALSE;
}


/* Keep track of page location and update internal status accordingly */
gboolean on_drip_druid_next_cache(GnomeDruidPage *druidpage,gpointer arg1,gpointer user_data) {
    GString *command = g_string_new("");
    GString *temp = g_string_new("");
    //GString *dvd_cache_file = g_string_new("");
    gint i;
    gint result = 0;
    struct stat st;
    gint err;//,dvd_fd;
    GString *text = g_string_new("");
    GtkWidget *vbox23;
    GtkWidget *scrolledwindow6;
    GtkWidget *viewport1;
    /* list widgets */
    GtkWidget *clist1;
    GtkWidget *label_select_pc;
    GtkWidget *label_select_angle;
    GtkWidget *label_select_chap;
    GtkWidget *label_select_playback;
    GtkWidget *label_select_frames;
    GtkWidget *label_select_aspect;
    GtkWidget *label_select_FPS;
    GtkWidget *label_select_title;
    GtkWidget *label_select_vts;
    GString *select_pc = g_string_new("");
    GString *select_angle = g_string_new("");
    GString *select_chap = g_string_new("");
    GString *select_playback = g_string_new("");
    GString *select_frames = g_string_new("");
    GString *select_aspect = g_string_new("");
    GString *select_FPS = g_string_new("");
    GString *select_title = g_string_new("");
    GString *select_vts = g_string_new("");
    gchar *row[10];

    /* Keep track of page location and update internal status accordingly */

    /* Location of input content */
    if (Config.useDVDdevice==FALSE) {
        g_string_sprintf(temp,"%s",Config.DVDsource->str);
    } else {
        g_string_sprintf(temp,"%s",Config.DVDdevice->str);
    }
    g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Opening DVD content at %s (3)",temp->str);

    /* Does source content location exsists? */
    if (stat(temp->str, &st) != 0) {
        g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"Content not found (%s %s)",strerror(errno),temp->str);
        /* Clean & exit */
        encoder_stop(FALSE);             // stop encoder
        converting = FALSE;              // clear encoding flag
        encoding_time = FALSE;           // ---
        quit_converting = TRUE;          // set request quit flag, used to shutdown threads by request
        stopped = TRUE;                  // set general idle mode flag
        paused = FALSE;                  // lift pause block

        gtk_widget_hide(hbox35);
        gnome_appbar_set_status(GNOME_APPBAR(appbar1),"");
        gnome_appbar_set_progress(GNOME_APPBAR(appbar1),1);

        pthread_cancel(ripthread);       // cancel encoding thread
        gtk_widget_destroy(audio_subpicture_dialog);
        audio_subpicture_dialog = NULL;
        g_log(DRIP_CB_LD,G_LOG_LEVEL_INFO,"Encoding aborted.");
        gnome_appbar_set_status(GNOME_APPBAR(appbar1),"   Ready");
        g_string_free(command,TRUE);
        g_string_free(temp,TRUE);
        g_string_free(cached_files,TRUE);
        return TRUE;
    }

    /* Opening cached files or DVD contents? */
    g_string_sprintf(command,"ls -lsa %s | grep DVDTITLE.tbl | awk '{printf($10)}'",temp->str);
    text = drip_system(command->str,&result,FALSE,FALSE);
    if (/*dvd_fd!=-1) {*/ strstr(text->str,"DVDTITLE")!=NULL) {
        Config.DVDhandle = NULL;
        Config.conversion_mode = DVDTITLE_DRIPCACHE;
        //bind_titles_guitype();
        load_dvd_title_info(-1,FALSE);
        g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Opened Drip cache from %s",temp->str);
    } else {
        Config.DVDhandle = DVDOpen(temp->str);
        err = errno;
        g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"After DVDOpen (%s %s)",strerror(err),temp->str);
        /* Check operation */
        switch (err) {
        case 123:/* NO medium found */
                g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"Content not opened (%s %s)",strerror(err),temp->str);
                /* Clean & exit */
                converting = FALSE;
                gnome_appbar_set_status(GNOME_APPBAR(appbar1),"   Ready");
                g_string_free(command,TRUE);
                g_string_free(temp,TRUE);
                pthread_cancel(ripthread);
                gtk_widget_destroy(audio_subpicture_dialog);
                audio_subpicture_dialog = NULL;
                return TRUE;
                break;
        default:
                break;
        }
        // TODO: check if location is valid, cq contains content
        if (!detect_DVD_titles(FALSE)) {
            g_log(DRIP_CB_LD,G_LOG_LEVEL_WARNING,"Could not open DVD content");
            encoder_stop(FALSE);             // stop encoder

            converting = FALSE;              // clear encoding flag
            encoding_time = FALSE;           // ---
            quit_converting = TRUE;          // set request quit flag, used to shutdown threads by request
            stopped = TRUE;                  // set general idle mode flag
            paused = FALSE;                  // lift pause block

            gtk_widget_hide(hbox35);
            gnome_appbar_set_status(GNOME_APPBAR(appbar1),"");
            gnome_appbar_set_progress(GNOME_APPBAR(appbar1),1);

            pthread_cancel(ripthread);       // cancel encoding thread
            gtk_widget_destroy(audio_subpicture_dialog);
            audio_subpicture_dialog = NULL;
            g_log(DRIP_CB_LD,G_LOG_LEVEL_INFO,"Encoding stopped.");
            return TRUE;
        }
        selected_files = 1; // we're about to read one stream
        if (Config.useDVDdevice==FALSE) {
            Config.conversion_mode = DVDTITLE_DVDDISK;
        } else {
            Config.conversion_mode = DVDTITLE_DVDIMAGE;
        }
        //bind_titles_guitype();
        g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Opened DVD content at %s",temp->str);
    }
    //close(dvd_fd);
    if ((Config.conversion_mode == DVDTITLE_DVDDISK) || (Config.conversion_mode == DVDTITLE_DVDIMAGE)) {
        for (i=0;i<Config.DVD_TitleSets;i++) {
            parse_ifo(i+1,FALSE,TRUE);
        }
    }

    /* Destroy old page */
    gtk_widget_destroy(frame5);

    /* Build Titles Page */
    frame5 = gtk_frame_new (NULL);
    gtk_widget_ref (frame5);
    gtk_object_set_data_full (GTK_OBJECT (window1), "frame5", frame5,
                            (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (frame5);
    gtk_container_add (GTK_CONTAINER (druid_vbox2), frame5);
    gtk_container_set_border_width (GTK_CONTAINER (frame5), 3);

    vbox23 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox23);
    gtk_object_set_data_full (GTK_OBJECT (window1), "vbox23", vbox23,
                            (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (vbox23);
    gtk_container_add (GTK_CONTAINER (frame5), vbox23);
    gtk_container_set_border_width (GTK_CONTAINER (vbox23), 3);

    scrolledwindow6 = gtk_scrolled_window_new (NULL, NULL);
    gtk_widget_ref (scrolledwindow6);
    gtk_object_set_data_full (GTK_OBJECT (window1), "scrolledwindow6", scrolledwindow6,                            (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (scrolledwindow6);
    gtk_box_pack_start (GTK_BOX (vbox23), scrolledwindow6, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow6), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    viewport1 = gtk_viewport_new (NULL, NULL);
    gtk_widget_ref (viewport1);
    gtk_object_set_data_full (GTK_OBJECT (window1), "viewport1", viewport1,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (viewport1);
    gtk_container_add (GTK_CONTAINER (scrolledwindow6), viewport1);

    clist1 = gtk_clist_new (9);
    gtk_widget_ref (clist1);
    gtk_object_set_data_full (GTK_OBJECT (window1), "clist1", clist1,(GtkDestroyNotify) gtk_widget_unref);
    gtk_container_add (GTK_CONTAINER (viewport1), clist1);
    gtk_widget_show (clist1);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 160);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 2, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 3, 100);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 4, 150);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 5, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 6, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 7, 80);
    gtk_clist_set_column_width (GTK_CLIST (clist1), 8, 80);

    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 0,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 1,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 2,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 3,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 4,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 5,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 6,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 7,TRUE);
    gtk_clist_set_column_auto_resize (GTK_CLIST (clist1), 8,TRUE);

    gtk_clist_set_column_justification(GTK_CLIST (clist1), 0, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 1, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 2, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 3, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 4, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 5, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 6, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 7, GTK_JUSTIFY_CENTER);
    gtk_clist_set_column_justification(GTK_CLIST (clist1), 8, GTK_JUSTIFY_CENTER);

    gtk_clist_set_selection_mode (GTK_CLIST (clist1), GTK_SELECTION_MULTIPLE);
    gtk_clist_column_titles_show (GTK_CLIST (clist1));

    label_select_pc = gtk_label_new (_("  Program Chain  "));
    gtk_widget_ref (label_select_pc);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_pc", label_select_pc,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_pc);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 0, label_select_pc);

    label_select_angle = gtk_label_new (_("  Angles  "));
    gtk_widget_ref (label_select_angle);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_angle", label_select_angle,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_angle);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 1, label_select_angle);

    label_select_chap = gtk_label_new (_("  Chapters  "));
    gtk_widget_ref (label_select_chap);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_chap", label_select_chap,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_chap);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 2, label_select_chap);

    label_select_playback = gtk_label_new (_("  Playback  "));
    gtk_widget_ref (label_select_playback);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_playback", label_select_playback,(GtkDestroyNotify)
gtk_widget_unref);
    gtk_widget_show (label_select_playback);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 3, label_select_playback);

    label_select_frames = gtk_label_new (_("  Frames  "));
    gtk_widget_ref (label_select_frames);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_frames", label_select_frames,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_frames);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 4, label_select_frames);

    label_select_aspect = gtk_label_new (_("  Aspect  "));
    gtk_widget_ref (label_select_aspect);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_aspect", label_select_aspect,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_aspect);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 5, label_select_aspect);

    label_select_FPS = gtk_label_new (_("  FPS  "));
    gtk_widget_ref (label_select_FPS);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_FPS", label_select_FPS,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_FPS);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 6, label_select_FPS);

    label_select_title = gtk_label_new (_("  DVD Title  "));
    gtk_widget_ref (label_select_title);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_title", label_select_title,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_title);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 7, label_select_title);

    label_select_vts = gtk_label_new (_("  DVD Title Set  "));
    gtk_widget_ref (label_select_vts);
    gtk_object_set_data_full (GTK_OBJECT (window1), "label_select_vts", label_select_vts,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (label_select_vts);
    gtk_clist_set_column_widget (GTK_CLIST (clist1), 8, label_select_vts);


    /* Attach callback handlers */
    gtk_signal_connect (GTK_OBJECT (clist1), "select_row",GTK_SIGNAL_FUNC (on_dvdtitels_select_row),NULL);
    gtk_signal_connect (GTK_OBJECT (clist1), "unselect_row",GTK_SIGNAL_FUNC (on_dvdtitels_unselect_row),NULL);

    /* Fill in columns */
    for (i=0;i<Config.DVD_Total_ChapterSequences;i++) {
        g_string_sprintf(select_pc,"%i",i+1);
        g_string_sprintf(select_angle,"%i",Config.VT_Angles[Config.CS_belongs_to_VT[i]]);
        g_string_sprintf(select_chap,"%i",Config.CS_Chapters[i]);
        seconds2time((gint)(Config.frames2encode[i]/Config.framerate),select_playback);
        g_string_sprintf(select_frames,"%i",Config.frames2encode[i]);
        g_string_sprintf(select_aspect,"%.3g:1",Config.VTS_Aspects[Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]]]);
        g_string_sprintf(select_FPS,"%g",Config.framerate);
        g_string_sprintf(select_title,"%i",Config.CS_belongs_to_VT[i]+1);
        g_string_sprintf(select_vts,"%i",Config.VT_belongs_to_VTS[Config.CS_belongs_to_VT[i]]);

        row[0] = select_pc->str;
        row[1] = select_angle->str;
        row[2] = select_chap->str;
        row[3] = select_playback->str;
        row[4] = select_frames->str;
        row[5] = select_aspect->str;
        row[6] = select_FPS->str;
        row[7] = select_title->str;
        row[8] = select_vts->str;
        gtk_clist_append(GTK_CLIST(clist1),row);
        if (Config.CS[i]==TRUE) {
            gtk_clist_select_row(GTK_CLIST(clist1),i,0);
            selected_files++;
        }
    }

    /* Set next (dummy) page */
    on_combo_entry_DVDtitle_changed(NULL,NULL);

    /* Call divx output naming */
    format_divxname(Config.DIVXfileUser,FALSE);

    /* Clean & Exit */
    g_string_free(temp,TRUE);
    g_string_free(command,TRUE);
    g_string_free(text,TRUE);
    g_string_free(select_pc,TRUE);
    g_string_free(select_playback,TRUE);
    g_string_free(select_frames,TRUE);
    g_string_free(select_aspect,TRUE);
    g_string_free(select_FPS,TRUE);
    g_string_free(select_title,TRUE);
    g_string_free(select_vts,TRUE);
    //g_string_free(dvd_cache_file,TRUE);
    return FALSE;
}


void on_drip_druidpagefinish1_finish(GnomeDruidPage *gnomedruidpage, gpointer arg1, gpointer user_data) {
    /* Remove dialog and continue encoding process */
    gtk_widget_destroy(audio_subpicture_dialog);
    audio_subpicture_dialog = NULL;
    return;
}


void on_reset_to_default_clicked(GtkButton *button,gpointer user_data) {
    GString *command = g_string_new("");
    GtkWidget *combo = (GtkWidget*)user_data;
    gint i;
    /* Build new plugin gui */
    g_string_sprintf(command,"%s",gtk_entry_get_text(GTK_ENTRY(combo)));
    for (i=0;i<filters_index;i++) {
        if (strcmp(filters[i].module_name->str,command->str)==0) {
            (*filters[i].module_default_function)();
            i = filters_index;
        }
    }
    // Refresh plugin widget
    on_combo_entry_plugin_changed((GtkEditable *)combo_entry12, combo_entry12);

    /* Clean & Exit */
    g_string_free(command,TRUE);
    return;
}

void g_list_move_up(GList *list,gint position) {
    /* Move element at position forward on GList */
    GList *P1 = g_list_nth(list,position-1);
    GList *P2 = g_list_nth(list,position);
    GList *P3 = g_list_nth(list,position+1);
    GList *P4 = g_list_nth(list,position+2);

    /* Dont move last in list */
    if (P2->next == NULL) {
        g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Not moving list element, already @ last position");
        return;
    }

    /* Move P2 toward last */
    if (P1!=NULL) P1->next = P3;
    if (P2!=NULL) P2->prev = P3;
    if (P2!=NULL) P2->next = P4;
    if (P3!=NULL) P3->prev = P1;
    if (P3!=NULL) P3->next = P2;
    if (P4!=NULL) P4->prev = P2;

    /* Moved 1st in list? */
    if (P2 == list) {
        Config.selected_chapters[Config.CURRENT_AVIFILE] = P3;
    }
    return;
}


void g_list_move_down(GList *list,gint position) {
    /* Move element at position backward on GList */
    GList *P1 = g_list_nth(list,position-2);
    GList *P2 = g_list_nth(list,position-1);
    GList *P3 = g_list_nth(list,position);
    GList *P4 = g_list_nth(list,position+1);

    /* Dont move first in list */
    if (P3->prev == NULL) {
        g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Not moving list element, already @ first position");
        return;
    }

    /* Move P3 toward first */
    if (P1!=NULL) P1->next = P3;
    if (P2!=NULL) P2->prev = P3;
    if (P2!=NULL) P2->next = P4;
    if (P3!=NULL) P3->prev = P1;
    if (P3!=NULL) P3->next = P2;
    if (P4!=NULL) P4->prev = P2;

    /* Moved to start of list? */
    if (P2 == list) {
        Config.selected_chapters[Config.CURRENT_AVIFILE] = P3;
    }
    return;
}

void on_button_up_clicked (GtkButton *button, gpointer user_data) {
    GList *temp;
    if (current_avi_clist!=NULL) {
        temp = (GTK_CLIST(current_avi_clist))->selection;
        while (temp) {
            g_list_move_up(Config.selected_chapters[Config.CURRENT_AVIFILE],(gint)(temp->data));
            temp = g_list_next(temp);
        }

    }
    /* Refresh avi list */
    build_compose_avilist();

    return;
}

void on_button_down_clicked (GtkButton *button, gpointer user_data) {
    GList *temp;
    if (current_avi_clist!=NULL) {
        temp = (GTK_CLIST(current_avi_clist))->selection;
        while (temp) {
            g_list_move_down(Config.selected_chapters[Config.CURRENT_AVIFILE],(gint)(temp->data));
            temp = g_list_next(temp);
        }
    }
    /* Refresh avi list */
    build_compose_avilist();

    return;
}

void on_button20_clicked (GtkButton *button, gpointer user_data) {
    Config.progres_size = Config.progres_size + (gdouble)0.1;
    if (Config.progres_size>(gdouble)1.0) Config.progres_size = (gdouble)1.0;
    if (Config.progres_size<(gdouble)0.2) Config.progres_size = (gdouble)0.2;
    encoder_refresh_progress(FALSE);
    // g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Config.progres_size changed to %g",Config.progres_size);
    return;
}

void on_button21_clicked (GtkButton *button, gpointer user_data) {
    Config.progres_size = Config.progres_size - (gdouble)0.1;
    if (Config.progres_size<(gdouble)0.2) Config.progres_size = (gdouble)0.2;
    encoder_refresh_progress(FALSE);
    // g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Config.progres_size changed to %g",Config.progres_size);
    return;
}

void on_button22_clicked (GtkButton *button, gpointer user_data) {
    Config.progres_size = Config.progres_size * (gdouble)-1;
    encoder_refresh_progress(FALSE);
    // g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Config.progres_size changed to %g",Config.progres_size);
    return;
}

void on_button23_clicked (GtkButton *button, gpointer user_data) {
    encoder_refresh_progress(FALSE);
    // g_log(DRIP_CB_LD,G_LOG_LEVEL_DEBUG,"Config.progres_size changed to %g",Config.progres_size);
    return;
}

