/*
 * LEDbarP.h
 * Copyright (C) Michael Stickel <michael@cubic.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _XmsLEDbarP_H_
#define _XmsLEDbarP_H_

#include <X11/IntrinsicP.h>

#include "LEDbar.h"

_XFUNCPROTOBEGIN

typedef struct 
{
  /* methods */
  /* class variables */
  int dummy;
} XmsLEDbarClassPart;

typedef struct _XmsLEDbarClassRec 
{
  CoreClassPart core_class;
  XmsLEDbarClassPart xmsLEDbar_class;
} XmsLEDbarClassRec;

typedef struct 
{
  /* resources */
  int  numboxes;
  int  value;
  Pixel  onColor;
  Pixel  offColor;
  XtCallbackList  selectCallback;
  /* private state */
  GC  gc_on;
  GC  gc_off;
  XRectangle * rect;
} XmsLEDbarPart;

typedef struct _XmsLEDbarRec 
{
  CorePart core;
  XmsLEDbarPart xmsLEDbar;
} XmsLEDbarRec;

externalref XmsLEDbarClassRec xmsLEDbarClassRec;

_XFUNCPROTOEND

#endif /* _XmsLEDbarP_H_ */
