/*
 * Defines for the error and message code.
 *
 * Copyright 2000 by Gray Watson
 *
 * This file is part of the dmalloc package.
 *
 * Permission to use, copy, modify, and distribute this software for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of Gray Watson not be used in advertising
 * or publicity pertaining to distribution of the document or software
 * without specific, written prior permission.
 *
 * Gray Watson makes no representations about the suitability of the
 * software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted via http://dmalloc.com/
 *
 * $Id: error.h,v 1.47 2000/05/16 18:36:51 gray Exp $
 */

#ifndef __ERROR_H__
#define __ERROR_H__

#include <stdarg.h>				/* for ... */

#include "conf.h"				/* up here for _INCLUDE */

/* for time type -- see settings.h */
#if STORE_TIME
#ifdef TIME_INCLUDE
#include TIME_INCLUDE
#endif
#endif

/* for timeval type -- see settings.h */
#if STORE_TIMEVAL
#ifdef TIMEVAL_INCLUDE
#include TIMEVAL_INCLUDE
#endif
#endif

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

/* logfile for dumping dmalloc info, DMALLOC_LOGFILE env var overrides this */
extern
char		*_dmalloc_logpath;

/* address to look for.  when discovered call dmalloc_error() */
extern
DMALLOC_PNT	_dmalloc_address;

/* when to stop at an address */
extern
unsigned long	_dmalloc_address_seen_n;

/* global debug flags that are set my DMALLOC_DEBUG environ variable */
extern
unsigned int	_dmalloc_flags;

/* global iteration counter for activities */
extern
unsigned long	_dmalloc_iter_c;

/* how often to check the heap */
extern
unsigned long	_dmalloc_check_interval;

#if STORE_TIMEVAL
/* overhead information storing when the library started up for elapsed time */
extern
TIMEVAL_TYPE	_dmalloc_start;
#endif /* if STORE_TIMEVAL */

#if STORE_TIMEVAL == 0
#if HAVE_TIME
/* NOTE: we do the ifdef this way for fillproto */
extern
TIME_TYPE	_dmalloc_start;
#endif /* if HAVE_TIME */
#endif /* if STORE_TIMEVAL == 0 */

/* when we are going to startup our locking subsystem */
extern
int		_dmalloc_lock_on;

/* global flag which indicates when we are aborting */
extern
int		_dmalloc_aborting_b;

/*
 * Open up our log file and write some version of settings
 * information.
 */
extern
void	_dmalloc_open_log(void);

#if STORE_TIMEVAL
/*
 * print the time into local buffer which is returned
 */
extern
char	*_dmalloc_ptimeval(const TIMEVAL_TYPE *timeval_p, char *buf,
			   const int buf_size, const int elapsed_b);
#endif /* if STORE_TIMEVAL */

#if STORE_TIMEVAL == 0 && HAVE_TIME
/*
 * print the time into local buffer which is returned
 */
extern
char	*_dmalloc_ptime(const TIME_TYPE *time_p, char *buf, const int buf_size,
			const int elapsed_b);
#endif /* if STORE_TIMEVAL == 0 && HAVE_TIME */

/*
 * message writer with vprintf like arguments
 */
extern
void	_dmalloc_vmessage(const char *format, va_list args);

/*
 * message writer with printf like arguments
 */
extern
void	_dmalloc_message(const char *format, ...)
#ifdef __GNUC__
  __attribute__ ((format (printf, 1, 2)))
#endif
;

/*
 * kill the program because of an internal malloc error
 */
extern
void	_dmalloc_die(const int silent_b);

/*
 * handler of error codes from procedure FUNC.  the procedure should
 * have set the errno already.
 */
extern
void	dmalloc_error(const char *func);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __ERROR_H__ */
