package error;
use strict;
return 1;

# Create a new error
sub new
{
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self = {
		id => shift,
		msg => shift,
        };
        bless($self,$class);
        return $self;
}

sub process
{
        my $proto = shift;
	my $name = shift;
	my $status = shift;

	my $exit_value  = $status >> 8;
	my $signal_num  = $status & 127;
	my $dumped_core = $status & 128;

	return $proto->new("error"->general,
 			"$name: exit=$exit_value, ".
      			"signal=$signal_num, core=$dumped_core");
}

# Return error message to display to user
sub msg
{
	my $self=shift;
	return $self->{"msg"};
}

# Return error id so that program can take appropriate action
sub id
{
	my $self=shift;
	return $self->{"id"};
}

# limited selection of error codes, so that program
# can determine if error is fatal or not.
# this list should really be updated.

sub general
{
	return 1;
}

sub notfound
{
	return 2;
}

sub alreadyexists
{
	return 3;
}
