/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/to_string.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref ::diagnostics::internal::to_string -- is
 * only used internally but must be available in the interface for
 * some inlined code. Do not use directly.
 *
 * @todo make available as part of the interface
 *
 * @test none
 */


#ifndef DIAGNOSTICS__UTIL__TO_STRING_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__TO_STRING_HPP__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>

// used in the implementation by value
#include <sstream>

DIAGNOSTICS_NAMESPACE_BEGIN;
INTERNAL_NAMESPACE_BEGIN;

template<typename T> 
::std::string to_string(T const & t)
{
    ::std::ostringstream os;
    os << t;
    return os.str();
}

template<typename T0,typename T1> 
::std::string to_string(T0 const & t0,
			T1 const & t1)
{
    ::std::ostringstream os;
    os << t0 << t1;
    return os.str();
}

template<typename T0,typename T1,typename T2> 
::std::string to_string(T0 const & t0,
			T1 const & t1,
			T2 const & t2)
{
    ::std::ostringstream os;
    os << t0 << t1 << t2;
    return os.str();
}

template<typename T0,typename T1,typename T2,typename T3> 
::std::string to_string(T0 const & t0,
			T1 const & t1,
			T2 const & t2,
			T3 const & t3)
{
    ::std::ostringstream os;
    os << t0 << t1 << t2 << t3;
    return os.str();
}

template<typename T0,typename T1,typename T2,typename T3, typename T4> 
::std::string to_string(T0 const & t0,
			T1 const & t1,
			T2 const & t2,
			T3 const & t3,
			T4 const & t4)
{
    ::std::ostringstream os;
    os << t0 << t1 << t2 << t3 << t4;
    return os.str();
}

template<typename T0,typename T1,typename T2,typename T3, typename T4,typename T5> 
::std::string to_string(T0 const & t0,
			T1 const & t1,
			T2 const & t2,
			T3 const & t3,
			T4 const & t4,
			T5 const & t5)
{
    ::std::ostringstream os;
    os << t0 << t1 << t2 << t3 << t4 << t5;
    return os.str();
}


INTERNAL_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif
// vim:ts=4:sw=4
