#include "includes.h"
#include "dbus_service.h"
#include "dhcp_options.h"
#include "dhcdbd.h"

void handle_subscription(DBUS_SVC dbus, char *ip_if, char *opt, dbus_svc_MessageHandle msg)
{
    char *name=0L, a[16], a1[16], *dn=0;	
    struct in_addr ip, ip2;
    uint8_t b;

    if( strcmp(opt,"reason") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_BYTE, &b,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%u\n", ip_if, name, b);
	}
    }else
    if( strcmp(opt,"ip_address") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_UINT32, &ip,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s\n", ip_if, name, 
		inet_ntop(AF_INET, &ip, &(a[0]),16) 
	       );
	}
    }else
    if( strcmp(opt,"subnet_mask") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_UINT32, &ip,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s\n", ip_if, name, 
		inet_ntop(AF_INET, &ip, &(a[0]),16) 
	       );
	}
    }else
    if( strcmp(opt,"broadcast_address") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_UINT32, &ip,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s\n", ip_if, name, 
		inet_ntop(AF_INET, &ip, &(a[0]),16) 
	       );
	}
    }else
    if( strcmp(opt,"routers") == 0 )
    {  /* we assume that routers has one member! */
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_UINT32, &ip,
			      TYPE_INVALID
		             )
	  )
	{
		printf("%s\t%s\t%s\n", ip_if, name, 
		    inet_ntop(AF_INET, &ip, &(a[0]),16) 
		    );
	}
    }else
    if( strcmp(opt,"domain_name_servers") == 0 )
    {  /* we assume that d_n_s has two members! */
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_UINT32, &ip,
			      TYPE_UINT32, &ip2,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s %s\n", ip_if, name, 
		   inet_ntop(AF_INET, (struct in_addr*)&ip, &(a[0]),16), 
		   inet_ntop(AF_INET, (struct in_addr*)&ip2, &(a1[0]),16)
		);
	}
    }else
    if( strcmp(opt,"domain_name") == 0 )
    {
	if( dbus_svc_get_args(dbus, msg,
			      TYPE_STRING, &name,
			      TYPE_STRING, &dn,
			      TYPE_INVALID
		             )
	  )
	{
	    printf("%s\t%s\t%s\n", ip_if, name, dn);
	}
    }else
	printf("Unrequested Opt: %s\n", opt);
}

dbus_svc_HandlerResult
message_filter
(
    DBusMsgHandlerArgs
) 
{
    char *ip_if;
/*    printf("Filter: got message %u %u %s %s %s %s %s %s\n",
 	   reply_expected, serial, destination, path, member, interface, sender, signature
 	);
*/
    if (  ( type == SIGNAL )
	&&( strcmp(path,"/org/freedesktop/DBus/Local") == 0 )
	&&( strcmp(member,"Disconnected") == 0 )
       ) 
    {
	dbus_svc_quit( dbus );
    }

    if ( strcmp(interface,"com.redhat.dhcp.subscribe.dbus") == 0 )
    {
	ip_if = strrchr(path, '/');
	if( ip_if == 0L)
	    return HANDLED;
	++ip_if;
/*	printf("\t subscription: path:%s member:%s interface:%s ip_if:%s\n",
	       path,member,interface,ip_if
	    );
*/
	handle_subscription(dbus, ip_if, member, msg);
    }
    return HANDLED;
}

uint8_t subscribe_to_dhcdbd
( DBUS_SVC dbus, char *type, char *ip_if, int n_subs, ...)
{
    int i;
    va_list va;
    va_start(va, n_subs);
    char subs[1024], path[1024],*option_name;
    dbus_svc_MessageHandle msg;
    
    sprintf(subs,"com.redhat.dhcp.subscribe");
    sprintf(path,"/com/redhat/dhcp/%s",ip_if);
    for(i = 0; i < n_subs; i++)
    {
	option_name = va_arg(va,char*);
	msg = dbus_svc_call
	      ( dbus,
		"com.redhat.dhcp",
		path,
		type,		
		subs,		
		TYPE_STRING, &option_name,
		TYPE_INVALID
	      );
	if(msg == 0L)
	    return 0;	
    }
    return 1;
}

int main( int argc, char **argv, char **envp )
{
    DBUS_SVC dbus;

    dbus = dbus_svc_init( DBUS_SYSTEM, 0L, 0L, 0L );

    if ( dbus == 0L )
    {
	printf("Failed to initialise D-Bus service.\n");
	return( 1 );
    }
	
    if ( !dbus_svc_add_message_filter
	 ( dbus, message_filter,1,
	   "type=signal"
	 )
       )return( 1 );

    
    if( ! subscribe_to_dhcdbd
	  ( dbus, "dbus", "eth0", 7,
	    "reason", "ip-address", "subnet-mask", "broadcast-address", "routers", "domain-name", "domain-name-servers"
	  )
      )
    {
	printf("subscription failed\n");
	return(1);
    }

    dbus_svc_main_loop( dbus, 0L);

    return(0);
}
