private with Ada.Containers.Indefinite_Ordered_Maps;

package Environment_Variable_Backups is

   --  An ugly trick to transmit scenario variables because the
   --  current version of Prj does not allow to transmit scenario
   --  variables easily. We set environment variables, load the file
   --  then reset them. Here are the structures used to store the old
   --  state.

   --  This package should be replaced as soon as possible with Prj
   --  options.

   pragma Elaborate_Body;

   type Backup is private;
   --  Only changes done with Set are stored and reverted.

   procedure Set (Name      : in     String;
                  New_Value : in     String;
                  Changes   : in out Backup);

   procedure Restore (Changes : in Backup);

private

   type Variable_State
     (Was_Set      : Boolean;
      Value_Length : Natural) is record
      case Was_Set is
         when True => Value : String (1 .. Value_Length);
         when False => null;
      end case;
   end record;

   pragma Warnings (Off,
                    "pragma Warnings Off for ""*"" unused, could be omitted");

   package Variable_Maps is new Ada.Containers.Indefinite_Ordered_Maps
     (String, Variable_State);

   pragma Warnings (On,
                    "pragma Warnings Off for ""*"" unused, could be omitted");

   type Backup is new Variable_Maps.Map with null record;

end Environment_Variable_Backups;
