/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "stringfunctions.h"
#include "global.h"
#include "shell.h"
#include <string.h>
#include <stdlib.h>

char* GenerateUriList(char* filenames)
{
  char *text;
  char *text2;
  char *text3;
  char *newline;
  int count=0;
  int i=0;
  int j;
  
  while (filenames[i]!=0) {
    if (filenames[i]==' ')
      count++;
    if (filenames[i]=='\\')
      i++;
    i++;
  }
  text=malloc(strlen(filenames)+
              count*strlen("file:/cl")+
              count*strlen(getenv("HOME"))+1);
  text[0]=0;
  newline=malloc(3);
  newline[0]=13;
  newline[1]=10;
  newline[2]=0;
  i=0;
  while (filenames[i]!=0) {
    strcat(text,"file:");
    j=i+1;
    while (filenames[j]!=0 && filenames[j]!=' ') {
      if (filenames[j]=='\\')
        j++;
      j++;
    }
    text2=malloc(j-i);
    strncpy(text2,filenames+i+1,j-i-1);
    text2[j-i-1]=0;
    text3=GenerateDeBackslashName(text2);
    free(text2);
    text2=ExpandTilde(text3);
    free(text3);
    strcat(text,text2);
    free(text2);
    i=j;
    strcat(text,newline);
  }
  free(newline);
  return(text);
}

char* GenerateBackslashName(char* input)
{
  char *text;
  int i;
  char *insert;
  insert=strdup(" ");
  text=malloc(2*strlen(input)+2);
  text[0]=0;
  i=0;
  while (input[i]!=0) {
    if (input[i]<'+')
      strcat(text,"\\");
    else if (input[i]>'9' && input[i]<'A')
      strcat(text,"\\");
    else if (input[i]>'z' && input[i]<'~')
      strcat(text,"\\");
    else if (input[i]>'~')
      strcat(text,"\\");
    insert[0]=input[i];
    strcat(text,insert);
    i++;
  }
  free(insert);
  return(text);
}

char* GenerateDeBackslashName(char* input)
{
  char *text;
  int i;
  char *insert;
  insert=strdup(" ");
  text=malloc(strlen(input)+2);
  text[0]=0;
  if (input[0]==' ')
    i=1;
  else
    i=0;
  while (input[i]!=0) {
    if (input[i]!='\\') {
      insert[0]=input[i];
      strcat(text,insert);
    }
    i++;
  }
  free(insert);
  return(text);
}

char* GenerateWindowName(char* pathname,int type)
{
  char *text;
  char *windowname;
  int i,j;
  if (strcmp(pathname,"/")==0 || strcmp(pathname,"~/")==0) {
    text=malloc(strlen(pathname)+1);
    strcpy(text,pathname);
  } else {
    i=1;j=1;
    do {
      j++;
      if (pathname[j-2]=='/')
	i=j-1;
    } while (pathname[j]!=0);
    text=malloc(j-i+1);
      strncpy(text,pathname+i,j-i);
      text[j-i-1]=0;
  }
  windowname=malloc(strlen(pathname)+strlen(text)+10);
  strcpy(windowname,text);
  free(text);
  if (type==NORMAL)
    strcat(windowname," --- dfm:");
  else if (type==DETAIL)
    strcat(windowname," -d- dfm:");
  else /*STRUCTURE*/ 
    strcat(windowname," -s- dfm:");
  strcat(windowname,pathname);
  return(windowname);
}

char* GenerateLastName(char* filename)
{
  char *text;
  char *name;
  int i,j;
  i=1;j=1;
  do {
    j++;
    if (filename[j-2]=='/')
      i=j-1;
  } while (filename[j]!=0);
  text=malloc(j-i+1);
  strcpy(text,filename+i);
  
  name=malloc(strlen(text)+1);
  strcpy(name,text);
  free(text);
  return(name);
}

char* GenerateLastNameWithoutSlash(char* pathname)
{
  char *text;
  char *iconname;
  int i,j;
  if (strcmp(pathname,"/")==0 || strcmp(pathname,"~/")==0) {
    text=malloc(strlen(pathname)+1);
    strcpy(text,pathname);
  } else {
    i=1;j=1;
    do {
      j++;
      if (pathname[j-2]=='/')
	i=j-1;
    } while (pathname[j]!=0);
    text=malloc(j-i+1);
    strncpy(text,pathname+i,j-i);
    if (text[j-i-1]=='/') 
      text[j-i-1]=0;
    else
      text[j-i]=0;
  }
  iconname=malloc(strlen(text)+1);
  strcpy(iconname,text);
  free(text);
  return(iconname);
}

char* GeneratePathNameFromFile(char* pathname)
{
  char *text;
  int i,j;
  text=malloc(strlen(pathname)+1);
  strcpy(text,pathname);
  j=strlen(text)-1;
  for (i=0;i<strlen(text)-1;i++)
    if (text[i]=='/')
      j=i;
  text[j+1]=0;
  return(text);
}

