/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "iconmanager.h"
#include "filemanager.h"
#include "iwc.h"
#include "shell.h"
#include "extension.h"
#include "namedemultiplexer.h"
#include "wmicon.h"
#include "color.h"
#include "gui.h"
#include "changename.h"
#include "pixmap.h"
#include "arcwindow.h"
#include "positiontext.h"
#include "stringfunctions.h"
#include "global.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "menus.h"
#include "timer.h"
#include "createicon.h"
#include "positionarrange.h"
#include "windowposition.h"
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "rubwindow.h"
#include "freeze.h"
#include "includepixmaps/slider.h"
#include "includepixmaps/tree.h"

#include <time.h>

#include <X11/extensions/shape.h>

struct item *keyentry=NULL;
struct item *directory=NULL;

int grid=0;

Window movexmain,movex;
Window moveymain,movey;
Window quader;
int moveonx=False,moveony=False;
int quaderon=False;

int sorttype;

Pixmap minus=0;
Pixmap minus_shape=0;
Pixmap plus=0;
Pixmap plus_shape=0;
Pixmap noplus=0;
Pixmap noplus_shape=0;
Pixmap switchb=0;
Pixmap switchb_shape=0;
Pixmap lineh=0;
Pixmap linev=0;

struct item* SearchLastOne(struct item *rec,struct item *search,struct item *this)
{
   struct item *found=NULL;
   struct item *direntry;
   direntry=rec;
   while (direntry!=NULL && found==NULL) {
     if (direntry->subtree!=NULL) {
       found=SearchLastOne(direntry->subtree,search,direntry);
     } else if (direntry->nextitem==NULL) {
         if (direntry==search)
	   return this;
         else
	   return NULL;
     }
     direntry=direntry->nextitem;
   }
   if (found!=NULL && found->nextitem==NULL)
     return this;
   else
     return found;
}

struct item *Getnextitem(struct item *fileitem) 
{
  struct item *found;
  if (fileitem->subtree!=NULL)
    return fileitem->subtree;
  else if (fileitem->nextitem!=NULL)
    return fileitem->nextitem;
  else {
    found=SearchLastOne(directory,fileitem,NULL);
    if (found!=NULL) {
      return found->nextitem;
    }
    else
      return NULL;
  }
}

void CalcMoveWindowSize()
{
  static int sizex1=-1,sizex2=-1,sizey1=-1,sizey2=-1;
  unsigned int minx,miny;
  int ax,ay;
  int x,y;
  int i;
  unsigned int width,height;
  unsigned int border,depth;
  Window root;
  struct item *direntry;
  Pixmap pixelmap,pixelmap2;
  unsigned int dummy;
  if (GetIsDesktop()==False) {
    XGetGeometry(GetDisplay(),GetMoveWindow(),&root,&ax,&ay,
		 &width,&height,&border,&depth);
    minx=0;
    miny=0;
    i=0;
    direntry=directory;
    while (direntry!=NULL) {
      i++;
      XGetGeometry(GetDisplay(),direntry->Iconwindow,&root,&x,&y,
		   &width,&height,&border,&depth);
      if (minx<x+width) minx=x+width;
      if (miny<y+height) miny=y+height;
      direntry=Getnextitem(direntry);
   }
    for (i=0;i<3;i++) {
      XGetGeometry(GetDisplay(),GetWindow(),&root,&x,&y,
		   &width,&height,&border,&depth);
      if (moveony==True) width=width-SLIDER;
      if (moveonx==True) height=height-SLIDER;
      if (miny>height|| ay!=0) { 
	if (moveony==False) {
	  moveymain=XCreateSimpleWindow(GetDisplay(),GetWindow(),
					width,0,SLIDER,height,0,
					0,0);
	  XSelectInput(GetDisplay(),moveymain,ButtonReleaseMask|ButtonPressMask
		       |PointerMotionMask);
	  movey=XCreateSimpleWindow(GetDisplay(),moveymain,
				    0,SLIDER,SLIDER,height-SLIDERBUTTON*2,0,
				    0,0);
	  XSelectInput(GetDisplay(),movey,ButtonReleaseMask|ButtonPressMask
		       |PointerMotionMask);
          XLowerWindow(GetDisplay(),moveymain);
          XMapWindow(GetDisplay(),moveymain);
          XMapRaised(GetDisplay(),movey);
	  moveony=True;
	}
	XMoveResizeWindow(GetDisplay(),moveymain,width,0,SLIDER,height);
      } else {
	if (moveony==True) {
	  XDestroyWindow(GetDisplay(),moveymain);
	  moveony=False;
	}      
      }
      if (minx>width || ax!=0 ) { 
	if (moveonx==False) {
	  movexmain=XCreateSimpleWindow(GetDisplay(),GetWindow(),
					0,height,width,SLIDER,0,
					0,0
					);
	  XSelectInput(GetDisplay(),movexmain,ButtonReleaseMask|ButtonPressMask
		       |PointerMotionMask);
	  movex=XCreateSimpleWindow(GetDisplay(),movexmain,
				    0,SLIDER,width-SLIDERBUTTON*2,SLIDER,0,
				    0,0);
	  XSelectInput(GetDisplay(),movex,ButtonReleaseMask|ButtonPressMask
		       |PointerMotionMask);
          XLowerWindow(GetDisplay(),movexmain);
          XMapWindow(GetDisplay(),movexmain);
          XMapRaised(GetDisplay(),movex);
	  moveonx=True;
	}
	XMoveResizeWindow(GetDisplay(),movexmain,0,height,width,SLIDER);
      } else {
	if (moveonx==True) {
	  XDestroyWindow(GetDisplay(),movexmain);
	  moveonx=False;
	}
      }
    }
    if (moveonx==True || moveony==True) {
      if (quaderon==False) {
	quader=XCreateSimpleWindow(GetDisplay(),GetWindow(),
				   width,height,SLIDER,SLIDER,0,0,0);
	XSelectInput(GetDisplay(),quader,ButtonReleaseMask|ButtonPressMask
		     |PointerMotionMask);
	DataPixmap(quader_xpm,&pixelmap,NULL);
	XSetWindowBackgroundPixmap(GetDisplay(),quader,pixelmap);
	XFreePixmap(GetDisplay(),pixelmap);
	XMapRaised(GetDisplay(),quader);
	quaderon=True;
      }
      XMoveResizeWindow(GetDisplay(),quader,width,height,SLIDER,SLIDER);
    } else {
      if (quaderon==True) {
	XDestroyWindow(GetDisplay(),quader);
	quaderon=False;
      }
    }
    if (width-ax>minx) minx=width-ax;
    if (height-ay>miny) miny=height-ay;
    XResizeWindow(GetDisplay(),GetMoveWindow(),minx,miny);
    if (moveony==True) {
      XMoveResizeWindow(GetDisplay(),movey,
			0,
			SLIDERBUTTON+(int)((double)(height-SLIDERBUTTON*2)*(double)(-ay)/(double)miny),
			SLIDER,
			1+(int)((double)(height-SLIDERBUTTON*2)*(double)height/(double)miny)
			);
    }
    if (moveonx==True) {
      XMoveResizeWindow(GetDisplay(),movex,
			SLIDERBUTTON+(int)((double)(width-SLIDERBUTTON*2)*(double)(-ax)/(double)minx),
			0,
			1+(int)((double)(width-SLIDERBUTTON*2)*(double)width
				/(double)minx),
			SLIDER
			);
    }
    if (moveony==True) {
      /*background*/
      XGetGeometry(GetDisplay(),moveymain,&root,&x,&y,&width,&height,&dummy,&depth);
      if (sizey1!=height) {      
        sizey1=height; 
        pixelmap=XCreatePixmap(GetDisplay(),moveymain,width,height,depth);
        /*top*/
        DataPixmap(moveymaintop_n_xpm,&pixelmap2,NULL);
        XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDER,SLIDERBUTTON,0,0);
        XFreePixmap(GetDisplay(),pixelmap2);
        /*middle*/
        DataPixmap(moveymainmiddle_xpm,&pixelmap2,NULL);
        for (i=SLIDERBUTTON;i<height;i=i+SLIDER)
	XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDER,SLIDER,0,i);
        XFreePixmap(GetDisplay(),pixelmap2);
        /*bottom*/
        DataPixmap(moveymainbottom_n_xpm,&pixelmap2,NULL);
        XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDER,SLIDERBUTTON,0,height-SLIDERBUTTON);
        XFreePixmap(GetDisplay(),pixelmap2);

        XSetWindowBackgroundPixmap(GetDisplay(),moveymain,pixelmap);
        XFreePixmap(GetDisplay(),pixelmap);
      }      
      /*slider*/
      XGetGeometry(GetDisplay(),movey,&root,&x,&y,&width,&height,&dummy,&depth);
      if (sizey2!=height) {      
        sizey2=height; 
        pixelmap=XCreatePixmap(GetDisplay(),movey,width,height,depth);
        /*top*/
        DataPixmap(moveytop_xpm,&pixelmap2,NULL);
        XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDER,3,0,0);
        XFreePixmap(GetDisplay(),pixelmap2);
        /*middle*/
        DataPixmap(moveymiddle_xpm,&pixelmap2,NULL);
        for (i=3;i<height;i=i+SLIDER)
	  XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDER,SLIDER,0,i);
        XFreePixmap(GetDisplay(),pixelmap2);
        /*bottom*/
        DataPixmap(moveybottom_xpm,&pixelmap2,NULL);
        XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDER,3,0,height-3);
        XFreePixmap(GetDisplay(),pixelmap2);

        XSetWindowBackgroundPixmap(GetDisplay(),movey,pixelmap);
        XFreePixmap(GetDisplay(),pixelmap);
      }
      XClearWindow(GetDisplay(),moveymain);
      XClearWindow(GetDisplay(),movey);
      if (IsFreezed()==False)
        XRaiseWindow(GetDisplay(),moveymain);
    } else {
      sizey1=-1; 
      sizey2=-1; 
    }
    if (moveonx==True) {
      /*background*/
      XGetGeometry(GetDisplay(),movexmain,&root,&x,&y,&width,&height,&dummy,&depth);
      if (sizex1!=width) {      
        sizex1=width; 
        pixelmap=XCreatePixmap(GetDisplay(),movexmain,width,height,depth);
        /*top*/
        DataPixmap(movexmainleft_n_xpm,&pixelmap2,NULL);
        XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDERBUTTON,SLIDER,0,0);
        XFreePixmap(GetDisplay(),pixelmap2);
        /*middle*/
        DataPixmap(movexmainmiddle_xpm,&pixelmap2,NULL);
        for (i=SLIDERBUTTON;i<width;i=i+SLIDER)
	  XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDER,SLIDER,i,0);
        XFreePixmap(GetDisplay(),pixelmap2);
        /*bottom*/
        DataPixmap(movexmainright_n_xpm,&pixelmap2,NULL);
        XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDERBUTTON,SLIDER,width-SLIDERBUTTON,0);
        XFreePixmap(GetDisplay(),pixelmap2);

        XSetWindowBackgroundPixmap(GetDisplay(),movexmain,pixelmap);
        XFreePixmap(GetDisplay(),pixelmap);
      }
      /*slider*/
      XGetGeometry(GetDisplay(),movex,&root,&x,&y,&width,&height,&dummy,&depth);
      if (sizex2!=width) {      
        sizex2=width; 
        pixelmap=XCreatePixmap(GetDisplay(),movex,width,height,depth);
        /*top*/
        DataPixmap(movexleft_xpm,&pixelmap2,NULL);
        XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,3,SLIDER,0,0);
        XFreePixmap(GetDisplay(),pixelmap2);
        /*middle*/
        DataPixmap(movexmiddle_xpm,&pixelmap2,NULL);
        for (i=3;i<width;i=i+SLIDER)
	  XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,SLIDER,SLIDER,i,0);
        XFreePixmap(GetDisplay(),pixelmap2);
        /*bottom*/
        DataPixmap(movexright_xpm,&pixelmap2,NULL);
        XCopyArea(GetDisplay(),pixelmap2,pixelmap,GetGC(),0,0,3,SLIDER,width-3,0);
        XFreePixmap(GetDisplay(),pixelmap2);

        XSetWindowBackgroundPixmap(GetDisplay(),movex,pixelmap);
        XFreePixmap(GetDisplay(),pixelmap);
      }
      XClearWindow(GetDisplay(),movexmain);
      XClearWindow(GetDisplay(),movex);
      if (IsFreezed()==False)
        XRaiseWindow(GetDisplay(),movexmain);
    } else {
      sizex1=-1; 
      sizex2=-1; 
    }
  }
}

void SelectDirentry(struct item* direntry)
{
  int iconx,icony;
  unsigned int windowwidth,windowheight;
  unsigned int iconwidth,iconheight;
  int movewinposx,movewinposy;
  unsigned int border,depth;
  Window root;
  int goalx,goaly;
  int detail=0;
  if (GetKindOfWindow()!=NORMAL)
    detail=20;
  XGetGeometry(GetDisplay(),GetWindow(),&root,
	       &movewinposx,&movewinposy,&windowwidth,&windowheight,&border,&depth);
  XGetGeometry(GetDisplay(),GetMoveWindow(),&root,
	       &movewinposx,&movewinposy,&iconwidth,&iconheight,&border,&depth);
  XGetGeometry(GetDisplay(),direntry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
  PlaceRubberband(iconx,icony,iconwidth-1,iconheight-1);
  if (moveonx==True)
    windowheight=windowheight-SLIDER;
  if (moveony==True)
    windowwidth=windowwidth-SLIDER;
  goalx=-movewinposx;
  goaly=-movewinposy;
  if (iconx+iconwidth>-movewinposx+windowwidth)
    goalx=iconx+iconwidth-windowwidth;
  if (iconx-detail<goalx) {
    goalx=iconx-detail;
  }
  if (goalx<=5)
    goalx=0;
  if (icony<-movewinposy+detail)
    goaly=icony-detail;
  if (icony+iconheight>goaly+windowheight)
    goaly=icony+iconheight-windowheight;
  if (icony<=5)
    goaly=0;
  if (goalx!=-movewinposx || goaly!=-movewinposy) {
    XMoveWindow(GetDisplay(),GetMoveWindow(),-goalx,-goaly);
    CalcMoveWindowSize();
  }
  if (GetKindOfWindow()==DETAIL)
    WriteDetailIcon(keyentry);
  ShowRubberband();
}

void SetPositionOnLastIcon()
{
  int x,y;
  unsigned int width,height;
  unsigned int border,depth;
  Window root;
  int ymax;
  struct item *direntry;
  
  ymax=5;
  direntry=directory;
  while (direntry!=NULL) {
    XGetGeometry(GetDisplay(),direntry->Iconwindow,&root,&x,&y,
		 &width,&height,&border,&depth);
    if (ymax<height+y) 
      ymax=height+y+10;
    direntry=Getnextitem(direntry);
  }
  SetNextPosition(5,ymax);
}

void MakeTreePixmaps(struct item *direntry)
{
        direntry->Expandbutton=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),
	              -100,-100,1,1,0,None,None);
        direntry->Connectline=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),
	              -100,-100,1,1,0,None,None);
        direntry->ExpandlineV=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),
	              -100,-100,1,1,0,None,None);
        direntry->ExpandlineH=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),
	              -100,-100,1,1,0,None,None);
        direntry->Switchbutton=XCreateSimpleWindow(GetDisplay(),GetMoveWindow(),
	              -100,-100,1,1,0,None,None);
	direntry->horizontal=False;
        XSelectInput(GetDisplay(),direntry->Expandbutton,PointerMotionMask|
		 ButtonReleaseMask|ButtonPressMask);
        XSelectInput(GetDisplay(),direntry->Switchbutton,PointerMotionMask|
		 ButtonReleaseMask|ButtonPressMask);
        if (linev==0) {
           DataPixmap(treelineV_xpm,&linev,NULL);
           DataPixmap(treelineH_xpm,&lineh,NULL);
           DataPixmap(treeplus_xpm,&plus,&plus_shape);
           DataPixmap(treenoplus_xpm,&noplus,&noplus_shape);
           DataPixmap(treeswitchb_xpm,&switchb,&switchb_shape);
           DataPixmap(treeminus_xpm,&minus,&minus_shape);
	}
        XSetWindowBackgroundPixmap(GetDisplay(),direntry->Connectline,linev);  
        XSetWindowBackgroundPixmap(GetDisplay(),direntry->ExpandlineV,linev);  
        XSetWindowBackgroundPixmap(GetDisplay(),direntry->ExpandlineH,lineh); 

        XSetWindowBackgroundPixmap(GetDisplay(),direntry->Expandbutton,plus);
        XShapeCombineMask(GetDisplay(),direntry->Expandbutton, ShapeBounding, 0, 0, 
  		    plus_shape, ShapeSet);
        XSetWindowBackgroundPixmap(GetDisplay(),direntry->Switchbutton,switchb);
        XShapeCombineMask(GetDisplay(),direntry->Switchbutton, ShapeBounding, 0, 0, 
  		    switchb_shape, ShapeSet);
}

void MakeWindowIcons()
{
  struct item *direntry;
  directory=GetDirectory(GetPath());
  directory=SortIcons(0,directory);
  direntry=directory;
  while (direntry!=NULL) {
    CreateIconWithDirentry(direntry,True,False);
    direntry=direntry->nextitem;
  }
  if (GetKindOfWindow()==NORMAL && GetIsDesktop()==False)
    SetPositionOnLastIcon(); 
  CalcMoveWindowSize();
}

void MakeWindowTree()
{
  directory=malloc(sizeof(struct item));
  directory->filename=malloc(1);
  directory->filename[0]=0;
  directory->nextitem=NULL;
  directory->subtree=NULL;
  directory->mark=False;
  directory->type=1;
  CreateIconWithDirentry(directory,True,False);
  MakeTreePixmaps(directory);
  PlusTree(directory);
  ArrangeTree();
  CalcMoveWindowSize();
}

Window LowerIcons()
{
  struct item *direntry;
  Window last;
  XWindowChanges wc;
  unsigned int changemask;
  direntry=directory;
  last=GetWindow();
  while (direntry!=NULL) {
    wc.sibling=last;
    wc.stack_mode=Above;
    changemask=CWStackMode|CWSibling;
    XConfigureWindow(GetDisplay(),direntry->Iconwindow,changemask,&wc);
    last=direntry->Iconwindow;
    direntry=Getnextitem(direntry);
  }
  return(last);
}


void PlusTree(struct item *fileitem)
{
  struct item *direntry;
  struct item *safe;
  char* text;
  
  if (fileitem->subtree==NULL) {
  
  text=malloc(strlen(GetPath())+strlen(fileitem->filename)+1);
  strcpy(text,GetPath());
  strcat(text,fileitem->filename);
  fileitem->subtree=GetDirectory(text);
  free(text);
  direntry=fileitem->subtree;
  while (direntry!=NULL && (direntry->type==0||direntry->type==2)) {
    free(direntry->filename);
    fileitem->subtree=direntry->nextitem;
    free(direntry);
    direntry=fileitem->subtree;
  }
  while (direntry!=NULL) {
    while (direntry->nextitem!=NULL &&
           (direntry->nextitem->type==0||direntry->nextitem->type==2)) {
      free(direntry->nextitem->filename);
      safe=direntry->nextitem;
      direntry->nextitem=direntry->nextitem->nextitem;
      free(safe);
    }
    text=malloc(strlen(fileitem->filename)+strlen(direntry->filename)+1);
    strcpy(text,fileitem->filename);
    strcat(text,direntry->filename);
    free(direntry->filename);
    direntry->filename=text;
    direntry=direntry->nextitem;
  }
  fileitem->subtree=SortIcons(NAME,fileitem->subtree);
  direntry=fileitem->subtree;
  while (direntry!=NULL) {
    CreateIconWithDirentry(direntry,True,False);
    MakeTreePixmaps(direntry);
    direntry=direntry->nextitem;
  }
  if (fileitem->subtree==NULL) {
    XSetWindowBackgroundPixmap(GetDisplay(),fileitem->Expandbutton,noplus);
    XShapeCombineMask(GetDisplay(),fileitem->Expandbutton, ShapeBounding, 0, 0, 
  		    noplus_shape, ShapeSet);
    XClearWindow(GetDisplay(),fileitem->Expandbutton);
  } else {
    XSetWindowBackgroundPixmap(GetDisplay(),fileitem->Expandbutton,minus);
    XShapeCombineMask(GetDisplay(),fileitem->Expandbutton, ShapeBounding, 0, 0, 
  		    minus_shape, ShapeSet);
    XClearWindow(GetDisplay(),fileitem->Expandbutton);
  }

  }

}

void MinusTree(struct item *deltree)
{
  struct item *direntry;
  struct item *direntrynew;

  XSetWindowBackgroundPixmap(GetDisplay(),deltree->Expandbutton,plus);
  XShapeCombineMask(GetDisplay(),deltree->Expandbutton, ShapeBounding, 0, 0, 
		    plus_shape, ShapeSet);
  XClearWindow(GetDisplay(),deltree->Expandbutton);
  direntry=deltree->subtree;
  while (direntry!=NULL) {
    MinusTree(direntry);
    XDestroyWindow(GetDisplay(),direntry->Iconwindow);
    /*XDestroyWindow(GetDisplay(),deltree->Inputonly);*/
    XDestroyWindow(GetDisplay(),direntry->Expandbutton);
    XDestroyWindow(GetDisplay(),direntry->Connectline);
    XDestroyWindow(GetDisplay(),direntry->ExpandlineV);
    XDestroyWindow(GetDisplay(),direntry->ExpandlineH);
    XDestroyWindow(GetDisplay(),direntry->Switchbutton);
    free(direntry->filename);
    direntrynew=direntry->nextitem;
    free(direntry);
    direntry=direntrynew;
  }
  deltree->subtree=NULL;
}

void ArrangeTreeRec(struct item *drawtree,int x,int y,int *maxx,int *maxy)
{
  struct item *direntry;
  Window root;
  unsigned int dummy;
  int xnotused;
  int ynotused;
  unsigned int width;
  unsigned int height;
  unsigned int depth;
  int xpos=0,ypos=0,mx,my; /*compiler meckert*/
  
  
  XGetGeometry(GetDisplay(),drawtree->Iconwindow,&root,&xnotused,&ynotused,&width,&height,&dummy,&depth);
  XMoveWindow(GetDisplay(),drawtree->Iconwindow,x+22,y);
  XMoveResizeWindow(GetDisplay(),drawtree->Expandbutton,
                    x,y+(height-15)/2,22,15);
  XMapRaised(GetDisplay(),drawtree->Expandbutton);		    
  *maxx=width+x;
  *maxy=height+y;
  if (drawtree->subtree!=NULL) {
    if (drawtree->horizontal==True) {
      XMoveResizeWindow(GetDisplay(),drawtree->ExpandlineV,
                    x+13,y+(height-15)/2+15,2,height-(height-15)/2);
      XMapRaised(GetDisplay(),drawtree->ExpandlineV);
      //XUnmapWindow(GetDisplay(),drawtree->ExpandlineV);
      ypos=*maxy+10;
      mx=  x-17;
      direntry=drawtree->subtree;
      while(direntry!=NULL) {
        xpos=mx+30;
        ArrangeTreeRec(direntry,xpos,ypos,&mx,&my);
        XMoveResizeWindow(GetDisplay(),direntry->Connectline,
                          xpos,y+height+2,2,ypos-(y+height+2)+(height-15)/2+7);
        XMapRaised(GetDisplay(),direntry->Connectline);
        if (mx>*maxx)
          *maxx=mx;
        if (my>*maxy)
          *maxy=my;
        direntry=direntry->nextitem;	
      }	             
      if (xpos-x-13>0) {
        XMoveResizeWindow(GetDisplay(),drawtree->ExpandlineH,
                          x+15,y+height+2,xpos-x-13,2);
        XMapRaised(GetDisplay(),drawtree->ExpandlineH);
      } else 
        XUnmapWindow(GetDisplay(),drawtree->ExpandlineH);  
    } else {
      XUnmapWindow(GetDisplay(),drawtree->ExpandlineH);
      xpos=x+13;
      direntry=drawtree->subtree;
      while(direntry!=NULL) {
        ypos=*maxy+3;
        ArrangeTreeRec(direntry,xpos,ypos,&mx,&my);
        XMoveResizeWindow(GetDisplay(),direntry->Connectline,
                          xpos,ypos,2,(height-15)/2+7);
        XMapRaised(GetDisplay(),direntry->Connectline);
        if (mx>*maxx)
          *maxx=mx;
        if (my>*maxy)
          *maxy=my;
        direntry=direntry->nextitem;	
      }
      XMoveResizeWindow(GetDisplay(),drawtree->ExpandlineV,
                    x+13,y+(height-15)/2+15,2,ypos-(y+(height-15)/2+15));
      XMapRaised(GetDisplay(),drawtree->ExpandlineV);
    }
    XMoveResizeWindow(GetDisplay(),drawtree->Switchbutton,
                  x+11,y+height,6,6);
    XMapRaised(GetDisplay(),drawtree->Switchbutton);
  } else {
    XUnmapWindow(GetDisplay(),drawtree->ExpandlineV);
    XUnmapWindow(GetDisplay(),drawtree->ExpandlineH);
    XUnmapWindow(GetDisplay(),drawtree->Connectline);
    XUnmapWindow(GetDisplay(),drawtree->Switchbutton);
  }
}

void ArrangeTree()
{
  int dummy1;
  int dummy2;
  FreezeWindow(); 
  ArrangeTreeRec(directory,0,22,&dummy1,&dummy2);
  UnfreezeWindow();
}

void UpdateTreeRec(struct item *old,struct item *new)
{
  struct item *olddirentry;
  struct item *newdirentry;
  new->horizontal=old->horizontal;
  if (old->subtree!=NULL) {
    PlusTree(new);
    olddirentry=old->subtree;
    newdirentry=new->subtree;
    while (olddirentry!=NULL && newdirentry!=NULL) {
      if        (strcmp(newdirentry->filename,olddirentry->filename)>0) {
         olddirentry=olddirentry->nextitem;
      } else if (strcmp(newdirentry->filename,olddirentry->filename)<0) {
         newdirentry=newdirentry->nextitem;      
      } else {
         UpdateTreeRec(olddirentry,newdirentry); 
         olddirentry=olddirentry->nextitem;
         newdirentry=newdirentry->nextitem;              
      }
    }
  }
}

void UpdateTree()
{
  struct item *newdir;
  
  newdir=malloc(sizeof(struct item));
  newdir->filename=malloc(1);
  newdir->filename[0]=0;
  newdir->nextitem=NULL;
  newdir->subtree=NULL;
  newdir->mark=False;
  newdir->type=1;
  CreateIconWithDirentry(newdir,True,False);
  MakeTreePixmaps(newdir);
  UpdateTreeRec(directory,newdir); 
  MinusTree(directory);
  XDestroyWindow(GetDisplay(),directory->Iconwindow);
  //XDestroyWindow(GetDisplay(),directory->Inputonly);
  XDestroyWindow(GetDisplay(),directory->Expandbutton);
  XDestroyWindow(GetDisplay(),directory->Connectline);
  XDestroyWindow(GetDisplay(),directory->ExpandlineV);
  XDestroyWindow(GetDisplay(),directory->ExpandlineH);
  XDestroyWindow(GetDisplay(),directory->Switchbutton);
  free(directory->filename);
  free(directory);
  directory=newdir;
  ArrangeTree();
  CalcMoveWindowSize();
}  

void TreeWindowPos(struct item* treeentry)
{
  struct item *direntry;
  struct item *subdirentry;
  int x,y,minx,maxx,miny,maxy,heix,heiy,newx,newy;
  unsigned int width,height;
  unsigned int border,depth;
  Window root;
  
  XGetGeometry(GetDisplay(),treeentry->Expandbutton,&root,&x,&y,
  		&width,&height,&border,&depth);
  minx=x; maxx=x+width; miny=y; maxy=y+height;
  direntry=treeentry->subtree;
  while (direntry!=NULL) {
    XGetGeometry(GetDisplay(),direntry->Iconwindow,&root,&x,&y,
  		 &width,&height,&border,&depth); 
    if (x+width>maxx)
        maxx=x+width;
    if (y+height>maxy)
        maxy=y+height;	
    subdirentry=direntry->subtree;
    while (subdirentry!=NULL) {
      XGetGeometry(GetDisplay(),subdirentry->Iconwindow,&root,&x,&y,
  		   &width,&height,&border,&depth); 
      if (x+width>maxx)
          maxx=x+width;
      if (y+height>maxy)
        maxy=y+height;	
      subdirentry=subdirentry->nextitem;    
    }
    direntry=direntry->nextitem;
  }  
  XGetGeometry(GetDisplay(),GetWindow(),&root,&x,&y,
		 &width,&height,&border,&depth);
  heix=(int)width;
  heiy=(int)height;
  XGetGeometry(GetDisplay(),GetMoveWindow(),&root,&x,&y,
	       &width,&height,&border,&depth);
  newx=x;
  if (maxx+SLIDER>-x+heix) {
      if (maxx-minx>heix)
	newx=-minx;
      else
	newx=-maxx+heix-SLIDER;	
  }
  newy=y;
  if (maxy+SLIDER>-y+heiy) {
      if (maxy-miny>heiy)
	newy=-miny;
      else
	newy=-maxy+heiy-SLIDER;	
  }
  XMoveResizeWindow(GetDisplay(),GetMoveWindow(),newx,newy,width,height);	
}

struct item *GetDirentryFromWindow(Window win)
{
  struct item *direntry;
  direntry=directory;
  while (direntry!=NULL && 
         direntry->Iconwindow!=win && 
	 direntry->Inputonly!=win)
    direntry=Getnextitem(direntry);
  return(direntry);
}

struct item *GetExpandEntryFromWindow(Window win)
{
  struct item *direntry;
  direntry=directory;
  while (direntry!=NULL && direntry->Expandbutton!=win)
    direntry=Getnextitem(direntry);
  return(direntry);
}

struct item *GetSwitchEntryFromWindow(Window win)
{
  struct item *direntry;
  direntry=directory;
  while (direntry!=NULL && direntry->Switchbutton!=win)
    direntry=Getnextitem(direntry);
  return(direntry);
}

  
void ExpandAllSubtree(struct item* tree)
{
  struct item *direntry;
  direntry=tree->subtree;
  while (direntry!=NULL) {
    PlusTree(direntry);
    direntry=direntry->nextitem;
  }
}

void UnsetMarks()
{
  struct item *direntry;
  direntry=directory;
  while (direntry!=NULL) {
    if (direntry->mark==True) {
      direntry->mark=False;
      CreateIconWithDirentry(direntry,False,False);
    }
    direntry=Getnextitem(direntry);
  }
}

void SetAllMarks()
{
  struct item *direntry;
  if (GetKindOfWindow()!=STRUCTURE) {
    direntry=directory;
    while (direntry!=NULL) {
      if (direntry->mark==False) {
	direntry->mark=True;
	CreateIconWithDirentry(direntry,False,False);
	keyentry=direntry;
      }
      direntry=direntry->nextitem;
    }
  }
}

void RubberBand(int x,int y)
{
  struct item *direntry;
  int iconx,icony;
  unsigned int width,height;
  int movewinposx,movewinposy;
  unsigned int border,depth;
  Window root;
  XEvent event;
  int sx=x,sy=y;
  int x1,y1,sx1,sy1;
  int buttonup=0;

  XGetGeometry(GetDisplay(),GetMoveWindow(),&root,
	       &movewinposx,&movewinposy,&width,&height,&border,&depth);
  XGetGeometry(GetDisplay(),GetWindow(),&root,
	       &iconx,&icony,&width,&height,&border,&depth);
  PlaceRubberband(x,y,1,1);
  ShowRubberband();
  do {
    if (x<sx) { x1=x; sx1=sx;} else { x1=sx; sx1=x;}
    if (y<sy) { y1=y; sy1=sy;} else { y1=sy; sy1=y;}
    PlaceRubberband(x1,y1,sx1-x1,sy1-y1);
    XPeekEvent(GetDisplay(),&event);
    if (0==XCheckTypedEvent(GetDisplay(),MotionNotify,&event))
      XNextEvent(GetDisplay(),&event);	  
    else
      while (0!=XCheckTypedEvent(GetDisplay(),MotionNotify,&event));
    switch (event.type) {
    case Expose:
      UpdateDetailView(event.xexpose.window);
      break;
    case MotionNotify:
      sx=event.xmotion.x;
      sy=event.xmotion.y;
      if (sx < -movewinposx) sx= -movewinposx;
      if (sy < -movewinposy) sy= -movewinposy;
      if (moveony==True) {
	if (sx > -movewinposx+width-SLIDER-1) 
	  sx= -movewinposx+width-SLIDER-1;
      } else {
	if (sx > -movewinposx+width-1) 
	  sx= -movewinposx+width-1;
      }
      if (moveonx==True) {
	if (sy > -movewinposy+height-SLIDER-1) 
	  sy= -movewinposy+height-SLIDER-1;
      } else {
	if (sy > -movewinposy+height-1) 
	  sy= -movewinposy+height-1;
      }
     break;
    case ButtonRelease:
      buttonup=1;
      break;
    }
  } while (buttonup==0);
  HideRubberband();
  keyentry=NULL;
  if (sx<x){
    border=x;
    x=sx;
    sx=border;
  }
  if (sy<y){
    border=y;
    y=sy;
    sy=border;
  }
  if (GetKindOfWindow()!=STRUCTURE) {
    direntry=directory;
    while (direntry!=NULL) {
      XGetGeometry(GetDisplay(),direntry->Iconwindow,&root,
		   &iconx,&icony,&width,&height,&border,&depth);
      if ((int)(sx-iconx)>=0 &&
	  (int)(iconx+width-x)>=0 && 
	  (int)(sy-icony)>=0 && 
	  (int)(icony+height-y)>=0 ) {
	direntry->mark=True;
	keyentry=direntry;
	CreateIconWithDirentry(direntry,False,False);
      }
      direntry=direntry->nextitem;
    }
  }
}

int GetMarkedNumber()
{
  struct item *direntry;
  int number=0;
  direntry=directory;
  while (direntry!=NULL) {
    if (direntry->mark==True) {
      number++;
    }
    direntry=Getnextitem(direntry);
  }
  return number;
}

void GetMarkedNames(char** files)
{
  struct item *direntry;
  char *text;
  char *text2;
  char *text3;
  direntry=directory;
  *files=malloc(1);
  (*files)[0]=0;
  while (direntry!=NULL) {
    if (direntry->mark==True) {
      text2=malloc(strlen(direntry->filename)+strlen(GetPath())+1);
      strcpy(text2,GetPath());
      strcat(text2,direntry->filename);
      text3=GenerateBackslashName(text2);
      text=malloc(strlen(*files)+strlen(text3)+2);
      strcpy(text,*files);
      strcat(text," ");
      strcat(text,text3);
      free(text3);
      free(text2);
      free(*files);
      *files=text;
    }
    direntry=Getnextitem(direntry);
  }
}

void IconMotion(struct item *direntry,int x,int y,int rootx,int rooty)
{
  struct item *direntry2;
  char *newpos;
  char *pos;
  char *icon;
  char *start;
  char *text;
  char *files;
  Window NeuesIcon;
  Window other;
  XEvent event;
  int ondesk;
  int xw,yw;
  int xr,yr;
  int buttonup=0;
  unsigned int keys;
  XWindowAttributes attr;

  NeuesIcon=direntry->Iconwindow;
  direntry->mark=False;
  if (GetMarkedNumber()>0)
    CreateIconWithDirentry(direntry,True,True);
  else
    CreateIconWithDirentry(direntry,True,False);
  direntry->mark=True;
  other=direntry->Iconwindow;
  direntry->Iconwindow=NeuesIcon;
  NeuesIcon=other;
  XReparentWindow(GetDisplay(),NeuesIcon,XDefaultRootWindow(GetDisplay()),
		  rootx-x,rooty-y);
  do {
    XPeekEvent(GetDisplay(),&event);
    if (0==XCheckTypedEvent(GetDisplay(),MotionNotify,&event))
      XNextEvent(GetDisplay(),&event);	  
    else
      while (0!=XCheckTypedEvent(GetDisplay(),MotionNotify,&event));
    switch (event.type) {
    case Expose:
      if (UpdateDetailView(event.xexpose.window)==False) {
	other=direntry->Iconwindow;
	direntry->Iconwindow=NeuesIcon;
	NeuesIcon=other;
	
	WriteDetailIcon(direntry);
	
	other=direntry->Iconwindow;
	direntry->Iconwindow=NeuesIcon;
	NeuesIcon=other;
      }
      break;
    case MotionNotify:
      XMoveWindow(GetDisplay(),NeuesIcon,
		  event.xmotion.x_root-x,event.xmotion.y_root-y);
      break;
    case ButtonRelease:
      buttonup=1;
      break;
    }
  } while (buttonup==0);
  XDestroyWindow(GetDisplay(),NeuesIcon);
  XFlush(GetDisplay());
  XQueryPointer(GetDisplay(),XDefaultRootWindow(GetDisplay()),&other,
		&NeuesIcon,&xr,&yr,&xw,&yw,&keys);
  ondesk=False;
  if (GetIsDesktop()==True) {
    direntry2=directory;
    while (direntry2!=NULL) {
      if (direntry2->Iconwindow==NeuesIcon)
	ondesk=True;
      direntry2=direntry2->nextitem;
    }
  }
  if (NeuesIcon==GetGreatestParent(GetWindow()) || 
      ondesk==True || 
      (GetIsDesktop()==True &&
       NeuesIcon==None)) {
    if (GetIsDesktop()==False || (ondesk==False && (GetIsDesktop()==False || NeuesIcon!=None)))
      XQueryPointer(GetDisplay(),GetMoveWindow(),&other,&NeuesIcon,
		    &xr,&yr,&xw,&yw,&keys);
    if (NeuesIcon==None) {
      if (GetKindOfWindow()==NORMAL) {
	text=malloc(strlen(direntry->filename)+strlen(GetPath())+1);
	strcpy(text,GetPath());
	strcat(text,direntry->filename);
	GetFileInfoFromDesktop(text,&pos,&icon,&start);
	if (pos==NULL || pos[0]!='a') {
	  if (GetIsDesktop()==True && grid>0) {
	    XGetWindowAttributes(GetDisplay(),direntry->Iconwindow,&attr);
	    xr=(int)(0.5+(double)(xw-x+attr.width/2)/(double)grid)*grid;
	    yr=(int)(0.5+(double)(yw-y+attr.height/2)/(double)grid)*grid;
	    SetPositionToText(&newpos,xr-attr.width/2,yr-attr.height/2,' ');
	    SendFileInfoToDesktop(text,newpos,NULL,NULL);
	    free(newpos);
	    XMoveWindow(GetDisplay(),direntry->Iconwindow,
			xr-attr.width/2,yr-attr.height/2);	    
	  } else {
	    SetPositionToText(&newpos,xw-x,yw-y,' ');
	    SendFileInfoToDesktop(text,newpos,NULL,NULL);
	    free(newpos);
	    XMoveWindow(GetDisplay(),direntry->Iconwindow,
			xw-x,yw-y);
	  }
	}
	free(pos);
	free(icon);
	free(start);
	free(text);
      }
    } else 
      if (NeuesIcon!=direntry->Iconwindow) {
	direntry2=GetDirentryFromWindow(NeuesIcon);
	if (direntry2!=NULL) {
	  if (direntry2->filename[strlen(direntry2->filename)-1]!='/') {
	    text=malloc(strlen(direntry2->filename)+strlen(GetPath())+1);
	    strcpy(text,GetPath());
	    strcat(text,direntry2->filename);
	    GetFileInfoFromDesktop(text,&pos,&icon,&start);
	    GetMarkedNames(&files);
	    ExecuteShellWithFollowLink(text,start,files,0);
	    free(files);
	    free(text);
	    free(pos);
	    free(icon);
	    free(start);
	  } else {
	    GetMarkedNames(&files);
	    text=strdup(direntry2->filename);
	    GoalWasFolder(GetMoveWindow(),text,files,keys);
	    free(text);
	    free(files);
	  }
	}
      }
  } else {
    GetMarkedNames(&files);
    if (GetKindOfWindow()==NORMAL)
      SendFiles(event,x,y,files);
    else
      SendFiles(event,0,0,files);      
    free(files);
  }
  CalcMoveWindowSize();
}

int UpdateDetailView(Window win)
{
  struct item *direntry;
  if (GetKindOfWindow()==DETAIL) {
    direntry=GetDirentryFromWindow(win);
    if (direntry!=NULL)
      WriteDetailIcon(direntry);
    else
      return False;
  }
  return True;
}

void PlaceIcons()
{
  int x,y;
  unsigned int width,height;
  unsigned int border,depth;
  Window root;
  struct item *direntry;
  if (GetKindOfWindow()==NORMAL) {
    XGetGeometry(GetDisplay(),GetWindow(),&root,&x,&y,
	         &width,&height,&border,&depth);
    XMoveResizeWindow(GetDisplay(),GetMoveWindow(),0,0,width,height);
    ResetPosition();
    direntry=directory;
    while (direntry!=NULL) {
      XGetGeometry(GetDisplay(),direntry->Iconwindow,&root,&x,&y,
  		   &width,&height,&border,&depth);
      PositionArrange(direntry,width,height);
      direntry=direntry->nextitem;
    }
  } else if (GetKindOfWindow()==DETAIL) {
    if (directory!=NULL)
      XGetGeometry(GetDisplay(),directory->Iconwindow,&root,&x,&y,
  		   &width,&height,&border,&depth);
    direntry=directory;
    y=20;
    while (direntry!=NULL) {
      XMoveWindow(GetDisplay(),direntry->Iconwindow,20,y);
      y=y+height;
      direntry=direntry->nextitem;
    }
  } else if (GetKindOfWindow()==STRUCTURE) {
    fprintf(stderr,"hallo fehler Placeicons in Structure view aufgerufen\n");
  }
  CalcMoveWindowSize();
}

void MoveTheMoveWindow(XEvent evnt)
{
  int z;
  int goalx,goaly;
  int xr,yr;
  int buttonup=0;
  int x,y,add,addp;
  unsigned int width,height;
  int ax,ay;
  unsigned int nwidth,nheight;
  unsigned int minx,miny;
  unsigned int border,depth;
  Window root;
  Pixmap pixelmap;
  XEvent evnt2;
  
  XGetGeometry(GetDisplay(),GetWindow(),&root,&x,&y,
	       &width,&height,&border,&depth);
  if (moveony==True) width=width-SLIDER;
  if (moveonx==True) height=height-SLIDER;
  XGetGeometry(GetDisplay(),GetMoveWindow(),&root,&ax,&ay,
	       &minx,&miny,&border,&depth);
  xr=evnt.xbutton.x_root;
  yr=evnt.xbutton.y_root;
  if (evnt.xbutton.button==2) {
    do {
      XPeekEvent(GetDisplay(),&evnt);
      if (evnt.type==MotionNotify) {
        if (0==XCheckTypedEvent(GetDisplay(),ButtonRelease,&evnt))
          while (0!=XCheckTypedEvent(GetDisplay(),MotionNotify,&evnt));
      } else
        XNextEvent(GetDisplay(),&evnt);
      switch (evnt.type) {
      case Expose:
	UpdateDetailView(evnt.xexpose.window);
	while (0!=XCheckTypedEvent(GetDisplay(),Expose,&evnt))
  	  UpdateDetailView(evnt.xexpose.window);
  	XSync(GetDisplay(),0);
	break;
      case MotionNotify:
	goalx=evnt.xmotion.x_root-xr+ax;
	goaly=evnt.xmotion.y_root-yr+ay;
	if (goalx>0) goalx=0;
	if (goaly>0) goaly=0;
	if (goalx<(int)width-(int)minx) goalx=(int)width-(int)minx;
	if (goaly<(int)height-(int)miny) goaly=(int)height-(int)miny;
	XMoveWindow(GetDisplay(),GetMoveWindow(),goalx,goaly);
	if (GetKindOfWindow()==DETAIL)
	  XMoveWindow(GetDisplay(),GetDetailWindow(),20+goalx,0);
	if (moveony==True) {
	  XMoveResizeWindow(GetDisplay(),movey,
	      0,
	      SLIDERBUTTON+(int)((double)(height-SLIDERBUTTON*2)*(double)(-goaly)/(double)miny),
	      SLIDER,
	      1+(int)((double)(height-SLIDERBUTTON*2)*(double)height/(double)miny)
			    );
	}
	if (moveonx==True) {
	  XMoveResizeWindow(GetDisplay(),movex,
	      SLIDERBUTTON+(int)((double)(width-SLIDERBUTTON*2)*(double)(-goalx)/(double)minx),
	      0,
	      1+(int)((double)(width-SLIDERBUTTON*2)*(double)width/(double)minx),
	      SLIDER
			    );
	}
	break;
      case ButtonRelease:
	buttonup=1;
	break;
      }
    } while (buttonup==0);
  } else if (evnt.xbutton.window==movex || evnt.xbutton.window==movexmain) {
    XGetGeometry(GetDisplay(),movex,&root,&x,&y,
		 &nwidth,&nheight,&border,&depth);
    if (evnt.xbutton.window==movex) {
      do {
	XNextEvent(GetDisplay(),&evnt);
	switch (evnt.type) {
	case Expose:
	  UpdateDetailView(evnt.xexpose.window);
          z=0;
	  while (0!=XCheckTypedEvent(GetDisplay(),Expose,&evnt)) {
  	    UpdateDetailView(evnt.xexpose.window);
            XSync(GetDisplay(),0);
  	    if (z==0 && 0!=XCheckTypedEvent(GetDisplay(),MotionNotify,&evnt)) {
  	      while (0!=XCheckTypedEvent(GetDisplay(),MotionNotify,&evnt));
	      goalx=evnt.xmotion.x_root-xr+x;
	      if (goalx<SLIDERBUTTON) goalx=SLIDERBUTTON;
	      if (goalx>width-nwidth-SLIDERBUTTON)
	      goalx=width-nwidth-SLIDERBUTTON;
	      XMoveWindow(GetDisplay(),movex,goalx,0);
	      if (0!=XCheckTypedEvent(GetDisplay(),ButtonRelease,&evnt2)) {
	        XPutBackEvent(GetDisplay(),&evnt2);
	        z=1;
	      }
	      XPutBackEvent(GetDisplay(),&evnt);
	    }
  	  }
	  break;
	case MotionNotify:
	  goalx=evnt.xmotion.x_root-xr+x;
	  if (goalx<SLIDERBUTTON) goalx=SLIDERBUTTON;
	  z=(int)(-0.5-(double)(goalx-SLIDERBUTTON)*(double)minx/(double)(width-SLIDERBUTTON*2));
	  if (goalx>width-nwidth-SLIDERBUTTON) {
	    goalx=width-nwidth-SLIDERBUTTON;
	    z=width-minx;
	  }
	  XMoveWindow(GetDisplay(),movex,goalx,0);
	  XMoveWindow(GetDisplay(),GetMoveWindow(),z,ay);
	  if (GetKindOfWindow()==DETAIL)
	    XMoveWindow(GetDisplay(),GetDetailWindow(),20+z,0);
	  break;
	case ButtonRelease:
	  buttonup=1;
	  break;
	}
      } while (buttonup==0);
    } else {
      if (evnt.xbutton.x<SLIDERBUTTON) {
	DataPixmap(movexmainleft_p_xpm,&pixelmap,NULL);
        XCopyArea(GetDisplay(),pixelmap,movexmain,GetGC(),0,0,SLIDERBUTTON,SLIDER,0,0);
	XFreePixmap(GetDisplay(),pixelmap);
	addp=1;
      } else if (evnt.xbutton.x<x) {
	addp=width;
      } else if (evnt.xbutton.x>width-SLIDERBUTTON) {
	DataPixmap(movexmainright_p_xpm,&pixelmap,NULL);
	XCopyArea(GetDisplay(),pixelmap,movexmain,GetGC(),0,0,SLIDERBUTTON,SLIDER,width-SLIDERBUTTON,0);
	XFreePixmap(GetDisplay(),pixelmap);
	addp=-1;
      } else if (evnt.xbutton.x>x+nwidth) {
	addp=-width;
      } else 
	addp=0;
      do {
	add=addp;
	if (ax+add>0)
	  add=-ax;
	else if (ax+add<(int)width-(int)minx)
	  add=-ax+(int)width-(int)minx;
	XMoveWindow(GetDisplay(),movex,
		    SLIDERBUTTON+(int)((double)(width-SLIDERBUTTON*2)*(double)(-(ax+add))/(double)minx),0);
	XMoveWindow(GetDisplay(),GetMoveWindow(),ax+add,ay);
	if (GetKindOfWindow()==DETAIL)
	  XMoveWindow(GetDisplay(),GetDetailWindow(),20+ax+add,0);
	XFlush(GetDisplay());
	XSync(GetDisplay(),0);
	XGetGeometry(GetDisplay(),GetMoveWindow(),&root,&ax,&ay,
		     &minx,&miny,&border,&depth);
	while (XEventsQueued(GetDisplay(),QueuedAfterReading)!=0 && evnt.type!=ButtonRelease) {
	  XNextEvent(GetDisplay(),&evnt);
	  if (evnt.type==Expose)
	    UpdateDetailView(evnt.xexpose.window);
	}
      } while(evnt.type!=ButtonRelease && (addp==1 || addp==-1));
      XClearWindow(GetDisplay(),movexmain);
    } 
  } else if (evnt.xbutton.window==movey || evnt.xbutton.window==moveymain) {
    XGetGeometry(GetDisplay(),movey,&root,&x,&y,
		 &nwidth,&nheight,&border,&depth);
    if (evnt.xbutton.window==movey) {
      do {
	XNextEvent(GetDisplay(),&evnt);
	switch (evnt.type) {
	case Expose:
	  UpdateDetailView(evnt.xexpose.window);
          z=0;
	  while (0!=XCheckTypedEvent(GetDisplay(),Expose,&evnt)) {
  	    UpdateDetailView(evnt.xexpose.window);
            XSync(GetDisplay(),0);
  	    if (z==0 && 0!=XCheckTypedEvent(GetDisplay(),MotionNotify,&evnt)) {
  	      while (0!=XCheckTypedEvent(GetDisplay(),MotionNotify,&evnt));
	      goaly=evnt.xmotion.y_root-yr+y;
	      if (goaly<SLIDERBUTTON) goaly=SLIDERBUTTON;
	      if (goaly>height-nheight-SLIDERBUTTON) 
	        goaly=height-nheight-SLIDERBUTTON;
	      XMoveWindow(GetDisplay(),movey,0,goaly);
	      if (0!=XCheckTypedEvent(GetDisplay(),ButtonRelease,&evnt2)) {
	        XPutBackEvent(GetDisplay(),&evnt2);
	        z=1;
	      }
	      XPutBackEvent(GetDisplay(),&evnt);
	    }
	  }
	  break;
	case MotionNotify:
	  goaly=evnt.xmotion.y_root-yr+y;
	  if (goaly<SLIDERBUTTON) goaly=SLIDERBUTTON;
	  z=(int)(-0.5-(double)(goaly-SLIDERBUTTON)*(double)miny/(double)(height-SLIDERBUTTON*2));
	  if (goaly>height-nheight-SLIDERBUTTON) { 
	    goaly=height-nheight-SLIDERBUTTON;
	    z=height-miny;
	  }
	  XMoveWindow(GetDisplay(),movey,0,goaly);
	  XMoveWindow(GetDisplay(),GetMoveWindow(),ax,z);
	  break;
	case ButtonRelease:
	  buttonup=1;
	  break;
	}
      } while (buttonup==0);
    } else {
      if (evnt.xbutton.y<SLIDERBUTTON) {
	DataPixmap(moveymaintop_p_xpm,&pixelmap,NULL);
	XCopyArea(GetDisplay(),pixelmap,moveymain,GetGC(),0,0,SLIDER,SLIDERBUTTON,0,0);
	XFreePixmap(GetDisplay(),pixelmap);
	addp=1;
      } else if (evnt.xbutton.y<y) {
	addp=height;
      }else if (evnt.xbutton.y>height-14) {
	DataPixmap(moveymainbottom_p_xpm,&pixelmap,NULL);
	XCopyArea(GetDisplay(),pixelmap,moveymain,GetGC(),0,0,SLIDER,SLIDERBUTTON,0,height-SLIDERBUTTON);
	XFreePixmap(GetDisplay(),pixelmap);
	addp=-1;
      } else if (evnt.xbutton.y>y+nheight) {
	addp=-height;
      } else 
	addp=0;
      do {
	add=addp;
	if (ay+add>0)
	  add=-ay;
	else if (ay+add<(int)height-(int)miny)
	  add=-ay+(int)height-(int)miny;
	XMoveWindow(GetDisplay(),movey,0,
		    SLIDERBUTTON+(int)((double)(height-SLIDERBUTTON*2)*(double)(-(ay+add))/(double)miny));
	XMoveWindow(GetDisplay(),GetMoveWindow(),ax,ay+add);
	XFlush(GetDisplay());
	XSync(GetDisplay(),0);
	XGetGeometry(GetDisplay(),GetMoveWindow(),&root,&ax,&ay,
		     &minx,&miny,&border,&depth);
	while (XEventsQueued(GetDisplay(),QueuedAfterReading)!=0 && evnt.type!=ButtonRelease) {
	  XNextEvent(GetDisplay(),&evnt);
	  if (evnt.type==Expose)
	    UpdateDetailView(evnt.xexpose.window);
	}
      } while(evnt.type!=ButtonRelease && (addp==1 || addp==-1));
/*      } while(evnt.type!=ButtonRelease && (addp==10 || addp==-10));*/
      XClearWindow(GetDisplay(),moveymain);
    } 
  }
  XSync(GetDisplay(),0);
  while (0!=XCheckTypedEvent(GetDisplay(),Expose,&evnt))
    UpdateDetailView(evnt.xexpose.window);
  CalcMoveWindowSize();
}

int SortHelp(const void *a,const void *b)
{
  int adot,bdot,i;
  Window root;
  int ax,bx,topa,bottoma,topb,bottomb;
  unsigned int width,height,border,depth;
  int x,y;
  if (sorttype==ARRANGE) {
    XGetGeometry(GetDisplay(),(*((struct item**)a))->Iconwindow,&root,&x,&y,&width,&height,&border,&depth);
    ax=x;
    topa=y;
    bottoma=y+height;
    XGetGeometry(GetDisplay(),(*((struct item**)b))->Iconwindow,&root,&x,&y,&width,&height,&border,&depth);
    bx=x;
    topb=y;
    bottomb=y+height;
    if (topa>bottomb)
      return(1);
    else if (topb>bottoma)
      return(-1);
    else
      return(ax-bx);
  } else if (sorttype==NAME) {
    if ((i=strcasecmp((*((struct item**)a))->filename,
                     (*((struct item**)b))->filename))!=0)
      return(i);
    else
      return(strcmp((*((struct item**)a))->filename,
                    (*((struct item**)b))->filename));
  } else if (((*((struct item**)a))->type==0 || (*((struct item**)a))->type==2) &&
      ((*((struct item**)b))->type==1 || (*((struct item**)b))->type==3))
    return(1);
  else if (((*((struct item**)a))->type==1 || (*((struct item**)a))->type==3) &&
	   ((*((struct item**)b))->type==0 || (*((struct item**)b))->type==2))
    return(-1);
  else {     
    adot=strlen((*((struct item**)a))->filename)-1;i=0;
    while ((*((struct item**)a))->filename[i]!=0) {
      if ((*((struct item**)a))->filename[i]=='.' && i!=0)
	adot=i;
      i++;
    }
    bdot=strlen((*((struct item**)b))->filename)-1;i=0;
    while ((*((struct item**)b))->filename[i]!=0) {
      if ((*((struct item**)b))->filename[i]=='.' && i!=0)
	bdot=i;
      i++;
    }
    if (sorttype==EXTENSION && 
	(strcasecmp(((*((struct item**)a))->filename)+adot+1,
		((*((struct item**)b))->filename)+bdot+1)<0))
      return(-1);
    else if (sorttype==EXTENSION && 	     
	     (strcasecmp(((*((struct item**)a))->filename)+adot+1,
		     ((*((struct item**)b))->filename)+bdot+1)>0))
      return(1);
    else if (sorttype==DATEASC && (*((struct item**)a))->info.st_mtime <
	     (*((struct item**)b))->info.st_mtime)
      return(-1);
    else if (sorttype==DATEASC && (*((struct item**)a))->info.st_mtime >
	     (*((struct item**)b))->info.st_mtime)
      return(1);
    else if (sorttype==DATEDESC && (*((struct item**)a))->info.st_mtime <
	     (*((struct item**)b))->info.st_mtime)
      return(1);
    else if (sorttype==DATEDESC && (*((struct item**)a))->info.st_mtime >
	     (*((struct item**)b))->info.st_mtime)
      return(-1);
    else if (sorttype==SIZEASC && (*((struct item**)a))->info.st_size <
	     (*((struct item**)b))->info.st_size)
      return(-1);
    else if (sorttype==SIZEASC && (*((struct item**)a))->info.st_size >
	     (*((struct item**)b))->info.st_size)
      return(1);
    else if (sorttype==SIZEDESC && (*((struct item**)a))->info.st_size <
	     (*((struct item**)b))->info.st_size)
      return(1);
    else if (sorttype==SIZEDESC && (*((struct item**)a))->info.st_size >
	     (*((struct item**)b))->info.st_size)
      return(-1);
    else {
      if ((i=strcasecmp((*((struct item**)a))->filename,
                        (*((struct item**)b))->filename))!=0)
        return(i);
      else
        return(strcmp((*((struct item**)a))->filename,
                      (*((struct item**)b))->filename));
    }
  }
}

struct item *SortIcons(int type,struct item *top)
{
  int i,j;
  struct item *ret;
  struct item *direntry;
  struct item **newdir;

  ResetPositionHistory();
  sorttype=type;
  i=0;
  direntry=top;
  ret=top;
  while (direntry!=NULL) {
    i++;
    direntry=direntry->nextitem;
  }
  if (i>0) {
    newdir=malloc(i*sizeof(struct item*));
    i=0;
    direntry=top;
    while (direntry!=NULL) {
      newdir[i]=direntry;
      i++;
      direntry=direntry->nextitem;
    }
    qsort(newdir,i,sizeof(struct item*),SortHelp);
    for (j=0;j<i-1;j++) 
      newdir[j]->nextitem=newdir[j+1];
    newdir[i-1]->nextitem=NULL;
    ret=newdir[0];
    free(newdir);
  }
  return ret;
}

void SortIconsTop(int type)
{
  directory=SortIcons(type,directory);
}

void UpdateWindow()
{
  static char *backgroundnameold=NULL;
  char *backgroundname=NULL;
  char *positiona=NULL;
  char *positions=NULL;
  char *text;
  int r,g,b;
  int sx,sy;
  unsigned long bg;
  Pixmap backgroundpixmap;
  XWindowAttributes rootatr;

  text=GenerateWindowName(GetPath(),NORMAL);
  GetFileInfoFromDesktop(text,&positiona,&backgroundname,&positions);
  if (backgroundname==NULL && GetIsDesktop()==False) {
    backgroundname=GetDefaultBackground();
  }
  free(text);
  if (backgroundname!=NULL && (backgroundnameold==NULL || 
			       GetIsDesktop()==True ||
			       strcmp(backgroundnameold,backgroundname)!=0)){
    if (LoadPixmap(backgroundname,0,&backgroundpixmap,NULL)==0) {
      if (GetIsDesktop()==True) 
	XSetWindowBackgroundPixmap(GetDisplay(),XDefaultRootWindow(GetDisplay()),backgroundpixmap);
      else
	XSetWindowBackgroundPixmap(GetDisplay(),GetMoveWindow(),backgroundpixmap);
      XFreePixmap(GetDisplay(),backgroundpixmap);
    } else {
      bg=GetBestColor(65535,65535,65535);
      if (backgroundname[0]=='#') {
	sscanf(backgroundname+2,"%u %u %u",&r,&g,&b);
	bg=GetBestColor(257*r,257*g,257*b);
      } 
      if (GetIsDesktop()==True) 
	XSetWindowBackground(GetDisplay(),XDefaultRootWindow(GetDisplay()),bg);	  
      else
	XSetWindowBackground(GetDisplay(),GetMoveWindow(),bg);
    }
    free(backgroundnameold);
    backgroundnameold=malloc(strlen(backgroundname)+1);
    strcpy(backgroundnameold,backgroundname);
    
  }  
  if (GetIsDesktop()==True) {
    GetPositionFromText(positiona,&sx,&sy,&grid);
    XGetWindowAttributes(GetDisplay(),XDefaultRootWindow(GetDisplay()),&rootatr);
    sx=rootatr.width;
    sy=rootatr.height;
    if (positions[0]=='c'){
      sx--;
      sy--;
    } else if (positions[0]=='a')
      sx--;
    else if (positions[0]!='b')
      sy--;
    XResizeWindow(GetDisplay(),GetWindow(),sx,sy);
    XResizeWindow(GetDisplay(),GetMoveWindow(),sx,sy);
    XClearWindow(GetDisplay(),XDefaultRootWindow(GetDisplay()));
  } else 
    XClearWindow(GetDisplay(),GetMoveWindow());
  if (positiona!=NULL && positiona[0]=='a')
    SetShowHidden(False);
  else
    SetShowHidden(True);
  free(positiona);
  free(backgroundname);
  free(positions);
  if (GetIsDesktop()==False)
    SetWMIcon();
  else {
    if (GetMainBackground()==True)
      XMapWindow(GetDisplay(),GetWindow());
    else
      XUnmapWindow(GetDisplay(),GetWindow());
  }
}

void UpdateIcons(int fast)
{
  struct item *savedir;
  struct item *oldkeyentry;
  struct item *olddirentry;
  struct item *newdirentry;
  struct item *eraseentry;
  int resorttype;
  int changes;
  static int p=False;
/*  static time_t lastupdatetime=0;
  static time_t lastmodificationtime=0;
  char *pathsaved;
  struct stat info2;
  time_t currenttime;*/

  StopAlarm();
  UpdateTimer();
  oldkeyentry=keyentry;
  HideRubberband();
  if (fast==False) {
    EraseIconPixmaps();
    UpdateWindow();
    UpdateFontName();
    UpdateColors();
    if (GetIsDesktop()==True)
      ResetPosition();
  }
  if (GetKindOfWindow()!=STRUCTURE) {
    /*pathsaved=strdup(GetPath());
    if (pathsaved[0]=='~' && pathsaved[1]=='/')
      pathsaved[0]='.';
    currenttime=time(NULL);
    stat(pathsaved,&info2);
    free(pathsaved);
    if (lastmodificationtime>=lastupdatetime || 
        lastmodificationtime<info2.st_mtime ||
	fast==False) {
      lastmodificationtime=info2.st_mtime;
      lastupdatetime=currenttime;*/
      keyentry=NULL;
      if (GetTimer()>10 && fast==True)
        XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());
      ResetPositionHistory();
      resorttype=sorttype;
      savedir=SortIcons(NAME,directory);
      directory=GetDirectory(GetPath());
      directory=SortIcons(NAME,directory);
      olddirentry=savedir;
      newdirentry=directory;
      changes=False;
      while (newdirentry!=NULL || olddirentry!=NULL) {
        if (newdirentry!=NULL && 
	    olddirentry!=NULL &&
	    strcmp(newdirentry->filename,olddirentry->filename)==0) {
	  newdirentry->Iconwindow=olddirentry->Iconwindow;
	  if (fast==False)
	    CreateIconWithDirentry(newdirentry,False,False);
	  else {
	    newdirentry->mark=olddirentry->mark;
	    newdirentry->mini=olddirentry->mini;
	    newdirentry->minis=olddirentry->minis;
	    if (olddirentry==oldkeyentry)
	      keyentry=newdirentry;
	  }
	  olddirentry=olddirentry->nextitem;
	  newdirentry=newdirentry->nextitem;
        }
        if (newdirentry!=NULL && 
	    olddirentry!=NULL &&
	    strcmp(newdirentry->filename,olddirentry->filename)>0) {
	  XDestroyWindow(GetDisplay(),olddirentry->Iconwindow);      
	  if (olddirentry==keyentry)
	    keyentry=NULL;	    
	  olddirentry=olddirentry->nextitem;
	  changes=True;
        }
        if (newdirentry!=NULL &&
	    olddirentry!=NULL &&
	    strcmp(newdirentry->filename,olddirentry->filename)<0) {
	  CreateIconWithDirentry(newdirentry,True,False);
	  newdirentry=newdirentry->nextitem;
	  changes=True;
        }
        if (newdirentry==NULL && olddirentry!=NULL) {
	  XDestroyWindow(GetDisplay(),olddirentry->Iconwindow);  
	  if (olddirentry==keyentry) 
	    keyentry=NULL;	    
	  olddirentry=olddirentry->nextitem;
	  changes=True;
        }      
        if (newdirentry!=NULL && olddirentry==NULL) {
	  CreateIconWithDirentry(newdirentry,True,False);
	  newdirentry=newdirentry->nextitem;
	  changes=True;
        }
      }
      while(savedir!=NULL) {
        eraseentry=savedir->nextitem;
        free(savedir->filename);
        free(savedir);
        savedir=eraseentry;
      }
      sorttype=resorttype;
      directory=SortIcons(sorttype,directory);
      if (GetKindOfWindow()==DETAIL) {
        if (changes==True) {
          PlaceIcons();
        }
      }     
      if (GetTimer()>10 && fast==True)
        XUndefineCursor(GetDisplay(),GetWindow());
    /*}*/
  } else {
    XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());
    keyentry=NULL;
    UpdateTree();

    XUndefineCursor(GetDisplay(),GetWindow());
  }
  if (keyentry!=NULL && keyentry->mark==False)
    SelectDirentry(keyentry);
  CalcMoveWindowSize();
  if (GetIsDesktop()==True) {
    if (GetAutoSave()==True) {
      p=True;
      ExecuteShellcommand("dfm","!0! -save",NULL,0);
    } else {
      if (p==True) {
        p=False;
        ExecuteShellcommand("dfm","!0! -save",NULL,0);
      }
    }
  }
  ReactivateAlarm();
}

void RunAndWaitAtPosition(char *text,int kind)
{
  char *windowname;
  char *positions;
  char *positiona;
  char *background;
  XEvent event;

  if (kind==DETAIL)
    windowname=GenerateWindowName(text,DETAIL);
  else
    windowname=GenerateWindowName(text,NORMAL);
  GetFileInfoFromDesktop(windowname,&positiona,&background,
			 &positions);
  if (positiona!=NULL && positiona[0]=='a') { /* the hidden info must not be changed */
    free(positions);
    free(positiona);
    free(background);
    GetFileInfoFromDesktop(GetWindowName(),&positiona,&background,
			   &positions);
    positiona[0]='a';
    SendFileInfoToDesktop(windowname,positiona,NULL,
			   positions);
  } else {
    free(positions);
    free(positiona);
    free(background);
    GetFileInfoFromDesktop(GetWindowName(),&positiona,&background,
			   &positions);
    positiona[0]=' ';
    SendFileInfoToDesktop(windowname,positiona,NULL,
			   positions);
  }
  if (kind==DETAIL)
    ExecuteShellWithFollowLink(text,"dfm !0! -detail",NULL,0);
  else
    ExecuteShellWithFollowLink(text,"dfm !0!",NULL,0);
  SetDestroy(5);
  do {
    XNextEvent(GetDisplay(),&event);
  } while (event.type!=VisibilityNotify);
  StopDestroy();
  free(windowname);
  free(positions);
  free(positiona);
  free(background);
}

void HandleKeyPress(XEvent evnt)
{
  char keys[10];  
  static char search[100]="";  
  KeySym mykey;
  int size;
  int i,j;
  char *text;
  char *text2;
  struct item* direntry;
  struct item* newentry;
  struct item* treeentry;
  char *pos;
  char *icon;
  char *start;
  int iconx,icony;
  unsigned int iconwidth,iconheight;
  unsigned int border,depth;
  Window root;

  size=XLookupString((XKeyPressedEvent*)(&evnt),keys,10,&mykey,0);
  if (size==1) {
    if (mykey==XK_Escape) {
      XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());
      UpdateIcons(False);
      XUndefineCursor(GetDisplay(),GetWindow());
    } else if (mykey==XK_Delete && keyentry!=NULL) {
      XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());
      if (keyentry->mark==True)
	GetMarkedNames(&text2);
      else {
	text=malloc(strlen(GetPath())+strlen(keyentry->filename)+1);
	strcpy(text,GetPath());
	strcat(text,keyentry->filename); 
	text2=GenerateBackslashName(text);
	free(text);
      }
      if (text2[0]==' ') {
	EraseCall(text2,True,False);
      } else {
	text=malloc(strlen(text2)+2);
	strcpy(text," ");
	strcat(text,text2);
	EraseCall(text,True,False);
	free(text);
      }
      UpdateIcons(True);
      free(text2); 
      XUndefineCursor(GetDisplay(),GetWindow());
    } else if (mykey==XK_space) {
      if (GetKindOfWindow()==STRUCTURE) {
        UnsetMarks();
        treeentry=keyentry;
	if (treeentry!=NULL) {
            HideRubberband();
            XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());	    
	    if (treeentry->subtree==NULL)
	      PlusTree(treeentry);
	    else
	      MinusTree(treeentry);
	    XUndefineCursor(GetDisplay(),GetWindow());
            ArrangeTree();
            CalcMoveWindowSize();
	    TreeWindowPos(treeentry);
            SelectDirentry(keyentry);
	}
      } else {
        if (keyentry==NULL)
          keyentry=directory;
        if (keyentry!=NULL) {
          if (keyentry->mark==True)
            keyentry->mark=False;
          else
            keyentry->mark=True;
	  CreateIconWithDirentry(keyentry,False,False);
    	  if (keyentry->nextitem!=NULL) {
	    keyentry=keyentry->nextitem;
            SelectDirentry(keyentry);
	  }
        }
      }
    } else if (mykey==XK_BackSpace) {
      if (strcmp("~/",GetPath())!=0) {
	text=strdup(GetPath());
	j=0;
	for (i=0;i<(strlen(text)-1);i++)
	  if (text[i]=='/') 
	    j=i;
	text[j+1]=0;
	if (IsSubDesktop()==True) {
	  ExecuteShellcommand(text,"dfm !0!",NULL,0);
	} else if (GetKindOfWindow()!=STRUCTURE) {
	  RunAndWaitAtPosition(text,GetKindOfWindow());
	  XCloseDisplay(GetDisplay());
	  _exit(0);
	}
	free(text);
      }
    } else if (mykey==XK_Return) {
      if (keyentry!=NULL) {
        text=malloc(strlen(keyentry->filename)+strlen(GetPath())+1);
        strcpy(text,GetPath());
        strcat(text,keyentry->filename);
        GetLinkNameWithoutLast(&text);
        GetFileInfoFromDesktop(text,&pos,&icon,&start);
	if (GetKindOfWindow()==STRUCTURE && keyentry==directory) {
	  ExecuteShellcommand(GetPath(),"dfm !0!",NULL,0);
	} else {
	  if (IsSubDesktop()==False && 
	      GetKindOfWindow()!=STRUCTURE &&
	      strncmp(start,"dfm !0!",strlen("dfm !0!"))==0) {
	     RunAndWaitAtPosition(text,GetKindOfWindow());
	     XCloseDisplay(GetDisplay());
	     exit(0);
	  } else
	     ExecuteShellWithFollowLink(text,start,NULL,0);
	}
        free(text);
        free(pos);
        free(icon);
        free(start);
     }
    } else {
      if (evnt.xkey.state==ControlMask || evnt.xkey.state==Mod1Mask) {
	if (mykey==XK_a) {
	  XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());
	  SetAllMarks();
	  XUndefineCursor(GetDisplay(),GetWindow());
	} else if (mykey==XK_y) {
	  XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());
	  directory=SortIcons(TYPE,directory);
	  PlaceIcons();
	  XUndefineCursor(GetDisplay(),GetWindow());
	} else if (mykey==XK_q || mykey==XK_w) {
	  if (GetIsDesktop()==False) {
	    XCloseDisplay(GetDisplay());
	    _exit(0);
	  }
	} else if (mykey==XK_f) {
	  NewFolder();
	} else if (mykey==XK_s) {
          if (keyentry==NULL) {
	    if (GetKindOfWindow()!=STRUCTURE) {
	      ExecuteShellcommand(GetPath(),"dfm !0! -structure",NULL,0);
	    }
	  } else if (GetKindOfWindow()!=STRUCTURE || keyentry!=directory) {
	    text=malloc(strlen(GetPath())+strlen(keyentry->filename)+1);
	    strcpy(text,GetPath());
	    strcat(text,keyentry->filename);
	    ExecuteShellWithFollowLink(text,"dfm !0! -structure",NULL,0);
	    free(text);
	  }
	} else if (mykey==XK_d) {
          if (keyentry==NULL) {
	    if (GetKindOfWindow()==NORMAL && GetIsDesktop()==False) {
	      RunAndWaitAtPosition(GetPath(),DETAIL);
	      XCloseDisplay(GetDisplay());
	      _exit(0);
	    } else
	      ExecuteShellcommand(GetPath(),"dfm !0! -detail",NULL,0);
	  } else {
	    text=malloc(strlen(GetPath())+strlen(keyentry->filename)+1);
	    strcpy(text,GetPath());
	    strcat(text,keyentry->filename);
	    ExecuteShellWithFollowLink(text,"dfm !0! -detail",NULL,0);
	    free(text);
	  }
	} else if (mykey==XK_n) {
          if (keyentry==NULL) {
	    if (GetKindOfWindow()==DETAIL) {
	      RunAndWaitAtPosition(GetPath(),NORMAL);
	      XCloseDisplay(GetDisplay());
	      _exit(0);
	    } else
	      ExecuteShellcommand(GetPath(),"dfm !0!",NULL,0);
	  } else {
	    text=malloc(strlen(GetPath())+strlen(keyentry->filename)+1);
	    strcpy(text,GetPath());
	    strcat(text,keyentry->filename);
	    ExecuteShellWithFollowLink(text,"dfm !0!",NULL,0);
	    free(text);
	  }
	} else if (mykey==XK_o || mykey==XK_i) {
	  if (keyentry==NULL) {
	    text=malloc(strlen("dfm -setdir  &")+strlen(GetPath())+1);
	    strcpy(text,"dfm -setdir ");
	    strcat(text,GetPath());
	    strcat(text," &");
	    for(i=0;i<strlen(text)-2;i++) 
	      if (text[i]==' ' && text[i+1]=='~' && text[i+2]=='/')
	        text[i+1]='.';
	    usershellsystem(text,NULL);
	    free(text);
	  } else {
 	    if (keyentry->mark==True)
	      GetMarkedNames(&text2);
	    else {
	      text=malloc(strlen(GetPath())+strlen(keyentry->filename)+1);
	      strcpy(text,GetPath());
	      strcat(text,keyentry->filename); 
	      text2=GenerateBackslashName(text);
	      free(text);
            }
	    text=malloc(strlen("dfm -setfile  &")+strlen(text2)+1);
	    strcpy(text,"dfm -setfile ");
	    strcat(text,text2);
	    strcat(text," &");
	    for(i=0;i<strlen(text)-2;i++) 
	      if (text[i]==' ' && text[i+1]=='~' && text[i+2]=='/')
	        text[i+1]='.';
	    usershellsystem(text,NULL);
	    free(text);
	    free(text2);
	  }
	}
      } else {
        if ((keys[0]>=32 || keys[0]<=126) && 
	    GetKindOfWindow()!=STRUCTURE) {
          strcat(search,keys);
          keyentry=directory;
	  if (strlen(search)>99)
	    keyentry=NULL;
          while (keyentry!=NULL &&
                 strncasecmp(keyentry->filename,search,strlen(search))!=0)
            keyentry=keyentry->nextitem;
          if (keyentry==NULL) {
	    strcpy(search,keys);
            keyentry=directory;
            while (keyentry!=NULL &&
                   strncasecmp(keyentry->filename,search,strlen(search))!=0)
              keyentry=keyentry->nextitem;
          }
          if (keyentry!=NULL)
            SelectDirentry(keyentry);
          else 
            HideRubberband();
	}
      }
    }
  } else { 
    if (mykey==XK_Home) {
      keyentry=directory;
      SelectDirentry(keyentry);
    } else if (mykey==XK_End) {
      if (directory!=NULL) {
        direntry=directory;
        while (Getnextitem(direntry)!=NULL)
          direntry=Getnextitem(direntry);
        keyentry=direntry;	
        SelectDirentry(keyentry);	
      }
    } else if (mykey==XK_Left) {
      if (keyentry!=directory && directory!=NULL) {
        if (keyentry==NULL)
          keyentry=directory;
	else {
	  direntry=directory;
	  while (Getnextitem(direntry)!=keyentry)
	    direntry=Getnextitem(direntry);
          keyentry=direntry;	
	}
        SelectDirentry(keyentry);
      }
    } else if (mykey==XK_Up) {
      if (keyentry!=directory && directory!=NULL) {
        if (keyentry==NULL)
          keyentry=directory;
	else {
	  direntry=directory;
	  newentry=directory;
          XGetGeometry(GetDisplay(),direntry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	  size=iconheight+icony;
	  while (Getnextitem(direntry)!=keyentry) {
	    direntry=Getnextitem(direntry);
            XGetGeometry(GetDisplay(),direntry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	    if (size<iconheight+icony) {
	      size=iconheight+icony;
	      newentry=direntry;
	    }
	  }
          keyentry=newentry;	
	}
        SelectDirentry(keyentry);
      }
    } else if (mykey==XK_Right) {
      if (keyentry==NULL)
        keyentry=directory;
      else if (Getnextitem(keyentry)!=NULL)
        keyentry=Getnextitem(keyentry);
      SelectDirentry(keyentry);
    } else if (mykey==XK_Down) {
      if (keyentry==NULL)
        keyentry=directory;     
      else {
        XGetGeometry(GetDisplay(),keyentry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	size=iconheight+icony;
        while (Getnextitem(keyentry)!=NULL && size>=iconheight+icony) {
          keyentry=Getnextitem(keyentry);
          XGetGeometry(GetDisplay(),keyentry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	}
      }
      SelectDirentry(keyentry);
    } else if (mykey==XK_Prior) {
      if (keyentry==NULL)
        keyentry=directory;     
      else {
        XGetGeometry(GetDisplay(),GetWindow(),&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	size=iconheight;
        XGetGeometry(GetDisplay(),keyentry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	size=icony-(size-34);
	keyentry=directory;
        XGetGeometry(GetDisplay(),keyentry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
        while (Getnextitem(keyentry)!=NULL && size>=icony) {
          keyentry=Getnextitem(keyentry);
          XGetGeometry(GetDisplay(),keyentry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	}
      }
      SelectDirentry(keyentry);
    } else if (mykey==XK_Next) {
      if (keyentry==NULL)
        keyentry=directory;     
      else {
        XGetGeometry(GetDisplay(),GetWindow(),&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	size=iconheight;
        XGetGeometry(GetDisplay(),keyentry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	size=size+icony-34;
        while (Getnextitem(keyentry)!=NULL && size>=icony+iconheight) {
          keyentry=Getnextitem(keyentry);
          XGetGeometry(GetDisplay(),keyentry->Iconwindow,&root,
	       &iconx,&icony,&iconwidth,&iconheight,&border,&depth);
	}
      }
      SelectDirentry(keyentry);
    } 
  }
}

int HandleTheEvent(XEvent evnt)
{
  char *pos;
  char *icon;
  char *start;
  char *text;
  char *text2;
  static Time t;
  static int x=0,y=0,press=0;
  static struct item *direntryold;
  struct item *direntry;
  struct item *treeentry;
  int done=0;
  switch (evnt.type) {
  case KeyPress:
    HandleKeyPress(evnt);
    break;
  case ConfigureNotify:
    if (SaveNewWindowPosition()==True)
      CalcMoveWindowSize();
    break;
  case MotionNotify:
    if (press==1 && evnt.xmotion.window!=GetMoveWindow()) {
      direntry=GetDirentryFromWindow(evnt.xmotion.window);
      if (direntry!=NULL && direntry->mark==True ) {
	if ((x-evnt.xmotion.x_root)*(x-evnt.xmotion.x_root)>4 ||
	    (y-evnt.xmotion.y_root)*(y-evnt.xmotion.y_root)>4) {
	  if (direntry!=directory || GetKindOfWindow()!=STRUCTURE) {
	    IconMotion(direntry,
		       evnt.xmotion.x+x-evnt.xmotion.x_root,
		       evnt.xmotion.y+y-evnt.xmotion.y_root,
		       evnt.xmotion.x_root,evnt.xmotion.y_root);
	  }
	  press=0;
	}
      } else 
	press=0;
    } else 
      if (press==1) {
	RubberBand(evnt.xmotion.x,evnt.xmotion.y);
	press=0;
      }
    break;
  case ButtonRelease:
    press=0;
    if (evnt.xbutton.button==3) {
      HideRubberband();
      keyentry=NULL;
      if ((evnt.xbutton.state&ShiftMask)==ShiftMask) {
	direntry=GetDirentryFromWindow(evnt.xbutton.window);
	ChangeName(evnt.xbutton.time,direntry);
      } else {
        XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());
        if (evnt.xbutton.window==GetMoveWindow()) {
	  ArcWindow(evnt.xbutton.window);
	  text=GenerateBackslashName(GetPath());
	  MenuLaunch(evnt.xbutton.time,text,True,evnt.xbutton.x_root,
	                                         evnt.xbutton.y_root);
	  free(text);
	  DearcWindow(evnt.xbutton.window);
        } else {
	  direntry=GetDirentryFromWindow(evnt.xbutton.window);
	  if (direntry!=NULL) {
	    keyentry=direntry;
	    ArcWindow(evnt.xbutton.window);	  
	    if (direntry->mark==True) {
	      GetMarkedNames(&text);
	    } else {
	      text2=malloc(strlen(GetPath())+strlen(direntry->filename)+1);
	      strcpy(text2,GetPath());
	      strcat(text2,direntry->filename); 
	      text=GenerateBackslashName(text2);
	      free(text2);
	    }
	    MenuLaunch(evnt.xbutton.time,text,False,evnt.xbutton.x_root,
	                                            evnt.xbutton.y_root);
	    DearcWindow(evnt.xbutton.window);
	    free(text);
            keyentry=NULL;
	  }
        }
        XUndefineCursor(GetDisplay(),GetWindow());
      }
    }
    break;
  case ButtonPress:
    x=evnt.xbutton.x_root;
    y=evnt.xbutton.y_root;
    if (evnt.xbutton.window==movexmain || 
	evnt.xbutton.window==moveymain ||
	evnt.xbutton.window==movex ||
	evnt.xbutton.window==movey) {
      MoveTheMoveWindow(evnt);
    } else if (evnt.xbutton.button==2) {
      MoveTheMoveWindow(evnt);
    } else if (evnt.xbutton.button==1){
      press=1;
      if (evnt.xbutton.window==GetMoveWindow()) {
	if ((evnt.xbutton.state&ControlMask)!=ControlMask) {
          HideRubberband();
          keyentry=NULL;	
	  UnsetMarks();
	}
      } else {
	direntry=GetDirentryFromWindow(evnt.xbutton.window);
	if (direntry==NULL) { 
	  treeentry=GetExpandEntryFromWindow(evnt.xbutton.window);
	  if (treeentry!=NULL) { 
            HideRubberband();
            keyentry=NULL;
            XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());	    
	    if (treeentry->subtree==NULL)
	      PlusTree(treeentry);
	    else
	      MinusTree(treeentry);
            ArrangeTree();
	    TreeWindowPos(treeentry);
            CalcMoveWindowSize();
	    XUndefineCursor(GetDisplay(),GetWindow());
	  } else {
	    treeentry=GetSwitchEntryFromWindow(evnt.xbutton.window);
	    if (treeentry!=NULL) {
	      if (treeentry->horizontal==False) {
	        ExpandAllSubtree(treeentry);
	        treeentry->horizontal=True;
              } else
	        treeentry->horizontal=False;
              ArrangeTree();
 	      TreeWindowPos(treeentry);
              CalcMoveWindowSize();
	    }
	  }
	  press=0;
        } else {
	  if (direntry->mark==False) {
            HideRubberband();
	    keyentry=direntry;
	    t=evnt.xbutton.time;
	    direntryold=direntry;
	    if ((evnt.xbutton.state&ControlMask)!=ControlMask || 
	         GetKindOfWindow()==STRUCTURE)
	      UnsetMarks();
	    direntry->mark=True;
	    CreateIconWithDirentry(direntry,False,False);
	  } else {
	    if (evnt.xbutton.time-t<500 && direntry==direntryold) {
	      XDefineCursor(GetDisplay(),GetWindow(),GetWaitCursor());
	      text=malloc(strlen(direntry->filename)+strlen(GetPath())+1);
	      strcpy(text,GetPath());
	      strcat(text,direntry->filename);
              GetLinkNameWithoutLast(&text);
	      GetFileInfoFromDesktop(text,&pos,&icon,&start);
	      if (GetKindOfWindow()==STRUCTURE && direntry==directory) {
		ExecuteShellcommand(GetPath(),"dfm !0!",NULL,0);
	      } else {
		if ((evnt.xbutton.state&ShiftMask)==ShiftMask && 
		    IsSubDesktop()==False && 
		    GetKindOfWindow()!=STRUCTURE &&
		    strncmp(start,"dfm !0!",strlen("dfm !0!"))==0)
		  RunAndWaitAtPosition(text,GetKindOfWindow());
		else
		  ExecuteShellWithFollowLink(text,start,NULL,0);
	      }
	      free(text);
	      free(pos);
	      free(icon);
	      free(start);
	      if ((evnt.xbutton.state&ControlMask)!=ControlMask) {
                HideRubberband();
                keyentry=NULL;
		UnsetMarks();
	      }
	      XUndefineCursor(GetDisplay(),GetWindow());
	      if ((evnt.xbutton.state&ShiftMask)==ShiftMask && GetIsDesktop()==False) {
		XCloseDisplay(GetDisplay());
		exit(0);
	      }
	    } else {
	      t=evnt.xbutton.time;
	      direntryold=direntry;
	      if ((evnt.xbutton.state&ControlMask)==ControlMask) {
		direntry->mark=False;
                HideRubberband();
                keyentry=NULL;	
		CreateIconWithDirentry(direntry,False,False);
	      }
	    }
	  }
	}
      }
    }
    break;
  default:
    break;
  }
  return(done);
}
