/**************************************************************
  (C) 1997 by Achim Kaiser

  You may distribute under the terms of the GNU General Public
  License as specified in the COPYING file.
**************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <X11/Xlib.h>
#include "detailtitle.h"
#include "global.h"
#include "color.h"

/* This procedure creates the title of the detail window and is only used in 
   the detail view. The size of each section is fixed and so there are no
   parameters here */
void CreateDetailTitle()
{
    Pixmap backgroundpixmap;
  Font font;
  Window detailwin;
  
    detailwin=XCreateSimpleWindow(GetDisplay(),GetWindow(),20,0,700,20,
				  0,0,0);
    font=XLoadFont(GetDisplay(),"8x13");
    XSetFont(GetDisplay(),GetGC(),font);
    backgroundpixmap=XCreatePixmap(GetDisplay(),detailwin,
				   732,20,XDefaultDepth(GetDisplay(),
				   XDefaultScreen(GetDisplay())));
    XSetForeground(GetDisplay(),GetGC(),GetBestColor(0xcf3c,0xcf3c,0xcf3c));
    XFillRectangle(GetDisplay(),backgroundpixmap,GetGC(),0,0,732,20);
    XSetBackground(GetDisplay(),GetGC(),GetBestColor(0xcf3c,0xcf3c,0xcf3c));
    XSetForeground(GetDisplay(),GetGC(),GetBestColor(0,0,0));
    XDrawImageString(GetDisplay(),backgroundpixmap,GetGC(),
                     0,12," Size",strlen(" Size"));
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),0,0,0,19);
    XDrawImageString(GetDisplay(),backgroundpixmap,GetGC(),
                     116,12,"Name",strlen("Name"));
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),92,0,92,19);
    XDrawImageString(GetDisplay(),backgroundpixmap,GetGC(),
                     368,12,"Time",strlen("Time"));
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),364,0,364,19);
    XDrawImageString(GetDisplay(),backgroundpixmap,GetGC(),
                     472,12,"Modeline",strlen("Modeline"));
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),468,0,468,19);    
    XDrawImageString(GetDisplay(),backgroundpixmap,GetGC(),
                     559,12,"Owner",strlen("Owner"));
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),555,0,555,19);
    XDrawImageString(GetDisplay(),backgroundpixmap,GetGC(),
                     631,12,"Group",strlen("Group"));
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),627,0,627,19);
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),699,0,699,19);    
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),0,19,699,19);    
    XDrawLine(GetDisplay(),backgroundpixmap,GetGC(),0,0,699,0);    
    XSetWindowBackgroundPixmap(GetDisplay(),detailwin,backgroundpixmap);
    XFreePixmap(GetDisplay(),backgroundpixmap);
    XMapRaised(GetDisplay(),detailwin);
    SetDetailWindow(detailwin);
}
