/* Generated by GOB (v2.0.11) on Sun Jan 23 18:47:37 2005
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 11

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "devilspie-matcher-windowname.h"

#include "devilspie-matcher-windowname-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 16 "devilspie-matcher-windowname.gob"

void regexpr_free(regex_t *reg_expr)
{
  if (reg_expr) {
    regfree(reg_expr);
    g_free(reg_expr);
  }
}
  
void regexpr_init(regex_t **reg_expr, const GValue *str_val)
{
  const gchar *str;
  int res;
        
  str = g_value_get_string(str_val);
  if (!str) {
    regexpr_free(*reg_expr);
    *reg_expr = NULL;
  } else {
    if (!*reg_expr) {
      *reg_expr = g_new(regex_t, 1);
    } else {
      regfree(*reg_expr);
    }
    res = regcomp(*reg_expr, str, REG_EXTENDED|REG_NOSUB);
    if (res != 0) {
      char buffer[255];
      regerror (res, *reg_expr, buffer, 255);
      g_warning ("Invalid regular expression '%s': %s", str, buffer);
      *reg_expr = NULL;
    }
  }
}

gboolean regexpr_match(regex_t *reg_expr, const gchar *str)
{
  return (regexec(reg_expr, str, 0, NULL, 0) == 0) ? TRUE : FALSE;
}

#line 67 "devilspie-matcher-windowname.c"
/* self casting macros */
#define SELF(x) DEVILSPIE_MATCHER_WINDOWNAME(x)
#define SELF_CONST(x) DEVILSPIE_MATCHER_WINDOWNAME_CONST(x)
#define IS_SELF(x) DEVILSPIE_IS_MATCHER_WINDOWNAME(x)
#define TYPE_SELF DEVILSPIE_TYPE_MATCHER_WINDOWNAME
#define SELF_CLASS(x) DEVILSPIE_MATCHER_WINDOWNAME_CLASS(x)

#define SELF_GET_CLASS(x) DEVILSPIE_MATCHER_WINDOWNAME_GET_CLASS(x)

/* self typedefs */
typedef DevilsPieMatcherWindowName Self;
typedef DevilsPieMatcherWindowNameClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void devilspie_matcher_windowname_class_init (DevilsPieMatcherWindowNameClass * c) G_GNUC_UNUSED;
static gboolean ___1_devilspie_matcher_windowname_test (DevilsPieMatcher * self, WnckWindow * window) G_GNUC_UNUSED;
static void devilspie_matcher_windowname_init (DevilsPieMatcherWindowName * self) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_WINDOW_TITLE,
	PROP_APPLICATION_NAME,
	PROP_WINDOW_ROLE
};

/* pointer to the class of our parent */
static DevilsPieMatcherClass *parent_class = NULL;

/* Short form macros */
#define self_new devilspie_matcher_windowname_new
GType
devilspie_matcher_windowname_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (DevilsPieMatcherWindowNameClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) devilspie_matcher_windowname_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (DevilsPieMatcherWindowName),
			0 /* n_preallocs */,
			(GInstanceInitFunc) devilspie_matcher_windowname_init,
			NULL
		};

		type = g_type_register_static (DEVILSPIE_TYPE_MATCHER, "DevilsPieMatcherWindowName", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((DevilsPieMatcherWindowName *)g_object_new(devilspie_matcher_windowname_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static DevilsPieMatcherWindowName * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static DevilsPieMatcherWindowName *
GET_NEW_VARG (const char *first, ...)
{
	DevilsPieMatcherWindowName *ret;
	va_list ap;
	va_start (ap, first);
	ret = (DevilsPieMatcherWindowName *)g_object_new_valist (devilspie_matcher_windowname_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "DevilsPie:Matcher:WindowName::finalize"
	DevilsPieMatcherWindowName *self G_GNUC_UNUSED = DEVILSPIE_MATCHER_WINDOWNAME (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 63 "devilspie-matcher-windowname.gob"
	if(self->_priv->window_title_regexpr) { regexpr_free ((gpointer) self->_priv->window_title_regexpr); self->_priv->window_title_regexpr = NULL; }
#line 152 "devilspie-matcher-windowname.c"
#line 74 "devilspie-matcher-windowname.gob"
	if(self->_priv->application_name_regexpr) { regexpr_free ((gpointer) self->_priv->application_name_regexpr); self->_priv->application_name_regexpr = NULL; }
#line 155 "devilspie-matcher-windowname.c"
#line 86 "devilspie-matcher-windowname.gob"
	if(self->_priv->window_role_regexpr) { regexpr_free ((gpointer) self->_priv->window_role_regexpr); self->_priv->window_role_regexpr = NULL; }
#line 158 "devilspie-matcher-windowname.c"
}
#undef __GOB_FUNCTION__

static void 
devilspie_matcher_windowname_class_init (DevilsPieMatcherWindowNameClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "DevilsPie:Matcher:WindowName::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	DevilsPieMatcherClass *devilspie_matcher_class = (DevilsPieMatcherClass *)c;

	g_type_class_add_private(c,sizeof(DevilsPieMatcherWindowNamePrivate));

	parent_class = g_type_class_ref (DEVILSPIE_TYPE_MATCHER);

#line 96 "devilspie-matcher-windowname.gob"
	devilspie_matcher_class->test = ___1_devilspie_matcher_windowname_test;
#line 175 "devilspie-matcher-windowname.c"
	g_object_class->finalize = ___finalize;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("window_title" /* name */,
		 _("Window title regexp") /* nick */,
		 _("The regular expression that should match the window title") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_WINDOW_TITLE,
		param_spec);
	param_spec = g_param_spec_string
		("application_name" /* name */,
		 _("Application name regexp") /* nick */,
		 _("The regular expression that should match the name of the application (as determined by libwnck)") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_APPLICATION_NAME,
		param_spec);
	param_spec = g_param_spec_string
		("window_role" /* name */,
		 _("Window role regexp") /* nick */,
		 _("The regular expression that should match the role of the window (set by WM_WINDOW_ROLE atom)") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_WINDOW_ROLE,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 135 "devilspie-matcher-windowname.gob"
static void 
devilspie_matcher_windowname_init (DevilsPieMatcherWindowName * self G_GNUC_UNUSED)
#line 214 "devilspie-matcher-windowname.c"
{
#define __GOB_FUNCTION__ "DevilsPie:Matcher:WindowName::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,TYPE_SELF,DevilsPieMatcherWindowNamePrivate);
 {
#line 135 "devilspie-matcher-windowname.gob"

    DEVILSPIE_MATCHER(self)->type = MatchWindowNameType;
  
#line 223 "devilspie-matcher-windowname.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "DevilsPie:Matcher:WindowName::set_property"
{
	DevilsPieMatcherWindowName *self G_GNUC_UNUSED;

	self = DEVILSPIE_MATCHER_WINDOWNAME (object);

	switch (property_id) {
	case PROP_WINDOW_TITLE:
		{
#line 69 "devilspie-matcher-windowname.gob"

	regexpr_init(&self->_priv->window_title_regexpr, VAL);
      
#line 246 "devilspie-matcher-windowname.c"
		}
		break;
	case PROP_APPLICATION_NAME:
		{
#line 80 "devilspie-matcher-windowname.gob"

	regexpr_init(&self->_priv->application_name_regexpr, VAL);
      
#line 255 "devilspie-matcher-windowname.c"
		}
		break;
	case PROP_WINDOW_ROLE:
		{
#line 92 "devilspie-matcher-windowname.gob"

	regexpr_init(&self->_priv->window_role_regexpr, VAL);
      
#line 264 "devilspie-matcher-windowname.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 96 "devilspie-matcher-windowname.gob"
static gboolean 
___1_devilspie_matcher_windowname_test (DevilsPieMatcher * self G_GNUC_UNUSED, WnckWindow * window)
#line 283 "devilspie-matcher-windowname.c"
#define PARENT_HANDLER(___self,___window) \
	((DEVILSPIE_MATCHER_CLASS(parent_class)->test)? \
		(* DEVILSPIE_MATCHER_CLASS(parent_class)->test)(___self,___window): \
		((gboolean )0))
{
#define __GOB_FUNCTION__ "DevilsPie:Matcher:WindowName::test"
#line 96 "devilspie-matcher-windowname.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 96 "devilspie-matcher-windowname.gob"
	g_return_val_if_fail (DEVILSPIE_IS_MATCHER (self), (gboolean )0);
#line 96 "devilspie-matcher-windowname.gob"
	g_return_val_if_fail (window != NULL, (gboolean )0);
#line 96 "devilspie-matcher-windowname.gob"
	g_return_val_if_fail (WNCK_IS_WINDOW (window), (gboolean )0);
#line 298 "devilspie-matcher-windowname.c"
{
#line 96 "devilspie-matcher-windowname.gob"
	
    gboolean matching_window, matching_application, matching_role;
    gboolean matched_window, matched_application, matched_role;
    DevilsPieMatcherWindowName *m = (DevilsPieMatcherWindowName*)self;
    PARENT_HANDLER(self, window);

    matching_window = matching_application = matching_role = FALSE;
    matched_window = matched_application = matched_role = FALSE;

    if (m->_priv->window_title_regexpr) {
      const char *window_name;
      window_name = wnck_window_get_name(window);
      matching_window = TRUE;
      matched_window = regexpr_match(m->_priv->window_title_regexpr, window_name);
    }
    if (m->_priv->application_name_regexpr) {
      WnckApplication *app;
      const char *app_name;
      app = wnck_window_get_application(window);
      app_name = wnck_application_get_name(app);
      matching_application = TRUE;
      matched_application = regexpr_match(m->_priv->application_name_regexpr, app_name);
    }
    if (m->_priv->window_role_regexpr) {
      const char *role;
      role = _wnck_get_string_property_latin1 (wnck_window_get_xid (window), _wnck_atom_get("WM_WINDOW_ROLE"));
      matching_role = TRUE;
      matched_role = role == 0 ? FALSE : regexpr_match(m->_priv->window_role_regexpr, role);
    }
    
    if ((!matching_window || matched_window) &&
        (!matching_application || matched_application) &&
        (!matching_role || matched_role)) {
      return TRUE;
    } else {
      return FALSE;
    }
  }}
#line 339 "devilspie-matcher-windowname.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER


#line 139 "devilspie-matcher-windowname.gob"
GObject * 
devilspie_matcher_windowname_new (void)
#line 347 "devilspie-matcher-windowname.c"
{
#define __GOB_FUNCTION__ "DevilsPie:Matcher:WindowName::new"
{
#line 139 "devilspie-matcher-windowname.gob"
	
    return (GObject*)GET_NEW;
  }}
#line 355 "devilspie-matcher-windowname.c"
#undef __GOB_FUNCTION__
