/*
 * analysis_highlighting.c
 * Implements note highlighting for 
 * analysis results
 *
 * A Tee (c) 2001
 */

#include "datastructures.h"
#include "analysis_highlighting.h"
#include "frogio.h"
#include "utils.h"
#include "prefops.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#ifndef G_OS_WIN32
# include <wait.h>
#endif
#include <errno.h>



GList *results = NULL;

void
unhighlight (gpointer callback_data, GtkWidget * widget)
{
  staffnode *curstaff;
  staff *curstaffstruct;
  measurenode *curmeasure;
  objnode *curobj;
  mudelaobject *mudelaitem;
  struct scoreinfo *si = callback_data;
  
  for (curstaff = si->thescore; curstaff; curstaff = curstaff->next)
    {
      curstaffstruct = curstaff->data;
      for (curmeasure = (measurenode *) curstaffstruct->measures;
	   curmeasure; curmeasure = curmeasure->next)
	{

	  for (curobj = curmeasure->data; curobj; curobj = curobj->next)
	    {
	      mudelaitem = curobj->data;
	      mudelaitem->u.chordval.is_highlighted = FALSE;
	    }
	}
    }
  //  results = NULL;  
}


struct callbackdata
{
  struct scoreinfo *si;
  GtkWidget *nextbutton;
  GtkWidget *prevbutton;
};


void
highlight (gpointer callback_data, GtkWidget * widget)
{
  struct scoreinfo *si = callback_data;
  note_highlight (si, widget);
}


void
note_highlight (gpointer callback_data, GtkWidget * widget)
{
  staffnode *curstaff = NULL;
  staff *curstaffstruct = NULL;
  measurenode *curmeasure = NULL;
  objnode *curobj = NULL;
  mudelaobject *mudelaitem = NULL;
  Results *res = NULL;
  gint bar;
  gint i;
  gfloat beat;
  static gint counter = 0;
  GList *temp;

  /*struct callbackdata *cbdata = callback_data; */
  struct scoreinfo *si = callback_data;

  /*if(!results) */
  read_resultsfile (si, widget);

  /*res = (Results *) g_list_nth_data(results,counter); */
  /*unhighlight(cbdata->si,NULL); */

  for (temp = results; temp; temp = temp->next)
    {
      res = temp->data;
      for (curstaff = si->thescore, i = 1; i < res->staff || curstaff;
	   curstaff = curstaff->next, i++)
	{

	  g_print ("Staff %d\n", i);
	  if (i == res->staff)
	    {

	      curstaffstruct = (staff *) curstaff->data;
	      for (curmeasure = (measurenode *) curstaffstruct->measures,
		   bar = 1; curmeasure; curmeasure = curmeasure->next, bar++)
		{
		  if (bar >= res->start_bar && bar <= res->end_bar)
		    {
		      beat = 1.00;
		      for (curobj = curmeasure->data; curobj;
			   curobj = curobj->next)
			{
			  g_print ("Bar %d, Beat %f\n", bar, beat);
			  mudelaitem = curobj->data;
			  if (beatcmp
			      (bar, beat, res->start_bar,
			       res->start_beat) >= 0
			      || beatcmp (bar, beat, res->end_bar,
					  res->end_beat) >= 0)
			    {
			      mudelaitem->u.chordval.is_highlighted = TRUE;
			      g_print ("Set Highlight %d, %f \n", bar, beat);
			    }
			  beat += durationtofloat
			    (mudelaitem->u.chordval.baseduration,
			     mudelaitem->u.chordval.numdots);
			}

		    }
		}
	    }
	}
    }
  counter++;
  gtk_widget_draw (si->scorearea, NULL);
}


void
perform_analysis (gpointer callback_data, GtkWidget * widget)
{
  static GString *filename = NULL;
  static GString *patternname = NULL;
  static GString *passtosystem = NULL;
  static GString *resfilename = NULL;
  pid_t pid;
  int status;
  struct scoreinfo *si = callback_data;

  if (!filename)
    {
      filename = g_string_new (locatedotdenemo ());
      g_string_append (filename, "/denemoanalysis");
      patternname = g_string_new (locatedotdenemo ());
      g_string_append (patternname, "/denemoanalysispattern");
      passtosystem = g_string_new (NULL);
      resfilename = g_string_new (locatedotdenemo ());
      g_string_append (resfilename, "/denemoanalysisresults");
    }

  g_print ("%s \n %s", filename->str, patternname->str);



#ifdef G_OS_WIN32
  pid = -1;
#else
  pid = fork ();
#endif

  if (pid == -1)
    {
      /*
       * Fork failed to create a process :
       */
      fprintf (stderr, "%s: Failed to fork()\n", strerror (errno));
      return;

    }
  else if (pid == 0)
    {
      filesave (filename->str, si, 0, 0, 0);
      filesave (patternname->str, si, 0, 0, 0);
      g_string_append (passtosystem, "simulation");
      g_string_append (passtosystem, " -m -a 1 ");
      g_string_append (passtosystem, "-s");
      g_string_append (passtosystem, filename->str);
      g_string_append (passtosystem, " -p");
      g_string_append (passtosystem, patternname->str);
      g_string_append (passtosystem, " -r");
      g_string_append (passtosystem, resfilename->str);
      status = system (passtosystem->str);

      _exit (0);


    }

}

int
beatcmp (int bar1, int beat1, int bar2, int beat2)
{

  if (bar1 < bar2 && beat1 < beat2)
    return -1;
  else if (bar1 == bar2 && beat1 == beat2)
    return 0;
  else
    return 1;
}

void
read_resultsfile (gpointer callback_data, GtkWidget * widget)
{
  gchar buffer[50];
  gint num_fields;
  GString *resfile = NULL;
  Results *res = NULL;
  Results *tempres = NULL;
  FILE *fp = NULL;
  GList *temp = NULL;
  gint i = 0;

  if (!resfile)
    {
      resfile = g_string_new (locatedotdenemo ());
      g_string_append (resfile, "/denemoanalysisresults");
    }

  if ((fp = fopen (resfile->str, "r")) == NULL)
    return;
  else
    {
      while (!feof (fp))
	{
	  res = g_malloc (sizeof (Results));	/*createnewres(); */
	  if (res)
	    {
	      fscanf (fp, "%d %d %f %d %f\n", &res->staff,
		      &res->start_bar, &res->start_beat,
		      &res->end_bar, &res->end_beat);
	      g_print ("Read record %d\n", i);

	      g_print ("%d %d %f %d %f\n", res->staff,
		       res->start_bar, res->start_beat,
		       res->end_bar, res->end_beat);

	      results = g_list_insert (results, res, i);

	      i++;

	    }

	  res = NULL;

	}
      fclose (fp);
    }

  for (temp = results; temp; temp = temp->next)
    {
      tempres = (Results *) temp->data;
      g_print ("%d %d %f %d %f\n", tempres->staff,
	       tempres->start_bar, tempres->start_beat,
	       tempres->end_bar, tempres->end_beat);
    }

}


Results *createnewres (void)
{
  Results *newres = g_malloc (sizeof (Results));

  return newres;
}
