/**
 * Print an action/goto table for a push-down automaton.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include "cfg.h"
#include "pda.h"
#include "util.h"


/** Name of this program. */
const char* program = "print-pda";


/** Prints an action/goto table for the context-free grammar specified
 * on the command line. */
int
main( int argc, char* argv[])
{
	PDA pda;
	assumex( argc > 2, "missing file argument");
	read_cfg( &pda.g, open_file( argv[1]));
	read_pda( &pda, open_file( argv[2]));
	print_pda( &pda);
	return 0;
}
