#ifndef __lr_h__
#define __lr_h__


#include <stdio.h>
#include "cfg.h"
#include "tree.h"


/** Maximum number of states. */
#define STATES 256

/** Initial state. */
#define INITIAL_STATE 0

/** Syntax error. */
#define SYNTAX_ERROR 0

/** ACCEPT */
#define ACCEPT 0


/** PDA action. */
typedef struct {
	int reduce:1;
	int move:31;
} Action;

/** Discrete push-down automaton. */
typedef struct {
	CFG g;
	Action move[STATES][SYMBOLS];
} PDA;


void clear_pda( PDA* pda);
void print_pda( const PDA* pda);
void read_pda( PDA* pda, FILE* file);
Tree* parse( const PDA* pda, FILE* input);


#endif
