/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * he3.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: he3.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __HE3_H__
#define __HE3_H__

/**************************************************/
/* decompress data compressed using HE3 algorithm */ 
/**********************************************************/
/* input: a GByteArray containing HE3 compressed data     */
/* output: a GString containing uncompressed data or NULL */
/**********************************************************/
GString *decode_he3_data(GByteArray *data);

/*****************************************************************************************/
/* compress data compressed using an Huffman algorithm and store it in HE3 usable format */
/*****************************************************************************************/
/* input: a GString containing a string to compress        */
/* output: a GByteArray containing compressed data or NULL */
/***********************************************************/
GByteArray *encode_he3_data(GString *str);

#endif
