/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * dc_manage.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: dc_manage.h,v 1.2 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __DC_MANAGE_H__
#define __DC_MANAGE_H__

extern int hub_logged;		/* set to 1 when dctc is logged on the hub */

/*************************************************************************************/
/* this function is called each time the client receives a full line from the server */
/*****************************************************************************************/
/* sck is provided because the function to process may requires and access to the socket */
/*****************************************************************************************/
/* output: 0: continue */
/*         1: end      */
/***********************/
int process_incoming_dc_data(int sck,GString *input);

/*************************************************/
/* get dc lines from network until nothing comes */
/**************************************************************************************/
/* all incoming lines are processed either to send new commands or to display results */
/**************************************************************************************/
void get_dc_line_and_process(int sck);

/******************************************************/
/* the following function must be used very carefully */
/******************************************************/

/***************************************************************************/
/* process the "$ConnectToMe nick ip:port|" command                        */
/* when a user want someone to connect him directly, this message is sent. */
/* this case appears when someone (!BHF) wants to ul/dl/filebrowse with    */
/* the user here.                                                          */
/***************************************************************************/
int connecttome_process(const char *cmd,int sck,GString *input, char *xtra_param);


/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* managment of com socket */
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */
/* ---------------------------------------------------------------------- */

/********************************************/
/* someone tries to connect to the com port */
/********************************************/
void manage_com_port(int in_sck);

/********************************************************/
/* we receive someone search results on the search port */
/********************************************************/
int manage_srch_port(int udp_sck, int main_sck);

extern GPtrArray *hub_capabilities;		/* capabilities of the current hub */

/*******************************************/
/* send the client capabilities to the hub */
/*******************************************/
void send_client2hub_capabilities(void);

#endif
