<?php
    /*
     * $Id: login.php,v 1.3.2.2.2.15 2004/01/01 18:20:00 mdean Exp $
     *
     * Double Choco Latte - Source Configuration Management System
     * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
     *
     * This program is free software; you can redistribute it and/or
     * modify it under the terms of the GNU General Public License
     * as published by the Free Software Foundation; either version 2
     * of the License, or (at your option) any later version.
     *
     * This program is distributed in the hope that it will be useful,
     * but WITHOUT ANY WARRANTY; without even the implied warranty of
     * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     * GNU General Public License for more details.
     *
     * You should have received a copy of the GNU General Public License
     * along with this program; if not, write to the Free Software
     * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
     *
     * Select License Info from the Help menu to view the terms and conditions of this license.
     */

if (!IsSet($GLOBALS['LOGIN_PHP_INCLUDED']))
{
	$GLOBALS['LOGIN_PHP_INCLUDED'] = 1;

	// This should only be called from main.php or such.  Template files need to include config.php to get info before login
	if (!defined('__DCL_CONFIG_INCLUDED__'))
		include_once('inc/config.php');

	$bInPHPGroupWare = false;
	$bInXOOPS = false;
	$bNoHeader = (IsSet($menuAction) && ($menuAction == 'htmlTicketDetail.Download' || $menuAction == 'htmlWorkOrderDetail.Download' || $menuAction == 'boGraph.Show'));
	if (@is_dir('../phpgwapi') && @file_exists('../header.inc.php'))
	{
		$phpgw_info['flags'] = array(
				'currentapp' => 'dcl',
				'noheader'   => True,
				'nonavbar'   => True
			);
		include_once('../header.inc.php');
		$bInPHPGroupWare = true;
	}
	else if (@is_dir('../../modules') && @file_exists('../../xoops.css'))
	{
		include_once('xoops_header.php');
		$xoopsOption['template_main'] = 'xoops_dcl.html';
		include XOOPS_ROOT_PATH . '/header.php';
		$bInXOOPS = true;
	}

	if (!defined('DCL_ENTITY_GLOBAL'))
		include_once(DCL_ROOT . 'inc/functions.inc.php');
		
	define('DCL_EMBEDDED_STATE', ($bInPHPGroupWare ? DCL_PHPGW : ($bInXOOPS ? DCL_XOOPS : DCL_STANDALONE)));

	function Refresh($toHere = 'index.php', $session_id = '', $domain = 'default')
	{
		global $DCLINFO, $DCLUI;
		if (!empty($_SERVER))
			extract($_SERVER);
		else if (!empty($HTTP_SERVER_VARS))
			extract($HTTP_SERVER_VARS);

		$bIsLogin = (substr($toHere, 0, 9) == 'index.php');

		if ($bIsLogin)
		{
			$theCookie = '';
			if (IsSet($QUERY_STRING) && $QUERY_STRING != '')
				$toHere .= sprintf('%srefer_to=%s', strpos($toHere, '?') > 0 ? '&' : '?', urlencode($QUERY_STRING));
		}
		else
			$theCookie = $session_id . '/' . $domain;

		if (DCL_COOKIE_METHOD == 'header')
		{
			$hdr = '';
			if (DCL_REDIR_METHOD == 'php')
				$hdr = "Location: $toHere\n";

			$hdr .= "Set-Cookie: DCLINFO=$theCookie\n";
			$hdr .= "\n";

			Header($hdr);
			if ($bIsLogin)
				exit;
		}

		if (DCL_COOKIE_METHOD == 'php')
		{
			$httpDomain = '';
			if (ereg('^[0-9]{2,3}\.[0-9]{2,3}\.[0-9]{2,3}\.[0-9]{2,3}$', $HTTP_HOST))
			{
				$httpDomain = $HTTP_HOST;
			}
			else if (ereg('.*\..*$', $HTTP_HOST))
			{
				$httpDomain = eregi_replace('^www\.', '', $HTTP_HOST);
				$httpDomain = '.' . $httpDomain;
			}

			SetCookie('DCLINFO', $theCookie, 0, '/', $httpDomain);

			if (DCL_REDIR_METHOD == 'php')
			{
				Header("Location: $toHere\n\n");
				if ($bIsLogin)
					exit;
			}
		}

		print('<html><head>');

		if (DCL_COOKIE_METHOD == 'meta')
		{
			print("<meta http-equiv=\"Set-Cookie\" content=\"DCLINFO=$theCookie\">");
		}

		print("<meta http-equiv=\"refresh\" content=\"00;URL=$toHere\">");
		print('</head>');
		if ($bIsLogin)
		{
			print('<body bgcolor="#FFFFFF"></body></html>');
			exit;
		}
	}

	if (IsSet($HTTP_COOKIE_VARS['DCLINFO']) && !IsSet($HTTP_POST_VARS['UID']))
	{
		$g_oSession = CreateObject('dcl.dbSession');
		list($dcl_session_id, $DOMAIN) = explode('/', $HTTP_COOKIE_VARS['DCLINFO']);
		if (strlen($dcl_session_id) != 32)
			Refresh($dcl_www_root . 'index.php?cd=2');

		$g_oSession->Connect();
		if (!$g_oSession->conn)
			Refresh($dcl_www_root . 'index.php?cd=3');

		if ($g_oSession->Load($dcl_session_id) == false)
			Refresh($dcl_www_root . 'index.php?cd=2');

		if (!$g_oSession->conn)
			Refresh('index.php?cd=3');

		if (!$g_oSession->IsValidSession())
			Refresh('index.php?cd=2');

		LoadStringResource('cmmn');
	}
	else
	{
		$obj = GetAuthenticator();
		$aAuthInfo = array();
		if ($obj->IsValidLogin($aAuthInfo))
		{
			$oConfig = CreateObject('dcl.dbConfig');
			$dcl_info = array();
			$oConfig->Load();

			$g_oSession = CreateObject('dcl.dbSession');
			$g_oSession->Connect();
			if (!$g_oSession->conn)
				Refresh('index.php?cd=3');

			$g_oSession->personnel_id = $aAuthInfo['id'];
			$g_oSession->Add();

			$oPreferences = CreateObject('dcl.dbPreferences');
			$oPreferences->Connect();
			$oPreferences->Load($aAuthInfo['id']);

			$g_oSession->Register('DCLID', $aAuthInfo['id']);
			$g_oSession->Register('SEC', $aAuthInfo['security']);
			$g_oSession->Register('DCLNAME', trim($aAuthInfo['short']));
			$g_oSession->Register('USEREMAIL', $aAuthInfo['email']);
			$g_oSession->Register('dcl_info', $dcl_info);
			$g_oSession->Register('dcl_preferences', $oPreferences->preferences_data);
			$g_oSession->Edit();

			$menuAction = 'menuAction=htmlMyDCL.show';
			if (IsSet($HTTP_POST_VARS['refer_to']) && $HTTP_POST_VARS['refer_to'] != '')
				$menuAction = urldecode($HTTP_POST_VARS['refer_to']);

			$tpl = $oPreferences->Value('DCL_PREF_TEMPLATE_SET');
			if ($tpl == '')
				$tpl = $dcl_info['DCL_DEF_TEMPLATE_SET'];

			if (file_exists('templates/' . $tpl . '/frameset.php'))
				Refresh('templates/' . $tpl . '/frameset.php?' . $menuAction, $g_oSession->dcl_session_id, $HTTP_POST_VARS['DOMAIN']);
			else
				Refresh('main.php?' . $menuAction, $g_oSession->dcl_session_id, $HTTP_POST_VARS['DOMAIN']);
		}
		else
			Refresh('index.php?cd=1');
	}
}
?>
