<?php
/*
 * $Id: class.htmlWorkOrderTypeView.inc.php,v 1.1.2.1 2003/12/10 05:54:54 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('chk');
import('htmlView');
class htmlWorkOrderTypeView extends htmlView
{
	function htmlWorkOrderTypeView()
	{
		parent::htmlView();
		$this->sColumnTitle = STR_CMMN_OPTIONS;
		$this->sSortAction = 'htmlWorkOrderTypeView.execurl';
	}
	
	function Render(&$oView)
	{
		global $g_oSec, $dcl_info;
		
		if ($g_oSec->HasSecLvl($dcl_info['DCL_ADD_USER']))
			parent::Render($oView);
		else
			return PrintPermissionDenied();
	}
	
	function _SetActionFormOptions()
	{
		global $dcl_info, $g_oSec;
		
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_ADD_USER']))
			return PrintPermissionDenied();
		
		$aLinks = array(
				STR_CMMN_NEW => menuLink('', 'menuAction=htmlWorkOrderType.add'),
				DCL_MENU_SYSTEMSETUP => menuLink('', 'menuAction=boAdmin.ShowSystemConfig')
			);

		$this->_SetVar('hActionLinkSetLinks', '');
		$bFirst = true;
		foreach ($aLinks as $sText => $sLink)
		{
			if ($bFirst)
				$bFirst = false;
			else
				$this->Template->parse('hActionLinkSetLinks', 'actionLinkSetSep', true);

			$this->_SetVar('LNK_ACTIONVALUE', $sLink);
			$this->_SetVar('VAL_ACTIONVALUE', $sText);
			$this->Template->parse('hActionLinkSetLinks', 'actionLinkSetLink', true);
		}
		
		$this->Template->parse('hActionLinkSet', 'actionLinkSet');
		$this->Template->parse('hActions', 'actions');
	}

	function _DisplayOptions()
	{
		global $dcl_info, $g_oSec;
		
		if (!$g_oSec->HasSecLvl($dcl_info['DCL_ADD_USER']))
			return PrintPermissionDenied();
		
		$this->_SetVar('hDetailColumnLinkSetLinks', '');
		$id = $this->oDB->f('wo_type_id');

		$this->_AddDisplayOption(STR_CMMN_EDIT, menuLink('', 'menuAction=htmlWorkOrderType.modify&wo_type_id=' . $id), false);
		$this->_AddDisplayOption(STR_CMMN_DELETE, menuLink('', 'menuAction=htmlWorkOrderType.delete&wo_type_id=' . $id), true);

		$this->Template->parse('hDetailColumnLinkSet', 'detailColumnLinkSet');
		$this->Template->parse('hDetailCells', 'detailCells', true);

		// this avoids repeating cells
		$this->_ResetDetailCells();
	}
}
?>