<?php
/*
 * $Id: class.htmlTicketForm.inc.php,v 1.3.2.1.2.4 2003/11/11 05:50:04 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('tck');

class htmlTicketForm
{
	function Show($obj = '')
	{
		global $dcl_info;

		$isEdit = is_object($obj);

		if (!$GLOBALS['g_oSec']->HasSecLvl($isEdit ? $GLOBALS['dcl_info']['DCL_MOD_WO'] : $GLOBALS['dcl_info']['DCL_ADD_WO']))
			return PrintPermissionDenied();

		$objHTMLPersonnel = CreateObject('dcl.htmlPersonnel');
		$objJS = CreateObject('dcl.jsAttributesets');
		$objAcc = CreateObject('dcl.htmlAccounts');
		$objPrd = CreateObject('dcl.htmlProducts');
		$objMod = CreateObject('dcl.htmlProductModules');
		$objPri = CreateObject('dcl.htmlPriorities');
		$objSev = CreateObject('dcl.htmlSeverities');

		$objJS->bPriorities = true;
		$objJS->bSeverities = true;
		$objJS->bModules = true;
		$objJS->forWhat = 'tck';
		$objJS->DisplayAttributeScript();

		$Template = CreateTemplate(array('hForm' => 'htmlTicketForm.tpl'));

		$Template->set_block('hForm', 'assign', 'hAssign');
		$Template->set_block('hForm', 'responsible', 'hResponsible');
		$Template->set_block('hForm', 'resolution', 'hResolution');
		$Template->set_block('hForm', 'modify', 'hModify');
		$Template->set_block('hForm', 'add', 'hAdd');
		$Template->set_block('hForm', 'attach', 'hAttach');

		$Template->set_var('hAssign', '');
		$Template->set_var('hResponsible', '');
		$Template->set_var('hResolution', '');
		$Template->set_var('hModify', '');
		$Template->set_var('hAdd', '');
		$Template->set_var('hAttach', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());

		$Template->set_var('TXT_JUMPTOTICKETID', STR_TCK_JUMPTOTICKETID);
		$Template->set_var('BTN_FIND', STR_CMMN_FIND);
		$Template->set_var('TXT_RESPONSIBLE', STR_TCK_RESPONSIBLE);
		$Template->set_var('VAL_DCLID', $GLOBALS['DCLID']);
		$Template->set_var('TXT_ASSIGNTOME', STR_TCK_ASSIGNTOME);
		$Template->set_var('TXT_CONTACT', STR_TCK_CONTACT);
		$Template->set_var('TXT_CONTACTPHONE', STR_TCK_CONTACTPHONE);
		$Template->set_var('TXT_CONTACTEMAIL', STR_TCK_CONTACTEMAIL);
		$Template->set_var('TXT_ACCOUNT', STR_TCK_ACCOUNT);
		$Template->set_var('TXT_PRODUCT', STR_TCK_PRODUCT);
		$Template->set_var('TXT_MODULE', 'Module*');
		$Template->set_var('TXT_VERSION', STR_TCK_VERSION);
		$Template->set_var('TXT_PRIORITY', STR_TCK_PRIORITY);
		$Template->set_var('TXT_TYPE', STR_TCK_TYPE);
		$Template->set_var('TXT_SUMMARY', STR_TCK_SUMMARY);
		$Template->set_var('TXT_ISSUE', STR_TCK_ISSUE);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_SAVEANDCLOSE', STR_TCK_SAVEANDCLOSE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_CMMN_HIGHLIGHTEDNOTE);
		$Template->set_var('TXT_FILE', STR_TCK_ATTACHFILE);

		if ($dcl_info['DCL_MAX_UPLOAD_FILE_SIZE'] > 0 && !$isEdit)
			$Template->parse('hAttach', 'attach');

		if ($isEdit)
		{
			$objProduct = CreateObject('dcl.dbProducts');
			$objProduct->Connect();
			$objProduct->Query('SELECT tcksetid FROM products WHERE id=' . $obj->product);
			$objProduct->next_record();
			$setid = $objProduct->f(0);

			$Template->set_var('TXT_TITLE', sprintf(STR_TCK_EDITTITLE, $obj->ticketid));
			$Template->set_var('CMB_RESPONSIBLE', $objHTMLPersonnel->GetCombo($obj->responsible, 'responsible', 'lastfirst', 0, false, $dcl_info['DCL_HAVE_WO']));
			$Template->set_var('VAL_CONTACT', htmlspecialchars($obj->contact));
			$Template->set_var('VAL_CONTACTPHONE', htmlspecialchars($obj->contactphone));
			$Template->set_var('VAL_CONTACTEMAIL', htmlspecialchars($obj->contactemail));
			$Template->set_var('CMB_ACCOUNT', $objAcc->GetCombo($obj->account, 'account', 'name', 0, false));
			$Template->set_var('CMB_PRODUCT', $objPrd->GetCombo($obj->product, 'product', 'name', 0, 0, false, true));
			$Template->set_var('CMB_MODULE', $objMod->GetCombo($obj->module_id, 'module_id', 0, false, $obj->product));
			$Template->set_var('VAL_VERSION', htmlspecialchars($obj->version));
			$Template->set_var('CMB_PRIORITY', $objPri->GetCombo($obj->priority, 'priority', 'name', 0, false, $setid));
			$Template->set_var('CMB_TYPE', $objSev->GetCombo($obj->type, 'type', 'name', 0, false, $setid));
			$Template->set_var('VAL_SUMMARY', htmlspecialchars($obj->summary));
			$Template->set_var('VAL_ISSUE', htmlspecialchars($obj->issue));
			$Template->parse('hModify', 'modify');

			$hiddenVars = '<input type="hidden" name="menuAction" value="boTickets.dbmodify">';
			$hiddenVars .= sprintf('<input type="hidden" name="ticketid" value="%d">', $obj->ticketid);
			$hiddenVars .= sprintf('<input type="hidden" name="status" value="%d">', $obj->status);
		}
		else
		{
			$Template->set_var('TXT_TITLE', STR_TCK_ADDTITLE);
			$Template->set_var('CMB_RESPONSIBLE', $objHTMLPersonnel->GetCombo($GLOBALS['DCLID'], 'responsible', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
			$Template->set_var('VAL_CONTACT', '');
			$Template->set_var('VAL_CONTACTPHONE', '');
			$Template->set_var('VAL_CONTACTEMAIL', '');
			$Template->set_var('CMB_ACCOUNT', $objAcc->GetCombo());
			$Template->set_var('CMB_PRODUCT', $objPrd->GetCombo(0, 'product', 'name', 0, 0, true, true));
			$Template->set_var('CMB_MODULE', $objMod->GetCombo(0, 'module_id', 0, true));
			$Template->set_var('VAL_VERSION', '');
			$Template->set_var('CMB_PRIORITY', $objPri->GetCombo());
			$Template->set_var('CMB_TYPE', $objSev->GetCombo(0, 'type'));
			$Template->set_var('VAL_SUMMARY', '');
			$Template->set_var('VAL_ISSUE', '');
			$Template->set_var('TXT_RESOLUTION', STR_TCK_RESOLUTION);
			$Template->parse('hResolution', 'resolution');
			$Template->parse('hAdd', 'add');

			$hiddenVars = '<input type="hidden" name="menuAction" value="boTickets.dbadd">';
			$hiddenVars .= sprintf('<input type="hidden" name="status" value="%d">', $dcl_info['DCL_DEFAULT_TICKET_STATUS']);
			$hiddenVars .= sprintf('<input type="hidden" name="startedon" value="%s">', date($dcl_info['DCL_TIMESTAMP_FORMAT']));
		}

		$Template->set_var('HIDDEN_VARS', $hiddenVars);
		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ASSIGN_WO'])
		{
			$Template->parse('hAssign', 'assign');
		}
		elseif ($GLOBALS['SEC'] >= $dcl_info['DCL_HAVE_WO'])
		{
			if (!$isEdit || $obj->responsible == $GLOBALS['DCLID'])
				$Template->set_var('IS_CHECKED', ' checked');
			else
				$Template->set_var('IS_CHECKED', '');

			$Template->parse('hResponsible', 'responsible');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
