<?php
/*
 * $Id: class.htmlProjectmap.inc.php,v 1.1.1.1.2.1.2.3 2003/10/13 02:22:49 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('pm');

class htmlProjectmap
{
	function _display($hidden_vars, $sFunction)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$objProject = CreateObject('dcl.htmlProjects');

		$Template = CreateTemplate(array('hForm' => 'htmlProjectmapForm.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_FUNCTION', $sFunction);

		$Template->set_var('HIDDEN_VARS', $hidden_vars);
		$Template->set_var('TXT_CHOOSEPRJ', STR_PM_CHOOSEPRJ);
		$Template->set_var('CMB_PROJECT', $objProject->GetCombo(0, 'projectid', 0, 0, -1, true));
		$Template->set_var('TXT_ADDALLSEQ', STR_PM_ADDALLSEQ);
		$Template->set_var('BTN_OK', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);

		$Template->pparse('out', 'hForm');
	}

	function ChooseProjectForJCN($jcn, $seq)
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$hidden_vars = GetHiddenVar('menuAction', 'boProjects.dbaddtoproject');
		$hidden_vars .= GetHiddenVar('jcn', $jcn);
		$hidden_vars .= GetHiddenVar('seq', $seq);

		$this->_display($hidden_vars, STR_PM_ADDTOPRJ);
	}

	function move()
	{
		global $dcl_info;
		
		commonHeader();

		if (!$GLOBALS['g_oSec']->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$hidden_vars = GetHiddenVar('menuAction', 'htmlProjectmap.submitMove');
		$hidden_vars .= GetHiddenVar('jcn', $jcn);
		$hidden_vars .= GetHiddenVar('seq', $seq);

		$this->_display($hidden_vars, 'Move Work Order to Another Project');
	}

	function batchMove()
	{
		global $dcl_info;

		commonHeader();
		$_SRC = GetSourceArray();

		if (!$GLOBALS['g_oSec']->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$hidden_vars = GetHiddenVar('menuAction', 'htmlProjectmap.submitBatchMove');
		if (IsSet($GLOBALS[$_SRC]['selected']) && is_array($GLOBALS[$_SRC]['selected']) && count($GLOBALS[$_SRC]['selected']) > 0)
		{
			reset($GLOBALS[GetSourceArray()]['selected']);
			while (list($key, $val) = each($GLOBALS[$_SRC]['selected']))
			{
				$hidden_vars .= GetHiddenVar('selected[]', $val);
			}

			$this->_display($hidden_vars, 'Batch Move Work Orders to Another Project');

			$obj = CreateObject('dcl.htmlTimeCards');
			$obj->ShowBatchWO();
		}
		else
			return PrintPermissionDenied();
	}

	function submitMove()
	{
		global $dcl_info;

		commonHeader();

		if (!$GLOBALS['g_oSec']->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		CleanVars('HTTP_POST_VARS');
		$o = CreateObject('dcl.boProjects');
		$o->move($GLOBALS['HTTP_POST_VARS']);
	}

	function submitBatchMove()
	{
		global $dcl_info;

		commonHeader();

		if (!$GLOBALS['g_oSec']->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$o = CreateObject('dcl.boProjects');
		$o->batchMove($GLOBALS['HTTP_POST_VARS']);
		unset($o);

		$o = CreateObject('dcl.htmlProjectsdetail');
		if (!IsSet($GLOBALS['wostatus']))
			$GLOBALS['wostatus'] = 0;

		if (!IsSet($GLOBALS['woresponsible']))
			$GLOBALS['woresponsible'] = 0;

		$o->show($GLOBALS['projectid'], $GLOBALS['wostatus'], $GLOBALS['woresponsible']);
	}
}
?>
