<?php
/*
 * $Id: class.htmlFaq.inc.php,v 1.3.2.1.2.2 2003/01/26 18:59:27 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('faq');

class htmlFaq
{
	function DisplayForm($obj = '')
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ASSIGN_WO']))
			return PrintPermissionDenied();

		$isEdit = is_object($obj);
		$Template = CreateTemplate(array('hForm' => 'htmlFaqForm.tpl'));

		if ($isEdit)
		{
			$Template->set_var('TXT_TITLE', STR_FAQ_EDIT);
			$Template->set_var('VAL_NAME', htmlspecialchars($obj->name));
			$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->description));
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo($obj->active, 'active', 0, false));
			$hiddenvars = '<input type="hidden" name="menuAction" value="boFaq.dbmodify">' .
				'<input type="hidden" name="faqid" value="' . $obj->faqid . '">';
		}
		else
		{
			$Template->set_var('CMB_ACTIVE', GetYesNoCombo('Y', 'active', 0, false));
			$Template->set_var('TXT_TITLE', STR_FAQ_ADDNEW);
			$Template->set_var('VAL_NAME', '');
			$Template->set_var('VAL_DESCRIPTION', '');
			$hiddenvars = '<input type="hidden" name="menuAction" value="boFaq.dbadd">';
		}

		$Template->set_var('HIDDEN_VARS', $hiddenvars);
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('TXT_ACTIVE', STR_CMMN_ACTIVE);
		$Template->set_var('TXT_NAME', STR_FAQ_NAME);
		$Template->set_var('TXT_DESCRIPTION', STR_FAQ_DESCRIPTION);
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_RESET', STR_CMMN_RESET);
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', STR_FAQ_HIGHLIGHTEDNOTE);

		$Template->pparse('out', 'hForm');
	}

	function ExecuteSearch($searchFld, $searchText) {}

	function ShowAll($orderBy = 'name')
	{
		global $dcl_info;

		$obj = CreateObject('dcl.dbFaq');
		$obj->Connect();
		$query = "SELECT faqid,active,name,createby,createon,modifyby,modifyon FROM faq ORDER BY $orderBy";
		$obj->Query($query);
		$allRecs = $obj->FetchAllRows();

		if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
			$titleLink = '<a class="adark" href="' . menuLink('', 'menuAction=boFaq.add') . '">[ ' . STR_FAQ_NEW . ' ]</a>';
		else
			$titleLink = '';

		if (count($allRecs) > 0)
		{
			$objP = CreateObject('dcl.dbPersonnel');
			$objP->Connect($obj->conn);
			for ($i = 0; $i < count($allRecs); $i++)
			{
				if ($allRecs[$i][3] > 0 && $objP->Load($allRecs[$i][3]) != -1)
					$allRecs[$i][3] = $objP->f('short');

				if ($allRecs[$i][5] > 0 && $objP->Load($allRecs[$i][5]) != -1)
					$allRecs[$i][5] = $objP->f('short');

				$allRecs[$i][4] = $obj->FormatTimestampForDisplay($allRecs[$i][4]);
				$allRecs[$i][6] = $obj->FormatTimestampForDisplay($allRecs[$i][6]);
			}

			$allName = array(
					0 => STR_FAQ_ID, 
					1 => STR_FAQ_ACCT, 
					2 => STR_FAQ_NAME, 
					3 => STR_FAQ_CREATEDBY, 
					4 => STR_FAQ_CREATEDON,
					5 => STR_FAQ_MODIFIEDBY, 
					6 => STR_FAQ_MODIFIEDON);

			if (count($allRecs) > 0)
			{
				$allName[] = STR_FAQ_OPTIONS;
				for ($i = 0; $i < count($allRecs); $i++)
				{
					$options = '<a class="adark" href="' . menuLink('', 'menuAction=boFaq.view&faqid=' . $allRecs[$i][0]) . '">' . STR_CMMN_VIEW . '</a>';
					if ($GLOBALS['SEC'] >= $dcl_info['DCL_ADD_USER'])
					{
						$options .= '&nbsp;';
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boFaq.modify&faqid=' . $allRecs[$i][0]) . '">' . STR_CMMN_EDIT . '</a>';
						$options .= "&nbsp;";
						$options .= '<a class="adark" href="' . menuLink('', 'menuAction=boFaq.delete&faqid=' . $allRecs[$i][0]) . '">' . STR_CMMN_DELETE . '</a>';
					}
					$allRecs[$i][] = $options;
				}
			}

			PrintArrayAsChocoTable($allName, $allRecs, sprintf(STR_FAQ_ORDEREDBY, $orderBy), '', $titleLink);
		}
		else
		{
			print('<CENTER>');
			print(STR_FAQ_NOTFOUND . '&nbsp;&nbsp;' . $titleLink);
			print('</CENTER>');
		}
	}

	function ShowFaq($obj)
	{
		global $dcl_info;

		if (!is_object($obj))
		{
			print('<p><center>');
			PrintWithChocoFont(STR_FAQ_NOOBJECT);
			print('</center>');
			return;
		}

		$Template = CreateTemplate(array('hForm' => 'htmlFaqDetail.tpl'));
		$Template->set_block('hForm', 'topics', 'hTopics');
		$Template->set_block('hForm', 'notopics', 'hNoTopics');
		$Template->set_var('hTopics', '');
		$Template->set_var('hNoTopics', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_NAME', sprintf(STR_FAQ_FAQNAME, htmlspecialchars($obj->name)));
		$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->description));
		$Template->set_var('TXT_TOPICS', STR_FAQ_TOPICS);
		$Template->set_var('VAL_FAQID', $obj->faqid);
		$Template->set_var('VAL_ADDTOPICLINK', menuLink('', 'menuAction=boFaqtopics.add&faqid=' . $obj->faqid));
		$Template->set_var('TXT_NEW', STR_FAQ_NEW);

		$objF = CreateObject("dcl.dbFaqtopics");
		$objF->Connect($obj->conn);
		$objF->LoadByFaqID($obj->faqid);
		if ($objF->next_record())
		{
			$i = 0;
			do
			{
				if ($i++ % 2 == 0)
					$Template->set_var('ROW_COLOR', '#ffffff');
				else
					$Template->set_var('ROW_COLOR', $dcl_info['DCL_COLOR_LIGHT']);

				$Template->set_var('VAL_NUM', $i);
				$Template->set_var('VAL_VIEWTOPICLINK', menuLink('', 'menuAction=boFaqtopics.view&topicid=' . $objF->f('topicid')));
				$Template->set_var('VAL_TOPICID', $objF->f('topicid'));
				$Template->set_var('VAL_TOPICNAME', htmlspecialchars($objF->f('name')));
				$Template->parse('hTopics', 'topics', true);
			}
			while ($objF->next_record());
		}
		else
		{
			$Template->set_var('TXT_NOTOPICS', STR_FAQ_NOTOPICS);
			$Template->parse('hNoTopics', 'notopics');
		}

		$Template->pparse('out', 'hForm');
	}
}
?>
