<?php
/*
 * $Id: class.htmlConfig.inc.php,v 1.3.2.3.2.9 2003/12/28 19:41:15 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('cfg');

class htmlConfig
{
	function Show()
	{
		global $dcl_info;

		if (!$GLOBALS['g_oSec']->HasSecLvl($GLOBALS['dcl_info']['DCL_ADD_USER']))
			return PrintPermissionDenied();

		$Template = CreateTemplate(array('hForm' => 'htmlConfig.tpl'));
		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);
		$Template->set_var('VAL_BACKLINK', menuLink('', 'menuAction=boAdmin.ShowSystemConfig'));
		$Template->set_var('VAL_FORMACTION', menuLink());
		$Template->set_var('BTN_SAVE', STR_CMMN_SAVE);
		$Template->set_var('BTN_CANCEL', STR_CMMN_CANCEL);
		$Template->set_var('IMG_RIGHT', 'img/false.gif');
		$Template->set_var('IMG_DOWN', 'img/true.gif');

		$Template->set_var('TXT_CONFIGTITLE', STR_CFG_TITLE);
		$Template->set_var('TXT_CONFIGDESC', STR_CFG_DESC);
		$Template->set_var('VAL_SYSTEMSETUPHREF', menuLink('', 'menuAction=boAdmin.ShowSystemConfig'));
		$Template->set_var('TXT_SYSTEMSETUP', DCL_MENU_SYSTEMSETUP);

		// System
		$Template->set_var('TXT_SYSTEMTITLE', STR_CFG_SYSTEMTITLE);
		$Template->set_var('TXT_DATEFORMAT', STR_CFG_DATEFORMAT);
		$Template->set_var('TXT_DATEFORMATDB', STR_CFG_DATEFORMATDB);
		$Template->set_var('TXT_TIMESTAMPFORMAT', STR_CFG_TIMESTAMPFORMAT);
		$Template->set_var('TXT_TIMESTAMPFORMATDB', STR_CFG_TIMESTAMPFORMATDB);
		$Template->set_var('TXT_MAXUPLOADFILESIZE', STR_CFG_MAXUPLOADFILESIZE);
		$Template->set_var('TXT_LANGUAGE', STR_CFG_LANGUAGE);
		$Template->set_var('TXT_PRIVATEKEY', STR_CFG_PRIVATEKEY);
		$Template->set_var('TXT_HTMLTITLE', STR_CFG_HTMLTITLE);
		$Template->set_var('TXT_FILEPATH', STR_CFG_FILEPATH);
		$Template->set_var('TXT_ROOT', STR_CFG_ROOT);
		$Template->set_var('TXT_GDTYPE', STR_CFG_GDTYPE);
		$Template->set_var('TXT_SESSIONTIMEOUT', STR_CFG_SESSIONTIMEOUT);

		$Template->set_var('CMB_DATEFORMAT', $this->GetDateCombo('DCL_DATE_FORMAT', $dcl_info['DCL_DATE_FORMAT']));
		$Template->set_var('CMB_DATEFORMATDB', $this->GetDateCombo('DCL_DATE_FORMAT_DB', $dcl_info['DCL_DATE_FORMAT_DB']));
		$Template->set_var('CMB_TIMESTAMPFORMAT', $this->GetTimestampCombo('DCL_TIMESTAMP_FORMAT', $dcl_info['DCL_TIMESTAMP_FORMAT']));
		$Template->set_var('CMB_TIMESTAMPFORMATDB', $this->GetTimestampCombo('DCL_TIMESTAMP_FORMAT_DB', $dcl_info['DCL_TIMESTAMP_FORMAT_DB']));
		$Template->set_var('VAL_MAXUPLOADFILESIZE', $dcl_info['DCL_MAX_UPLOAD_FILE_SIZE']);
		$Template->set_var('CMB_DEFAULT_LANGUAGE', $this->GetLangCombo('DCL_DEFAULT_LANGUAGE', $dcl_info['DCL_DEFAULT_LANGUAGE']));
		$Template->set_var('VAL_PRIVATEKEY', $dcl_info['DCL_PRIVATE_KEY']);
		$Template->set_var('VAL_HTMLTITLE', $dcl_info['DCL_HTML_TITLE']);
		$Template->set_var('VAL_FILEPATH', $dcl_info['DCL_FILE_PATH']);
		$Template->set_var('VAL_ROOT', $dcl_info['DCL_ROOT']);
		$Template->set_var('CMB_GDTYPE', $this->GetGraphicsCombo('DCL_GD_TYPE', $dcl_info['DCL_GD_TYPE']));
		$Template->set_var('VAL_SESSIONTIMEOUT', $dcl_info['DCL_SESSION_TIMEOUT']);

		// SMTP Server Settings
		$Template->set_var('TXT_EMAILSERVERTITLE', STR_CFG_EMAILSERVERTITLE);
		$Template->set_var('TXT_SMTPENABLED', STR_CFG_SMTPENABLED);
		$Template->set_var('TXT_SMTPSERVER', STR_CFG_SMTPSERVER);
		$Template->set_var('TXT_SMTPPORT', STR_CFG_SMTPPORT);
		$Template->set_var('TXT_SMTPTIMEOUT', STR_CFG_SMTPTIMEOUT);
		$Template->set_var('TXT_SMTPDEFAULTEMAIL', 'Default e-Mail Address (Used If Not Supplied)*');

		$Template->set_var('VAL_SMTPENABLED', $dcl_info['DCL_SMTP_ENABLED'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_SMTPSERVER', $dcl_info['DCL_SMTP_SERVER']);
		$Template->set_var('VAL_SMTPPORT', $dcl_info['DCL_SMTP_PORT']);
		$Template->set_var('VAL_SMTPTIMEOUT', $dcl_info['DCL_SMTP_TIMEOUT']);
		$Template->set_var('VAL_SMTPDEFAULTEMAIL', $dcl_info['DCL_SMTP_DEFAULT_EMAIL']);

		// Look and feel
		$Template->set_var('TXT_LOOKNFEELTITLE', STR_CFG_LOOKNFEELTITLE);
		$Template->set_var('TXT_DEFTEMPLATESET', STR_CFG_DEFTEMPLATESET);
		$Template->set_var('TXT_COLORDARK', STR_CFG_COLORDARK);
		$Template->set_var('TXT_COLORLIGHT', STR_CFG_COLORLIGHT);

		$Template->set_var('CMB_DEFTEMPLATESET', $this->GetTemplatesCombo('DCL_DEF_TEMPLATE_SET', $dcl_info['DCL_DEF_TEMPLATE_SET']));

		// Security
		$Template->set_var('TXT_SECURITYTITLE', STR_CFG_SECURITYTITLE);
		$Template->set_var('TXT_ADDUSER', STR_CFG_ADDUSER);
		$Template->set_var('TXT_DELWO', STR_CFG_DELWO);
		$Template->set_var('TXT_MODWO', STR_CFG_MODWO);
		$Template->set_var('TXT_ASSIGNWO', STR_CFG_ASSIGNWO);
		$Template->set_var('TXT_HAVEWO', STR_CFG_HAVEWO);
		$Template->set_var('TXT_ADDWO', STR_CFG_ADDWO);
		$Template->set_var('TXT_CHGPWD', STR_CFG_CHGPWD);

		$Template->set_var('CMB_ADDUSER', $this->GetSecurityCombo('DCL_ADD_USER', $dcl_info['DCL_ADD_USER']));
		$Template->set_var('CMB_DELWO', $this->GetSecurityCombo('DCL_DEL_WO', $dcl_info['DCL_DEL_WO']));
		$Template->set_var('CMB_MODWO', $this->GetSecurityCombo('DCL_MOD_WO', $dcl_info['DCL_MOD_WO']));
		$Template->set_var('CMB_ASSIGNWO', $this->GetSecurityCombo('DCL_ASSIGN_WO', $dcl_info['DCL_ASSIGN_WO']));
		$Template->set_var('CMB_HAVEWO', $this->GetSecurityCombo('DCL_HAVE_WO', $dcl_info['DCL_HAVE_WO']));
		$Template->set_var('CMB_ADDWO', $this->GetSecurityCombo('DCL_ADD_WO', $dcl_info['DCL_ADD_WO']));
		$Template->set_var('CMB_CHGPWD', $this->GetSecurityCombo('DCL_CHG_PWD', $dcl_info['DCL_CHG_PWD']));

		// Work Orders
		$Template->set_var('TXT_WORKORDERTITLE', STR_CFG_WORKORDERTITLE);
		$Template->set_var('TXT_DEFAULTSTATUSASSIGN', STR_CFG_DEFAULTSTATUSASSIGN);
		$Template->set_var('TXT_DEFAULTSTATUSUNASSIGN', STR_CFG_DEFAULTSTATUSUNASSIGN);
		$Template->set_var('TXT_DEFAULTPRIORITY', STR_CFG_DEFAULTPRIORITY);
		$Template->set_var('TXT_DEFAULTSEVERITY', STR_CFG_DEFAULTSEVERITY);
		$Template->set_var('TXT_AUTODATE', STR_CFG_AUTODATE);
		$Template->set_var('TXT_TIMECARDORDER', STR_CFG_TIMECARDORDER);
		$Template->set_var('TXT_WONOTIFICATIONHTML', 'Send Work Order Notifications as HTML*');
		$Template->set_var('TXT_WOEMAILTEMPLATE', 'Work Order Notification Template (templates/custom dir)*');
		$Template->set_var('TXT_WOSECONDARYACCOUNTSENABLED', 'Allow Mutiple Accounts Per Work Order (Not Compatible With MySQL)');

		$Template->set_var('CMB_DEFAULTSTATUSASSIGN', $this->GetStatusCombo('DCL_DEF_STATUS_ASSIGN_WO', $dcl_info['DCL_DEF_STATUS_ASSIGN_WO']));
		$Template->set_var('CMB_DEFAULTSTATUSUNASSIGN', $this->GetStatusCombo('DCL_DEF_STATUS_UNASSIGN_WO', $dcl_info['DCL_DEF_STATUS_UNASSIGN_WO']));
		$Template->set_var('CMB_DEFAULTPRIORITY', $this->GetPriorityCombo('DCL_DEF_PRIORITY', $dcl_info['DCL_DEF_PRIORITY']));
		$Template->set_var('CMB_DEFAULTSEVERITY', $this->GetSeverityCombo('DCL_DEF_SEVERITY', $dcl_info['DCL_DEF_SEVERITY']));
		$Template->set_var('VAL_AUTODATE', $dcl_info['DCL_AUTO_DATE'] == 'Y' ? ' checked' : '');
		$Template->set_var('CMB_TIMECARDORDER', $this->GetDisplayOrderCombo('DCL_TIME_CARD_ORDER', $dcl_info['DCL_TIME_CARD_ORDER']));
		$Template->set_var('VAL_WONOTIFICATIONHTML', $dcl_info['DCL_WO_NOTIFICATION_HTML'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_WOEMAILTEMPLATE', $dcl_info['DCL_WO_EMAIL_TEMPLATE']);
		$Template->set_var('VAL_WOSECONDARYACCOUNTSENABLED', $dcl_info['DCL_WO_SECONDARY_ACCOUNTS_ENABLED'] == 'Y' ? ' checked' : '');

		// Projects
		$Template->set_var('TXT_PROJECTTITLE', STR_CFG_PROJECTTITLE);
		$Template->set_var('TXT_DCLPROJECTXMLTEMPLATES', STR_CFG_DCLPROJECTXMLTEMPLATES);
		$Template->set_var('TXT_DCLPROJECTINCLUDECHILDSTATS', STR_CFG_DCLPROJECTINCLUDECHILDSTATS);
		$Template->set_var('TXT_DCLPROJECTINCLUDEPARENTSTATS', STR_CFG_DCLPROJECTINCLUDEPARENTSTATS);
		$Template->set_var('TXT_DCLPROJECTBROWSEPARENTSONLY', STR_CFG_DCLPROJECTBROWSEPARENTSONLY);
		$Template->set_var('TXT_DCLDEFAULTPROJECTSTATUS', STR_CFG_DCLDEFAULTPROJECTSTATUS);

		$Template->set_var('VAL_PRJXMLTMPL', $dcl_info['DCL_PROJECT_XML_TEMPLATES'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_PRJCHLDSTATS', $dcl_info['DCL_PROJECT_INCLUDE_CHILD_STATS'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_PRJPRNTSTATS', $dcl_info['DCL_PROJECT_INCLUDE_PARENT_STATS'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_PRJBROWSEPARENTSONLY', $dcl_info['DCL_PROJECT_BROWSE_PARENTS_ONLY'] == 'Y' ? ' checked' : '');
		$Template->set_var('CMB_DEFAULTPROJECTSTATUS', $this->GetStatusCombo('DCL_DEFAULT_PROJECT_STATUS', $dcl_info['DCL_DEFAULT_PROJECT_STATUS']));

		// Tickets
		$Template->set_var('TXT_TICKETTITLE', STR_CFG_TICKETTITLE);
		$Template->set_var('TXT_CQQPERCENT', STR_CFG_CQQPERCENT);
		$Template->set_var('TXT_CQQFROM', STR_CFG_CQQFROM);
		$Template->set_var('TXT_CQQSUBJECT', STR_CFG_CQQSUBJECT);
		$Template->set_var('TXT_CQQTEMPLATE', STR_CFG_CQQTEMPLATE);
		$Template->set_var('TXT_DCLDEFAULTTICKETSTATUS', STR_CFG_DCLDEFAULTTICKETSTATUS);
		$Template->set_var('TXT_TCKNOTIFICATIONHTML', 'Send Ticket Notifications as HTML*');
		$Template->set_var('TXT_TCKEMAILTEMPLATE', 'Ticket Notification Template (templates/custom dir)*');

		$Template->set_var('CMB_CQQPERCENT', $this->GetPercentCombo('DCL_CQQ_PERCENT', $dcl_info['DCL_CQQ_PERCENT']));
		$Template->set_var('VAL_CQQFROM', $dcl_info['DCL_CQQ_FROM']);
		$Template->set_var('VAL_CQQSUBJECT', $dcl_info['DCL_CQQ_SUBJECT']);
		$Template->set_var('VAL_CQQTEMPLATE', $dcl_info['DCL_CQQ_TEMPLATE']);
		$Template->set_var('CMB_DEFAULTTICKETSTATUS', $this->GetStatusCombo('DCL_DEFAULT_TICKET_STATUS', $dcl_info['DCL_DEFAULT_TICKET_STATUS']));
		$Template->set_var('VAL_TCKNOTIFICATIONHTML', $dcl_info['DCL_TCK_NOTIFICATION_HTML'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_TCKEMAILTEMPLATE', $dcl_info['DCL_TCK_EMAIL_TEMPLATE']);

		// Wiki
		$Template->set_var('TXT_WIKI', STR_CFG_WIKI);
		$Template->set_var('TXT_WIKIENABLED', STR_CFG_WIKIENABLED);
		$Template->set_var('TXT_WIKIVIEWLEVEL', STR_CFG_WIKIVIEWLEVEL);
		$Template->set_var('TXT_WIKIEDITLEVEL', STR_CFG_WIKIEDITLEVEL);

		$Template->set_var('VAL_WIKIENABLED', $dcl_info['DCL_WIKI_ENABLED'] == 'Y' ? ' checked' : '');
		$Template->set_var('CMB_WIKIVIEW', $this->GetSecurityCombo('DCL_WIKI_VIEW', $dcl_info['DCL_WIKI_VIEW']));
		$Template->set_var('CMB_WIKIEDIT', $this->GetSecurityCombo('DCL_WIKI_EDIT', $dcl_info['DCL_WIKI_EDIT']));

		// e-Mail Gateway for Tickets
		$Template->set_var('TXT_GATEWAYTICKETTITLE', STR_CFG_GATEWAYTICKETTITLE);
		$Template->set_var('TXT_GATEWAYTICKETENABLED', STR_CFG_GATEWAYTICKETENABLED);
		$Template->set_var('TXT_GATEWAYTICKETAUTORESPOND', STR_CFG_GATEWAYTICKETAUTORESPOND);
		$Template->set_var('TXT_GATEWAYTICKETAUTORESPONSEEMAIL', STR_CFG_GATEWAYTICKETAUTORESPONSEEMAIL);
		$Template->set_var('TXT_GATEWAYTICKETREPLY', STR_CFG_GATEWAYTICKETREPLY);
		$Template->set_var('TXT_GATEWAYTICKETSTATUS', STR_CFG_GATEWAYTICKETSTATUS);
		$Template->set_var('TXT_GATEWAYTICKETPRIORITY', STR_CFG_GATEWAYTICKETPRIORITY);
		$Template->set_var('TXT_GATEWAYTICKETSEVERITY', STR_CFG_GATEWAYTICKETSEVERITY);
		$Template->set_var('TXT_GATEWAYTICKETFILEPATH', STR_CFG_GATEWAYTICKETFILEPATH);
		$Template->set_var('TXT_GATEWAYTICKETACCOUNT', STR_CFG_GATEWAYTICKETACCOUNT);
		$Template->set_var('TXT_GATEWAYTICKETREPLYLOGGEDBY', STR_CFG_GATEWAYTICKETREPLYLOGGEDBY);

		$Template->set_var('VAL_GATEWAYTICKETENABLED', $dcl_info['DCL_GATEWAY_TICKET_ENABLED'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_GATEWAYTICKETAUTORESPOND', $dcl_info['DCL_GATEWAY_TICKET_AUTORESPOND'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_GATEWAYTICKETAUTORESPONSEEMAIL', $dcl_info['DCL_GATEWAY_TICKET_AUTORESPONSE_EMAIL']);
		$Template->set_var('VAL_GATEWAYTICKETREPLY', $dcl_info['DCL_GATEWAY_TICKET_REPLY'] == 'Y' ? ' checked' : '');
		$Template->set_var('CMB_GATEWAYTICKETSTATUS', $this->GetStatusCombo('DCL_GATEWAY_TICKET_STATUS', $dcl_info['DCL_GATEWAY_TICKET_STATUS']));
		$Template->set_var('CMB_GATEWAYTICKETPRIORITY', $this->GetPriorityCombo('DCL_GATEWAY_TICKET_PRIORITY', $dcl_info['DCL_GATEWAY_TICKET_PRIORITY']));
		$Template->set_var('CMB_GATEWAYTICKETSEVERITY', $this->GetSeverityCombo('DCL_GATEWAY_TICKET_SEVERITY', $dcl_info['DCL_GATEWAY_TICKET_SEVERITY']));
		$Template->set_var('CMB_GATEWAYTICKETACCOUNT', $this->GetAccountCombo('DCL_GATEWAY_TICKET_ACCOUNT', $dcl_info['DCL_GATEWAY_TICKET_ACCOUNT']));
		$Template->set_var('CMB_GATEWAYTICKETREPLYLOGGEDBY', $this->GetPersonnelCombo('DCL_GATEWAY_TICKET_REPLY_LOGGED_BY', $dcl_info['DCL_GATEWAY_TICKET_REPLY_LOGGED_BY']));
		$Template->set_var('VAL_GATEWAYTICKETFILEPATH', $dcl_info['DCL_GATEWAY_TICKET_FILE_PATH']);

		// e-Mail Gateway for Work Orders
		$Template->set_var('TXT_GATEWAYWOTITLE', STR_CFG_GATEWAYWOTITLE);
		$Template->set_var('TXT_GATEWAYWOENABLED', STR_CFG_GATEWAYWOENABLED);
		$Template->set_var('TXT_GATEWAYWOAUTORESPOND', STR_CFG_GATEWAYWOAUTORESPOND);
		$Template->set_var('TXT_GATEWAYWOAUTORESPONSEEMAIL', STR_CFG_GATEWAYWOAUTORESPONSEEMAIL);
		$Template->set_var('TXT_GATEWAYWOREPLY', STR_CFG_GATEWAYWOREPLY);
		$Template->set_var('TXT_GATEWAYWOSTATUS', STR_CFG_GATEWAYWOSTATUS);
		$Template->set_var('TXT_GATEWAYWOPRIORITY', STR_CFG_GATEWAYWOPRIORITY);
		$Template->set_var('TXT_GATEWAYWOSEVERITY', STR_CFG_GATEWAYWOSEVERITY);
		$Template->set_var('TXT_GATEWAYWOFILEPATH', STR_CFG_GATEWAYWOFILEPATH);

		$Template->set_var('VAL_GATEWAYWOENABLED', $dcl_info['DCL_GATEWAY_WO_ENABLED'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_GATEWAYWOAUTORESPOND', $dcl_info['DCL_GATEWAY_WO_AUTORESPOND'] == 'Y' ? ' checked' : '');
		$Template->set_var('VAL_GATEWAYWOAUTORESPONSEEMAIL', $dcl_info['DCL_GATEWAY_WO_AUTORESPONSE_EMAIL']);
		$Template->set_var('VAL_GATEWAYWOREPLY', $dcl_info['DCL_GATEWAY_WO_REPLY'] == 'Y' ? ' checked' : '');
		$Template->set_var('CMB_GATEWAYWOSTATUS', $this->GetStatusCombo('DCL_GATEWAY_WO_STATUS', $dcl_info['DCL_GATEWAY_WO_STATUS']));
		$Template->set_var('CMB_GATEWAYWOPRIORITY', $this->GetPriorityCombo('DCL_GATEWAY_WO_PRIORITY', $dcl_info['DCL_GATEWAY_WO_PRIORITY']));
		$Template->set_var('CMB_GATEWAYWOSEVERITY', $this->GetSeverityCombo('DCL_GATEWAY_WO_SEVERITY', $dcl_info['DCL_GATEWAY_WO_SEVERITY']));
		$Template->set_var('VAL_GATEWAYWOFILEPATH', $dcl_info['DCL_GATEWAY_WO_FILE_PATH']);

		// SCCS Integration
		$Template->set_var('TXT_SCCS', 'SCCS Integration');
		$Template->set_var('TXT_SCCSENABLED', 'SCCS Integration Enabled');

		$Template->set_var('VAL_SCCSENABLED', $dcl_info['DCL_SCCS_ENABLED'] == 'Y' ? ' checked' : '');

		$Template->pparse('out', 'hForm');
	}

	function _GetCombo($sName, $aOptions, $sDefault)
	{
		$retVal = '<select name="' . $sName . '">';

		if (is_array($aOptions))
		{
			reset($aOptions);
			while (list($key, $val) = each($aOptions))
			{
				$retVal .= '<option value="' . $key . '"';
				if ($key == $sDefault)
					$retVal .= ' selected';

				$retVal .= '>' . $val . '</option>';
			}
		}

		$retVal .= '</select>';

		return $retVal;
	}

	function GetDateCombo($sName, $sDefault)
	{
		$aOptions = array(
				'm/d/Y' => 'mm/dd/yyyy',
				'd/m/Y' => 'dd/mm/yyyy',
				'm.d.Y' => 'mm.dd.yyyy',
				'd.m.Y' => 'dd.mm.yyyy',
				'm-d-Y' => 'mm-dd-yyyy',
				'd-m-Y' => 'dd-mm-yyyy',
				'Y/m/d' => 'yyyy/mm/dd',
				'Y.m.d' => 'yyyy.mm.dd',
				'Y-m-d' => 'yyyy-mm-dd',
				'Ymd' => 'yyyymmdd'
			);

		return $this->_GetCombo($sName, $aOptions, $sDefault);
	}

	function GetTimestampCombo($sName, $sDefault)
	{
		$aOptions = array(
				'm/d/Y H:i:s' => 'mm/dd/yyyy hh:mm:ss',
				'd/m/Y H:i:s' => 'dd/mm/yyyy hh:mm:ss',
				'm.d.Y H:i:s' => 'mm.dd.yyyy hh:mm:ss',
				'd.m.Y H:i:s' => 'dd.mm.yyyy hh:mm:ss',
				'm-d-Y H:i:s' => 'mm-dd-yyyy hh:mm:ss',
				'd-m-Y H:i:s' => 'dd-mm-yyyy hh:mm:ss',
				'Y/m/d H:i:s' => 'yyyy/mm/dd hh:mm:ss',
				'Y.m.d H:i:s' => 'yyyy.mm.dd hh:mm:ss',
				'Y-m-d H:i:s' => 'yyyy-mm-dd hh:mm:ss',
				'YmdHis' => 'yyyymmddhhmmss'
			);

		return $this->_GetCombo($sName, $aOptions, $sDefault);
	}

	function GetLangCombo($sName, $sDefault)
	{
		$aOptions = array(
				'en' => 'English',
				'fr' => 'French',
				'de' => 'German',
				'it' => 'Italian',
				'ru' => 'Russian',
				'es' => 'Spanish',
				'sl' => 'Slovenina',
				'sv' => 'Swedish'
			);

		return $this->_GetCombo($sName, $aOptions, $sDefault);
	}

	function GetGraphicsCombo($sName, $sDefault)
	{
		$aOptions = array(
				'gif' => 'GIF&nbsp;&nbsp;',
				'png' => 'PNG&nbsp;&nbsp;',
				'jpeg' => 'JPEG&nbsp;&nbsp;'
			);

		return $this->_GetCombo($sName, $aOptions, $sDefault);
	}

	function GetTemplatesCombo($sName, $sDefault)
	{
		$aOptions = array();
		$sPath = './templates/';
		if (is_dir($sPath) && $hDir = opendir($sPath))
		{
			while ($fileName = readdir($hDir))
				if (is_dir($sPath . $fileName) && $fileName != '.' && $fileName != '..' && $fileName != 'CVS' && $fileName != 'custom')
					$aOptions[$fileName] = $fileName;

			if ($hDir)
				closedir($hDir);
		}

		return $this->_GetCombo($sName, $aOptions, $sDefault);
	}

	function GetSecurityCombo($sName, $sDefault)
	{
		$aOptions = array();
		for ($i = 1; $i < 10; $i++)
			$aOptions[strval($i)] = 'Level ' . $i;

		return $this->_GetCombo($sName, $aOptions, $sDefault);
	}

	function GetStatusCombo($sName, $sDefault)
	{
		$o = CreateObject('dcl.htmlStatuses');
		return $o->GetCombo(intval($sDefault), $sName);
	}

	function GetPriorityCombo($sName, $sDefault)
	{
		$o = CreateObject('dcl.htmlPriorities');
		return $o->GetCombo(intval($sDefault), $sName);
	}

	function GetSeverityCombo($sName, $sDefault)
	{
		$o = CreateObject('dcl.htmlSeverities');
		return $o->GetCombo(intval($sDefault), $sName);
	}

	function GetAccountCombo($sName, $sDefault)
	{
		$o = CreateObject('dcl.htmlAccounts');
		return $o->GetCombo(intval($sDefault), $sName);
	}

	function GetPersonnelCombo($sName, $sDefault)
	{
		$o = CreateObject('dcl.htmlPersonnel');
		return $o->GetCombo(intval($sDefault), $sName);
	}

	function GetDisplayOrderCombo($sName, $sDefault)
	{
		$aOptions = array(
				'ASC' => 'Oldest First',
				'DESC' => 'Newest First'
			);

		return $this->_GetCombo($sName, $aOptions, $sDefault);
	}

	function GetPercentCombo($sName, $sDefault)
	{
		$aOptions = array();
		for ($i = 0; $i < 100; $i += 5)
			$aOptions[strval($i)] = $i . '%';

		$aOptions['101'] = '100%'; // PHP3 and 4 are off from each other in rand, so 101 covers both

		return $this->_GetCombo($sName, $aOptions, $sDefault);
	}
}
?>
