<?php
/*
 * $Id: class.htmlChecklistTplView.inc.php,v 1.1.2.1 2003/12/10 05:54:54 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('chk');
import('htmlView');
class htmlChecklistTplView extends htmlView
{
	function htmlChecklistTplView()
	{
		parent::htmlView();
		$this->sColumnTitle = STR_CMMN_OPTIONS;
		$this->sSortAction = 'htmlChecklistTplView.execurl';
	}
	
	function _SetActionFormOptions()
	{
		$aLinks = array(
				STR_CMMN_BROWSE => menuLink('', 'menuAction=boChecklists.show'),
				STR_CHK_TEMPLATES => menuLink('', 'menuAction=boChecklistTpl.show'),
				STR_CHK_NEWTEMPLATE => menuLink('', 'menuAction=boChecklistTpl.add')
			);

		$this->_SetVar('hActionLinkSetLinks', '');
		$bFirst = true;
		foreach ($aLinks as $sText => $sLink)
		{
			if ($bFirst)
				$bFirst = false;
			else
				$this->Template->parse('hActionLinkSetLinks', 'actionLinkSetSep', true);

			$this->_SetVar('LNK_ACTIONVALUE', $sLink);
			$this->_SetVar('VAL_ACTIONVALUE', $sText);
			$this->Template->parse('hActionLinkSetLinks', 'actionLinkSetLink', true);
		}
		
		$this->Template->parse('hActionLinkSet', 'actionLinkSet');
		$this->Template->parse('hActions', 'actions');
	}

	function _DisplayOptions()
	{
		global $dcl_info, $g_oSec;
		
		$this->_SetVar('hDetailColumnLinkSetLinks', '');
		$id = $this->oDB->f('dcl_chklst_tpl_id');

		if ($g_oSec->HasSecLvl($dcl_info['DCL_ASSIGN_WO']))
			$this->_AddDisplayOption(STR_CHK_INITIATE, menuLink('', 'menuAction=boChecklists.add&dcl_chklst_tpl_id=' . $id), false, $this->oDB->f('dcl_chklst_tpl_active') != 'Y');
		
		$this->_AddDisplayOption(STR_CMMN_VIEW, menuLink('', 'menuAction=boChecklistTpl.view&dcl_chklst_tpl_id=' . $id), true);

		if ($g_oSec->HasSecLvl($dcl_info['DCL_MOD_WO']))
			$this->_AddDisplayOption(STR_CMMN_EDIT, menuLink('', 'menuAction=boChecklistTpl.modify&dcl_chklst_tpl_id=' . $id), true);

		if ($g_oSec->HasSecLvl($dcl_info['DCL_DEL_WO']))
			$this->_AddDisplayOption(STR_CMMN_DELETE, menuLink('', 'menuAction=boChecklistTpl.delete&dcl_chklst_tpl_id=' . $id), true);

		$this->Template->parse('hDetailColumnLinkSet', 'detailColumnLinkSet');
		$this->Template->parse('hDetailCells', 'detailCells', true);

		// this avoids repeating cells
		$this->_ResetDetailCells();
	}
}
?>