<?php
/*
 * $Id: class.dbProjectmap.inc.php,v 1.3.4.2 2003/08/11 01:52:30 mdean Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */

LoadStringResource('db');
class dbProjectmap extends dclDB
{
	var $projectid;
	var $jcn;
	var $seq;

	function dbProjectmap()
	{
           // Table Fields
		$this->fieldArray = array('projectid', 'jcn', 'seq');

           // Foreign Keys
		$this->foreignKeys = array();

		$this->cacheEnabled = false;
		$this->dclDB();
	}

	function Add()
	{
		if ($this->conn == 0)
		{
			if(!$this->Connect())
				return -1;
		}

		$query  = 'INSERT INTO projectmap ';
		$query .= '(projectid,jcn,seq) VALUES (';
		$query .= $this->projectid . ',' . $this->jcn . ',' . $this->seq . ')';

		if ($this->Insert($query) == -1)
		{
			print(sprintf(STR_DB_PROJECTMAPINSERTERR, $query));
		}
	}

	function Edit()
	{
	}

	function Delete()
	{
		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$query = 'delete from projectmap where projectid=' . $this->projectid . ' and jcn=' . $this->jcn;
		if ($this->seq > 0)
			$query .= ' and seq=' . $this->seq;

		$this->Execute($query);
	}

	function GetRow()
	{
		if (!$this->res || count($this->Record) < 1)
			return -1;

		$this->projectid = $this->f('projectid');
		$this->jcn = $this->f('jcn');
		$this->seq = $this->f('seq');
	}

	function Load($projectid)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT b.projectid,a.jcn,a.seq FROM workorders a, projectmap b WHERE ';
		$sql .= "a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND b.projectid=$projectid ";
		$sql .= 'ORDER BY a.jcn,a.seq';
		if (!$this->Query($sql))
			return -1;

		if (!$this->next_record())
			return -1;

		return $this->GetRow();
	}

	function LoadFilter($projectid, $status, $responsible)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT b.projectid,a.jcn,a.seq FROM workorders a, projectmap b WHERE ';
		$sql .= "a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND b.projectid=$projectid ";

		if ($status > 0)
			$sql .= "AND a.status=$status ";

		if ($responsible > 0)
			$sql .= "AND a.responsible=$responsible ";

		$sql .= 'ORDER BY a.jcn,a.seq';
		if (!$this->Query($sql))
			return -1;

		return 1;
	}

	function GetProjectParents($projectid, $includethis = false)
	{
		if ($includethis == false){
			$this->Clear();

			if ($this->conn == 0)
			{
				if (!$this->Connect())
					return -1;
			}

			$projectids = '';
		}else{
			$projectids = $projectid;
		}
		if ($this->Query("SELECT parentprojectid FROM dcl_projects WHERE projectid =$projectid") != -1)
		{
			while ($this->next_record())
			{
				if($includethis)
					$projectids .= ',';
				$projectids .= $this->GetProjectParents($this->f(0), true);
			}
		}

		return $projectids;
	}

	function GetProjectChildren($projectid, $includethis = false)
	{
		if ($includethis == false){
			$this->Clear();

			if ($this->conn == 0)
			{
				if (!$this->Connect())
					return -1;
			}

			$projectids = '';
		}else{
			$projectids = $projectid;
		}
		if ($this->Query("SELECT projectid FROM dcl_projects WHERE parentprojectid=$projectid") != -1)
		{
			if ($this->next_record())
			{
				if($includethis)
					$projectids .= ',';
				$projectids .= $this->GetProjectChildren($this->f(0), true);
			}
		}

		return $projectids;
	}

	function LoadProjects($projectids)
	{
		if ($projectids == '')
			return -1;

		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = 'SELECT b.projectid,a.jcn,a.seq FROM workorders a, projectmap b WHERE ';
		$sql .= 'a.jcn=b.jcn AND (b.seq=0 OR a.seq=b.seq) AND ';
		$sql .= "b.projectid in ($projectids) ";
		$sql .= 'ORDER BY b.projectid,a.jcn,a.seq';
		if (!$this->Query($sql))
			return -1;

		return 1;
	}

	function LoadChildren($projectid)
	{
		$projectids = $this->GetProjectChildren($projectid, true);
		return $this->LoadProjects($projectids);
	}

	function LoadParents($projectid)
	{
		$projectids = $this->GetProjectParents($projectid, true);
		return $this->LoadProjects($projectids);
	}

	function LoadByWO($jcn, $seq)
	{
		$this->Clear();

		if ($this->conn == 0)
		{
			if (!$this->Connect())
				return -1;
		}

		$sql = "SELECT projectid,jcn,seq FROM projectmap WHERE jcn=$jcn and seq in (0,$seq)";
		if (!$this->Query($sql))
			return -1;

		if (!$this->next_record())
			return -1;

		return $this->GetRow();
	}

	function LoadByWOFilter($jcn, $seq, $seqonly = false, $allforjcn = false)
	{
		$query = "SELECT projectid, jcn, seq FROM projectmap WHERE jcn=$jcn";
		if ($allforjcn == false)
		{
			$query .= ' AND ';
			if ($seqonly)
				$query .= "seq=$seq";
			else
				$query .= "seq in (0,$seq)";
		}

		if (!$this->Query($query))
			return -1;
	}

	function Clear()
	{
		$this->projectid = 0;
		$this->jcn = 0;
		$this->seq = 0;
	}
}
?>
