/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * bittorrent_clist.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: bittorrent_clist.h,v 1.1 2004/01/13 18:10:29 ericprev Exp $
*/

#ifndef __BITTORRENT_CLIST_H__
#define __BITTORRENT_CLIST_H__

/*********************************************************************/
/* check if the given pid is the one of a running bittorrent process */
/*********************************************************************/
/* output: TRUE=dead, FALSE=running */
/************************************/
gboolean is_a_dead_bittorrent(pid_t bt_pid);

/********************************************************************************************************/
/* search inside the available_bt_entry array an entry with an map->original_url matching the given one */
/********************************************************************************************************/
/* output: -1=not found else the pid of the entry (which can be the one of a not running client) */
/*************************************************************************************************/
pid_t get_bt_pid_by_bt_url(const char *url);

/*****************************************************************************************/
/* search inside the available_bt_entry array an entry with a pid matching the given one */
/*****************************************************************************************/
/* ouput: NULL=not found else a copy of the url of the entry (must be free() at end) */
/*************************************************************************************/
char *get_bt_url_by_bt_pid(const pid_t pid);

/********************************/
/* periodic bittorrent function */
/********************************/
gint bittorrent_list_periodic_refresh(gpointer data);

/*****************************/
/* create the empty bt array */
/*****************************/
void init_bt_array(void);

/***************************************************************************************************/
/* this function calls the given fnc for each selected entry of the "bittorrent_treeview" treeview */
/***************************************************************************************************/
void generic_selected_bittorrent_clist_calls(GtkTreeSelectionForeachFunc fnc, void *data);

/********************************/
/* delete data of a dead client */
/***********************************************************************************************************/
/* the function deletes the .lock file and the info file of the bt client and can also the downloaded data */
/***********************************************************************************************************/
/* input: pid of the dead client                                                                      */
/*        with_dled_data: TRUE => all files, including downloaded data, FALSE= only map and lock file */
/******************************************************************************************************/
void delete_bittorrent_file(pid_t bt_pid, gboolean with_dled_data);

/*********************************************/
/* build modele and view for the queue clist */
/*********************************************/
void bmav4_bittorrent_clist(void);

#endif
