package DBIShell::Gtk::main;

use strict;

use Gtk;
use Gtk::Atoms;
use Gtk::Icon;

use DBIShell::UTIL qw(TRUE FALSE);

use Gtk::Symbols (':func'          ,
		  ':gdk_win_type'  ,
		  ':toolbar_style' ,
		  ':orientation'   ,
		  ':gdk_ev_type'   ,
		  ':state_type'    ,
		  ':signals'       ,
		 );

use constant WINDOW_LABEL => 'dbishell / gtk';

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS $VERSION);

@ISA         = qw(DBIShell::Gtk);
@EXPORT      = ();
@EXPORT_OK   = ();
%EXPORT_TAGS = ();
$VERSION     = 0.00_01;

sub handler ($;@)
{
    my $sh     = shift( @_ );
    my $button = $_[0];
    my $action = $button->get_user_data();

    local($_) = $action;

  PANEL_ACTION:
    {
	/^connect$/ix && return $sh->DBIShell::Gtk::conn::panel( @_ );
	/^help$   /ix && return $sh->DBIShell::Gtk::help::panel( @_ );
	/^bug$    /ix && return $sh->DBIShell::Gtk::rbug::panel( @_ );
	/^quit$   /ix && return $sh->close_down();
    };
}

sub panel ($)
{
    use constant TL_TXT => 0;
    use constant TL_TIP => 0;
    use constant TL_XPM => 1;
    use constant TL_TX2 => 2;

    my $sh      = $_[0];

    my $idir    = join( '/', $sh->_share(), 'icons' );
    my $handler = sub { handler($sh, @_) };

    my $window  = Gtk::Window  -> new ( GDK_WIN_TYPE_TOPLEVEL );
    my $vbox_0  = Gtk::VBox    -> new ( FALSE, FALSE          );
    my $bpanel  = Gtk::Toolbar -> new ( ORIENTATION_HORIZONTAL,
					TOOLBAR_STYLE_ICONS
				      );
    $sh->{GTK}{CONTROL} = $window;

    $window->set_title( WINDOW_LABEL );
    $window->signal_connect( GDK_EV_TYPE_DESTROY, GTK__MAIN_QUIT );
    $window->signal_connect( GDK_EV_TYPE_DELETE,  GTK__MAIN_QUIT );

    $window->add( $vbox_0 );
    $vbox_0->show();

    foreach (
	     [ Connect => "$idir/connect.xpm", 'connect' ],
	     [ Bug     => "$idir/bug.xpm"    , 'bug'     ],
	     [ Help    => "$idir/help.xpm"   , 'help'    ],
	     [ Quit    => "$idir/quit.xpm"   , 'quit'    ],
	    )
    {
	my $icon = Gtk::Icon::xpm( $window, $_->[TL_XPM], STATE_TYPE_NORMAL );
	my $bt   = $bpanel->append_item( $_->[TL_TXT],
					 $_->[TL_TIP],
					 $_->[TL_TX2],
					 $icon
				       );
	$bt->set_user_data( $_->[TL_TX2] );
	$bt->signal_connect( BUTTON_CLICKED, $handler );
    }

    $bpanel->show();
    $vbox_0->pack_start( $bpanel, FALSE, FALSE, FALSE );

    $window->show();
}
