use strict;
use Test;
use Carp;

use vars 
  '$dbasetype',
  '$defdb',
  '$descdb',
  '$dbase',
  '$port',
  '$server',
  '$user',
  '$passwd',
  '$dbconn',
  '$dbh',
  ;

# Local settings
my $config_file = '../../base/dbengine.cfg';
my $path_to_db_libs = '..';


BEGIN { plan tests => 7, todo => [6,7]};

# Test 1: Check that DBI is installed
eval { require DBI; return 1; };
ok($@,'');
croak() if $@;  # If DBI isn't installed... bail hard now


# Test 2: Check that config file can be found and and settings can be loaded
eval {
  open (CONF, $config_file) or die "File not found ($config_file): $_";
  &readCFG($config_file);
  return 1;
};
ok($@,'');
croak() if $@;  # If config file not found... bail now


# Test 3: Check that preferred DBD is installed
eval {
  if ($dbasetype eq 'mysql') {
    require DBD::mysql;
  } elsif ($dbasetype eq 'oracle') {
    require DBD::oracle;
  } elsif ($dbasetype eq 'postgres') {
    require DBD::postgres;
  }
};
ok($@,'');
croak() if $@;  # If unable to load DBD driver... bail now


# Test 4: Check that the library files are available (base.pl, mysql.pl, etc)
eval {
  if(-e "${path_to_db_libs}/${dbasetype}.pl") {
	require "${path_to_db_libs}/${dbasetype}.pl";
	&db_initVars();
      } else {
	die("Database $dbasetype not supported");
      }
};
ok($@,'');
croak() if $@;   # If unable to load libraries... bail now


# Test 5: Connect to the database
eval {
  &db_connect2database();
};
ok($@,'');
croak() if $@;  # If unable to connect to db... leave


# Test 6: Check that the test tables are loaded
## TODO -- TEST THE REST OF THE TABLES IN THE CIS & CISINFO DB'S
my $sql = "SELECT * FROM Articles";
my @row_ary = $dbconn->selectrow_array($sql);
my $t = $#row_ary > 0;
ok($t, 1);


# Test 7: Test &fillValues
## TODO -- What needs to be tested? wlm 01-12-05
##   1. $relations_data arrayref is set
##   2. $values{xmin} has been set
##   3. %values has been set
##   4. &getVirtualFields() has been successfully executed
##   5. 
ok(1,0);




#################################################
#
# Helper Subroutines
#
#################################################

sub readCFG {
	my ($filename) = @_;
	my ($mode, $varname, $content, %xnames);
	open (CFG, "<$filename");
	while (<CFG>) {
		s/^\s*\#.*//g;		# remove comments
		s/^\s+//g;		# remove leading whitespace
		next if /^$/;		# skip empty lines
		if ( /\[([^]]+)\]/ ) {	# identify mode
			$mode = $1;
			next;
		}

		# split cfg line and cleanup entries for Taint-mode
		# also accept standard Perl variable assignment syntax
		if(/\$([^\s\=]+)\s*\=\s*([^\;]+)\;/) {
			$varname = $1;
			$content = $2;
			$content = $1 if($content =~ /^\"([^\"]*)\"$/);
			$content = $1 if($content =~ /^\'([^\']*)\'$/);

		# if in text/tab style
		} else {
			s/^\s+//g;		# remove leading whitespace
			next if /^$/;		# skip empty lines
			($varname, $content) = split(/\s+/, $_);
		}
		$varname =~ /(.*)/;
		$varname = $1;
		$content =~ /(.*)/;
		$content = $1;

		#
		# lines in the [CONFIG] section are evaluated
		# to initialize according global variables
		if($mode =~ /CONFIG/i) {
			eval "\$$varname = \"$content\"\n";


		#
		# lines in the [X-NAMES] section are saved in the %xnames array
		} elsif($mode =~ /X-NAMES/i) {
			$xnames{$varname} = $content;
		}
	}
	close CFG;
}


sub connError {
	#
	# print the given $message and the current database
	# error message to STDOUT and die unless the connection is OK
	my ($message) = @_;
	if (!defined($dbconn)) {
	  print "$message\nError: ". $DBI::errstr;
	}
}
