
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#ifndef __HOST_DB_H
#define __HOST_DB_H

#include "bignum.h"
#include "db.h"
#include <stdio.h>

/* Maximum data transfer value the DB can hold is 2^64:
 * 18,446,744,073,709,551,616  Bytes
 * 18,014,398,509,481,984     KBytes
 * 17,592,186,044,416         MBytes
 * 17,179,869,184             GBytes
 * 16,777,216                 TBytes
 *
 * Good for a few more years.
 */

typedef struct {
	dword ip_addr;
	char *hostname;
	int64 data_in;
	int64 data_out;
} host_record;

#define CLASSA(ip) ((ip >> 24) & 0xFF)



/* Global database */
extern db host_db[256];
extern host_record *local_host_rec;



void host_db_init(void);
void host_db_free(void);
inline dword host_db_used(void);

/* host_record needs to be deallocated when it's no longer needed */
inline host_record *host_make(const dword ip_addr);

/* add or find a host by ip */
inline host_record *host_from_ip(const dword ip);

/* add or update a host, depending on whether it exists in the db or not */
inline void host_transfer_in(const dword ip, const dword in);
inline void host_transfer_out(const dword ip, const dword out);

inline dword ip_from_quad(const int a, const int b, const int c, const int d);

inline host_record **host_db_sort(sort_type st);

void host_db_save(FILE *fp);
int host_db_load(FILE *fp);

#endif

