"""Access to darkstat API - text format interface.

This file is a part of darkstat (http://purl.org/net/darkstat)
Author: Oleg Broytmann <phd@phd.pp.ru>
License: GPL
"""


import darkstat

class DarkstatAPI(darkstat.DarkstatAPI):
   info_total_bytes_url = "/info/bytes-total.txt"

   def get_total_bytes(self):
      lines = darkstat.DarkstatAPI.get_total_bytes(self)

      # darkstat forcibly set LC_NUMERIC to en_US that uses commas
      # to separate 3-digits groups in decimal representation
      bytes_total = lines[0].replace(',', '') # remove commas

      return long(bytes_total) # convert to long int
