#!/usr/bin/env perl

use lib 'lib/perl', '../tests/lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use File::Slurp;
use Cwd 'abs_path';
use strict;

use File::Temp 'tempdir';
chdir tempdir( CLEANUP => 1 );

mkpath 'first';
chdir  'first';
darcs  'init';
open FORMAT, ">>_darcs/format";
print FORMAT "gobbledygook\n";
close FORMAT;
chdir '../';

my $out = darcs "get first second";
like($out,qr/Can't understand repository format/i, "got expected failure when using unknown repoformat in get");
