#!/usr/bin/env perl

# Some tests for 'darcs record '

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use strict;
use Shell::Command;
use File::Slurp;
use Cwd;

init_tmp_repo();

{
    my $test_name = 'issue308 - no patches and no deps for record should abort';
    like( darcs(qw/record -am foo --ask-deps/), qr/Ok, if you don't want to record anything, that's fine!/i,
          $test_name) ;
}

if ($^O =~ /msys/i) {
    pass 'test does not work on msys due to stdin oddities';
} else {
    my $test_name = 'RT#476 - --ask-deps works when there are no patches';
    touch 't.f';
    darcs qw/add t.f/;
    like( darcs(qw/record  -am add/), qr/Finished recording/i, "add file") ;
    like( echo_to_darcs("record  -am foo --ask-deps",'a'), qr/finished recording/i,          $test_name) ;
    is($?, 0, "record no-patch return code == 0");
}

{
    my $test_name = 'RT#231 - special message is given for nonexistent directories';
    like( darcs(qw/record  -am foo not_there.txt/),qr/non ?existent/i, $test_name) ;
}

{
    my $test_name = 'RT#231 - a nonexistent file before an existing file is handled correctly';
    touch 'b.t';
    like( darcs(qw/record  -am foo a.t b.t/),
          qr/Non ?existent files or directories: "a.t"/i, $test_name) ;
}

{
    my $test_name = 'record works with absolute paths';

    touch 'date.t';
    darcs qw/add date.t/;

    like( darcs(q{record  -a -m foo "}
            .cwd()
            .q{/date.t"} ), qr/Finished recording/i, $test_name);
}

{
    my $test_name = 'issue396 - record -l ""';
    touch 'notnull.t';
    like( darcs(qw/record  -am foo -l "" notnull.t/), qr/Finished recording/i, $test_name) ;
}

BASIC_RECORD: {
    my $test_name = 'basic record';
    `date >> date.t`;
    like( darcs(qw/record  -a -m basic_record date.t/), qr/finished recording/i, $test_name);
}

LOGFILE: {
    my $test_name = 'testing --logfile';
    `date >> date.t`;
    append_file('log.txt',"second record\n");
    like( darcs(qw/record  -a -m 'second record' --logfile=log.txt  date.t/), qr/finished recording/i, $test_name);

}
