#!/usr/bin/env perl

# A test for darcs resolve detecting a conflict, inspired by bug #152 in RT

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;
use File::Slurp;
use File::Temp 'tempdir';
my $work_dir = tempdir( CLEANUP => 1 );
chdir $work_dir;


mkpath 'tmp1';
chdir 'tmp1' || die;
darcs 'init';

write_file('one.txt',"from tmp1");

darcs(q( add one.txt));
darcs(q( rec -A bar -am "add one.txt"));

append_file("one.txt","\n");

write_file('_darcs/prefs/defaults',"apply allow-conflicts\n");

chdir "../";
darcs 'get tmp1 tmp2';

chdir "tmp2/" || die "couldn't chdir: $!";

like(darcs(q(query manifest)), qr/one.txt/, "reality check: manifest");

append_file('one.txt',"in tmp2\n");

like(darcs(q( w -s)), qr/M/, "reality check: darcs w -s");

my $out = darcs 'rec -A bar -am "add extra line"';

like(darcs(q( push -a)) ,qr/conflicts/i,'expect conflicts when pushing');  
chdir '../tmp1';

TODO: {
    local $TODO = 'waiting on code to fix this';
    unlike(darcs(q(resolve)),qr/no conflicts/i, "after a conflict, darcs resolve should report a conflict");
}

