#!/usr/bin/env perl

# Some tests for the repodir flag

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;
use warnings;

my $test_name = 'Make sure that a simple init works.';
init_tmp_repo();

ok((-d '_darcs'), '_darcs directory was created');

$test_name = 'Make sure that init in a pre-existing darcs directory fails.';
like(darcs('init'), qr/not run this command in a repository/, $test_name);

$test_name = 'Make sure that init --repodir creates the directory if it does not exist';

cleanup 'temp1';
darcs 'init --repodir=temp1';
ok((-d 'temp1/_darcs'), '_darcs directory was created');

