/*
 *  Copyright (C) 2010  Giorgio Wicklein <g.wicklein@giowisys.com>
 *
 *  This file is part of DaemonFS.
 *
 *  DaemonFS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  DaemonFS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with DaemonFS.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

//-----------------------------------------------------------------------------
// Hearders
//-----------------------------------------------------------------------------

#include <QMainWindow>
#include <QSystemTrayIcon>


//-----------------------------------------------------------------------------
// Forward declarations
//-----------------------------------------------------------------------------

class QStackedWidget;
class QMenu;
class QAction;
class QHttp;
class FileWatcherEngine;
class StartWidget;
class FileWidget;
class EventsWidget;
class AboutDialog;


//-----------------------------------------------------------------------------
// MainWindow
//-----------------------------------------------------------------------------

class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    FileWatcherEngine *fswatch;


private slots:
    void aboutSlot();
    void monitorButtonClicked();
    void backButtonClicked();
    void startButtonClicked();
    void stopButtonClicked();
    void fschanged(QString);
    void trayActivated(QSystemTrayIcon::ActivationReason);
    void trayMessage(QString);
    void updateSlot();
    void updateDoneSlot(bool error);
    void reportBugSlot();
    void askSlot();
    void featureRequestSlot();

private:
    void createMenu();
    void createCentralWidget();
    void createModules();
    void createTrayIcon();
    void initComponents();
    void createConnections();

    QMenu *fileMenu;
    QMenu *helpMenu;
    QAction *exitAction;
    QAction *aboutAction;
    QAction *aboutQtAction;
    QAction *updateAction;
    QAction *reportBugAction;
    QAction *askAction;
    QAction *featureRequestAction;
    QStackedWidget *stackedWidget;
    QSystemTrayIcon *trayIcon;
    QMenu *trayMenu;
    QAction *showAction;
    QAction *hideAction;
    QHttp *http;

    StartWidget *startWidget;
    FileWidget *fileWidget;
    EventsWidget *eventsWidget;
    AboutDialog *aboutDialog;
    int BUILD;

};

#endif // MAINWINDOW_H
