<?php
/**
 * Interface to handle all private messages between users
 *
 * daCode http://www.dacode.org/
 * src/phplib/messages.php3
 * $Id: messages.php3,v 1.42.2.12 2002/08/17 19:37:25 pterjan Exp $
 *
 * Depends: Config Db User Html
 */
class Message {

	/**
	 * Session class instance
	 *@var object Session
	 */
	var $session;
	
	/**
	 * Html subclasse instance
	 *@var object Html
	 */
	var $html;
	
	/**
	 * Db abstraction layer instance
	 *@var object Db
	 */
	var $db;

	/**
	 * Class constructor.
	 *@access public
	 */
	Function Message() {
		$this->db = LoadClass('Db');
		$this->session = LoadClass('Session');
		$this->html = LoadClass('Html');
		$this->redirect = LoadClass('Redirect');
		$this->user = LoadClass('User');
		$this->utils = LoadClass('Utils');
	}

	/**
	 * Add a new message into table message
	 *@param array list of fields to record into message's table
	 *@return mixed Error string or header of a new page
	 *@access public
	 */
	Function add_new_message($row) {
		global $config;

		$tmp = "";
		if (!$this->session->checked) {
			echo lecho("Must be logged...")."<br />\n";
			exit;
		}
		if (!ereg("^[0-9]+$",$row['user_id_dest']) || $row['user_id_dest'] == 1) {
			echo lecho("Look likes trouble to me...");
			exit;
		}

		if (empty($row['subject']) || empty($row['body'])) {
			echo lecho("Must enter subject AND body");
			exit;
		}

		$sqlc_q = "INSERT INTO ".$config->tables['messages'].
			"(user_id_source,user_id_dest,subject,body) VALUES ('".
			addslashes($this->session->user_id)."','".
			addslashes($row['user_id_dest'])."','".
			addslashes($row['subject'])."','".
			addslashes($row['body']). "')";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			exit;
		}

		header("Cache-Control: no-cache, must-revalidate");
		header("Pragma: no-cache");
		if (empty($row['url'])) {
			$row['url'] = $config->basehref;
		}
		header("Location: ".$row['url']);
		exit;
	}

	/**
	 * Produce html form to write a message 
	 *@param array list of fields read from message's table
	 *@return string html to be displayed
	 *@access public
	 */
	Function show_new_message($row) {
		global $HTTP_REFERER;
		global $config;

		$tmp = '';

		if (!$this->session->checked) {
			$tmp .= lecho("Must be logged...")."<br />\n";
			return $tmp;
		}

		if (!ereg("^[0-9]+$",$row['user_id_dest'])) {
			$tmp .= lecho("Look likes trouble to me...");
			return $tmp;
		}

		$sqlc_q = "SELECT login,fname,lname FROM ".$config->tables['users'].
			" WHERE id='".addslashes($row['user_id_dest'])."'";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}

		if ($this->db->num_rows()!=1) {
			$tmp .= lecho("No users exists with that ID!")."<br />\n";
			return $tmp;
		}
		$c = $this->db->fetch_array();

		$subject = '';
		$body = '';
		if ($row['answer'] && ereg("^[0-9]+$",$row['answer'])) {
			$sqlc_q = "SELECT ".
				$config->tables['messages'].".timestamp,".
				$config->tables['messages'].".user_id_dest,".
				$config->tables['messages'].".subject,".
				$config->tables['messages'].".body".
				" FROM ".
				$config->tables['messages'].",".
				$config->tables['users']." ".
				"WHERE ".
				$config->tables['messages'].".id='".
				addslashes($row['answer'])."' AND ".
				$config->tables['users'].".id=".
				$config->tables['messages'].".user_id_source";

			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$tmp .= lecho("SQL Failed: ").$this->db->error();
				return $tmp;
			}
			$d = $this->db->fetch_array();
			if ($d['user_id_dest'] != $this->session->user_id) {
				$tmp .= lecho("Trying to play with your life? ")."<br />\n";
				return $tmp;
			}
			if ($row['quote']) {
				$body .= lecho("On ");
				if ($config->defaultlang == "fr") {
					$body .= ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})'.
						'([0-9]{2})([0-9]{2})', '\3/\2/\1 @ \4:\5:\6', $d['timestamp']);
				} else {
					$body .= ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})'.
						'([0-9]{2})([0-9]{2})', '\1/\2/\3 @ \4:\5:\6', $d['timestamp']);
				}
				$body .= lecho(", you wrote: ")."\n";
				$body .= htmlentities($this->utils->quote_text($d['body'], 1, 42));
			}

			$subject = htmlentities(eregi('^re: ',$d['subject'])?
				$d['subject']:'Re: '.$d['subject']);
		}

		$tmp .= '<form method="post" action="'.$config->basehref.
				'messages/add.'.$config->php.'">'."\n";
		$tmp .= '<table>'."\n";
		$tmp .= '<tr><td align="right" class="newstext">'.
			lecho("Message from").'</td><td class="newstext"><b> [ ';
		if (!empty($this->session->fname) ||
			!empty($this->session->lname)) {
			$tmp .= htmlentities($this->session->fname." ".$this->session->lname);
		} else {
			$tmp .= htmlentities($this->session->login);
		}
		$tmp .= ' ] </b></td></tr>'."\n";
		$tmp .= '<tr><td align="right" class="newstext">'.
			lecho("addressed to").'</td><td class="newstext"><b> [ ';
		if (!empty($c['fname']) || !empty($c['lname'])) {
			$tmp .= htmlentities($c['fname']." ".$c['lname']);
		} else {
			$tmp .= htmlentities($c['login']);
		}

		$tmp .= ' ] </b></td></tr>'."\n";
		$tmp .= '<tr><td align="right" class="newstext">'.
			lecho("Subject").'</td><td class="newstext">'.
			'<input type="text" name="table[subject]"'.
			' value="'.$subject.'" size="50" '.
			'maxlength="80" /></td></tr>'.
			'<tr><td valign="top" align="right" class="newstext">'.
			ucfirst(lecho("comment")).
			'</td><td class="newstext">'.
			'<textarea name="table[body]" rows="10" cols="50">'.$body.
			'</textarea></td></tr>';
		$tmp .= '<tr><td colspan="2" align="center" class="newstext">'.
			'<input type="submit" name="table[submit]" value="'.
			lecho("Submit").'" />'.
			'<input type="hidden" name="table[user_id_dest]" value="'.
			$row['user_id_dest'].'" />'.
			'<input type="hidden" name="table[url]" value="'.
			$config->baseurl.'messages/index.'.$config->php.'" /></td>';


		$tmp .= '</tr></table></form>'."\n";
		$tmp = $this->html->simplebox($tmp);
		$tmp .= '<div align="center"><a href="'.$config->basehref.'messages/">'.
			lecho("Go back to the messages").'</a></div>';

		return $tmp;
	}

	/**
	 * Produce a box to warn about new message into mailbox
	 *@return string html to be displayed 
	 *@access public
	 */
	Function show_new_title() {
		global $config;

		if (!$this->session->checked) {
			$tmp = '<!-- MESSAGESHOW -->';
			$tmp .= '<!-- /MESSAGESHOW -->';
			return $tmp;
		}
		$tmp = "";

		$sqlc_q = "SELECT subject,id FROM ".$config->tables['messages'].
			" WHERE user_id_dest='".
			addslashes($this->session->user_id).
			"' AND read_ok='0' ORDER BY id DESC";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= "<!-- SQL failed: ".$this->db->error()." -->\n";
			return $tmp;
		}
		if (!$this->db->num_rows()) {
			$tmp = '<!-- MESSAGESHOW -->';
			$tmp .= '<!-- /MESSAGESHOW -->';
			return $tmp;
		}

		while ($row=$this->db->fetch_array()) {
			$tmp .= '&nbsp;-&nbsp;<a href="'.
				$config->basehref.'messages/view.'.$config->php.'?id='.$row['id'].
				'">'.htmlentities($row['subject']).'</a><br />';
		}
		$this->db->free();

		$tmp = '<!-- MESSAGESHOW -->'.
			$this->html->sidebox($this->redirect->make(lecho("New Messages"),
			$config->basehref.'messages/',"", ' class="boxheader"'),$tmp).
			'<!-- /MESSAGESHOW -->';

		return $tmp;
	}

	/**
	 * Remove a message from DB
	 *@param string id of message to be deleted (but why is it string?!)
	 *@return mixed Error string or header of a new page
	 *@access public
	 */
	Function del_message($message_id= "") {
		global $config;

		if (!$this->session->checked) {
			header("Location: ".$config->basehref);
			exit;
		}
		if (!ereg("^[0-9]+$",$message_id)) {
			header("Location: ".$config->basehref."messages/");
			exit;
		}

		$sqlc_q = "SELECT id FROM ".$config->tables['messages']." WHERE ".
			"user_id_dest='".addslashes($this->user->user_id)."' AND id='".
			addslashes($message_id)."'";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo lecho("SQL Failed: ").$this->db->error();
			exit;
		}
		if ($this->db->num_rows()) {
			$sqlc_q = "DELETE FROM ".$config->tables['messages']." WHERE ".
			"id='".$message_id."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				echo lecho("SQL Failed: ").$this->db->error();
				exit;
			}
			header("Location: ".$config->basehref."messages/");
			exit;
		} else {
			echo lecho("Seems it doesn't belong to you!<br />\n");
		}
	}

	/**
	 * Show a message in order to read it and eventually answer
	 *@param array with id of the message
	 *@return string html to be displayed
	 *@access public
	 */
	Function view_message($row) {
		global $config;

		$tmp = "";
		if (!$this->session->checked) {
			return;
		}

		if (!ereg("^[0-9]+$",$row['id'])) {
			$tmp .= lecho("Look likes trouble to me...");
			return $tmp;
		}

		$sqlc_q = "SELECT ".
			$config->tables['messages'].".timestamp,".
			$config->tables['messages'].".user_id_source,".
			$config->tables['messages'].".user_id_dest,".
			$config->tables['messages'].".subject,".
			$config->tables['messages'].".body,".
			$config->tables['users'].".login,".
			$config->tables['users'].".fname,".
			$config->tables['users'].".lname".
			" FROM ".
			$config->tables['messages'].",".
			$config->tables['users']." ".
			"WHERE ".
			$config->tables['messages'].".id='".
			addslashes($row['id'])."' AND ".
			$config->tables['users'].".id=".
			$config->tables['messages'].".user_id_source";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= lecho("SQL Failed: ").$this->db->error();
			return $tmp;
		}
		$c=$this->db->fetch_array();
		if ($c['user_id_dest'] != $this->session->user_id
				&& $c['user_id_source'] != $this->session->user_id) {
			$tmp .= lecho("Trying to play with your life? ")."<br />\n";
			return $tmp;
		}
		if ($config->defaultlang == "fr") {
			$date = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})'.
				'([0-9]{2})([0-9]{2})', '\3/\2/\1 @ \4:\5:\6', $c['timestamp']);
		} else {
			$date = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})'.
				'([0-9]{2})([0-9]{2})', '\1/\2/\3 @ \4:\5:\6', $c['timestamp']);
		}
		$tmp .= '<table width="100%"><tr>'.
			'<td align="right" width="15%" class="newstext"><b>'.
			lecho("Message from").': </b></td><td class="newstext">';
		if (!empty($c['fname']) || !empty($c['lname'])) {
			$tmp .= htmlentities($c['fname']." ".$c['lname']);
		} else {
			$tmp .= htmlentities($c['login']);
		}
		$tmp .= '</td></tr>';
		$tmp .= '<tr><td align="right" class="newstext"><b>'.
			lecho("Date").': </b></td><td class="newstext">'.$date.'</td></tr>';
		$tmp .= '<tr><td align="right" class="newstext"><b>'.
			lecho("Subject").': </b></td><td class="newstext">'.
			htmlentities($c['subject']).'</td></tr>';
		$tmp .= '<tr><td align="right" valign="top" class="newstext"><b>'.
			lecho("Body").': </b></td><td valign="top" class="newstext">'.
			nl2br(htmlentities($c['body'])).'</td></tr>';
		
		if ($c['user_id_dest'] == $this->session->user_id) {
			$tmp .= '<tr><td colspan="2" class="newstext"><div align="center">'.
				'<a href="'.$config->basehref.'messages/post.'.$config->php.
				'?user_id_dest='.$c['user_id_source'].'&amp;answer_id='.$row['id'].
				'&amp;quote=0">'.lecho("Reply without text").'</a> - '."\n".
				'<a href="'.$config->basehref.'messages/post.'.$config->php.
				'?user_id_dest='.$c['user_id_source'].'&amp;answer_id='.$row['id'].
				'&amp;quote=1">'.lecho("Reply with text").'</a> - '."\n".
				'<a href="'.$config->basehref.'messages/del.'.$config->php.
				'?message_id='.$row['id'].'">'.lecho("Delete").'</a></div></td></tr>';
		}
		$tmp .=	'</table>';

		if ($c['user_id_dest'] == $this->session->user_id) {
			$sqlc_q = "UPDATE ".$config->tables['messages'].
				" SET read_ok='1', timestamp=timestamp".
				" WHERE id='".addslashes($row['id'])."'";
			$ret = $this->db->query($sqlc_q);
			if (!$ret) {
				$tmp .= lecho("SQL Failed: ").$this->db->error();
			}
		}

		$tmp = $this->html->simplebox($tmp);
		$tmp .= '<div align="center"><a href="'.$config->basehref.'messages/">'.
			lecho("Go back to the messages").'</a></div>';

		return $tmp;
	}


	/**
	 * Show the list of messages received by a user
	 *@return string html array to be displayed of all received messages
	 *@access public
	 */
	Function show_received() {
		global $config;
		$tmp = '';

		if (!$this->session->checked) {
			$tmp .= '<tr><td>'.lecho("Seems it doesn't belong to you!<br />\n").
				'</td></tr>';
			return $tmp;
		}

		$sqlc_q = "SELECT ".
			$config->tables['messages'].".timestamp,".
			$config->tables['messages'].".subject,".
			$config->tables['messages'].".id,".
			$config->tables['messages'].".read_ok,".
			$config->tables['messages'].'.user_id_source,'.
			$config->tables['users'].".login,".
			$config->tables['users'].".fname,".
			$config->tables['users'].".lname".
			" FROM ".
			$config->tables['messages'].",".
			$config->tables['users']." ".
			"WHERE ".
			$config->tables['messages'].".user_id_dest='".
			addslashes($this->session->user_id)."' AND ".
			$config->tables['users'].".id=".
			$config->tables['messages'].".user_id_source".
			" ORDER BY ".$config->tables['messages'].".id DESC";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= "<!-- SQL failed: ".$this->db->error()." -->\n";
			return $tmp;
		}
		if (!$this->db->num_rows()) {
			$tmp .= '<tr><td>'.lecho("Sorry, you didn't receive any message yet").
				'</td></tr>';
			return $tmp;
		}
		$tmp .= '<tr><td width="30%" class="newstext"><b>'.lecho("Title").
			'</b></td><td width="30%" class="newstext"><b>'.lecho("from").
			'</b></td><td width="30%" class="newstext"><b>'.lecho("Date").
			'</b></td><td width"10%">'."\n&nbsp;\n</td>\n</tr>\n";
		while($row=$this->db->fetch_array()) {
			$tmp .= '<tr><td class="newstext">'."\n";
			if (!$row['read_ok']) {
				$tmp .= '<img src="'.$this->session->imgurl("new").
					'" border="0" alt="'.lecho("NEW").'" />&nbsp;';
			}
			$tmp .= '<a href="'.$config->basehref.'messages/view.'.
				$config->php.'?id='.$row['id'].'">'.htmlentities($row['subject']).
				"</a>\n</td>\n".'<td class="newstext">'."\n";
			$tmp .= '<a href="'.$config->basehref.'users/index.'.
				$config->php.'?a=vu&amp;user_id='.$row['user_id_source'].'">';
			if (!empty($row['fname']) || !empty($row['lname'])) {
				$tmp .= $row['fname']." ".$row['lname'];
			} else {
				$tmp .= $row['login'];
			}
			$tmp .= '</a>';
			$tmp .= '</td><td class="newstext">';
			if ($config->defaultlang == "fr") {
				$date = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})'.
					'([0-9]{2})([0-9]{2})', '\3/\2/\1 \4:\5:\6', $row['timestamp']);
			} else {
				$date = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})'.
					'([0-9]{2})([0-9]{2})', '\1/\2/\3 \4:\5:\6', $row['timestamp']);
			}
			$tmp .= $date.'</td><td class="newstext">'."\n";
			$tmp .= '<a href="'.$config->basehref.'messages/del.'.$config->php.
				'?message_id='.$row['id'].'">'.lecho("Delete")."</a>\n</td>\n</tr>\n";
		}
		$this->db->free();

		return $tmp;
	}

	/**
	 * Show the list of messages send by a user
	 *@return string html array to be displayed of all send messages
	 *@access public
	 */
	Function show_sent() {
		global $config;
		$tmp = '';

		if (!$this->session->checked) {
			$tmp .= "<tr><td>\n".lecho("Seems it doesn't belong to you!<br />\n").
				"</td></tr>\n";
			return $tmp;
		}

		$sqlc_q = "SELECT ".
			$config->tables['messages'].".timestamp,".
			$config->tables['messages'].".subject,".
			$config->tables['messages'].".id,".
			$config->tables['messages'].".read_ok,".
			$config->tables['users'].".login,".
			$config->tables['users'].".fname,".
			$config->tables['users'].".lname".
			" FROM ".
			$config->tables['messages'].",".
			$config->tables['users']." ".
			"WHERE ".
			$config->tables['messages'].".user_id_source='".
			addslashes($this->session->user_id)."' AND ".
			$config->tables['users'].".id=".
			$config->tables['messages'].".user_id_dest".
			" ORDER BY ".$config->tables['messages'].".id DESC";

		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			$tmp .= "<!-- SQL failed: ".$this->db->error()." -->\n";
			return $tmp;
		}
		if (!$this->db->num_rows()) {
			$tmp .= "<tr><td>\n".lecho("Sorry, you didn't send any message yet").
				"\n</td></tr>\n";
			return $tmp;
		}
		$tmp .= '<tr><td width="30%" class="newstext"><b>'.lecho("Title").
			'</b></td><td width="30%" class="newstext"><b>'.lecho("to").
			'</b></td><td width="30%" class="newstext"><b>'.lecho("Date").
			'</b></td><td width"10%" class="newstext">'."\n".
			lecho("Already read?")."\n</td>\n</tr>\n";
		while($row=$this->db->fetch_array()) {
			$tmp .= "<tr><td class=\"newstext\">\n".
						'<a href="'.$config->basehref.'messages/view.'.
						$config->php.'?id='.$row['id'].'">'.htmlentities($row['subject']).
						"</a>\n</td>\n<td class=\"newstext\">\n";
			if (!empty($row['fname']) || !empty($row['lname'])) {
				$tmp .= $row['fname']." ".$row['lname'];
			} else {
				$tmp .= $row['login'];
			}
			$tmp .= "</td>\n".'<td class="newstext">';
			if ($config->defaultlang == "fr") {
				$date = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})'.
					'([0-9]{2})([0-9]{2})', '\3/\2/\1 \4:\5:\6', $row['timestamp']);
			} else {
				$date = ereg_replace('([0-9]{4})([0-9]{2})([0-9]{2})([0-9]{2})'.
					'([0-9]{2})([0-9]{2})', '\1/\2/\3 \4:\5:\6', $row['timestamp']);
			}
			$tmp .= $date."\n</td>\n".'<td class="newstext">';
			$tmp .= $row['read_ok']?lecho("Yes"):lecho("No");
			$tmp .= "\n</td>\n</tr>\n";
		}
		$this->db->free();

		return $tmp;
	}

}

?>
