/*  
    gets.r:

    Copyright (C) 2000 John ffitch

    This file is part of Csound.

    The Csound Library is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    Csound is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with Csound; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307 USA
*/

#include "Types.r"

type 'GETS' (128) {
        integer = $$Countof(StringArray);
        array StringArray {
                cstring;
        };
};

resource 'STR#' (128, "Error strings") {
  {
    "            ilength should be greater than kgsize * max up\n", /* 1 */
    "            pitch shift. Also, igsize_os and igskip_os should\n", /* 2 */
    "      remainder of line flushed\n", /* 3 */
    "    String truncated\n", /* 4 */
    "   Zero substituted\n", /* 5 */
    "   ending at %p\n", /* 6 */
    "   note aborted\n", /* 7 */
    "   zero substituted.\n", /* 8 */
    "Legal flags are:\n", /* 9 */
    "  ... extracting ...\n", /* 10 */
    "-F fpnum\tamount to scale amplitude\n", /* 11 */
    "  fd %d in %lx", /* 12 */
    "  rtevent:\t   T%7.3f TT%7.3f M:", /* 13 */
    " (default 0)\n", /* 14 */
    " - note deleted.  i%d had %d init errors\n", /* 15 */
    " - note deleted. instr %d(%d) undefined\n", /* 16 */
    " bad imode value", /* 17 */
    " from timepoint %3.1f\n", /* 18 */
    "Usage:\tscale [-flags] soundfile\n", /* 19 */
    " max found %6.1f, rel amp %6.1f\n", /* 20 */
    " no", /* 21 */
    " odd", /* 22 */
    "util PVLOOK:\n", /* 23 */
    "-F file \tfile of scaling information (alternative)\n", /* 24 */
    "no end sample", /* 25 */
    "cannot allocate last note because it exceeds 100%% of cpu time\n", /* 26 */
    "cannot allocate last note because it exceeds instr maxalloc\n", /* 27 */
    "%c\tbeep!\n", /* 28 */
    "%d WAVE IN devices found\n", /* 29 */
    "%d WAVE OUT devices found\n", /* 30 */
    "%d amp tracks, %d freq tracks", /* 31 */
    "%d chans (not 1) in PVOC file %s", /* 32 */
    "%d forced decays, %d extra noteoffs\n", /* 33 */
    "%d lines read\n", /* 34 */
    "%d lpc frames written to %s\n", /* 35 */
    "%d memfile%s deleted\n", /* 36 */
    "%d opcodes\n", /* 37 */
    "%d syntax errors in orchestra.  compilation invalid\n", /* 38 */
    "flag defaults: scale -s -otest -F 0.0\n", /* 39 */
    "%d: File %s position %ld\n", /* 40 */
    "If scale is 0.0 then reports maximum possible scaling\n", /* 41 */
    "no scale factor", /* 42 */
    "%f Sec, kgsize is %f Sec\n", /* 43 */
    "%ld %d-byte soundblks of %s written to %s", /* 44 */
    "%ld output frames estimated\n", /* 45 */
    "%ld output frames written\n", /* 46 */
    "%ld usecs illegal in Tempo event\n", /* 47 */
    "%s  %ld points, max %5.3f %s", /* 48 */
    "%s  %ld points, max %5.3f", /* 49 */
    "%s %d pts, max %f", /* 50 */
    "%s channels\n", /* 51 */
    "%s format %s not yet supported", /* 52 */
    "%s found %d f event%s with non-zero p2\n", /* 53 */
    "%s has no soundfile header, assuming %s\N", /* 54 */
    "%s has no soundfile header, reading as %s, %d chnl%s", /* 55 */
    "%s inconsistent with global nchnls (%d); replaced with %s\n", /* 56 */
    "%s is soundfile with bytes in the wrong order\n", /* 57 */
    "%s nchnls = %d, soundin reading as if nchnls = %d\n", /* 58 */
    "%s not a CONVOLVE file (magic %ld)", /* 59 */
    "%s not a PVOC file (magic %ld)", /* 60 */
    "%s not a recognised SFOUTYP env setting", /* 61 */
    "%s sr = %ld, orch sr = %7.1f\n", /* 62 */
    "%s''s srate = %8.0f, orch's srate = %8.0f\n", /* 63 */
    "%s, reading ", /* 64 */
    "%s: AIFF, %ld %s samples", /* 65 */
    "%s: AIFF-C, %ld%s samples", /* 66 */
    "%s: Midifile format %d not supported", /* 67 */
    "%s: WAVE, %ld %s samples\n", /* 68 */
    "%s: assuming MPU401 midifile format, ticksize = 5 msecs\n", /* 69 */
    "%s: error: %s (%s)\n", /* 70 */
    "%s: error: %s\n", /* 71 */
    "%s: found standard midifile header\n", /* 72 */
    "%s:\n\tcould not find\n", /* 73 */
    "%s:\n\tno recognisable soundfile header\n", /* 74 */
    "%s\t%ld points, scalemax %5.3f\n", /* 75 */
    "%s: error while opening %s", /* 76 */
    "(disk may be full...\n closing the file ...)\n", /* 77 */
    "(wait)", /* 78 */
    "** Warning **  PostScript file %s cannot be opened \n", /* 79 */
    ", %ld to %ld", /* 80 */
    ", baseFrq %4.1f (midi %d), gain %d db", /* 81 */
    ", baseFrq %4.1f (midi %d, detune %d), gain %d db", /* 82 */
    ", line %d:\n", /* 83 */
    ", looping with modes %d, %d", /* 84 */
    ", no looping", /* 85 */
    ", no looping\n", /* 86 */
    ", relesLp: mode %d", /* 87 */
    ", sustnLp: mode %d", /* 88 */
    "-- fnam\t Redirect output to listing file 'fnam'\n", /* 89 */
    "-- fnam\tlog output to file\n", /* 90 */
    "-- fname\tLog output to file\n", /* 91 */
    "--->WAVE IN DEV.#%d ENABLED  ( %s )\n", /* 92 */
    "--->WAVE OUT DEV.#%d ENABLED  ( %s )\n", /* 93 */
    "-8\t8-bit unsigned_char sound samples\n", /* 94 */
    "-A overriding local default WAV out\n", /* 95 */
    "-A\tcreate an AIFF format output soundfile\n", /* 96 */
    "-B %d probably too large, suggest 1024\n", /* 97 */
    "-B %d probably too small, suggest %d\n", /* 98 */
    "-B %d probably too small, suggest 1024", /* 99 */
    "-B N\tsamples per hardware sound I/O buffer\n", /* 100 */
    "-C<string>\tcomment field of lp header (default empty)\n", /* 101 */
    "-C\tuse Cscore processing of scorefile\n", /* 102 */
    "-D\tdefer GEN01 soundfile loads until performance time\n", /* 103 */
    "-E N\t Number of tables in graphics window\n", /* 104 */
    "-F fnam\tread MIDIfile event stream from file 'fnam'\n", /* 105 */
    "-F: stdin previously assigned", /* 106 */
    "-G\tsuppress graphics, use Postscript displays\n", /* 107 */
    "-H#\tprint a heartbeat style 1, 2 or 3 at each soundfile write\n", /* 108 */
    "-I\tI-time only orch run\n", /* 109 */
    "-J overriding local default AIFF/WAV out\n", /* 110 */
    "-J\tcreate an IRCAM format output soundfile\n", /* 111 */
    "-L dnam\tread Line-oriented realtime score events from device 'dnam'\n", /* 112 */
    "-L stdin fcntl failed", /* 113 */
    "-L with negative p2 illegal\n", /* 114 */
    "-L: stdin previously assigned", /* 115 */
    "-M dnam\tread MIDI realtime events from device 'dnam'\n", /* 116 */
    "-M stdin fcntl failed", /* 117 */
    "-M stdin: system has no fcntl reading stdin\n", /* 118 */
    "-M: stdin previously assigned", /* 119 */
    "-N\tnotify (ring the bell) when score or miditrack is done\n", /* 120 */
    "-P N\tMIDI sustain pedal threshold (0 - 128)\n", /* 121 */
    "-P<mincps>\tlower limit for pitch search (default %5.1f Hz)\n", /* 122 */
    "-Q fnam\t Analysis Directory\n", /* 123 */
    "-Q<maxcps>\tupper limit for pitch search (default %5.1f Hz)\n", /* 124 */
    "-R\tcontinually rewrite header while writing soundfile (WAV/AIFF)\n", /* 125 */
    "-T\tterminate the performance when miditrack is done\n", /* 126 */
    "-U %s not a valid UTIL name", /* 127 */
    "-U unam\trun utility program unam\n", /* 128 */
    "-V N\t Number of chars in screen buffer for output window\n", /* 129 */
    "-V N\tset real-time audio output volume to N (1 to 100)\n", /* 130 */
    "-W overriding local default AIFF out\n", /* 131 */
    "-W\tcreate a WAV format output soundfile\n", /* 132 */
    "-X fnam\t Sound File Directory\n", /* 133 */
    "-Y N\t Enables Profile Display at rate N in seconds,\n", /* 134 */
    "-a\t\talternate (pole) file storage\n", /* 135 */
    "-a\talaw sound samples\n", /* 136 */
    "-b %d probably too large, suggest <= 2048\n", /* 137 */
    "-b N\tsample frames (or -kprds) per software sound I/O buffer\n", /* 138 */
    "-b<begin>\tbegin time in seconds into soundfile (default 0.0)\n", /* 139 */
    "-c<chnlreq>\trequested channel of sound (default chan 1)\n", /* 140 */
    "-c\t8-bit signed_char sound samples\n", /* 141 */
    "-d<duration>\tseconds of sound to be analysed (default: to EOF)\n", /* 142 */
    "-d\tsuppress all displays\n", /* 143 */
    "-e\t\t Rescaled floats as shorts to max amplitude\n", /* 144 */
    "-f\tfloat sound samples\n", /* 145 */
    "-g\tgraphical display of results\n", /* 146 */
    "-g\tsuppress graphics, use ASCII displays\n", /* 147 */
    "-h<hopsize>\toffset between frames in samples (default %d)\n", /* 148 */
    "-h\tno header on output soundfile\n", /* 149 */
    "-i fnam\tsound input filename\n", /* 150 */
    "-i: stdin previously assigned", /* 151 */
    "-k N\torchestra krate override\n", /* 152 */
    "-l\tlong_int sound samples\n", /* 153 */
    "-m N\ttty message level. Sum of: 1=note amps, 2=out-of-range msg, 4=warnings\n", /* 154 */
    "-n\tno sound onto disk\n", /* 155 */
    "-o cannot be stdin", /* 156 */
    "-o fnam\tsound output filename\n", /* 157 */
    "-p<npoles>\tnumber of poles for analysis (default %d)\n", /* 158 */
    "-p\t\t Play after rendering\n", /* 159 */
    "-q fnam\t Sound Sample-In Directory\n", /* 160 */
    "-r N\torchestra srate override\n", /* 161 */
    "-s %ld overriding soundfile sr %ld\N", /* 162 */
    "-s<srate>\tinput sample rate (defaults to header else %7.1f.)\n", /* 163 */
    "-s\tshort_int sound samples\n", /* 164 */
    "-t N\tuse uninterpreted beats of the score, initially at tempo N\n", /* 165 */
    "-u\tulaw sound samples\n", /* 166 */
    "-v<verblevel>\tprinting verbosity: 0=none, 1=verbose, 2=debug.", /* 167 */
    "-v\tverbose orch translation\n", /* 168 */
    "-w\t\t Record and Save MIDI input to a file\n", /* 169 */
    "-x fnam\textract from score.srt using extract file 'fnam'\n", /* 170 */
    "-y N\t Enables Progress Display at rate N seconds,\n", /* 171 */
    "-z\tList opcodes in this version\n", /* 172 */
    "adsynt: wavetable not found", /* 173 */
    "...done!\n", /* 174 */
    "/dev/audio: cannot do AUDIO_GETINFO", /* 175 */
    "/dev/audio: could not write all bytes requested\n", /* 176 */
    "/dev/dsp: could not write all bytes requested\n", /* 177 */
    "100th system exclusive $%x, length %d\n", /* 178 */
    "6-channel", /* 179 */
    "AIFF does not support %s encoding", /* 180 */
    "WAV does not support %s encoding", /* 181 */
    "Max scale factor = %.3f\n", /* 182 */
    "%d sample%s out of range\n", /* 183 */
    "???", /* 184 */
    "ADSYN cannot load %s", /* 185 */
    "AIFF 3-byte samples not supported", /* 186 */
    "AIFF-C 3-byte samples not supported", /* 187 */
    "AIFF-C soundfile", /* 188 */
    "About to draw graph...type ENTER to continue\n", /* 189 */
    "already allocated", /* 190 */
    "Application Signature not pErF\n", /* 191 */
    "Min val %d at index %ld (time %.4f, chan %d) %d times\n", /* 192 */
    "Bad key signature", /* 193 */
    "Buffer memory not allocated!", /* 194 */
    "CHAN %ld DRUMKEY %ld not in keylst, PARAM %ld NOT UPDATED\n", /* 195 */
    "CONVOLVE cannot load %s", /* 196 */
    "CONVOLVE: channel number greater than number of channels in source", /* 197 */
    "CONVOLVE: output channels not equal to number of channels in source", /* 198 */
    "Cannot ioctl EXTCLK", /* 199 */
    "Cannot ioctl EXTCLK\n", /* 200 */
    "Cannot ioctl ITIMER", /* 201 */
    "Cannot ioctl RS422", /* 202 */
    "Cannot ioctl RS422\n", /* 203 */
    "Cannot open MIDI device\n", /* 204 */
    "Cannot write to MIDI device", /* 205 */
    "Cannot create temporary file for MIDI subfile\n", /* 206 */
    "Cannot get capabilities", /* 207 */
    "Cannot handle uneven pole count yet \n", /* 208 */
    "Cannot open #include'd file %s\n", /* 209 */
    "Cannot open %s", /* 210 */
    "Cannot open LoFi\n", /* 211 */
    "Cannot open PV file", /* 212 */
    "Cannot open input comma file%s\n", /* 213 */
    "Cannot open input file %s\n", /* 214 */
    "Cannot open output file %s\n", /* 215 */
    "Cannot open output hetro file %s\n", /* 216 */
    "Cannot open temporary file (%s) for MIDI subfile\n", /* 217 */
    "Case2: indx=%ld (%lx); (short)indx = %d (%x)\n", /* 218 */
    "Circular note list\n", /* 219 */
    "Click here to continue..", /* 220 */
    "Clockbase = %f\n", /* 221 */
    "Closing bracket not allowed in context []\n", /* 222 */
    "Coeffs not allocated!", /* 223 */
    "Compression Type is not FL32", /* 224 */
    "Config : %s\n", /* 225 */
    "Connect failed", /* 226 */
    "Could not get audio information", /* 227 */
    "Could not open /dev/audio for reading", /* 228 */
    "Could not open /dev/audio for writing", /* 229 */
    "Could not set audio information", /* 230 */
    "Could not allocate for initial shape", /* 231 */
    "Creating %s (%p)\n", /* 232 */
    "Creating options\n", /* 233 */
    "Creating orchestra\n", /* 234 */
    "Creating score\n", /* 235 */
    "Csound Command ERROR:\t%s\n", /* 236 */
  "Csound Version %d.%.02df%.02d (%s)\n",  				/* 237 */
    "DECaudio record not available", /* 238 */
    "DSP device does not support the requested mode (mono/stereo)", /* 239 */
    "Decode failed....stopping\n", /* 240 */
    "Deferred-size ftable %f load not available at perf time.", /* 241 */
    "Deprecated -- use round brackets instead of curly\n", /* 242 */
    "Phaser mode must be either 1 or 2", /* 243 */
    "Destination dft table %.2f not found.\n", /* 244 */
    "Die: %s\n", /* 245 */
    "Division by zero", /* 246 */
    "DlineA not initialised", /* 247 */
    "Do not understand block data yet.\n", /* 248 */
    "Duplicate %d: %s (%s,%ld)\n", /* 249 */
    "ERROR: illegal character %c(%.2x) in scoreline: ", /* 250 */
    "ERROR: too many pfields: ", /* 251 */
    "Envelope: value=%f target=%f rate=%f state=%d\n", /* 252 */
    "Error code: %s\n", /* 253 */
    "Error in coef %d : %f <> %f \n", /* 254 */
    "Error in reading MIDI subfile -- no size read\n", /* 255 */
    "Error reading PV header: %s\n", /* 256 */
    "Error reading PVOC file", /* 257 */
    "Error writing PVOC file", /* 258 */
    "Error:%s,%s\n", /* 259 */
    "Expected =", /* 260 */
    "Expected score or functions section", /* 261 */
    "Expression got lost\n", /* 262 */
    "Extending Global pool to %d\n", /* 263 */
    "Extending Local pool to %d\n", /* 264 */
    "Extending Polish array length %ld\n", /* 265 */
    "Extending instr number from %d to %d\n", /* 266 */
    "FOF needs more overlaps", /* 267 */
    "FTERROR, ftable %d: %s\n", /* 268 */
    "Failed to create\n", /* 269 */
    "Failed to find %s\n", /* 270 */
    "Failed to open MIDI OUT due to %s\n", /* 271 */
    "Failed to open dac", /* 272 */
    "Failed to open text file", /* 273 */
    "Failed to read LPC header\n", /* 274 */
    "Failed to set signal", /* 275 */
    "Filter cutoff freq. = %f\n", /* 276 */
    "Filter not inited, cannot set", /* 277 */
    "Filter order out of bounds: (1<=nb<51, 0<=na<=50)", /* 278 */
    "Final result", /* 279 */
    "Forcing 16bit -s sound format\n", /* 280 */
    "Forcing 8bit -c sound format\n", /* 281 */
    "Found Formant: %s (number %i)\n", /* 282 */
    "Found only %d poles...sorry\n", /* 283 */
    "Frame %ld", /* 284 */
    "GEN1 early end-of-file\n", /* 285 */
    "GEN1 read error", /* 286 */
    "GEN1: aiff file truncated by ftable size", /* 287 */
    "GEN1: input file truncated by ftable size\n", /* 288 */
    "GOTOS list is full..extending to %d\n", /* 289 */
    "GRPMAX overflow", /* 290 */
    "Got form.magic = %lx\n", /* 291 */
    "HP audio record not available", /* 292 */
    "HP write to streamSocket: could not write all bytes requested\n", /* 293 */
    "High frequency diffusion not in (0, 1)\n", /* 294 */
    "ID is out of range", /* 295 */
    "IEEE80:DoubleToUlong: val < 0\n", /* 296 */
    "INFILE ERROR: illegal %s info in AIFF-C file %s\n", /* 297 */
    "INFILE ERROR: illegal %s info in aiff file %s\n", /* 298 */
    "INIT ERROR in instr %d: %s\n", /* 299 */
    "INIT ERROR: %s\n", /* 300 */
    "Ignoring name %s not in file\n", /* 301 */
    "Illegal resonk iscl value, %f", /* 302 */
    "Improper \\", /* 303 */
    "Improper tie", /* 304 */
    "Incompatible sample/channel/width", /* 305 */
    "Incorrect evaluation\n", /* 306 */
    "Increasing number of tables from %d to %d\n", /* 307 */
    "Index out of range", /* 308 */
    "adsynt: freqtable not found", /* 309 */
    "Insno = %d\n", /* 310 */
    "Instrument not defined", /* 311 */
    "Internal error op=%c\n", /* 312 */
    "Interpolation failed\n", /* 313 */
    "Invalid field", /* 314 */
    "Invalid ftable no. %f", /* 315 */
    "Invalid pitch class", /* 316 */
    "Invalid switch option", /* 317 */
    "Invalid time signature", /* 318 */
    "LABELS list is full...extending to %d\n", /* 319 */
    "LFO: unknown oscillator type %d", /* 320 */
    "LINE %d:\n", /* 321 */
    "LPREAD cannot load %s", /* 322 */
    "LPTRKFNS: called with excessive Windsiz", /* 323 */
    "LPTRKFNS: inconsistent MAXWindow defines", /* 324 */
    "Legal flags are:\n", /* 325 */
    "Linux sound driver does not support floating-point samples", /* 326 */
    "Linux sound driver does not support long integer samples", /* 327 */
    "LoFi player: timeout at %s\n", /* 328 */
    "Loop terminated\n", /* 329 */
    "Lost previous note: not written", /* 330 */
    "MIDI receive: Cannot get termios info.", /* 331 */
    "MIDI receive: Cannot get tty settings.", /* 332 */
    "MIDI receive: Cannot set input baud rate.", /* 333 */
    "MIDI receive: Cannot set termios.", /* 334 */
    "MIDI receive: Cannot set tty settings", /* 335 */
    "Max val %d at index %ld (time %.4f, chan %d) %d times\n", /* 336 */
    "MIT Csound:  %d86 with floating point, v", /* 337 */
    "cannot write WAV soundfile with no header", /* 338 */
    "Usage:\tmixer [-flags] soundfile [-flags] soundfile ...\n", /* 339 */
    "Macro %s with %d arguments defined\n", /* 340 */
    "Macro definition for %s\n", /* 341 */
    "Macro expansion too long -- circular macros?", /* 342 */
    "magnitude: %f   Phase: %f\n", /* 343 */
    "Metrical timing, Qtempo = 120.0, Qticks = %d\n", /* 344 */
    "MidiFile Console input not implemented", /* 345 */
    "Minimum frequency too low", /* 346 */
    "Missing argument terminator\n%.98s", /* 347 */
    "Missing endin", /* 348 */
    "Must be \"on\" or \"off\"", /* 349 */
    "Must specify 2 or more letters of keyword", /* 350 */
    "Name   : %s\n", /* 351 */
    "Name not found", /* 352 */
    "Named section >>>%s<<<\n", /* 353 */
    "NeXT audio record not available", /* 354 */
    "NeXT supports nchnls = 2 (stereo) output only", /* 355 */
    "Non-positive reverb time\n", /* 356 */
    "Nested next-parameter passing", /* 357 */
    "New window: \nPosition & size, \nclick to go on", /* 358 */
    "No MIDI device available\n", /* 359 */
    "No PV error", /* 360 */
    "No base frequency for brass -- assumed to be 50Hz\n", /* 361 */
    "No base frequency for clarinet -- assuming 50Hz\n", /* 362 */
    "No base frequency for flute -- assumed to be 50Hz\n", /* 363 */
    "No base frequency for mandolin", /* 364 */
    "No current MIDI map", /* 365 */
    "No instrument specified", /* 366 */
    "No instruments declared", /* 367 */
    "No memory for PVOC", /* 368 */
    "No previous event in ^\n", /* 369 */
    "No sound capabilities", /* 370 */
    "No sound input capabilities", /* 371 */
    "No such window!", /* 372 */
    "No table for  FM4Op", /* 373 */
    "No table for Agogobell strike", /* 374 */
    "No table for Brass", /* 375 */
    "No table for Clarinet", /* 376 */
    "No table for FM4Op", /* 377 */
    "No table for Flute", /* 378 */
    "No table for Mandolin", /* 379 */
    "No table for Marimba strike", /* 380 */
    "No table for Modal4 case", /* 381 */
    "No table for Modulatr", /* 382 */
    "No table for Singwave", /* 383 */
    "No table for VibWaveato", /* 384 */
    "No table for Vibraphone strike", /* 385 */
    "No table for wgbow vibrato", /* 386 */
    "No tuning table %d\n", /* 387 */
    "No za space: zakinit has not been called yet.", /* 388 */
    "No zk space: zakinit has not been called yet.", /* 389 */
    "Not #define", /* 390 */
    "Not #include", /* 391 */
    "Not #undef", /* 392 */
    "Number not allowed in context []\n", /* 393 */
    "Number of outputs must be the same as the previous locsig;", /* 394 */
    "Object/file not PVOC", /* 395 */
    "Offset %f < 0 or > tablelength", /* 396 */
    "Open bracket not allowed in context []\n", /* 397 */
    "Operator %c not allowed in context []\n", /* 398 */
    "Orchestra sampling rate is not compatible with HRTF.\n", /* 399 */
    "Output file type changed to IRCAM for use in pipe\n", /* 400 */
    "Overriding File Type to AIFF-C for AIFF float format\n", /* 401 */
    "Overriding File Type to AIFF-C for float output\n", /* 402 */
    "PERF ERROR in instr %d: %s\n", /* 403 */
    "PLAY........................................\n", /* 404 */
    "PMAX exceeded, string event truncated.\n", /* 405 */
    "PV frame %d bigger than %ld in %s", /* 406 */
    "PV frame %ld seems too small in %s", /* 407 */
    "PVADD cannot load %s", /* 408 */
    "PVADD ktimpnt truncated to last frame\n", /* 409 */
    "PVADD timpnt < 0", /* 410 */
    "PVOC cannot load %s", /* 411 */
    "PVOC debug : one frame gets through \n", /* 412 */
    "PVOC frame %d bigger than %ld in %s", /* 413 */
    "PVOC frame %ld seems too small in %s", /* 414 */
    "PVOC ktimpnt truncated to last frame\n", /* 415 */
    "PVOC timpnt < 0", /* 416 */
    "PVOC transpose too high", /* 417 */
    "PVOC transpose too low", /* 418 */
    "PVREAD cannot load %s", /* 419 */
    "PVRdH: wanted %d got %d\n", /* 420 */
    "PVRead: wanted %d got %ld\n", /* 421 */
    "Parameter number out of range", /* 422 */
    "Pickup out of range (%f)\n", /* 423 */
    "wguide2 xfreq1 and xfreq2 arguments must be both a-rate or k and i-rate", /* 424 */
    "-t 0\tuse score.srt for sorted score rather than a temporary\n", /* 425 */
    "bad size for PEAK chunk in AIFF file", /* 426 */
    "unknown PEAK chunk version in AIFF file", /* 427 */
    "cannot open device %s for audio output: %s", /* 428 */
    "cannot open device %s for audio input: %s", /* 429 */
    "Pole file not supported for this opcode !\n", /* 430 */
    "Port in map does not exist", /* 431 */
    "Q %4.1f needs %d samples, octdown has just %d", /* 432 */
    "QIOLOFIINFO failed %d times, errno = %d\n", /* 433 */
    "RECORD........................................\n", /* 434 */
    "RMScross = %6.1f, lambda = %ld\n", /* 435 */
    "RMStot = %6.1f\n", /* 436 */
    "RT Midi_event Console not implemented", /* 437 */
    "Random not in context []\n", /* 438 */
    "Read error on %s\n", /* 439 */
    "Reading sound from %s, writing lpfile to %s\n", /* 440 */
    "Real: %f   Imag: %f\n", /* 441 */
    "Redefinition of tempo", /* 442 */
    "Reflection invalid (%f)\n", /* 443 */
    "Repeat not at top level; ignored\n", /* 444 */
    "Repeat section (%d)\n", /* 445 */
    "Repeats=%d\n", /* 446 */
    "Result .. and what it should have been\n", /* 447 */
    "SECTION %d:\n", /* 448 */
    "SFDIR undefined.  using current directory\n", /* 449 */
    "SMPTE timing, %d frames/sec, %d ticks/frame\n", /* 450 */
    "SNDWARP at last sample frame\N", /* 451 */
    "SRate 44.1K or 22.05K only. This %ld playing at %ld\n", /* 452 */
    "STARTING FILE\n", /* 453 */
    "SUN audio record not available", /* 454 */
    "Sample rate set to %d (instead of %d)\n", /* 455 */
    "Score must start with orchestra section", /* 456 */
    "See usage.txt\n", /* 457 */
    "Seeding from current time %d\n", /* 458 */
    "Seeding with %.3f\n", /* 459 */
    "Selecting device %d\n", /* 460 */
    "Setting Phoneme: %f %d\n", /* 461 */
    "Should be %d...exiting.\n", /* 462 */
    "SingWave: rate=%f sweepRate=%f mytime=%f\n", /* 463 */
    "Size = %d", /* 464 */
    "Socket creation failed", /* 465 */
    "Soundcard DMA buffer size set to %d bytes (instead of %d)\n", /* 466 */
    "Source 1 s1ft table %.2f not found.\n", /* 467 */
    "Source 2 s2ft table %.2f not found.\n", /* 468 */
    "Source sft table %.2f not found.\n", /* 469 */
    "Specified device is out of range", /* 470 */
    "Start data", /* 471 */
    "Sustain level out of range!!, correcting\n", /* 472 */
    "Sync error\n", /* 473 */
    "Syntax error in macro call", /* 474 */
    "Syntax error: cannot back up", /* 475 */
    "Syntax error: no =", /* 476 */
    "Syntax error: no number", /* 477 */
    "Syntax error: no {", /* 478 */
    "Table %f not found\n", /* 479 */
    "Table kfn=%.2f < 1\n", /* 480 */
    "Table kfn=%.2f length %ld shorter than ksmps %d\n", /* 481 */
    "Table no. < 1 dft=%.2f  s1ft=%.2f  s2ft=%.2f\n", /* 482 */
    "Table no. < 1 dft=%.2f  sft=%.2f\n", /* 483 */
    "Table number < 1 dft=%.2f  s1ft=%.2f  s2ft=%.2f\n", /* 484 */
    "Table write k rate function table no. %f < 1", /* 485 */
    "Table write offset %f < 0 or > tablelength", /* 486 */
    "Tempo must be specified", /* 487 */
    "The Progress/Profile feature is currently disabled, sorry.\n", /* 488 */
    "The poles files have different pole count\n", /* 489 */
    "This Csound needs an 80x87", /* 490 */
    "Tie between different pitches", /* 491 */
    "Time values must be in increasing order", /* 492 */
    "Timeout waiting for DSP to boot\n", /* 493 */
    "Token length extended to %ld\n", /* 494 */
    "Tokens length extended to %d\n", /* 495 */
    "Too many arguments to macro", /* 496 */
    "Transform", /* 497 */
    "Trying to get solaris audio device...", /* 498 */
    "Type ENTER to continue...", /* 499 */
    "USAGE:\tlpanal [flags] infilename outfilename\n", /* 500 */
    "unable to allocate or lock memory", /* 501 */
    "Unable to configure MIDI port\n", /* 502 */
    "Unable to open Midi Port %s\n", /* 503 */
    "Undefined macro", /* 504 */
    "Undefining undefined macro", /* 505 */
    "Unexpected end of file", /* 506 */
    "unknown # option", /* 507 */
    "unknown distribution\n", /* 508 */
    "unknown chunk %.4s of size %ld\n", /* 509 */
    "unknown command :%s\n", /* 510 */
    "-F fpnum\tamount to scale amplitude for next input\n", /* 511 */
    "unknown lowest frequency for bowed string -- assuming 50Hz\n", /* 512 */
    "unknown GEN number", /* 513 */
    "Unmatched comment", /* 514 */
    "Unrecognised keyword", /* 515 */
    "Usage: cvanal [-d<duration>] [-c<channel>] [-b<begin time>] <input soundfile> <output impulse response FFT file> \n", /* 516 */
    "Usage: het_import commafile hetfile\n", /* 517 */
    "Usage: pvanal [-n<frmsiz>] [-w<windfact> | -h<hopsize>] [-g | -G<latch>] [-v | -V txtfile] inputSoundfile outputFFTfile\n", /* 518 */
    "Usage:\tcsound [-flags] orchfile scorefile\n", /* 519 */
    "Using %s type of file.\n", /* 520 */
    "Using filter coefficient storage method\n", /* 521 */
    "Using pole storage method\n", /* 522 */
    "Version: %s\n", /* 523 */
    "Volume must be between 0 and 100", /* 524 */
    "%s encoding information cannot\n       be contained in the header...\n", /* 525 */
    "%s\n", /* 526 */
    "xdns: zero Density requested\n", /* 527 */
    "WAVE IN device %d: %s\n", /* 528 */
    "WAVE OUT device %d: %s\n", /* 529 */
    "WAVE OUT unknown wave format\n", /* 530 */
    "Warning: High frequency diffusion<0\n", /* 531 */
    "Warning: High frequency diffusion>1\n", /* 532 */
    "Warning: Unknown # option", /* 533 */
    "Warning: params changed on tie", /* 534 */
    "Warp_factor = %f\n", /* 535 */
    "Will probably not work with playback routines\n", /* 536 */
    "Window type =%d\n", /* 537 */
    "Writing text form to file %s\n", /* 538 */
    "Wrong input count in multitap\n", /* 539 */
    "Wrong number of beats in bar", /* 540 */
    "Wrong number of input arguments\n", /* 541 */
    "Wrong number of outputs in locsig; must be 2 or 4", /* 542 */
    "Wrong number of outputs in sndwarpst; must be 2 or 4", /* 543 */
    "XY input", /* 544 */
    "\n PMLqueuesize = %d\n", /* 545 */
    "\n PostScript graphs written to file %s \n \n", /* 546 */
    "-F fname\tfile of a scale table for next input\n", /* 547 */
    "\n%d errors in performance\n", /* 548 */
    "follow - zero length!\n", /* 549 */
    "\nError: linseg not initialised (krate)\n", /* 550 */
    "\nINIT ERROR: %s\n", /* 551 */
    "\nLast argument must be the string 'HRTFcompact' ...correcting.\n", /* 552 */
    "\nPERF ERROR: %s\n", /* 553 */
    "\n\t   overall samples out of range:", /* 554 */
    "\n\t\trolloff vals:", /* 555 */
    "\n\tdbthresh %4.1f: X-corr %s threshon %4.1f, threshoff %4.1f\n", /* 556 */
    "\n\tremainder of line flushed\n", /* 557 */
    "-S integer\tsample number at which to insert file\n", /* 558 */
    "-T fpnum\ttime at which to insert file\n", /* 559 */
    "\t number of samples out of range:", /* 560 */
    "\t sect %d line %d\n", /* 561 */
    "\t%d oct analysis window delay = %ld samples (%d msecs)\n", /* 562 */
    "\t... closed\n", /* 563 */
    "\t... done\n", /* 564 */
    "\tAIFF soundfile", /* 565 */
    "\tQ %4.1f uses a %d sample window each octdown\n", /* 566 */
    "\tWAVE soundfile\n", /* 567 */
    "\t\t   T%7.3f - note deleted. ", /* 568 */
    "-1 -2 -3 -4\tinclude named channel\n", /* 569 */
    "\t\t\t(-P0 inhibits pitch tracking)\n", /* 570 */
    "\t\t\t(framesize will be twice <hopsize>)\n", /* 571 */
    "\t\t\tor for negative N, at -N kperiods\n", /* 572 */
    "\taudio samps %ld exceeds ftsize %ld\n", /* 573 */
    "\tauxch at %lx: size %lx, auxp %lx, endp %lx\n", /* 574 */
    "\tearly end of file\n", /* 575 */
    "\theadersiz %ld, datasiz %ld (%ld sample frames)\n", /* 576 */
    "\thigh cps %7.1f\n\t low cps %7.1f\n", /* 577 */
    "\tlooping endpoint %ld exceeds ftsize %ld\n", /* 578 */
    "\tsrate %ld, %s, %ld bit %s, %4.2f seconds\n", /* 579 */
    "\twhere flag options are:\n", /* 580 */
    "_____________Macintosh Command Line Flags_________________\n", /* 581 */
    "__________________________________________________________\n", /* 582 */
    "active:%d\n", /* 583 */
    "add recv_reply_port to set", /* 584 */
    "adsyn: not initialised", /* 585 */
    "aiff looping file, once through only\n", /* 586 */
    "alaw and ulaw not implemented here", /* 587 */
    "alaw audio_in not yet implemented", /* 588 */
    "alaw bytes", /* 589 */
    "alaw not yet implemented", /* 590 */
    "all", /* 591 */
    "allocate owner port", /* 592 */
    "allocate port set", /* 593 */
    "allocate timer reply port", /* 594 */
    "allpadd: not initialised", /* 595 */
    "-^ n m\tinclude channel n and output as channel m\n", /* 596 */
    "analysis aborted", /* 597 */
    "analysing %ld sample frames (%3.1f secs)", /* 598 */
    "analysing harmonic #%d\n", /* 599 */
    "arg1 is zero", /* 600 */
    "arg2 is zero", /* 601 */
    "audio buffered in %d sample-frame blocks\n", /* 602 */
    "audio relational", /* 603 */
    "audio sr = %ld, ", /* 604 */
    "audio_in %s format unclear, deducing %s\n", /* 605 */
    "audio_in %s has %ld chnls, orch %d chnls", /* 606 */
    "audio_in %s has sr = %ld, orch sr = %ld\n", /* 607 */
    "auxchfree: illegal auxp %lx in chain", /* 608 */
    "auxlist for instr %d (%lx):\n", /* 609 */
    "avail_ports:%d\n", /* 610 */
    "bad form for aifcReadHeader", /* 611 */
    "bad form for aiffReadHeader", /* 612 */
    "bad form for wavReadHeader", /* 613 */
    "bad header length %ld in '%s'", /* 614 */
    "balance:%d\n", /* 615 */
    "baseNote", /* 616 */
    "become owner", /* 617 */
    "bootfile: %s\n", /* 618 */
    "both", /* 619 */
    "buffer %p size %d\n", /* 620 */
    "buffer_size:%d\n", /* 621 */
    "bufsize = %ld frames\n", /* 622 */
    "buzz knh (%d) <= 0; taken as 1\n", /* 623 */
    "buzz: not initialised", /* 624 */
    "called from line %d of macro %s\n", /* 625 */
    "cannot find end of file %s", /* 626 */
    "cannot open %s, errno = %d\n", /* 627 */
    "cannot rewrite header if no header requested", /* 628 */
    "cannot write AIFF/WAV soundfile with no header", /* 629 */
    "cannot write header", /* 630 */
    "cannot create cscore.out", /* 631 */
    "cannot create output file", /* 632 */
    "cannot create output file\n", /* 633 */
    "cannot extract %s, name conflict", /* 634 */
    "cannot find %s\n", /* 635 */
    "cannot load %s", /* 636 */
    "cannot load %s, or SADIR undefined", /* 637 */
    "cannot open %s for read/write, SFDIR undefined", /* 638 */
    "cannot open %s for writing", /* 639 */
    "cannot write AIFF soundfile with no header", /* 640 */
    "cannot open %s, SFDIR undefined", /* 641 */
    "cannot open %s.  Not in cur dir, SSDIR or SFDIR as defined", /* 642 */
    "cannot open '%s'", /* 643 */
    "cannot open extract file %s", /* 644 */
    "cannot open orch file %s", /* 645 */
    "cannot open scorefile %s", /* 646 */
    "cannot read %s\n", /* 647 */
    "cannot read sformat %s\n", /* 648 */
    "cannot reopen %s", /* 649 */
    "cannot reopen cscore.out", /* 650 */
    "cannot reopen cscore.srt", /* 651 */
    "wrong number of args", /* 652 */
    "cfsetispeed", /* 653 */
    "channel %d illegal", /* 654 */
    "channel %d\n", /* 655 */
    "channel must be in the range 1 to 4", /* 656 */
    "channel peaks:\n", /* 657 */
    "channel request %d illegal\n", /* 658 */
    "channels:%d\n", /* 659 */
    "chnl %d using instr %d\n", /* 660 */
    "chnl mode msg %d not implemented\n", /* 661 */
    "click here to EXIT", /* 662 */
    "coef range: %6.3f - %6.3f\n", /* 663 */
    "coefficients too large(param1 + param2)", /* 664 */
    "comb: not initialised", /* 665 */
    "command-line srate / krate not integral", /* 666 */
    "convolve: not initialised", /* 667 */
    "could not allocate memory", /* 668 */
    "could not find indefinitely playing instr %d\n", /* 669 */
    "could not open file", /* 670 */
    "could not configure output device", /* 671 */
    "could not open space file", /* 672 */
    "could not redirect standard out\n", /* 673 */
    "could not write the outfile header", /* 674 */
    "cpstabm: invalid modulator table", /* 675 */
    "cscore lplay:  full Csound would now play the following score\n", /* 676 */
    "cscorinit: scorin not yet open", /* 677 */
    "ctrl %ld has no exclus list\n", /* 678 */
    "cvanal error: %s\n", /* 679 */
    "cvanal: Error allocating header\n", /* 680 */
    "db", /* 681 */
    "dbg_open: failed on %s\n", /* 682 */
    "deferred alloc\n", /* 683 */
    "deferred size for GEN1 only", /* 684 */
    "deferred size, but filesize unknown", /* 685 */
    "deferred-size ftable %f illegal here", /* 686 */
    "delay: not initialised", /* 687 */
    "delayr: not initialised", /* 688 */
    "delayw: not initialised", /* 689 */
    "deltap3: not initialised", /* 690 */
    "deltap: not initialised", /* 691 */
    "deltapi: not initialised", /* 692 */
    "deltapn: not initialised", /* 693 */
    "diskin %s superseded by %s header format %s\n", /* 694 */
    "diskin cannot find \"%s\" in its search paths", /* 695 */
    "diskin cannot open %s", /* 696 */
    "diskin read error - during backwards playback", /* 697 */
    "diskin seek error during reinit", /* 698 */
    "diskin seek error: invalid skip time", /* 699 */
    "diskin: illegal no of receiving channels", /* 700 */
    "diskin: not initialised", /* 701 */
    "dispfft: not initialised", /* 702 */
    "display", /* 703 */
    "display: not initialised", /* 704 */
    "displays suppressed\n", /* 705 */
    "divide by unary minus", /* 706 */
    "do not understand symbols\n", /* 707 */
    "dot carry has no reference\n", /* 708 */
    "duplicate label", /* 709 */
    "duration < zero\n", /* 710 */
    "encoding:%d\n", /* 711 */
    "end of MPU401 midifile '%s'\n", /* 712 */
    "end of audio_in file\n", /* 713 */
    "end of lplay event list\t      peak amps:", /* 714 */
    "end of midi track in '%s'\n", /* 715 */
    "end of score.\t\t   overall amps:", /* 716 */
    "end of section %d\t sect peak amps:", /* 717 */
    "end of track in midifile '%s'\n", /* 718 */
    "envlpx rise func ends with zero", /* 719 */
    "envlpx(krate): not initialised", /* 720 */
    "eof:%d\n", /* 721 */
    "error in opening %s\n", /* 722 */
    "error in score.  illegal opcode %c (ASCII %d)\n", /* 723 */
    "error line %d.  unknown label:\n", /* 724 */
    "error opening ASCII file", /* 725 */
    "error reading audio_filehdr", /* 726 */
    "error reading format data: is this a compressed file?", /* 727 */
    "error reading unknown chunk in WAV file", /* 728 */
    "error rewriting WAV header", /* 729 */
    "error rewriting sfheader", /* 730 */
    "error seeking to start of sound data", /* 731 */
    "error skipping unknown chunk in WAV file", /* 732 */
    "error trying to loop back to the beginning of the sound file!?!??", /* 733 */
    "error while closing sound mixer device", /* 734 */
    "error while opening %s", /* 735 */
    "error while reading DSP device for audio input", /* 736 */
    "error while rewriting AIFF header", /* 737 */
    "error while rewriting AIFF-C header", /* 738 */
    "error while seeking past AIFF chunk", /* 739 */
    "error while seeking past AIFF-C chunk", /* 740 */
    "error writing AIFF header", /* 741 */
    "error writing AIFF-C header", /* 742 */
    "error writing WAV header", /* 743 */
    "error writing size into sfheader", /* 744 */
    "error:  %s", /* 745 */
    "error:%d\n", /* 746 */
    "escape event, length %ld\n", /* 747 */
    "expression syntax", /* 748 */
    "expseg (arate): not initialised", /* 749 */
    "expseg (krate): not initialised", /* 750 */
    "extending Floating pool to %d\n", /* 751 */
    "f%3.0f%8.2f%8.2f%8.2f", /* 752 */
    "Failed to open MIDI output port to Csound Server.\n", /* 753 */
    "failed while querying soundcard about buffer size", /* 754 */
    "failed while trying to set soundcard DMA buffer size", /* 755 */
    "fcntl failed on %s", /* 756 */
    "fcntl", /* 757 */
    "fdclose: illegal fd %d in chain", /* 758 */
    "fdclose: no record of fd %d", /* 759 */
    "fdlist for instr %d (%lx):", /* 760 */
    "fft", /* 761 */
    "filclose: NULL file pointer\n", /* 762 */
    "filclose: fp not recorded\n", /* 763 */
    "file %s (%ld bytes) loaded into memory\n", /* 764 */
    "file %s bytes are in wrong order", /* 765 */
    "file too large for ortext space", /* 766 */
    "filter coefficient", /* 767 */
    "flag defaults: csound -s -otest -b%d -B%d -m7 -P128\n", /* 768 */
    "floats", /* 769 */
    "fof: not initialised", /* 770 */
    "form header not type 'AIFC'", /* 771 */
    "form header not type aiff", /* 772 */
    "form header not type wav", /* 773 */
    "foscil: not initialised", /* 774 */
    "foscili: not initialised", /* 775 */
    "frame: ", /* 776 */
    "frameSize must be between %d &%d\n", /* 777 */
    "freq est %6.1f,", /* 778 */
    "ftable %d now deleted\n", /* 779 */
    "-v\tverbose mode for debugging\n", /* 780 */
    "ftable %d:", /* 781 */
    "ftable %d:\n", /* 782 */
    "ftable does not exist", /* 783 */
    "ftable load error", /* 784 */
    "ftable %d relocating due to size change\ncurrently active instruments may find this disturbing\n", /* 785 */
    "ftell error on %s", /* 786 */
    "ftgen error", /* 787 */
    "ftgen string arg not allowed", /* 788 */
    "full requested duration not available\n", /* 789 */
    "gain:%d\n", /* 790 */
    "gauss: ill-conditioned", /* 791 */
    "gbuzz knh (%d) <= 0; taken as 1\n", /* 792 */
    "gbuzz: not initialised", /* 793 */
    "gen call has illegal x-ordinate values:", /* 794 */
    "gen call has negative segment size:", /* 795 */
    "getcurfp: no fp current\n", /* 796 */
    "grain4: not initialised", /* 797 */
    "grain: not initialised", /* 798 */
    "granule_set: Illegal combination of igskip and ilength", /* 799 */
    "granule_set: Illegal ithd, must be greater then 0", /* 800 */
    "granule_set: Illegal value of iatt and/or idec", /* 801 */
    "granule_set: Not enough voices for the number of pitches", /* 802 */
    "granule_set: Too many voices", /* 803 */
    "granule_set: Unable to find function table for envelop", /* 804 */
    "granule_set: Unable to find function table", /* 805 */
    "granule_set: WARNING * ilength may be too short * \n", /* 806 */
    "granule_set: igap_os must be 0%% to 100%%", /* 807 */
    "granule_set: igsize_os must be 0%% to 100%%", /* 808 */
    "granule_set: igskip_os must be greater then 0", /* 809 */
    "granule_set: imode must be -1, 0 or +1", /* 810 */
    "granule_set: ipitch1 must be greater then zero", /* 811 */
    "granule_set: ipitch2 must be greater then zero", /* 812 */
    "granule_set: ipitch3 must be greater then zero", /* 813 */
    "granule_set: ipitch4 must be greater then zero", /* 814 */
    "granule_set: ipshift must be integer between 0 and 4", /* 815 */
    "granule_set: iratio must be greater then 0", /* 816 */
    "granule_set: kgap must be greater then 0", /* 817 */
    "granule_set: kgsize must be greater then 0", /* 818 */
    "granule_set: must be positive and smaller than function table length", /* 819 */
    "graphics %s, ASCII substituted\n", /* 820 */
    "h of %d too low, reset to 1\n", /* 821 */
    "had %d init errors\n", /* 822 */
    "hardware buffers set to %d bytes\n", /* 823 */
    "harmon out of range", /* 824 */
    "harmon out of range...\n", /* 825 */
    "harmonic #%d:\tamp points %d, \tfrq points %d,\tpeakamp %d\n", /* 826 */
    "have not figured out DOS or BCC fcntl yet !!!\n", /* 827 */
    "header init errors", /* 828 */
    "hetro:  %s\n\tanalysis aborted\n", /* 829 */
    "hex", /* 830 */
    "hopsize may be too small, recommend at least poleCount * 5\n", /* 831 */
    "hrtfer: not initialised", /* 832 */
    "htim ftable must be all-positive", /* 833 */
    "i%ld pset args != pmax\n", /* 834 */
    "ifn table begins with zero", /* 835 */
    "ilen > ksmps", /* 836 */
    "illegal Q value", /* 837 */
    "illegal RT scoreline:\n%s\n", /* 838 */
    "illegal channel number", /* 839 */
    "illegal channel", /* 840 */
    "illegal character %c", /* 841 */
    "illegal code %d encountered", /* 842 */
    "illegal control number at position n.%d", /* 843 */
    "illegal controller number", /* 844 */
    "illegal ctrl no", /* 845 */
    "illegal delay time", /* 846 */
    "illegal encode for SFSUN41", /* 847 */
    "illegal frqratio, %5.2f", /* 848 */
    "illegal ftable number", /* 849 */
    "illegal gen number", /* 850 */
    "illegal idisprd", /* 851 */
    "illegal ifrqs", /* 852 */
    "illegal ihtim", /* 853 */
    "illegal imemdur", /* 854 */
    "illegal imindur", /* 855 */
    "illegal initvalue at position n.%d", /* 856 */
    "illegal input to getsizformat", /* 857 */
    "illegal input val (y <= 0) for gen call, beginning:", /* 858 */
    "illegal input vals for gen call, beginning:", /* 859 */
    "illegal instr number", /* 860 */
    "illegal iocts", /* 861 */
    "illegal iperiod", /* 862 */
    "illegal iprd", /* 863 */
    "illegal istartempo value", /* 864 */
    "illegal itweek", /* 865 */
    "illegal lo-hi values", /* 866 */
    "illegal loop time", /* 867 */
    "illegal lsb control number at position n.%d", /* 868 */
    "illegal midi channel", /* 869 */
    "illegal midi chnl no %d", /* 870 */
    "illegal mrtmsg argument", /* 871 */
    "illegal msb control number at position n.%d", /* 872 */
    "illegal no of output args", /* 873 */
    "illegal no of partials", /* 874 */
    "illegal ntracks in '%s'", /* 875 */
    "illegal number of filenames", /* 876 */
    "illegal opcod from expr anal", /* 877 */
    "illegal order num. (min 1, max 10)", /* 878 */
    "illegal release loop data", /* 879 */
    "illegal reson iscl value, %f", /* 880 */
    "illegal roughness factor(param1) value", /* 881 */
    "illegal sampframsiz", /* 882 */
    "illegal sfcode type", /* 883 */
    "illegal startempo", /* 884 */
    "illegal stretch factor(param1) value", /* 885 */
    "illegal stretch factor(param2) value", /* 886 */
    "illegal strset index\n", /* 887 */
    "illegal sustain loop data", /* 888 */
    "illegal table length", /* 889 */
    "illegal tempo", /* 890 */
    "illegal value for iolaps", /* 891 */
    "illegal x interval", /* 892 */
    "illegal xamp value", /* 893 */
    "illegal xint value", /* 894 */
    "improper chunksize in '%s'", /* 895 */
    "in line %f of file input %s\n", /* 896 */
    "inactive allocs returned to freespace\n", /* 897 */
    "inconsistent AIFF sizes", /* 898 */
    "inconsistent AIFF-C sizes", /* 899 */
    "inconsistent WAV size", /* 900 */
    "inconsistent argoff sumcount", /* 901 */
    "inconsistent opds total", /* 902 */
    "inconsistent sr, kr, ksmps", /* 903 */
    "inconsistent strarg sizecount", /* 904 */
    "incorrect cond value format", /* 905 */
    "incorrect logical arguments", /* 906 */
    "incorrect number of filenames", /* 907 */
    "index %ld exceeds ctrl %ld exclus list\n", /* 908 */
    "indexing overflow error", /* 909 */
    "indx=%ld (%lx); (short)indx = %d (%x)\n", /* 910 */
    "\init phase truncation\n", /* 911 */
    "input and begin times cannot be less than zero", /* 912 */
    "input arg '%s' of type %s not allowed when expecting %c", /* 913 */
    "input arg '%s' used before defined", /* 914 */
    "input framesize (inter-frame-offset*2) exceeds maximum allowed", /* 915 */
    "inputs have diff. time periods", /* 916 */
    "inputs have different amptypes", /* 917 */
    "inputs have different freq resolution", /* 918 */
    "inputs have different sizes", /* 919 */
    "Input formats not the same", /* 920 */
    "instr %d %s, dft (%s), %ld octaves (%3.1f - %3.1f Hz):", /* 921 */
    "instr %d %s, dft (%s), %ld octaves (%d - %d Hz):", /* 922 */
    "instr %d allocated at %p\n\tlclbas %p, opds %p\n", /* 923 */
    "instr %d does not exist. Cannot assign it to chan %d", /* 924 */
    "instr %d expects midi event data, cannot run from score\n", /* 925 */
    "instr %d had %d init errors\n", /* 926 */
    "instr %d p%d illegal for MIDI", /* 927 */
    "instr %d uses %d p-fields but is given %d", /* 928 */
    "instr %d seeking midi chnl data, assigned chnl %d\n", /* 929 */
    "flag defaults: mixer -s -otest -F 1.0 -S 0\n", /* 930 */
    "instr %d, signal %s, fft (%s):", /* 931 */
    "instr %d, signal %s:", /* 932 */
    "no scale factor", /* 933 */
    "instr %ld now on\n", /* 934 */
    "instr %ld redefined", /* 935 */
    "instr blocks cannot be nested (missing 'endin'?)", /* 936 */
    "insufficient args and no file header", /* 937 */
    "table size must be the same of source table", /* 938 */
    "insufficient arguments", /* 939 */
    "insufficient arguments\n", /* 940 */
    "insufficient gen arguments", /* 941 */
    "insufficient required arguments", /* 942 */
    "insufficient sound for analysis", /* 943 */
    "insufficient terms", /* 944 */
    "Insufficient memory\n", /* 945 */
    "ioctl", /* 946 */
    "isfinit: cannot open %s", /* 947 */
    "itablecopy is a deprecated opcode -- please use tableicopy\n", /* 948 */
    "itablegpw is a deprecated opcode -- please use tableigpw\n", /* 949 */
    "itablemix is a deprecated opcode -- please use tableimix\n", /* 950 */
    "itablew is a deprecated opcode -- please use tableiw\n", /* 951 */
    "ival%d is zero", /* 952 */
    "ival%d sign conflict", /* 953 */
    "ixmod out of range.", /* 954 */
    "k rate function table no. %f < 1", /* 955 */
    "k-period aligned audio buffering\n", /* 956 */
    "kfn table %.2f not found\n", /* 957 */
    "kin lopass coef1 %6.4f, fwd mask coef1 %6.4f\n", /* 958 */
    "kperiods/tick = %7.3f\n", /* 959 */
    "ksmps of %d needs wdw of %d, max is %d for pv %s\n", /* 960 */
    "kstart %.2f is outside table %.2f range 0 to %ld\n", /* 961 */
    "label list is full", /* 962 */
    "lambda %d, unilam %6.2f, RMScross %6.2f\n", /* 963 */
    "Cannot open scale table file %s\n", /* 984 */
    "less sound than expected!", /* 965 */
    "line LENMAX exceeded", /* 966 */
    "linseg: not initialised (arate)\n", /* 967 */
    "locscil: sustain defers to non-looping source\n", /* 968 */
    "longs", /* 969 */
    "losc: no sample rate stored in function assuming=sr\n", /* 970 */
    "lpfile srate != orch sr\n", /* 971 */
    "lpheader comment:\n%s\n", /* 972 */
    "lpheader overriding inputs\n", /* 973 */
    "lpinterpol works only with poles files..", /* 974 */
    "lpinterpol: not initialised", /* 975 */
    "lpread ktimpnt truncated to last frame\n", /* 976 */
    "lpread timpnt < 0", /* 977 */
    "lpread: not initialised", /* 978 */
    "LPC slot is not allocated\n", /* 979 */
    "lpslot number should be positive\n", /* 980 */
    "illegal reson iscl value, %f", /* 981 */
    "macro %s undefined\n", /* 982 */
    "mixing %ld sample frames (%3.1f secs)\n", /* 983 */
    "macro error\n", /* 984 */
    "mag", /* 985 */
    "makecurrent: fp not recorded\n", /* 986 */
    "massign: chnl %d exists, ctrls now defaults\n", /* 987 */
    "memfiles: cannot allocate for MEMFIL extension", /* 988 */
    "memory allocate failure for %d\n", /* 989 */
    "memory fault\n", /* 990 */
    "midi channel %d now using instr %d\n", /* 991 */
    "midi channel %d using instr %d\n", /* 992 */
    "midi init cannot find any instrs", /* 993 */
    "External LOOP=%d Level:%d\n", /* 994 */
    "%s Nested LOOP=%d Level:%d\n", /* 995 */
    "LOOP not at top level; ignored\n", /* 996 */
    "misplaced comma", /* 997 */
    "misplaced opcode", /* 998 */
    "misplaced relational op", /* 999 */
    "misplaced string\n", /* 1000 */
    "missing fscale table", /* 1001 */
    "missing htim ftable", /* 1002 */
    "missing or extra arg", /* 1003 */
    "modified opcod: %s\n", /* 1004 */
    "monaural", /* 1005 */
    "monaural\n", /* 1006 */
    "mono loscil cannot read from stereo ftable", /* 1007 */
    "multitap: not initialised", /* 1008 */
    "need quoted filename", /* 1009 */
    "negative rates not allowed!!, correcting\n", /* 1010 */
    "negative segsiz", /* 1011 */
    "negative time period", /* 1012 */
    "new alloc for instr %d:\n", /* 1013 */
    "nh partials < 1", /* 1014 */
    "nlfilt: not initialised", /* 1015 */
    "no -s and no soundheader, using sr default %ld\n", /* 1016 */
    "no Linein score device_name", /* 1017 */
    "no MIDI output device", /* 1018 */
    "no Rate for Profile Display", /* 1019 */
    "no Rate for Progress Display", /* 1020 */
    "no amplitude maximum", /* 1021 */
    "no amplitude minimum", /* 1022 */
    "no analysis directory name", /* 1023 */
    "no arguments", /* 1024 */
    "no begin time", /* 1025 */
    "no channel", /* 1026 */
    "no coefs present", /* 1027 */
    "no comment string", /* 1028 */
    "no control rate", /* 1029 */
    "no duration time", /* 1030 */
    "no filter cutoff", /* 1031 */
    "no framesize", /* 1032 */
    "no fundamental estimate", /* 1033 */
    "no hardware bufsamps", /* 1034 */
    "no harmonic count", /* 1035 */
    "no high frequency", /* 1036 */
    "no hopsize", /* 1037 */
    "no infilename", /* 1038 */
    "no iobufsamps", /* 1039 */
    "no latch", /* 1040 */
    "no legal base frequency\n", /* 1041 */
    "no legal opcode", /* 1042 */
    "no listing file name", /* 1043 */
    "no log file", /* 1044 */
    "no low frequency", /* 1045 */
    "no message level", /* 1046 */
    "no midi device_name", /* 1047 */
    "no midifile name", /* 1048 */
    "no number of graphs", /* 1049 */
    "no number of output points", /* 1050 */
    "no orchestra name", /* 1051 */
    "no outfilename", /* 1052 */
    "no output file for trace", /* 1053 */
    "no poles", /* 1054 */
    "no pool for unexpected global name", /* 1055 */
    "no sample rate", /* 1056 */
    "no sampling rate", /* 1057 */
    "no screen buffer size", /* 1058 */
    "no sound file directory name", /* 1059 */
    "no sound sample directory name", /* 1060 */
    "no sound written to disk\n", /* 1061 */
    "no soundin header, presuming orchestra sr\n", /* 1062 */
    "no tempo value", /* 1063 */
    "no utility name", /* 1064 */
    "no verbose level", /* 1065 */
    "no volume level", /* 1066 */
    "no windfact", /* 1067 */
    "no xfilename", /* 1068 */
    "noctdft: %s window, %s out, making tables ...\n", /* 1069 */
    "noctdft: Q %4.1f uses %d of %d samps per octdown\n", /* 1070 */
    "noctdft: not initialised", /* 1071 */
    "noctdft: unknown dbout code of %d", /* 1072 */
    "non-deferred ftable %d needs size %ld\n", /* 1073 */
    "non-looping sample\n", /* 1074 */
    "non-positive iatdec", /* 1075 */
    " External LOOP section (%d) Level:%d\n", /* 1076 */
    "not a PVOC file", /* 1077 */
    "not supported on this terminal", /* 1078 */
    "not writing to sound disk\n", /* 1079 */
    "npoles %ld, nvals %ld, totvals %ld, lastfram16 = %lx\n", /* 1080 */
    "npoles > MAXPOLES", /* 1081 */
    "null iopadr", /* 1082 */
    "null opadr", /* 1083 */
    "null record type, %s\n", /* 1084 */
    "number of output points is too great", /* 1085 */
    "numeric syntax '%s'", /* 1086 */
    "nxtopds = %p opdslim = %p\n", /* 1087 */
    "oct", /* 1088 */
    "octdft windowed sines:", /* 1089 */
    "octdown buffers:", /* 1090 */
    "op %d (%s) allocated at %p\n", /* 1091 */
    "open:%d\n", /* 1092 */
    "opening %s infile %s, with%s bytrev\n", /* 1093 */
    "opening %s outfile %s, with%s bytrev\n", /* 1094 */
    "opening NeXT infile %s, with%s bytrev\n", /* 1095 */
    "openout: illegal dirtyp", /* 1096 */
    "openwr: illegal dirtyp", /* 1097 */
    "orch compiler:\n", /* 1098 */
    "orch now loaded\n", /* 1099 */
    "orchname:  %s\n", /* 1100 */
    "oscil(krate): not initialised", /* 1101 */
    "oscil1(krate): not initialised", /* 1102 */
    "oscil1i(krate): not initialised", /* 1103 */
    "oscil3(krate): not initialised", /* 1104 */
    "oscil3: not initialised", /* 1105 */
    "oscil: not initialised", /* 1106 */
    "oscili(krate): not initialised", /* 1107 */
    "oscili: not initialised", /* 1108 */
    "osciln: not initialised", /* 1109 */
    "out contr14 msb:%x lsb:%x\n", /* 1110 */
    "output arg '%s' illegal type", /* 1111 */
    "output name previously used, type '%c' must be uniquely defined", /* 1112 */
    "output soundfile cannot be both AIFF and WAV", /* 1113 */
    "output timer port", /* 1114 */
    "over %d harmonics but continuing", /* 1115 */
    "overall peak: %f\n", /* 1116 */
    "padding error", /* 1117 */
    "pan: not initialised", /* 1118 */
    "partial count exceeds MAXPTLS", /* 1119 */
    "pause:%d\n", /* 1120 */
    "%s  Nested LOOP section (%d) Level:%d\n", /* 1121 */
    "pch track range: %5.1f - %5.1f Hz\n", /* 1122 */
    "per oct rolloff too steep", /* 1123 */
    "perf-pass statements illegal in header block", /* 1124 */
    "pitch tracking inhibited\n", /* 1125 */
    "pitch: not initialised", /* 1126 */
    "playing from cscore.srt\n", /* 1127 */
    "playopen: BeOS supports either one or two channels.", /* 1128 */
    "playopen: cannot open DAC.", /* 1129 */
    "pluck: not initialised", /* 1130 */
    "pole", /* 1131 */
    "poles exceeds maximum allowed", /* 1132 */
    "poles=%d hopsize=%d begin=%4.1f duration=%4.1f\n", /* 1133 */
    "port:%d\n", /* 1134 */
    "precision:%d\n", /* 1135 */
    "printks parm 1 was not a \"quoted string\"\n", /* 1136 */
    "psave beg at %p\n", /* 1137 */
    "-3\t24bit sound samples\n", /* 1138 */
    "pv_export usage: pvfile commafile\n", /* 1139 */
    "pvadd: not initialised", /* 1140 */
    "pvanal cannot have both -w and -h", /* 1141 */
    "pvanal: %d is a bad window overlap index\n", /* 1142 */
    "pvanal: frameSize must be 2^r", /* 1143 */
    "pvbufread: not initialised", /* 1144 */
    "pvcross: not initialised", /* 1145 */
    "pvinterp: not initialised", /* 1146 */
    "pvoc: not initialised", /* 1147 */
    "quad", /* 1148 */
    "read error on %s", /* 1149 */
    "read error", /* 1150 */
    "reading %d-byte blks of %s from %s %s\n", /* 1151 */
    "reading sys_ex event, length %ld\n", /* 1152 */
    "realtime performance using dummy numeric scorefile\n", /* 1153 */
    "recopen: BeOS supports either one or two channels.", /* 1154 */
    "recopen: Cannot allocate ADC buffer.", /* 1155 */
    "recopen: cannot open ADC.", /* 1156 */
    "recv port", /* 1157 */
    "redirecting standard out to %s......\n", /* 1158 */
    "release loop playMode", /* 1159 */
    "release loop", /* 1160 */
    "replacing previous ftable %d\n", /* 1161 */
    "req chan %d, file %s has only %ld", /* 1162 */
    "reset input buffers blocksize to power of 2 (%ld)\n", /* 1163 */
    "reset output buffer blocksize to power of 2 (%ld)\n", /* 1164 */
    "reverb2: not initialised", /* 1165 */
    "reverb: not initialised", /* 1166 */
    "revlpsiz inconsistent\n", /* 1167 */
    "rise func ends with zero", /* 1168 */
    "rtaudio: illegal dsize", /* 1169 */
    "rtplay: failed write to DAC port\n", /* 1170 */
    "rtrecord: error reading from ADC port", /* 1171 */
    "s", /* 1172 */
    "sample rate overrides: esr = %7.1f, ekr = %7.1f, ksmps = %d\n", /* 1173 */
    "sample_rate:%d\n", /* 1174 */
    "samples:%d\n", /* 1175 */
    "scale = %f\n", /* 1176 */
    "schedule event ignored. instr %d undefined\n", /* 1177 */
    "score error:  %s on line %d position %d", /* 1178 */
    "scorename: %s\n", /* 1179 */
    "scot processing terminated\n", /* 1180 */
    "scot: %d errors.\n", /* 1181 */
    "see also:  Csound Manual Appendix\n", /* 1182 */
    "seek error while updating AIFF header", /* 1183 */
    "seek error while updating AIFF-C header", /* 1184 */
    "sensMIDI: retval errno %d", /* 1185 */
    "sfheader codes corrupted\n", /* 1186 */
    "sfinit: cannot open %s", /* 1187 */
    "sfinit: cannot open /dev/audio", /* 1188 */
    "shorts", /* 1189 */
    "signed chars", /* 1190 */
    "skip time larger than audio data,substituting zero.\n", /* 1191 */
    "skipping meta event type %x\n", /* 1192 */
    "sndwarp: not initialised", /* 1193 */
    "sndwarpst: not initialised", /* 1194 */
    "sort: illegal opcode\n", /* 1195 */
    "sorting cscore.out ..\n", /* 1196 */
    "sorting score ...\n", /* 1197 */
    "Sound format -%c has been overruled by -%c\n", /* 1198 */
    "soundcard does not support the requested sample format", /* 1199 */
    "soundfile header write error.  aborting ...", /* 1200 */
    "soundfile read error", /* 1201 */
    "soundfile read error, could not fill first frame", /* 1202 */
    "soundfile write returned bytecount of %d, not %d\n", /* 1203 */
    "soundin %s superseded by %s header format %s\n", /* 1204 */
    "soundin cannot find \"%s\" in its search paths", /* 1205 */
    "soundin cannot open %s", /* 1206 */
    "soundin of %s not implemented", /* 1207 */
    "soundin seek error", /* 1208 */
    "soundin: illegal no of receiving channels", /* 1209 */
    "soundin: not initialised", /* 1210 */
    "soundout cannot find %s in search paths", /* 1211 */
    "soundout cannot open %s", /* 1212 */
    "space: not initialised", /* 1213 */
    "spdist: not initialised", /* 1214 */
    "specaddm: not initialised", /* 1215 */
    "specdiff: local buffers not initialised", /* 1216 */
    "specdiff: not initialised", /* 1217 */
    "specdisp: not initialised", /* 1218 */
    "specdisp: not initialised", /* 1219 */
    "specfilt: local buffers not initialised", /* 1220 */
    "specfilt: not initialised", /* 1221 */
    "spechist: local buffers not initialised", /* 1222 */
    "spechist: not initialised", /* 1223 */
    "specptrk: %d freqs, %d%s ptls at ", /* 1224 */
    "specptrk: not initialised", /* 1225 */
    "specscal: local buffer not initialised", /* 1226 */
    "specscal: not initialised", /* 1227 */
    "specsum: not initialised", /* 1228 */
    "spectrum windowed sines:", /* 1229 */
    "spectrum: %s window, %s out, making tables ...\n", /* 1230 */
    "srate and krate overrides must occur jointly", /* 1231 */
    "sread is confused on legal opcodes\n", /* 1232 */
    "sread:  text space overrun, increase MARGIN\n", /* 1233 */
    "sread: illegal number format, sect %d line %d:  ", /* 1234 */
    "sread: illegal opcode %c, sect %d line %d\n", /* 1235 */
    "sread: illegal use of carry, sect %d line %d,   0 substituted\n", /* 1236 */
    "sread: illegally placed string, sect %d line %d\n", /* 1237 */
    "sread: instr pcount exceeds PMAX\n", /* 1238 */
    "sread: requesting more memory\n", /* 1239 */
    "sread: unexpected char %c, sect %d line %d\n", /* 1240 */
    "sread: unmatched quote, sect %d line %d\n", /* 1241 */
    "stdin audio not supported", /* 1242 */
    "stdmode = %.8x Linefd = %d\n", /* 1243 */
    "stdout audio not supported", /* 1244 */
    "stereo loscil cannot read from mono ftable", /* 1245 */
    "stereo", /* 1246 */
    "striking three times here!!!\n", /* 1247 */
    "striking twice here!!\n", /* 1248 */
    "strset index conflict\n", /* 1249 */
    "suppressed", /* 1250 */
    "sustain count still %d\n", /* 1251 */
    "sustain loop playMode", /* 1252 */
    "sustain loop", /* 1253 */
    "swrite: output, sect%d line%d p%d expramp has illegal forward or backward ref\n", /* 1254 */
    "swrite: output, sect%d line%d p%d has illegal expramp symbol\n", /* 1255 */
    "swrite: output, sect%d line%d p%d has illegal number  ", /* 1256 */
    "swrite: output, sect%d line%d p%d has illegal ramp symbol\n", /* 1257 */
    "swrite: output, sect%d line%d p%d has illegally terminated string   ", /* 1258 */
    "swrite: output, sect%d line%d p%d makes illegal reference to ", /* 1259 */
    "swrite: output, sect%d line%d p%d ramp has illegal forward or backward ref\n", /* 1260 */
    "swrite: unexpected opcode, section %d line %d\n", /* 1261 */
    "system exclusive buffer overflow\n", /* 1262 */
    "table size too large", /* 1263 */
    "table(krate): not initialised", /* 1264 */
    "table3(krate): not initialised", /* 1265 */
    "table3: not initialised", /* 1266 */
    "table: not initialised", /* 1267 */
    "tablei(krate): not initialised", /* 1268 */
    "tablei: not initialised", /* 1269 */
    "tableseg: not initialised", /* 1270 */
    "tablexseg: not initialised", /* 1271 */
    "target label '%s' not found", /* 1272 */
    "tcgetattr", /* 1273 */
    "tcsetattr", /* 1274 */
    "tempest", /* 1275 */
    "tempest: not initialised", /* 1276 */
    "term count", /* 1277 */
    "terminating. ", /* 1278 */
    "time %11.5f:", /* 1279 */
    "time advanced %5.3f beats by score request\n", /* 1280 */
    "timer start", /* 1281 */
    "timer_track: netname_look_up error", /* 1282 */
    "token storage LENTOT exceeded", /* 1283 */
    "too few pfields\n", /* 1284 */
    "too few points requested", /* 1285 */
    "too many arguments", /* 1286 */
    "too many input args", /* 1287 */
    "too many input files open\n", /* 1288 */
    "too many iterations in laguer", /* 1289 */
    "too many open files", /* 1290 */
    "too many pfields\n", /* 1291 */
    "too many points requested", /* 1292 */
    "too many turnons waiting\n", /* 1293 */
    "tracksize = %ld\n", /* 1294 */
    "treqd %c, tfound %c\n", /* 1295 */
    "treqd = l\n", /* 1296 */
    "try increasing preferred size setting for the Perf Application\n", /* 1297 */
    "turnon deleted. instr %d ", /* 1298 */
    "turnon deleted. instr %d undefined\n", /* 1299 */
    "twarp: illegal opcode\n", /* 1300 */
    "twarp: t has extra or disordered beat value\n", /* 1301 */
    "twarp: t has non-positive tempo\n", /* 1302 */
    "twarp: t segments exceed twarp array\n", /* 1303 */
    "ulaw bytes", /* 1304 */
    "External LOOP terminated, level:%d\n", /* 1305 */
    "unable to close DSP device", /* 1306 */
    "unable to open soundcard for audio input", /* 1307 */
    "unable to open soundcard for audio output", /* 1308 */
    "unable to open soundcard mixer for setting volume", /* 1309 */
    "unable to set mode (mono/stereo) on soundcard", /* 1310 */
    "unable to set output volume on soundcard", /* 1311 */
    "unable to set requested sample format on soundcard\n", /* 1312 */
    "unable to set sample rate on soundcard\n", /* 1313 */
    "unary mult or divide", /* 1314 */
    "unbalanced parens", /* 1315 */
    "undefined sys-realtime msg %x\n", /* 1316 */
    "undefined sys_common msg %x\n", /* 1317 */
    "undetermined file length, will attempt requested duration\n", /* 1318 */
    "uneven ctrl pairs", /* 1319 */
    "uneven number of args", /* 1320 */
    "unexpected audio input length of %d (float)", /* 1321 */
    "unexpected audio input length of %d (linear)", /* 1322 */
    "unexpected end of '%s'", /* 1323 */
    "%s Nested LOOP terminated, level:%d\n", /* 1324 */
    "unexpected global name", /* 1325 */
    "unexpected quote character", /* 1326 */
    "unknown NPRN lsb %d\n", /* 1327 */
    "unknown audio_in format", /* 1328 */
    "unknown audio_out format", /* 1329 */
    "unknown csr field", /* 1330 */
    "unknown dbcode", /* 1331 */
    "unknown dbout code", /* 1332 */
    "unknown drum param nos, msb %ld lsb %ld\n", /* 1333 */
    "unknown flag -%c", /* 1334 */
    "unknown format request", /* 1335 */
    "unknown instr", /* 1336 */
    "unknown kdump format", /* 1337 */
    "unknown method code", /* 1338 */
    "unknown nametype", /* 1339 */
    "unknown opcode %c\n", /* 1340 */
    "unknown opcode", /* 1341 */
    "unknown sample format", /* 1342 */
    "unknown sound format %d(0x%x)", /* 1343 */
    "unknown srctable number", /* 1344 */
    "unknown", /* 1345 */
    "unlike signs", /* 1346 */
    "unmatched endin", /* 1347 */
    "unmatched quotes", /* 1348 */
    "unmatched quotes\n", /* 1349 */
    "unrecognised flag -%c", /* 1350 */
    "unrecognised message type %d", /* 1351 */
    "unrecognised switch option", /* 1352 */
    "unrecognised sys_common type %d", /* 1353 */
    "unresolved slur", /* 1354 */
    "unresolved tie", /* 1355 */
    "unsigned bytes", /* 1356 */
    "unsupported CONVOLVE data format %ld in %s", /* 1357 */
    "unsupported PV data format %ld in %s", /* 1358 */
    "unsupported PVOC data format %ld in %s", /* 1359 */
    "unsupported wave format", /* 1360 */
    "using Cscore processing\n", /* 1361 */
    "using previous %s\n", /* 1362 */
    "util CVANAL:\n", /* 1363 */
    "util HETRO:\n", /* 1364 */
    "util LPANAL:\n", /* 1365 */
    "util PVANAL:\n", /* 1366 */
    "util SNDINFO:\n", /* 1367 */
    "value out of range", /* 1368 */
    "vco knh (%d) <= 0; taken as 1\n", /* 1369 */
    "vco: not initialised", /* 1370 */
    "vdelay3: not initialised", /* 1371 */
    "vdelay: not initialised", /* 1372 */
    "voscili: not initialised", /* 1373 */
    "vpvoc: not initialised", /* 1374 */
    "waiting for buffer to open", /* 1375 */
    "waiting:%d\n", /* 1376 */
    "we are confused.  file '%s' begins with 'MT',\nbut not a legal header chunk", /* 1377 */
    "winGL:MakeGraph: fmfindfont failed.\n", /* 1378 */
    "window size must be power of two", /* 1379 */
    "within parens", /* 1380 */
    "write error", /* 1381 */
    "writing %d-byte blks of %s to %s", /* 1382 */
    "wrote %ld bytes to %s\n", /* 1383 */
    "x coordinate greater than function size:", /* 1384 */
    "x coordinates must all be in increasing order:", /* 1385 */
    "xfilename: %s\n", /* 1386 */
    "xincod = %d\n", /* 1387 */
    "zacl first > last. Not clearing.", /* 1388 */
    "zacl first or last < 0. Not clearing.", /* 1389 */
    "zacl first or last > isizea. Not clearing.", /* 1390 */
    "zakinit should only be called once.", /* 1391 */
    "zakinit: both isizea and isizek should be > 0.", /* 1392 */
    "zamod kzamod > isizea. Not writing.", /* 1393 */
    "zar index < 0. Returning 0.", /* 1394 */
    "zar index > isizea. Returning 0.", /* 1395 */
    "zarg index < 0. Returning 0.", /* 1396 */
    "zarg index > isizea. Returning 0.", /* 1397 */
    "zaw index < 0. Not writing.", /* 1398 */
    "zaw index > isizea. Not writing.", /* 1399 */
    "zero length escape event", /* 1400 */
    "zero length sys_ex event", /* 1401 */
    "zir index < 0. Returning 0.\n", /* 1402 */
    "zir index > isizek. Returning 0.\n", /* 1403 */
    "ziwm index < 0. Not writing.", /* 1404 */
    "ziwm index > isizek. Not writing.", /* 1405 */
    "zkcl first > last. Not clearing.", /* 1406 */
    "zkcl first or last < 0. Not clearing.", /* 1407 */
    "zkcl first or last > isizek. Not clearing.", /* 1408 */
    "zkmod kzkmod > isizek. Not writing.", /* 1409 */
    "zkr index < 0. Returning 0.\n", /* 1410 */
    "zkr index > isizek. Returning 0.\n", /* 1411 */
    "zkw index < 0. Not writing.", /* 1412 */
    "zkw index > isizek. Not writing.", /* 1413 */
    "zkwm index < 0. Not writing.", /* 1414 */
    "zkwm index > isizek. Not writing.", /* 1415 */
    "            be taken into consideration.\nilength is ", /* 1416 */
    "no start sample", /* 1417 */
    "-S overriding -T", /* 1418 */
    "no start time", /* 1419 */
    "-T overriding -S", /* 1420 */
    "no source channel number", /* 1421 */
    "no destination channel number", /* 1422 */
    "illegal channel number ignored", /* 1423 */
    "adsynt: partial count is greater than freqtable size", /* 1424 */
    "Too many mixin", /* 1425 */
    "Usage:\textracter [-flags] soundfile\n", /* 1426 */
    "-N\t\tnotify (ring the bell) when done\n", /* 1427 */
    "-S integer\tsample number at which to start file\n", /* 1428 */
    "-Z integer\tsample number at which to end file\n", /* 1429 */
    "-Q integer\tnumber of samples to read\n", /* 1430 */
    "-T fpnum\ttime in secs at which to start file\n", /* 1431 */
    "-E fpnum\ttime in secs at which to end file\n", /* 1432 */
    "-D fpnum\tduration in secs of extract\n", /* 1433 */
    "flag defaults: extracter -otest -S 0\n", /* 1434 */
    "-Z overriding -E", /* 1435 */
    "-Z overriding -D", /* 1436 */
    "-Z overriding -Q", /* 1437 */
    "no end time", /* 1438 */
    "-E overriding -D", /* 1439 */
    "-E overriding -Q", /* 1440 */
    "-E overriding -Z", /* 1441 */
    "-D overriding -E", /* 1442 */
    "-D overriding -Q", /* 1443 */
    "-D overriding -Z", /* 1444 */
    "no sample count", /* 1445 */
    "-Q overriding -E", /* 1446 */
    "-Q overriding -D", /* 1447 */
    "-Q overriding -Z", /* 1448 */
    "No input", /* 1449 */
    "Times %f %f %f\nNums %ld %ld %ld\n", /* 1450 */
    "Extracting from sample %ld for %ld samples (%.5f secs)\n", /* 1451 */
    "extracting from %ld sample frames (%3.1f secs)\n", /* 1452 */
    "illegal reson iscl value, %f", /* 1453 */
    "Upper not in context []\n", /* 1454 */
    "No valid header.  Calculating length using output file's format\n", /* 1455 */
    "No valid header.  Returning output nchnls\n", /* 1456 */
    "No valid header.  Returning orch's sr", /* 1457 */
    "Input channel for peak exceeds number of channels in file", /* 1458 */
    "No valid header.  Cannot calculate peak values", /* 1459 */
    "negative skip time, substituting zero.\n", /* 1460 */
    "delayw: associated delayr not found", /* 1461 */
    "deltap: associated delayr not found", /* 1462 */
    "diskinfo cannot open %s", /* 1463 */
    "diskinfo cannot find \"%s\" in its search paths", /* 1464 */
    "fout: cannot open outfile %s", /* 1465 */
    "fout: invalid file handle", /* 1466 */
    "foutk: cannot open outfile %s", /* 1467 */
    "fout: cannot open outfile %s", /* 1468 */
    "fouti: invalid file handle", /* 1469 */
    "fin: cannot open infile %s", /* 1470 */
    "fin: invalid file handle", /* 1471 */
    "fink: invalid file handle", /* 1472 */
    "adsynt: amptable not found", /* 1473 */
    "adsynt: partial count is greater than amptable size", /* 1474 */
    "adsynt: not initialised", /* 1475 */
    "hsboscil: not initialised", /* 1476 */
    "pitchamdf: maxcps must be > mincps", /* 1477 */
    "pitchamdf: not initialised", /* 1478 */
    "phasorbnk: not initialised", /* 1479 */
    "pluck: kcps more than sample rate", /* 1480 */
    "schedkwhen note deleted.  i%d had %d init errors\n", /* 1481 */
    "schedkwhen ignored. Instrument %d undefined\n", /* 1482 */
    "triginstr warning: negative kwhen reset to zero", /* 1483 */
    "scanu: Init table has bad size", /* 1484 */
    "Eek ... scan synthesis id wasn't found", /* 1485 */
    "scanu: Parameter tables should all have the same length", /* 1486 */
    "Mass displacement", /* 1487 */
    "scanu: Spring matrix is too small", /* 1488 */
    "Scansynth window", /* 1489 */
    "vermp: Trajectory table includes values out of range", /* 1490 */
    "sfload: cannot open SoundFont file \"%s\" (error %d)", /* 1491 */
    "\nPreset list of \"%s\"\n", /* 1492 */
    "%3d) %-20s\tprog:%-3d bank:%d\n", /* 1493 */
    "\nAssigning all Presets of \"%s\" starting from %d (preset handle number)\n", /* 1494 */
    "%3d<--%-20s\t(prog:%-3d bank:%d)\n", /* 1495 */
    "\nAll presets have been assigned to preset handles from %d to %d \n\n", /* 1496 */
    "\nInstrument list of \"%s\"\n", /* 1497 */
    "sfpreset: preset handle too big (%d), max: %d", /* 1498 */
    "sfpreset: cannot find any preset having prog.number %d and bank number %d in SoundFont file \"%s\"\n", /* 1499 */
    "sfinstr: instrument out of range", /* 1500 */
    "AIFF format error: PEAK chunk found before COMM chunk", /* 1501 */
    "bad size for PEAK chunk in AIFC file", /* 1502 */
    "unknown PEAK chunk version in AIFC file", /* 1503 */
    "AIFC format error: PEAK chunk found before COMM chunk", /* 1504 */
    "no COMM chunk in AIFF-C file!", /* 1505 */
    "no SSND chunk in AIFF-C file!", /* 1506 */
    "warning: unexpected FVER version in AIFF-C file\n", /* 1507 */
    "warning: no FVER chunk in AIFF-C file - may be obsolete format\n", /* 1508 */
    "bad size for PEAK chunk in WAV file", /* 1509 */
    "error reading PEAK chunk in WAV file", /* 1510 */
    "unknown PEAK chunk version in WAV file", /* 1511 */
    "error reading PEAK chunk in WAV file", /* 1512 */
    "Read PEAK data:\ncreation time: %s", /* 1513 */
    "Ch %2d: peak = %.6f at sample %d: %.4lf secs\n", /* 1514 */
    "peak Ch %2d: %f  (written: %f) at %ld\n", /* 1515 */
    "Input scale factor = %f\n", /* 1516 */
    "vpvoc: Could not find ifnmagctrl table %f\n", /* 1517 */
    "scanu: Could not find ifnnit ftable", /* 1518 */
    "scanu: Could not find ifninit ftable", /* 1519 */
    "scanu: Could not find ifnmass table", /* 1520 */
    "scanu: Could not find ifncentr table", /* 1521 */
    "scanu: Could not find ifndamp table", /* 1522 */
    "scanu: Could not find ifnstiff table", /* 1523 */
    "scanu: Could not find ifnvel table", /* 1524 */
    "scanu: Could not find (id) table", /* 1525 */
    "scans: Could not find the ifntraj table", /* 1526 */
    "scans: No scan synthesis net specified", /* 1527 */
    "cannot open %s.  Not in cur dir, INCDIR, SSDIR or SFDIR as defined", /* 1528 */
    "inz index > isizea. Not writing.", /* 1529 */
    "inz index < 0. Not writing.", /* 1530 */
    "outz index > isizea. No output", /* 1531 */
    "outz index < 0. No output.", /* 1532 */
    "pinkish: Invalid method code", /* 1533 */
    "pinkish: Filter method requires a-rate (noise) input", /* 1534 */
    "trigseq: incorrect table number", /* 1535 */
    "seqtim: incorrect table number", /* 1536 */
    "-Z\tDither output\n", /* 1537 */
    "Unable to write to SDIF file\n", /* 1538 */
    "OOPS: SDIF does not work on this machine!\n", /* 1539 */
    "Error creating %s\n", /* 1540 */
    "Error writing SDIF frame header.\n", /* 1541 */
    "Error writing SDIF matrix header.\n", /* 1542 */
    "Error writing SDIF data.\n", /* 1543 */
    "wrote %ld 1TRC frames to %s\n", /* 1544 */
  "Csound(d) Version %d.%.02df%.02d (%s)\n",  				/* 1545 */
    "reverbx: not initialised", /* 1546 */
    "reverbx; Combs ftable must have %d time and %d gain values", /* 1547 */
    "Failed to open MIDI input port to Csound Server.", /* 1548 */
    "-Q dnam\tselect MIDI output device\n", /* 1549 */
    "no midi output device name", /* 1550 */
    "no poll event rate", /* 1551 */
    "-K\tDo not generate PEAK chunks\n", /* 1552 */
    "transeg: not initialised (arate)\n", /* 1553 */
    "\nError: transeg not initialised (krate)\n", /* 1554 */
    "Sfont format not compatible", /* 1555 */
    "chanels-", /* 1556 */
    "No table for dconv", /* 1557 */
    "spat3d: not initialised", /* 1558 */
    "spat3di: not initialised", /* 1559 */
    "pvxanal: outfile name must use extension .pvx\n", /* 1560 */
    "pvxanal - source has too many channels: Maxchans = %d.\n", /* 1561 */
    "pvxanal: unable to create analysis file: %s", /* 1562 */
    "pvxanal: error writing analysis frames: %s", /* 1563 */
    "\n%ld %d-chan blocks written to %s\n", /* 1564 */
    "pvsanal: fftsize of 32 is too small!\n", /* 1565 */
    "pvsanal: window size too small for fftsize\n", /* 1566 */
    "pvsanal: overlap too big for fft size\n", /* 1567 */
    "pvsanal: overlap must be >= ksmps\n", /* 1568 */
    "pvsanal: unsupported value for iwintype\n", /* 1569 */
    "pvsanal: Not Initialised.\n", /* 1570 */
    "pvsynth: internal error: fsig has unrecognised value for iwintype\n", /* 1571 */
    "pvsynth: Not Initialised.\n", /* 1572 */
    "pvadsyn: bad value for inoscs\n", /* 1573 */
    "pvadsyn: format must be amp-freq (0).\n", /* 1574 */
    "pvsadsyn: ibin parameter out of range.\n", /* 1575 */
    "pvsadsyn: ibin + inoscs too large.\n", /* 1576 */
    "pvsadsyn: ibin + (inoscs * ibinoffset) too large.", /* 1577 */
    "pvsynth: Not initialised.\n", /* 1578 */
    "pvscross: source and dest signals must have same format\n", /* 1579 */
    "pvscross: not initialised\n", /* 1580 */
    "pvscross: mismatch in fsrc format\n", /* 1581 */
    "pvscross: mismatch in fdest format\n", /* 1582 */
    "pvsfread: file is empty!\n", /* 1583 */
    "pvsfread: file has only one frame (= impulse response).\n", /* 1584 */
    "pvsfread: analysis frame overlap must be >= ksmps\n", /* 1585 */
    "pvsfread: ichan value exceeds file channel count.\n", /* 1586 */
    "pvsfread: ichan cannot be negative.\n", /* 1587 */
    "pvsfread: not initialised.\n", /* 1588 */
    "pvsmaska: signal format must be amp-phase or amp-freq.\n", /* 1589 */
    "pvsmaska: ftable too small.\n", /* 1590 */
    "pvsmaska: not initialised\n", /* 1591 */
    "pvsmaska: negative value for kdepth; clipped to zero.\n", /* 1592 */
    "pvsmaska: kdepth > 1: clipped.\n", /* 1593 */
    "pvsftw: signal format must be amp-phase or amp-freq.\n", /* 1594 */
    "pvsftw: bad value for ifna.\n", /* 1595 */
    "pvsftw: bad value for ifnf.\n", /* 1596 */
    "pvsftw: amps ftable too small.\n", /* 1597 */
    "pvsftw: freqs ftable too small.\n", /* 1598 */
    "pvsftw: not initialised\n", /* 1599 */
    "pvsftw: no amps ftable!\n", /* 1600 */
    "pvsftw: no freqs ftable!\n", /* 1601 */
    "pvsftr: signal format must be amp-phase or amp-freq.\n", /* 1602 */
    "pvsftr: bad value for ifna.\n", /* 1603 */
    "pvsftr: bad value for ifnf.\n", /* 1604 */
    "pvsftr: amps ftable too small.\n", /* 1605 */
    "pvsftr: freqs ftable too small.\n", /* 1606 */
    "pvsftr: not initialised\n", /* 1607 */
    "unable to open pvocex file %s.\n", /* 1608 */
    "pvoc-ex file %s is not 32bit floats\n", /* 1609 */
    "pvoc-ex file %s not in AMP_FREQ format\n", /* 1610 */
    "pvoc-ex file %s is empty!\n", /* 1611 */
    "error reading pvoc-ex file %s\n", /* 1612 */
    "error reading pvoc-ex file %s after %d frames\n", /* 1613 */
    "\npvsys: already imnitialised", /* 1614 */
    "\npvsys: bad arguments", /* 1615 */
    "\npvsys: bad format parameter", /* 1616 */
    "\npvsys: bad window type", /* 1617 */
    "\npvsys: too many files open", /* 1618 */
    "\npvsys: no memory", /* 1619 */
    "\npvsys: no memory for custom window", /* 1620 */
    "\npvsys: unable to create file", /* 1621 */
    "\npvsys: Internal error: NULL data arrays", /* 1622 */
    "\npvsys: no memory for file data", /* 1623 */
    "\npvsys: unable to open file", /* 1624 */
    "\npvsys: error reading Source format data", /* 1625 */
    "\npvsys: not a WAVE_EX file", /* 1626 */
    "\npvsys: bad size for fmt chunk", /* 1627 */
    "\npvsys: error reading Extended format data", /* 1628 */
    "\npvsys: not a PVOCEX file", /* 1629 */
    "\npvsys: error reading Extended pvoc format data", /* 1630 */
    "\npvsys: unknown pvocex Version", /* 1631 */
    "\npvsys: error reading header", /* 1632 */
    "\npvsys: not a RIFF file", /* 1633 */
    "\npvsys: file too small", /* 1634 */
    "\npvsys: error reading data", /* 1635 */
    "\npvsys: not a WAVE file", /* 1636 */
    "\npvsys: error reading format chunk", /* 1637 */
    "\npvsys: PVXW chunk found before fmt chunk.", /* 1638 */
    "\npvsys: PVXW chunk found but custom window not specified", /* 1639 */
    "\npvsys: no memory for custom window data.", /* 1640 */
    "\npvsys: error reading window data.", /* 1641 */
    "\npvsys: bad RIFF file", /* 1642 */
    "\npvsys: bad format, data chunk before fmt chunk", /* 1643 */
    "\npvsys: custom window chunk PVXW not found", /* 1644 */
    "\npvsys: error skipping unknown WAVE chunk", /* 1645 */
    "\npvsys: bad format in RIFF file", /* 1646 */
    "\npvsys: error writing header", /* 1647 */
    "\npvsys: error writing fmt chunk", /* 1648 */
    "\npvsys: error writing header", /* 1649 */
    "\npvsys: error writing window data.", /* 1650 */
    "\npvsys: error updating data chunk", /* 1651 */
    "\npvsys: error updating riff chunk", /* 1652 */
    "\npvsys: error seeking to end of file", /* 1653 */
    "\npvsys: file does not exist", /* 1654 */
    "\npvsys: file not open", /* 1655 */
    "\npvsys: bad file descriptor", /* 1656 */
    "\npvsys: error writing data", /* 1657 */
    "\npvsys: bad file descriptor", /* 1658 */
    "\npvsys: error rewinding file", /* 1659 */
    "\npvsys: unable to close file on termination", /* 1660 */
    "\nerror - zero in fft parameters %d %d %d %d", /* 1661 */
    "\nerror - fft parameter n has more than 15 factors : %d", /* 1662 */
    "\nerror - zero in reals parameters : %d : %d ", /* 1663 */
    "vibrato(krate): not initialised", /* 1664 */
    "oscbnk: not initialised", /* 1665 */
    "cpstun: invalid table", /* 1666 */
    "unknown source table number", /* 1667 */
    "grain2: not initialised", /* 1668 */
    "grain3: not initialised", /* 1669 */
    "grain3: invalid grain duration", /* 1670 */
    "grain3: invalid grain density", /* 1671 */
    "grain3 needs more overlaps", /* 1672 */
    "rnd31: not initialised", /* 1673 */
    "applied byte-reversal\n", /* 1674 */
    "pvoc-ex file %s: FFT size %d too large for Csound\n", /* 1675 */
    "pvoc-ex file %s is not mono\n", /* 1676 */
    "pvoc-ex file %s is not 32bit floats\n", /* 1677 */
    "pvoc-ex file %s not in AMP_FREQ format\n", /* 1678 */
    "pvoc-ex file %s is empty!\n", /* 1679 */
    "error reading pvoc-ex file %s\n", /* 1680 */
    "error reading pvoc-ex file %s after %d frames\n", /* 1681 */
    "pvoc file has bad data alignment\n", /* 1682 */
    "a range given exceeds table length", /* 1683 */
    "an input function does not exist", /* 1684 */
    "vcomb: not initialised", /* 1685 */
    "valpass: not initialised", /* 1686 */
    "iresfn for ftmorf does not exist", /* 1687 */
    "iftfn for ftmorf does not exist", /* 1688 */
    "table in iftfn for ftmorf wrong size", /* 1689 */
    "table in iftfn for ftmorf does not exist", /* 1690 */
    "no infile specified in the commandline", /* 1691 */
    "No space for include files", /* 1692 */
    "Warning: truncating elevation to 2-D plane\n", /* 1693 */
    "Warning: Ambiguous transition 180 degrees.\n", /* 1694 */
    "Missing fields in vbap4move\n", /* 1695 */
    "Wrong dimension\n", /* 1696 */
    "Have to have at least %d directions in vbap4move\n", /* 1697 */
    "Missing fields in vbap8move\n", /* 1698 */
    "Have to have at least %d directions in vbap8move\n", /* 1699 */
    "Missing fields in vbap8move\n", /* 1700 */
    "Have to have at least %d directions in vbap16move\n", /* 1701 */
    "Missing fields in vbapzmove\n", /* 1702 */
    "Have to have at least %d directions in vbapzmove\n", /* 1703 */
    "Util DNOISE:\n", /* 1704 */
    "filter type not lowpass or highpass in clfilt", /* 1705 */
    "filter kind, %d, out of range in clfilt", /* 1706 */
    "number of poles, %f, out of range in clfilt", /* 1707 */
    "odd number of poles chosen in clfilt, rounded to %d\n", /* 1708 */
    "passband ripple must be positive in clfilt. Set to %f\n", /* 1709 */
    "passband ripple must be non-zero in clfilt. Set to %f\n", /* 1710 */
    "Macro expansion symbol ($) without macro name\n", /* 1711 */
    "stopband attenuation must be negative in clfilt. Set to %f\n", /* 1712 */
    "stopband attenuation must be non-zero in clfilt. Set to %f\n", /* 1713 */
    "tablexkt: not initialised",                        /* 1714 */
    "0dBFS level = %.1f\n",                             /* 1715 */
    "'elseif' statement cannot occur after an 'else'",  /* 1716 */
    "invalid 'else' statement; must have a corresponding 'if'", /* 1717 */
    "duplicate 'else' statement",                       /* 1718 */
    "invalid 'elseif' statement; must have a corresponding 'if'", /* 1719 */
    "vco2ft: invalid waveform number",                  /* 1720 */
    "vco2ft: table array not found for this waveform",  /* 1721 */
    "vco2ft: not initialised",                          /* 1722 */
    "vco2: too many input arguments",                   /* 1723 */
    "vco2: insufficient required arguments",            /* 1724 */
    "vco2: invalid argument type",                      /* 1725 */
    "vco2: not initialised",                            /* 1726 */
    "Cannot Find Instrument %s\n",                      /* 1727 */
    "internal error: opcode not found",                 /* 1728 */
    "%s: invalid local ksmps value: %d",                /* 1729 */
    "%s: not initialised",                              /* 1730 */
    "xin is allowed only in user opcodes",              /* 1731 */
    "xin: invalid number of arguments",                 /* 1732 */
    "xin: invalid argument type",                       /* 1733 */
    "xin was already used in this opcode definition",   /* 1734 */
    "xout is allowed only in user opcodes",             /* 1735 */
    "xout: invalid number of arguments",                /* 1746 */
    "xout: invalid argument type",                      /* 1747 */
    "xout was already used in this opcode definition",  /* 1748 */
    "setksmps is allowed only in user opcodes",         /* 1749 */
    "setksmps: invalid ksmps value: %d",                /* 1750 */
    "missing name for opcode",                          /* 1751 */
    "missing instrument number or name",                /* 1752 */
    "invalid name for opcode",                          /* 1753 */
    "No opcode name",                                   /* 1754 */
    "opcode declaration error (usage: opcode name, outtypes, intypes) -- opcode %s", /* 1755 */
    "No instrument name",                               /* 1756 */
    "instr declaration error(usage: instr name [, inptypes, outtypes] ) -- instr %s", /* 1757 */
    "cannot redefine %s",                               /* 1758 */
    "redefined opcode: %s\n",                  /* 1759 */
    "invalid output type for %s",                       /* 1760 */
    "invalid input type for instr %s",                  /* 1761 */
    "vco2init: invalid base ftable number",             /* 1762 */
    "vco2init: invalid partial number multiplier",      /* 1763 */
    "vco2init: invalid min table size",                 /* 1764 */
    "vco2init: invalid max table size",                 /* 1765 */
    "vco2init: invalid source ftable",                  /* 1766 */
    "vco2: table array not found for user defined waveform", /* 1767 */
    "error skipping unrecognised APPL chunk",           /* 1768 */
    "DLineN: Delay length too big ... setting to maximum length of %ld.\n", /* 1769 */
    "Error: bad format parameter for soundout\n",       /* 1770 */
    "Error: undefined format parameter for soundout\n", /* 1771 */
    "ftload: Bad table number. Loading is possible only into existing tables.", /* 1772 */
    "ftload: no table numbers",                         /* 1773 */
    "ftload: unable to open file",                      /* 1774 */
    "ftsave: Bad table number. Saving is possible only for existing tables.", /* 1775 */
    "ftsave: no table numbers",                         /* 1776 */
    "ftsave: unable to open file",                      /* 1777 */
    "Muting new instances of instr %d\n",               /* 1778 */
    "Allowing instrument %d to start\n",                /* 1779 */
    "pvanal: creating pvocex file\n",                   /* 1780 */
    "opcode blocks cannot be nested (missing 'endop'?)", /* 1781 */
    "opcode not allowed in instr block",                /* 1782 */
    "unmatched endop",                                  /* 1783 */
    "endop not allowed in instr block",                 /* 1784 */
    "instr not allowed in opcode block",                /* 1785 */
    "endin not allowed in opcode block",                /* 1786 */
    "No peak information contained in the header of this file", /* 1787 */
    "wterrain: ftable not found",                       /* 1788 */
    "Source table must be same size or smaller than dest table\n", /* 1789 */
    "Scantable: point table not found",                 /* 1790 */
    "Scantable: mass table not found",                  /* 1791 */
    "Scantable: stiffness table not found",             /* 1792 */
    "Scantable: damping table not found",               /* 1793 */
    "Scantable: velocity table not found",              /* 1794 */
    "Table lengths do not agree!!",                     /* 1795 */
    "NaN in pow\n",                                     /* 1796 */
    "Orchestra sampling rate is not compatible with HRTF.\nShould be %d...exiting.\n", /* 1797 */
    "INIT ERROR in instr %d (opcode %s): %s\n",         /* 1798 */
    "INIT ERROR in instr %d (subinstr %d): %s\n",       /* 1799 */
    "PERF ERROR in instr %d (opcode %s): %s\n",         /* 1800 */
    "PERF ERROR in instr %d (subinstr %d): %s\n",       /* 1801 */
    "subinstr: number of output args greater than nchnls", /* 1802 */
    "subinstr: too many p-fields",                      /* 1803 */
    "subinstr: not initialised",                        /* 1804 */
    "LineBuffer Overflow - Input Data has been Lost\n", /* 1805 */
    "Input ignored, RT Line Events (-L) has not been initialised\n", /* 1806 */
    "event: string name is allowed only for \"i\" events", /* 1807 */
    " - note deleted. instr %s undefined\n",            /* 1808 */
    "Setting instrument %s %s\n",                       /* 1809 */
    "on",                                               /* 1810 */
    "off",                                              /* 1811 */
    "Setting instrument %d %s\n",                       /* 1812 */
    " - note deleted.  i%d (%s) had %d init errors\n",  /* 1813 */
    "could not remove %s\n",                   /* 1814 */
    "File %s already exists\n",                         /* 1815 */
    "Cannot open sample file (%s) subfile\n",           /* 1816 */
    "Cannot open file (%s) subfile\n",                  /* 1817 */
    "invalid name for instrument",                      /* 1818 */
    "negative times not allowed!!, correcting\n",       /* 1819 */
    "sfplay: invalid or out-of-range preset number",    /* 1820 */
    "sfinstr: instrument out of range",                 /* 1821 */
    "instr %s not found, assuming insno = -1\n", /* 1822 */
    "sfplaym: invalid or out-of-range preset number",   /* 1823 */
    "fsig = : formats are different.\n",  		/* 1824 */
    ""    },
};
