%define version 0.4.4
%define release 1
%define prefix /usr

Summary: The ClanLib Game SDK.
Name: ClanLib
Version: %{version}
Release: %{release}
Copyright: LGPL
Group: Development/Libraries
BuildRoot: /tmp/clanlib-root
Source: ClanLib-%{version}.tar.gz
URL: http://clanlib.org
Requires: Hermes >= 1.3.0, zlib

# ----------------------------------------------------------------------

%description
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. The goal is to provide a common interface to
classical game problems (loading graphics eg.), so games can share as much
code as possible. Ideally anyone with small resources should be able to
write commercial quality games.

%package gl
Summary: ClanLib OpenGL module
Group: Development/Libraries
Requires: ClanLib = %{version}
%description gl
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the OpenGL module (clanGL).

%package magick
Summary: ClanLib ImageMagick module
Group: Development/Libraries
Requires: ClanLib = %{version}
%description magick
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the ImageMagick module
(clanMagick).

%package mikmod
Summary: ClanLib MikMod module
Group: Development/Libraries
Requires: ClanLib = %{version}
%description mikmod
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the MikMod module (clanMikMod).

%package png
Summary: ClanLib PNG module
Group: Development/Libraries
Requires: ClanLib = %{version}
%description png
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the PNG module (clanPNG).

#%package lua
#Summary: ClanLib Lua scripting module
#Group: Development/Libraries
#Requires: ClanLib = %{version}
#%description lua
#The ClanLib Game SDK is a crossplatform game library designed to ease the
#work for game developers. This package is the Lua scripting module
#(clanLua).

#%package gui
#Summary: ClanLib GUI module
#Group: Development/Libraries
#Requires: ClanLib = %{version}
#%description gui
#The ClanLib Game SDK is a crossplatform game library designed to ease the
#work for game developers. This package is the GUI module (clanGUI).

%package mpeg
Summary: ClanLib MPEG module
Group: Development/Libraries
Requires: ClanLib = %{version}
%description mpeg
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package is the MPEG module (clanMPEG).

%package devel
Summary: ClanLib include files for developers
Group: Development/Libraries
Requires: ClanLib = %{version}
%description devel
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package contains the header files needed to
build ClanLib applications.

%package docs
Summary: ClanLib documentation
Group: Development/Libraries
%description docs
The ClanLib Game SDK is a crossplatform game library designed to ease the
work for game developers. This package contains the documentation.

%prep
%setup

%build
CXXFLAGS="-O6 -mpentium -malign-loops=2 -malign-functions=2 -malign-jumps=2 -fomit-frame-pointer"
CFLAGS="-O6 -mpentium -malign-loops=2 -malign-functions=2 -malign-jumps=2 -fomit-frame-pointer"
./configure --prefix=%prefix --enable-x11 --enable-fbdev --enable-ggi --enable-opengl --enable-svgalib --enable-ptc --enable-clansound --enable-network --enable-asm386 --enable-dyn
make clanCore
make clanGL
make clanMikMod
make clanMagick
#make clanGUI
#make clanLua
make clanMPEG
make clanPNG
make strip
make docs

%install
make prefix=$RPM_BUILD_ROOT%{prefix} install
make prefix=$RPM_BUILD_ROOT%{prefix} docs_install

%post
/sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc README COPYING CREDITS CODING_STYLE FAQ ascii-logo
%{prefix}/lib/libclanCore.so*
%{prefix}/lib/ClanLib/*

%files devel
%defattr(-, root, root)
%{prefix}/include/ClanLib/*

%files docs
%defattr(-, root, root)
%{prefix}/doc/ClanLib-docs-%{version}/*
%{prefix}/man/man1/datafile_compiler.1
%{prefix}/man/man3/CL*
%{prefix}/man/man3/clanlib.3

%files gl
%defattr(-, root, root)
%{prefix}/lib/libclanGL.so*

%files magick
%defattr(-, root, root)
%{prefix}/lib/libclanMagick.so*

%files mikmod
%defattr(-, root, root)
%{prefix}/lib/libclanMikMod.so*

%files png
%defattr(-, root, root)
%{prefix}/lib/libclanPNG.so*

#%files lua
#%defattr(-, root, root)
#%{prefix}/lib/libclanLua.so*

#%files gui
#%defattr(-, root, root)
#%{prefix}/lib/libclanGUI.so*

%files mpeg
%defattr(-, root, root)
%{prefix}/lib/libclanMPEG.so*
