/*
	$Id: app_beos.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		main. Initialization of the BeOS version of ClanLib.

*/

#include "Core/precomp.h"

#include "API/Core/Display/display.h"
#include "Core/Display/Be/clanwindowscreen.h"
#include "Core/Display/Be/display_be.h"
#include "Core/Sound/Be/soundcard_be.h"
#include "API/Core/Sound/sound.h"
#include "API/Core/Input/input.h"
#include "Core/Input/Be/keyboard_be.h"

#include "app_beos.h"

#include <OS.h>
#include <Alert.h>

int CL_System::suspend_time = 0;
bool CL_System::time_running = true;
int CL_System::start_pause;

extern "C"
{
	#include <Hermes/Hermes.h>
}

CL_DisplayCard *cl_current_displaycard = NULL;
CL_SoundCard *cl_current_soundcard = NULL;

int main()
{
	DBG("initializing Hermes...");
	Hermes_Init();
	
	LibApplication* lapp = new LibApplication();
	lapp->Run();
	delete lapp;
}

LibApplication::LibApplication() : BApplication("application/x-vnd.ClanSoft-ClanLib")
{
}

void LibApplication::ReadyToRun()
{
	if (CL_ClanApplication::app == NULL)
	{
		BAlert* noProgram = new BAlert("ClanLib", "No program instance found", "Kick ass!", "Use Be!", "Have fun!", B_WIDTH_AS_USUAL, B_STOP_ALERT);
		noProgram->Go();
		PostMessage(B_QUIT_REQUESTED);
		return;
	}

	DBG("starting app's main");
	CL_ClanApplication::app->main(largc, largv);

	DBG("quitting");
	PostMessage(B_QUIT_REQUESTED);
}

void LibApplication::ArgvReceived(int32 argc, char **argv)
{
	largc = argc;
	largv = new char*[argc];
	for (int i=0; i<argc; i++)
	{
		largv[i] = new char[strlen(argv[i])];
		strcpy( largv[i], argv[i] );
	}
}

bool LibApplication::QuitRequested()
{
	DBG("QuitRequested()");
	is_quitting = true;
	return true;
}


bool CL_System::keep_alive()
{
	bool retval = false;

	int num = CL_System_Generic::keep_alives.get_num_items();
	for (int i=0; i<num; i++)
	{
		if (CL_System_Generic::keep_alives[i]->keep_alive()) retval = true;
	}

	return retval;
}

int CL_System::get_time()
{
	return (system_time() / 1000) - suspend_time;
}

void CL_System::pause_time()
{
	if (time_running)
	{
		time_running = false;
		start_pause = get_time();
	}
}

void CL_System::resume_time()
{
	if (!time_running)
	{
		time_running = true;
		suspend_time += get_time() - start_pause;
	}
}

void CL_System::sleep(int millis)
{
	snooze(millis*1000);
}

void CL_System::init_display(int options)
{
	DBG("init_display()");
	status_t err;
	((LibApplication*)be_app)->clanscreen = new ClanWindowScreen(&err);

	CL_Display::cards.add( new CL_DisplayCard_Be(CL_Display::cards.get_num_items()) );
	CL_Display::num_cards = CL_Display::cards.get_num_items();
	cl_current_displaycard = CL_Display::cards[0];
	
	CL_Input::keyboards.add( new CL_BeKeyboard() );
}

void CL_System::init_sound()
{
	CL_Sound::cards.add( new CL_SoundCard_Be() );
	CL_Sound::num_cards = CL_Sound::cards.get_num_items();
	cl_current_soundcard = CL_Sound::cards[0];
}

void CL_System::init_network()
{
}

void CL_System::deinit_display()
{
}

void CL_System::deinit_sound()
{
}

void CL_System::deinit_network()
{
}

CL_DisplayCard* CL_Display::get_current_card()
{
	return cl_current_displaycard;
}

CL_SoundCard* CL_Sound::get_current_card()
{
	return cl_current_soundcard;
}

CL_Array<CL_System_KeepAlive> CL_System_Generic::keep_alives;
