
#ifndef header_netgame_server
#define header_netgame_server

#include <list>
#include <queue>
#include <string>

#include "netgame_generic.h"

class CL_NetComputer_Host;

class CL_NetComputer_Host : public CL_NetComputer
{
public:
	CL_NetComputer_Host(CL_Connection *connection, int id);
	virtual ~CL_NetComputer_Host();

	int id;
	CL_Connection *connection;
};

class CL_NetChannelQueue : public std::queue<CL_NetMessage>
{
public:
	std::map<int, int> access;
};


class CL_NetGame_Server : public CL_NetGame_Generic, CL_Runnable
{
public:
	CL_NetGame_Server(
		CL_Network_Generic *network,
		const char *game_id,
		int port);
	virtual ~CL_NetGame_Server();

	virtual const CL_NetComputer *get_server() const;
	virtual const CL_NetGroup *get_all() const;
	
	virtual bool peek(int channel) const;
	virtual CL_NetMessage receive(int channel, int timeout=-1);

	virtual void send(
		const int dest_channel,
		const CL_NetComputer *dest,
		const CL_NetMessage &message,
		bool reliable = true);

	virtual void send(
		const int dest_channel,
		const CL_NetGroup *dest,
		const CL_NetMessage &message,
		bool reliable = true);

	virtual CL_NetComputer *receive_computer_leave();
	virtual const CL_NetComputer *receive_computer_join();
	virtual const CL_NetComputer *receive_computer_rejoin();
	virtual bool receive_game_closed();
	virtual int access_status(int channel) const;
	virtual bool is_writable(int channel) const;
	virtual bool is_readable(int channel) const;

	// Client side only:
	virtual int receive_access_changed();

	// Server side only:
	virtual void set_access(
		int channel,
		const CL_NetComputer *computer,
		int access_rights=ACCESS_CHANNEL_READ|ACCESS_CHANNEL_WRITE);
	virtual void set_access(
		int channel,
		const CL_NetGroup *group,
		int access_rights=ACCESS_CHANNEL_READ|ACCESS_CHANNEL_WRITE);
		
protected: // from netgame_generic:
	virtual void keep_alive();
		
private: // implementation helper functions:
	CL_NetChannelQueue *find_queue(int netchannel) const;
	CL_NetChannelQueue *create_queue(int netchannel);
	bool has_read_access(
		CL_NetChannelQueue *channel,
		CL_NetComputer_Host *host);

private: // data vars
	CL_NetGroup all;
	std::list<CL_NetComputer_Host*> prejoin;
	std::list<CL_NetComputer_Host*> computers;

	std::map<int /*netchannel*/,CL_NetChannelQueue> netchannels;
	
	CL_UDPConnection *udp_connection;

	int id_counter;
	std::string game_id;
	int port;
	
	std::queue<CL_NetComputer_Host*> join_queue;
	std::queue<CL_NetComputer_Host*> rejoin_queue;
	std::queue<CL_NetComputer_Host*> leave_queue;

private: // multithread:
	CL_Mutex *mutex;
	CL_Thread *thread;
	volatile bool exit_thread;

	virtual void run();
//	static void run_thread(void *self);

friend CL_NetComputer_Host;
};


#endif
