/*
	$Id: cl_gevent.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GEVENT_H
#define CL_GEVENT_H

#include "../Core/Input/inputbuffer.h"
#include "cl_gpoint.h"

///event baseclass
class CL_GEvent
{
 public:
  ///
  enum {
    MOUSEMOTION		= 1 << 0,
    MOUSEBUTTON		= 1 << 1,
    KEY              = 1 << 2,
    TIMER            = 1 << 3,
    QUIT             = 1 << 4,
    ICONIFIED        = 1 << 5,
    RESTORED         = 1 << 6,
    LOSTFOCUS        = 1 << 7,
    GOTFOCUS         = 1 << 8,
    UNKNOWN          = 1 << 15     
  };
  ///
  CL_GEvent(int eventType) : type_(eventType) {};
  ///
  int type() const { return type_; };

 protected:
  ///
  int type_;
  
};

/* lp
///
class UTimerEvent : public UEvent
{
 public:
  ///ID=0 is the "system-timer"
  UTimerEvent(int timerID=0) : UEvent(UEvent::TIMER), id_(timerID) {} ;
  ///
  int id()  const { return id_; };
 protected:
  ///
  int id_;
};
*/

///
class CL_GMouseButtonEvent : public CL_GEvent
{
 public:
  ///
  enum ButtonType 
  { 
    BUTTON_LEFT   = 1 << 0, 
    BUTTON_RIGHT  = 1 << 1,
    BUTTON_MIDDLE = 1 << 2
  };
  
  ///
  enum StateType
  {
    PRESSED,
    RELEASED
  };
  
  ///
  CL_GMouseButtonEvent(int state, int buttons, CL_GPoint pos) :
    CL_GEvent(CL_GEvent::MOUSEBUTTON),
    state_(state), 
    buttons_(buttons), 
    pos_(pos) {};
  
  ///
  int state()  const { return state_;};
  ///
  int buttons()  const { return buttons_;};
  ///
  CL_GPoint position()  const { return pos_;};

 protected:
  ///
  int state_;
  ///
  int buttons_;
  ///
  CL_GPoint pos_;
};

class CL_GKeyEvent : public CL_GEvent
{
public:
	enum state_type
	{
		PRESSED,
		RELEASED,
	};
	
	CL_GKeyEvent(CL_Key key) : CL_GEvent(CL_GEvent::KEY)
	{
		this->key = key;
		if (key.state == CL_Key::Pressed)
			state = PRESSED;
		else
			state = RELEASED;
	}
	CL_Key get_key() const { return key; }
	int get_state() const { return state; }

protected:
	CL_Key key;
	int state;
};

///
class CL_GMouseMotionEvent : public CL_GEvent
{
 public:
  ///
  CL_GMouseMotionEvent(CL_GPoint pos) : CL_GEvent(CL_GEvent::MOUSEMOTION), pos_(pos) {};
  ///
  CL_GPoint position()  const { return pos_; }

 protected:
  ///
  CL_GPoint pos_;
};
#endif