/*
	$Id: static_soundprovider.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Sound"

#ifndef header_static_soundprovider
#define header_static_soundprovider

#include "soundformat.h"

class CL_StaticSoundProvider
//: Static Soundprovider class.
// The static soundprovider provides the data  for any static (non-streamed)
// samples played using the ClanLib sound system.
{
public:
	virtual ~CL_StaticSoundProvider() { ; }

	virtual void lock()=0;
//: Locks the soundprovider. Locking a provider means, that 
//: the contents of the provider should be available following the 
//: call to lock(), which means that lock loads any files from disk, 
//: and performs any necessary initializations.

	virtual void unlock()=0;
//: Unlocks the soundprovider. Unlocking a provider means, that 
//: the contents of the provider should be deinitialized, thus 
//: removing any loaded sample data from memory.

	virtual SoundFormat get_format() const =0;
//: Returns the soundformat of the data stored by the provider. 
//: The data stored can be either 8-bit signed, 8-bit unsigned, 
//: 16-bit signed and 16-bit unsigned.
//!retval: The soundformat of the data stored.

	virtual int data_size() const =0;
//: Returns the total size in bytes of the data stored. 
//!retval: Size of data stored (in bytes).

	virtual void *get_data() const =0;
//: Returns a pointer to the data stored. 
//!retval: A pointer to the data stored.

	virtual int get_frequency() const =0;
//: Returns the frequency of the data stored. 
//!retval: Frequency of data stored.
};

#endif
