/*
	$Id: netobject_controller.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="NetObjects"

#ifndef header_netobject_controller_basic
#define header_netobject_controller_basic

#include "netobject.h"

class CL_NetObjectInfo;
class CL_NetObjectCreator;

class CL_NetObjectController_Basic
//: NetObject controller class.
// The NetObject controller is used to administrate the actual network
// sending and trivial of netobjects. It routes incoming messages to
// the correct netobject, and makes an unique identification of each
// netobject type.
//
// CL_NetObjectController uses the CL_NetObjectCreator instance to create
// netobjects on the client machines.
{
public:
	CL_NetObjectController_Basic();
	virtual ~CL_NetObjectController_Basic();

	void add(CL_NetObject *netobj, int type);
	void remove(CL_NetObject *netobj);
	int get_netobj_id(CL_NetObject *netobj);
	
	void set_creator(CL_NetObjectCreator *creator);

	void update(CL_NetGame *game, int netchannel);

	void send(
		CL_NetGame *game,
		int netchannel,
		CL_NetObject *obj,
		CL_NetMessage msg,
		const CL_NetGroup *group = NULL);

	void send(
		CL_NetGame *game,
		int netchannel,
		CL_NetObject *obj,
		CL_NetMessage msg,
		const CL_NetComputer *computer);

private:
	std::list <CL_NetObjectInfo *> netobjects;
	int next_obj_id;
	CL_NetObjectCreator *creator;
};

class CL_NetObjectInfo
{
public:
	int id;
	int type;
	CL_NetObject *obj;
};

#endif
