/*
	$Id: inputbutton_group.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="InputConverters"

#ifndef header_inputbutton_group
#define header_inputbutton_group

#include "../../stl.h"
#include "../Input/inputbutton.h"

class CL_InputButton_Group : public CL_InputButton
//: CL_InputButton container class.
// Groups a set of buttons - if either of them are down, CL_InputButton_Groups is down.
{
	std::list<CL_InputButton*> buttons;
public:
	void add(CL_InputButton *add_button)
	{
		buttons.push_back(add_button);
	}
	//: Adds a input button to the group.
	//!param: add_button - Button to be added.

	void remove(CL_InputButton *remove_button)
	{
		buttons.remove(remove_button);
	}
	//: Removes a (previously added) button from the group.
	//!param: remove_button - Button to be removed.

	virtual bool is_pressed()
	{
		for (
			std::list<CL_InputButton*>::iterator it = buttons.begin();
			it != buttons.end();
			it++)
		{
			if ((*it)->is_pressed() == true) return true;
		}

		return false;
	}
	//: Returns true if just one of the buttons in the button group is down; 
	//: false otherwise.
	//!retval: True if pressed, false otherwise.
};

#endif
