/*
	$Id: inputbuffer.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Input"

#ifndef header_inputbuffer
#define header_inputbuffer

#include "key.h"
#include "input_events.h"

class CL_InputBuffer : CL_Event_ButtonPress, CL_Event_ButtonRelease
//: Input buffer interface.
// Use this class to read buffered keys from the keyboard (or any other device).
{
public:
	CL_InputBuffer();
	// Constructs an input buffer that attaches itself to the first keyboard.

	CL_InputBuffer(CL_InputDevice *device);
	// Constructs an input buffer that attaches itself to the specified device.

	virtual ~CL_InputBuffer();

	CL_Key peek_key() const;
	// Returns the next key in the buffer, but unlike get_key() it does not
	// pop it from the input buffer.

	CL_Key get_key();
	// Pops the next key in the buffer and returns it.

	int keys_left();
	// Returns number of keys still available in the buffer.
	//!retval: Number of key values lefts in buffer.

	void clear();
	// Clears the buffer. After this, the buffer will not contain any keys.

// implementation:
private:
	virtual bool on_button_press(CL_InputDevice *device, const CL_Key &key);
	virtual bool on_button_release(CL_InputDevice *device, const CL_Key &key);

	std::queue<CL_Key> buffer;
	CL_InputDevice *device;
};

#endif
