/*
	$Id: stylemanager_default_generic.cpp,v 1.18 2002/01/17 14:38:45 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include "API/Core/Resources/resource_manager.h"
#include "stylemanager_default_generic.h"

CL_StyleManager_Default_Generic::CL_StyleManager_Default_Generic()
: 
	resources(NULL)
{ 
}

CL_StyleManager_Default_Generic::~CL_StyleManager_Default_Generic()
{
}

#define RGBCOL(x) (float(x)*(1/255.0f))

void CL_StyleManager_Default_Generic::get_color(
	GUIColor col,
	float &r,
	float &g,
	float &b,
	float &a)
{
	a = 1.0f;

	switch (col)
	{
	case GUICOLOR_SELECTED_OUTLINE:
		break;
	case GUICOLOR_DARK_OUTLINE:
		r = RGBCOL(128);
		g = RGBCOL(128);
		b = RGBCOL(128);
		break;
	case GUICOLOR_BRIGHT_SHADE:
		r = RGBCOL(255);
		g = RGBCOL(255);
		b = RGBCOL(255);
		break;
	case GUICOLOR_MEDIUM_SHADE:
		r = RGBCOL(211);
		g = RGBCOL(208);
		b = RGBCOL(200);
		break;
	case GUICOLOR_DARKER_SHADE:
		r = RGBCOL(65);
		g = RGBCOL(65);
		b = RGBCOL(65);
		break;
	case GUICOLOR_DARK_SHADE:
		r = RGBCOL(188);
		g = RGBCOL(190);
		b = RGBCOL(184);
		break;
	case GUICOLOR_DARK_OUTLINE_DISABLED:
		r = RGBCOL(192);
		g = RGBCOL(194);
		b = RGBCOL(189);
		break;
	case GUICOLOR_BRIGHT_SHADE_DISABLED:
		r = RGBCOL(243);
		g = RGBCOL(245);
		b = RGBCOL(241);
		break;
	case GUICOLOR_DARK_SHADE_DISABLED:
		r = RGBCOL(226);
		g = RGBCOL(227);
		b = RGBCOL(222);
		break;
	case GUICOLOR_WHITE:
		r = RGBCOL(255);
		g = RGBCOL(255);
		b = RGBCOL(255);
		break;
	case GUICOLOR_RED:
		r = RGBCOL(255);
		g = RGBCOL(55);
		b = RGBCOL(55);
		break;
	case GUICOLOR_CARET:
		r = RGBCOL(0);
		g = RGBCOL(0);
		b = RGBCOL(0);
		break;
	case GUICOLOR_PROGRESSBAR_FILLED:
	case GUICOLOR_SELECTION:
		r = RGBCOL(48);
		g = RGBCOL(105);
		b = RGBCOL(197);
		break;
	case GUICOLOR_PROGRESSBAR:
	case GUICOLOR_SCROLLBAR:
		r = RGBCOL(196);
		g = RGBCOL(197);
		b = RGBCOL(190);
		break;
	case GUICOLOR_BUTTON:
		r = RGBCOL(236);
		g = RGBCOL(238);
		b = RGBCOL(232);
		break;
	case GUICOLOR_FOCUS:
		r = RGBCOL(236);
		g = RGBCOL(238);
		b = RGBCOL(100);
		break;
	case GUICOLOR_BUTTON_DISABLED:
		r = RGBCOL(232);
		g = RGBCOL(235);
		b = RGBCOL(230);
		break;
	case GUICOLOR_BUTTON_TOGGLED:
		r = RGBCOL(230);
		g = RGBCOL(231);
		b = RGBCOL(225);
		break;
	case GUICOLOR_WINDOW_NORMAL:
		r = RGBCOL(235);
		g = RGBCOL(235);
		b = RGBCOL(227);
		break;
	case GUICOLOR_WINDOW_TITLEBAR:
		r = RGBCOL(40);
		g = RGBCOL(90);
		b = RGBCOL(150);
		break;
	case GUICOLOR_WINDOW_TITLEBAR_DISABLED:
		r = RGBCOL(40);
		g = RGBCOL(40);
		b = RGBCOL(40);
		break;
	}
}
